/*
 * Decompiled with CFR 0.152.
 */
package loliland.lolidecorative.models.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import loliland.lolidecorative.models.CommonSide;
import loliland.lolidecorative.models.tile.TileSynchronized;
import loliland.lolidecorative.models.util.DecorativeModel;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.forge.animatable.GeoBlockEntity;
import software.bernie.geckolib.forge.util.GeckoLibUtil;

public class TileDecorative
extends TileSynchronized
implements GeoBlockEntity {
    public static final DecorativeModel DEFAULT = new DecorativeModel();
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache(this);
    private String modelName;
    private DecorativeModel model;
    private AxisAlignedBB boundingBox;
    public int rotation = 0;
    public static final RawAnimation IDLE_ANIM = RawAnimation.begin().thenLoop("idle");

    public void setRotation(int rotation) {
        this.rotation = rotation;
        this.markDirtyDispatchable();
    }

    public String getModelName() {
        return this.modelName;
    }

    public DecorativeModel getModel() {
        return this.model;
    }

    public void setModel(String modelName) {
        this.modelName = modelName;
        DecorativeModel model = CommonSide.config.models.get(modelName);
        if (model != null) {
            this.setModel(model);
        } else {
            this.setModel(DEFAULT);
        }
    }

    public void setModel(DecorativeModel model) {
        this.model = model;
        if (model.collision != null) {
            this.setBoundingBox(model.collision.getBoundingBox());
        } else {
            this.setBoundingBox(AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.1f, (double)1.0));
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound tag) {
        this.rotation = tag.func_74762_e("rotation");
        if (tag.func_74764_b("modelName")) {
            this.modelName = tag.func_74779_i("modelName");
            DecorativeModel model = CommonSide.config.models.get(this.modelName);
            if (model != null) {
                this.setModel(model);
            }
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound tag) {
        tag.func_74768_a("rotation", this.rotation);
        if (this.modelName != null) {
            tag.func_74778_a("modelName", this.modelName);
        }
    }

    public AxisAlignedBB getBoundingBox() {
        return this.boundingBox;
    }

    public void setBoundingBox(AxisAlignedBB boundingBox) {
        this.boundingBox = boundingBox;
        this.func_70296_d();
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController<TileDecorative>(this, "popup_controller", 0, state -> {
            if (this.getModel() == null || !this.getModel().animation) {
                return PlayState.CONTINUE;
            }
            if (state.getController().getAnimationState() == AnimationController.State.STOPPED || state.getController().getAnimationState() == AnimationController.State.PAUSED) {
                state.getController().setAnimation(IDLE_ANIM);
            }
            return PlayState.CONTINUE;
        }));
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        DecorativeModel model = this.getModel();
        if (model != null) {
            return AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c - model.size.width / 2.0f - 1.0f), (double)(this.field_145848_d - 1), (double)((float)this.field_145849_e - model.size.width / 2.0f - 1.0f), (double)((float)this.field_145851_c + model.size.width / 2.0f + 1.0f), (double)((float)this.field_145848_d + model.size.height + 1.0f), (double)((float)this.field_145849_e + model.size.width / 2.0f + 1.0f));
        }
        return super.getRenderBoundingBox();
    }
}

