/*
 * Decompiled with CFR 0.152.
 */
package loliland.lolidecorative.models.render.tile;

import loliland.lolidecorative.models.tile.TileDecorative;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.forge.model.GeoModel;
import software.bernie.geckolib.forge.renderer.GeoBlockRenderer;
import software.bernie.geckolib.forge.renderer.GeoRenderer;
import software.bernie.geckolib.forge.renderer.layer.AutoGlowingGeoLayer;
import software.bernie.geckolib.forge.util.RenderStateShard;
import software.bernie.geckolib.forge.util.mc.Axis;
import software.bernie.geckolib.forge.util.mc.PoseStack;

public class TileDecorativeRenderer
extends GeoBlockRenderer<TileDecorative> {
    protected static final RenderStateShard NO_TRANSPARENCY = new RenderStateShard(() -> GL11.glDisable((int)3042), () -> {});
    protected static final RenderStateShard TRANSLUCENT_TRANSPARENCY = new RenderStateShard(() -> {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
    }, () -> GL11.glDisable((int)3042));

    public TileDecorativeRenderer() {
        super(new GeoModel<TileDecorative>(){

            @Override
            public ResourceLocation getModelResource(TileDecorative tile) {
                if (tile.getModel() == null) {
                    return new ResourceLocation("lolidecorative", "geo/block/default.geo.json");
                }
                return new ResourceLocation("lolidecorative", "geo/block/" + tile.getModel().model + ".geo.json");
            }

            @Override
            public ResourceLocation getTextureResource(TileDecorative tile) {
                if (tile.getModel() == null) {
                    return new ResourceLocation("lolidecorative", "textures/models/block/default.png");
                }
                return new ResourceLocation("lolidecorative", "textures/models/block/" + tile.getModel().texture + ".png");
            }

            @Override
            public ResourceLocation getAnimationResource(TileDecorative tile) {
                if (tile.getModel() == null) {
                    return new ResourceLocation("lolidecorative", "animations/block/default.animation.json");
                }
                return new ResourceLocation("lolidecorative", "animations/block/" + tile.getModel().model + ".animation.json");
            }

            @Override
            public ResourceLocation getTransformsResource(TileDecorative tileDecorative) {
                return null;
            }
        });
        this.addRenderLayer(new AutoGlowingGeoLayer<TileDecorative>((GeoRenderer)this){

            @Override
            public boolean canRender(TileDecorative tile) {
                if (tile.getModel() == null) {
                    return false;
                }
                return tile.getModel().emissive;
            }
        });
    }

    @Override
    public RenderStateShard getRenderStateShard(TileDecorative tile) {
        if (tile.getModel() != null && tile.getModel().translucent) {
            return TRANSLUCENT_TRANSPARENCY;
        }
        return super.getRenderStateShard((GeoAnimatable)tile);
    }

    @Override
    public void rotateBlock(EnumFacing facing, PoseStack poseStack) {
    }

    @Override
    public EnumFacing getFacing(TileDecorative te) {
        if (((TileDecorative)this.animatable).func_145830_o()) {
            this.poseStack.mulPose(Axis.YP.rotationDegrees(-((float)(((TileDecorative)this.animatable).rotation * 360) / 24.0f)));
        }
        return EnumFacing.NORTH;
    }
}

