/*
 * Decompiled with CFR 0.152.
 */
package loliland.lolidecorative.models.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import loliland.lolidecorative.models.block.ModBlock;
import loliland.lolidecorative.models.block.TextureType;
import loliland.lolidecorative.models.render.block.BlockVineRenderer;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Direction;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.util.ForgeDirection;

public class ModBlockVine
extends ModBlock
implements IShearable {
    private boolean end;

    public ModBlockVine(String name) {
        this(name, true);
    }

    public ModBlockVine(String name, boolean end) {
        super(name, Material.field_151582_l);
        this.end = end;
        this.func_149675_a(true);
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.setTexture("niiwork/vines", name, TextureType.SOLID);
    }

    public boolean isSameBlock(IBlockAccess blockAccess, int x, int y, int z) {
        return blockAccess.func_147439_a(x, y, z) == this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.topIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int side) {
        if (this.end) {
            boolean hasTop = this.isSameBlock(blockAccess, x, y + 1, z);
            boolean hasBottom = this.isSameBlock(blockAccess, x, y + -1, z);
            if (hasTop && !hasBottom) {
                return this.bottomIcon;
            }
        }
        return this.topIcon;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.topIcon = register.func_94245_a("lolidecorative:" + this.getTextureDir() + this.func_149641_N());
        if (this.end) {
            this.bottomIcon = register.func_94245_a("lolidecorative:" + this.getTextureDir() + this.func_149641_N() + "_end");
        }
    }

    public void func_149683_g() {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public int func_149645_b() {
        return BlockVineRenderer.renderId;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        boolean hasSide;
        float thickness = 0.0625f;
        int meta = world.func_72805_g(x, y, z);
        float minX = 1.0f;
        float minY = 1.0f;
        float minZ = 1.0f;
        float maxX = 0.0f;
        float maxY = 0.0f;
        float maxZ = 0.0f;
        boolean bl = hasSide = meta > 0;
        if ((meta & 2) != 0) {
            maxX = Math.max(maxX, 0.0625f);
            minX = 0.0f;
            minY = 0.0f;
            maxY = 1.0f;
            minZ = 0.0f;
            maxZ = 1.0f;
            hasSide = true;
        }
        if ((meta & 8) != 0) {
            minX = Math.min(minX, 0.9375f);
            maxX = 1.0f;
            minY = 0.0f;
            maxY = 1.0f;
            minZ = 0.0f;
            maxZ = 1.0f;
            hasSide = true;
        }
        if ((meta & 4) != 0) {
            maxZ = Math.max(maxZ, 0.0625f);
            minZ = 0.0f;
            minX = 0.0f;
            maxX = 1.0f;
            minY = 0.0f;
            maxY = 1.0f;
            hasSide = true;
        }
        if ((meta & 1) != 0) {
            minZ = Math.min(minZ, 0.9375f);
            maxZ = 1.0f;
            minX = 0.0f;
            maxX = 1.0f;
            minY = 0.0f;
            maxY = 1.0f;
            hasSide = true;
        }
        if (!hasSide && this.canAttach(world.func_147439_a(x, y + 1, z))) {
            minY = Math.min(minY, 0.9375f);
            maxY = 1.0f;
            minX = 0.0f;
            maxX = 1.0f;
            minZ = 0.0f;
            maxZ = 1.0f;
        }
        this.func_149676_a(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Nullable
    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public boolean func_149707_d(World world, int x, int y, int z, int side) {
        switch (side) {
            case 1: {
                return this.canAttach(world.func_147439_a(x, y + 1, z));
            }
            case 2: {
                return this.canAttach(world.func_147439_a(x, y, z + 1));
            }
            case 3: {
                return this.canAttach(world.func_147439_a(x, y, z - 1));
            }
            case 4: {
                return this.canAttach(world.func_147439_a(x + 1, y, z));
            }
            case 5: {
                return this.canAttach(world.func_147439_a(x - 1, y, z));
            }
        }
        return false;
    }

    private boolean canAttach(Block block) {
        return block.func_149686_d() && block.func_149688_o().func_76230_c();
    }

    private boolean validate(World world, int x, int y, int z) {
        int meta;
        int newMeta = meta = world.func_72805_g(x, y, z);
        if (meta > 0) {
            for (int dir = 0; dir <= 3; ++dir) {
                int flag = 1 << dir;
                if ((meta & flag) == 0 || this.canAttach(world.func_147439_a(x + Direction.field_71583_a[dir], y, z + Direction.field_71581_b[dir])) || world.func_147439_a(x, y + 1, z) == this && (world.func_72805_g(x, y + 1, z) & flag) != 0) continue;
                newMeta &= ~flag;
            }
        }
        if (newMeta == 0 && !this.canAttach(world.func_147439_a(x, y + 1, z))) {
            return false;
        }
        if (newMeta != meta) {
            world.func_72921_c(x, y, z, newMeta, 2);
        }
        return true;
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbor) {
        if (!world.field_72995_K && !this.validate(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
        }
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int meta) {
        switch (side) {
            case 2: {
                return 1;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 8;
            }
            case 5: {
                return 2;
            }
        }
        return meta;
    }

    @Nullable
    public Item func_149650_a(int meta, Random rand, int fortune) {
        return null;
    }

    public int func_149745_a(Random rand) {
        return 0;
    }

    public boolean isShearable(ItemStack stack, IBlockAccess w, int x, int y, int z) {
        return true;
    }

    public ArrayList<ItemStack> onSheared(ItemStack stack, IBlockAccess w, int x, int y, int z, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(new ItemStack((Block)this));
        return drops;
    }

    public boolean isLadder(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
        return true;
    }

    public ForgeDirection[] getValidRotations(World worldObj, int x, int y, int z) {
        return new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN};
    }

    public boolean rotateBlock(World worldObj, int x, int y, int z, ForgeDirection axis) {
        int rotMeta = worldObj.func_72805_g(x, y, z);
        int masked = rotMeta & 0xFFFFFFF0;
        int meta = ModBlockVine.rotateMetadata(rotMeta & 0xF);
        if (meta == -1) {
            return false;
        }
        worldObj.func_72921_c(x, y, z, meta & 0xF | masked, 3);
        return true;
    }

    private static int rotateMetadata(int meta) {
        return meta << 1 | (meta & 8) >> 3;
    }
}

