/*
 * Decompiled with CFR 0.152.
 */
package loliland.lolidecorative.models.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.IconFlipped;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.Item;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ModBlockDoor
extends BlockDoor {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconUpper;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconLower;
    private final String name;
    private String textureDir = null;
    private String textureName = null;
    private Item itemDoor;

    public ModBlockDoor(String name, Material material) {
        super(material);
        this.name = name;
        this.func_149711_c(3.0f);
        this.func_149672_a(field_149766_f);
        this.func_149649_H();
        this.func_149663_c(this.getName());
        this.setTexture(null, name);
        this.func_149647_a(null);
    }

    public ModBlockDoor setTexture(String textureDir, String textureName) {
        this.textureDir = textureDir;
        this.textureName = textureName;
        return this;
    }

    public ModBlockDoor setItemDoor(Item itemDoor) {
        this.itemDoor = itemDoor;
        return this;
    }

    public Item func_149650_a(int metadata, Random random, int fortune) {
        return (metadata & 8) != 0 ? null : this.itemDoor;
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World world, int x, int y, int z) {
        return this.itemDoor;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        return this.iconLower[0];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        if (side != 1 && side != 0) {
            boolean isUpper;
            int state = this.getFullMetadata(world, x, y, z);
            int orientation = state & 3;
            boolean open = (state & 4) != 0;
            boolean reversed = false;
            boolean bl = isUpper = (state & 8) != 0;
            if (open) {
                reversed = orientation == 0 && side == 2 || orientation == 1 && side == 5 || orientation == 2 && side == 3 || orientation == 3 && side == 4;
            } else {
                boolean bl2 = reversed = orientation == 0 && side == 5 || orientation == 1 && side == 3 || orientation == 2 && side == 4 || orientation == 3 && side == 2;
                if ((state & 0x10) != 0) {
                    boolean bl3 = reversed = !reversed;
                }
            }
            return isUpper ? this.iconUpper[reversed ? 1 : 0] : this.iconLower[reversed ? 1 : 0];
        }
        return this.iconLower[0];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.iconUpper = new IIcon[2];
        this.iconLower = new IIcon[2];
        this.iconUpper[0] = iconRegister.func_94245_a("lolidecorative:" + this.getTextureDir() + this.func_149641_N() + "_top");
        this.iconLower[0] = iconRegister.func_94245_a("lolidecorative:" + this.getTextureDir() + this.func_149641_N() + "_bottom");
        this.iconUpper[1] = new IconFlipped(this.iconUpper[0], true, false);
        this.iconLower[1] = new IconFlipped(this.iconLower[0], true, false);
    }

    public final String func_149739_a() {
        return "lolidecorative:tile." + this.getName();
    }

    public String getName() {
        return this.name;
    }

    public String getTextureDir() {
        return this.textureDir != null ? this.textureDir + "/" : "";
    }

    public String func_149641_N() {
        return this.textureName != null ? this.textureName : this.getName();
    }

    public int getFullMetadata(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        boolean upperPart = (meta & 8) != 0;
        int lowerMeta = upperPart ? world.func_72805_g(x, y - 1, z) : meta;
        int upperMeta = upperPart ? meta : world.func_72805_g(x, y + 1, z);
        boolean reversed = (upperMeta & 1) != 0;
        return lowerMeta & 7 | (upperPart ? 8 : 0) | (reversed ? 16 : 0);
    }
}

