/*
 * Decompiled with CFR 0.152.
 */
package loliland.lolidecorative.models.block;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import loliland.lolidecorative.models.block.IBlockSubnames;
import loliland.lolidecorative.models.item.ItemBlockArray;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public class ModBlockArrayLeave
extends BlockLeavesBase
implements IShearable,
IBlockSubnames {
    protected int[] field_150128_a;
    private final String name;
    private final String[] subnames;
    private String textureDir = null;
    private String textureName = null;
    @SideOnly(value=Side.CLIENT)
    public IIcon[] icons;

    public ModBlockArrayLeave(String name, String[] subnames) {
        super(Material.field_151584_j, true);
        this.name = name;
        this.subnames = subnames;
        this.func_149675_a(true);
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.func_149711_c(0.2f);
        this.func_149713_g(1);
        this.func_149672_a(field_149779_h);
        this.setTexture(null, name);
        GameRegistry.registerBlock((Block)this, ItemBlockArray.class, (String)name);
    }

    @Override
    public String getUnlocalizedSubname(Block block, int meta) {
        return "lolidecorative:tile." + this.getSubname(meta);
    }

    @Override
    public String getSubname(int index) {
        return this.subnames[index];
    }

    @Override
    public String itemPrefix() {
        return null;
    }

    public final String func_149739_a() {
        return "lolidecorative:tile." + this.name;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (meta > this.icons.length) {
            return this.icons[0];
        }
        return this.icons[meta];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tabs, List list) {
        for (int mata = 0; mata < this.subnames.length; ++mata) {
            list.add(new ItemStack(item, 1, mata));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.icons = new IIcon[this.subnames.length];
        for (int i = 0; i < this.subnames.length; ++i) {
            String subname = this.subnames[i];
            this.icons[i] = register.func_94245_a("lolidecorative:" + this.getTextureDir() + subname);
        }
    }

    public String getName() {
        return this.name;
    }

    public ModBlockArrayLeave setTexture(String textureDir, String textureName) {
        this.textureDir = textureDir;
        this.textureName = textureName;
        return this;
    }

    public String getTextureDir() {
        return this.textureDir != null ? this.textureDir + "/" : "";
    }

    public String func_149641_N() {
        return this.textureName != null ? this.textureName : this.getName();
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        boolean range = true;
        if (world.func_72904_c(x - 1 - 1, y - 1 - 1, z - 1 - 1, x + 1 + 1, y + 1 + 1, z + 1 + 1)) {
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        Block neighbour = world.func_147439_a(x + dx, y + dy, z + dz);
                        if (!neighbour.isLeaves((IBlockAccess)world, x + dx, y + dy, z + dz)) continue;
                        neighbour.beginLeavesDecay(world, x + dx, y + dy, z + dz);
                    }
                }
            }
        }
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
    }

    private void propagateDecay(int arraySize, int arrayArea, int center, int dx, int dy, int dz, int distance) {
        int[][] offsets;
        for (int[] off : offsets = new int[][]{{-1, 0, 0}, {1, 0, 0}, {0, -1, 0}, {0, 1, 0}, {0, 0, -1}, {0, 0, 1}}) {
            int nx = dx + off[0] + center;
            int ny = dy + off[1] + center;
            int nz = dz + off[2] + center;
            int nIdx = nx * arrayArea + ny * arraySize + nz;
            if (this.field_150128_a[nIdx] != -2) continue;
            this.field_150128_a[nIdx] = distance;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        if (world.func_72951_B(x, y + 1, z) && !World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z) && rand.nextInt(15) == 1) {
            double px = (float)x + rand.nextFloat();
            double py = (double)y - 0.05;
            double pz = (float)z + rand.nextFloat();
            world.func_72869_a("dripWater", px, py, pz, 0.0, 0.0, 0.0);
        }
    }

    private void removeLeaves(World world, int x, int y, int z) {
        this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
        world.func_147468_f(x, y, z);
    }

    public int func_149745_a(Random rand) {
        return rand.nextInt(20) == 0 ? 1 : 0;
    }

    public Item func_149650_a(int meta, Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    public void func_149690_a(World world, int x, int y, int z, int meta, float chance, int fortune) {
        super.func_149690_a(world, x, y, z, meta, 1.0f, fortune);
    }

    protected void getCustomDrop(World world, int x, int y, int z, int meta, int chance) {
    }

    public void func_149636_a(World p_149636_1_, EntityPlayer p_149636_2_, int p_149636_3_, int p_149636_4_, int p_149636_5_, int p_149636_6_) {
        super.func_149636_a(p_149636_1_, p_149636_2_, p_149636_3_, p_149636_4_, p_149636_5_, p_149636_6_);
    }

    public int func_149692_a(int meta) {
        return meta & 3;
    }

    public boolean func_149662_c() {
        return false;
    }

    protected ItemStack func_149644_j(int p_149644_1_) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, p_149644_1_ & 3);
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public ArrayList<ItemStack> onSheared(ItemStack item, IBlockAccess world, int x, int y, int z, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack((Block)this, 1, world.func_72805_g(x, y, z) & 3));
        return ret;
    }

    public void beginLeavesDecay(World world, int x, int y, int z) {
    }

    public boolean isLeaves(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        int chance = 20;
        if (fortune > 0 && (chance -= 2 << fortune) < 10) {
            chance = 10;
        }
        if (world.field_73012_v.nextInt(chance) == 0) {
            ret.add(new ItemStack(this.func_149650_a(metadata, world.field_73012_v, fortune), 1, this.func_149692_a(metadata)));
        }
        chance = 200;
        if (fortune > 0 && (chance -= 10 << fortune) < 40) {
            chance = 40;
        }
        this.captureDrops(true);
        this.getCustomDrop(world, x, y, z, metadata, chance);
        ret.addAll(this.captureDrops(false));
        return ret;
    }
}

