/*
 * Decompiled with CFR 0.152.
 */
package loliland.lolidecorative.models.block;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import loliland.lolidecorative.models.block.TextureType;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.IIcon;

public class ModBlock
extends Block {
    @SideOnly(value=Side.CLIENT)
    public IIcon topIcon;
    @SideOnly(value=Side.CLIENT)
    public IIcon bottomIcon;
    @SideOnly(value=Side.CLIENT)
    public IIcon sideIcon;
    private TextureType textureType = TextureType.SOLID;
    private String textureDir = null;
    private String textureName = null;
    private final String name;
    private final Class<? extends ItemBlock> itemBlock;

    public ModBlock(String name, Material material) {
        this(name, material, null);
    }

    public ModBlock(String name, Material material, boolean register) {
        this(name, material, null, register);
    }

    public ModBlock(String name, Material material, Class<? extends ItemBlock> itemBlock) {
        this(name, material, itemBlock, true);
    }

    public ModBlock(String name, Material material, Class<? extends ItemBlock> itemBlock, boolean register) {
        super(material);
        this.name = name;
        this.itemBlock = itemBlock;
        this.func_149663_c(this.getName());
        this.setTexture(null, name, TextureType.SOLID);
        if (register) {
            if (this.getItemBlock() != null) {
                GameRegistry.registerBlock((Block)this, this.getItemBlock(), (String)this.getName());
            } else {
                GameRegistry.registerBlock((Block)this, (String)this.getName());
            }
        }
    }

    public ModBlock setTexture(String textureDir, String textureName, TextureType textureType) {
        this.textureDir = textureDir;
        this.textureName = textureName;
        this.textureType = textureType;
        return this;
    }

    public ModBlock setTexture(String textureDir, String textureName) {
        this.textureDir = textureDir;
        this.textureName = textureName;
        this.textureType = TextureType.SOLID;
        return this;
    }

    public TextureType getTextureType() {
        return this.textureType;
    }

    public final String func_149739_a() {
        return "lolidecorative:tile." + this.getName();
    }

    public String getName() {
        return this.name;
    }

    public Class<? extends ItemBlock> getItemBlock() {
        return this.itemBlock;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (side == 0) {
            return this.getBottomIcon(meta);
        }
        if (side == 1) {
            return this.getTopIcon(meta);
        }
        return this.getSideIcon(meta);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        if (this.textureType == TextureType.SIDE_TOP) {
            this.sideIcon = register.func_94245_a("lolidecorative:" + this.getTextureDir() + this.func_149641_N());
            this.topIcon = register.func_94245_a("lolidecorative:" + this.getTextureDir() + this.func_149641_N() + "_top");
        } else if (this.textureType == TextureType.SIDE_TOP_BOTTOM) {
            this.sideIcon = register.func_94245_a("lolidecorative:" + this.getTextureDir() + this.func_149641_N());
            this.topIcon = register.func_94245_a("lolidecorative:" + this.getTextureDir() + this.func_149641_N() + "_top");
            this.bottomIcon = register.func_94245_a("lolidecorative:" + this.getTextureDir() + this.func_149641_N() + "_bottom");
        } else {
            this.sideIcon = register.func_94245_a("lolidecorative:" + this.getTextureDir() + this.func_149641_N());
        }
    }

    public String getTextureDir() {
        return this.textureDir != null ? this.textureDir + "/" : "";
    }

    public String func_149641_N() {
        return this.textureName != null ? this.textureName : this.getName();
    }

    @SideOnly(value=Side.CLIENT)
    protected IIcon getSideIcon(int type) {
        return this.sideIcon;
    }

    @SideOnly(value=Side.CLIENT)
    protected IIcon getBottomIcon(int type) {
        if (this.textureType == TextureType.SIDE_TOP_BOTTOM) {
            return this.bottomIcon;
        }
        if (this.textureType == TextureType.SIDE_TOP) {
            return this.topIcon;
        }
        return this.getSideIcon(type);
    }

    @SideOnly(value=Side.CLIENT)
    protected IIcon getTopIcon(int type) {
        if (this.textureType == TextureType.SIDE_TOP) {
            return this.topIcon;
        }
        return this.getSideIcon(type);
    }
}

