#version 150

uniform sampler2D DiffuseSampler;

in vec2 texCoord;
in vec2 oneTexel;

out vec4 fragColor;

void main(){
    vec4 center = texture(DiffuseSampler, texCoord);

    if (center.a > 0.5) {
        discard;
    }

    vec4 left = texture(DiffuseSampler, texCoord - vec2(oneTexel.x * 2, 0.0));
    vec4 right = texture(DiffuseSampler, texCoord + vec2(oneTexel.x * 2, 0.0));
    vec4 up = texture(DiffuseSampler, texCoord - vec2(0.0, oneTexel.y * 2));
    vec4 down = texture(DiffuseSampler, texCoord + vec2(0.0, oneTexel.y * 2));

//    vec4 left_up = texture(DiffuseSampler, texCoord + vec2(-oneTexel.x, oneTexel.x));
//    vec4 left_down = texture(DiffuseSampler, texCoord + vec2(-oneTexel.x, -oneTexel.x));
//    vec4 right_up = texture(DiffuseSampler, texCoord + vec2(oneTexel.x, oneTexel.x));
//    vec4 right_down = texture(DiffuseSampler, texCoord + vec2(oneTexel.x, -oneTexel.x));

    if (left.a + right.a + up.a + down.a > 0.5) {
        fragColor = vec4(1.0, 0.9, 0.12, 1.0);
    } else {
        discard;
    }
}
