/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib;

import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.TableLibFunction;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.VarArgFunction;

public class TableLib
extends TwoArgFunction {
    @Override
    public LuaValue call(LuaValue modname, LuaValue env) {
        LuaTable table = new LuaTable();
        table.set("concat", (LuaValue)new concat());
        table.set("insert", (LuaValue)new insert());
        table.set("pack", (LuaValue)new pack());
        table.set("remove", (LuaValue)new remove());
        table.set("sort", (LuaValue)new sort());
        table.set("unpack", (LuaValue)new unpack());
        env.set("table", (LuaValue)table);
        if (!env.get("package").isnil()) {
            env.get("package").get("loaded").set("table", (LuaValue)table);
        }
        return NIL;
    }

    static class concat
    extends TableLibFunction {
        concat() {
        }

        @Override
        public LuaValue call(LuaValue list) {
            return list.checktable().concat(EMPTYSTRING, 1, list.length());
        }

        @Override
        public LuaValue call(LuaValue list, LuaValue sep) {
            return list.checktable().concat(sep.checkstring(), 1, list.length());
        }

        @Override
        public LuaValue call(LuaValue list, LuaValue sep, LuaValue i) {
            return list.checktable().concat(sep.checkstring(), i.checkint(), list.length());
        }

        @Override
        public LuaValue call(LuaValue list, LuaValue sep, LuaValue i, LuaValue j) {
            return list.checktable().concat(sep.checkstring(), i.checkint(), j.checkint());
        }
    }

    static class insert
    extends VarArgFunction {
        insert() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            switch (args.narg()) {
                case 2: {
                    LuaTable table = args.checktable(1);
                    table.insert(table.length() + 1, args.arg(2));
                    return NONE;
                }
                case 3: {
                    LuaTable table = args.checktable(1);
                    int pos = args.checkint(2);
                    int max2 = table.length() + 1;
                    if (pos < 1 || pos > max2) {
                        insert.argerror(2, "position out of bounds: " + pos + " not between 1 and " + max2);
                    }
                    table.insert(pos, args.arg(3));
                    return NONE;
                }
            }
            return insert.error("wrong number of arguments to 'table.insert': " + args.narg() + " (must be 2 or 3)");
        }
    }

    static class pack
    extends VarArgFunction {
        pack() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            LuaTable t2 = pack.tableOf(args, 1);
            t2.set("n", args.narg());
            return t2;
        }
    }

    static class remove
    extends VarArgFunction {
        remove() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            LuaTable table = args.checktable(1);
            int size = table.length();
            int pos = args.optint(2, size);
            if (pos != size && (pos < 1 || pos > size + 1)) {
                remove.argerror(2, "position out of bounds: " + pos + " not between 1 and " + (size + 1));
            }
            return table.remove(pos);
        }
    }

    static class sort
    extends VarArgFunction {
        sort() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            args.checktable(1).sort(args.isnil(2) ? NIL : args.checkfunction(2));
            return NONE;
        }
    }

    static class unpack
    extends VarArgFunction {
        unpack() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            LuaTable t2 = args.checktable(1);
            int len = args.arg(3).isnil() ? t2.length() : 0;
            return t2.unpack(args.optint(2, 1), args.optint(3, len));
        }
    }
}

