/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib;

import org.luaj.vm2.Globals;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaThread;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.LibFunction;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.VarArgFunction;

public class CoroutineLib
extends TwoArgFunction {
    static int coroutine_count = 0;
    Globals globals;

    @Override
    public LuaValue call(LuaValue modname, LuaValue env) {
        this.globals = env.checkglobals();
        LuaTable coroutine = new LuaTable();
        coroutine.set("create", (LuaValue)new Create());
        coroutine.set("resume", (LuaValue)new Resume());
        coroutine.set("running", (LuaValue)new Running());
        coroutine.set("status", (LuaValue)new Status());
        coroutine.set("yield", (LuaValue)new Yield());
        coroutine.set("wrap", (LuaValue)new Wrap());
        env.set("coroutine", (LuaValue)coroutine);
        if (!env.get("package").isnil()) {
            env.get("package").get("loaded").set("coroutine", (LuaValue)coroutine);
        }
        return coroutine;
    }

    final class Create
    extends LibFunction {
        Create() {
        }

        @Override
        public LuaValue call(LuaValue f) {
            return new LuaThread(CoroutineLib.this.globals, f.checkfunction());
        }
    }

    static final class Resume
    extends VarArgFunction {
        Resume() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            LuaThread t2 = args.checkthread(1);
            return t2.resume(args.subargs(2));
        }
    }

    final class Running
    extends VarArgFunction {
        Running() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            LuaThread r = CoroutineLib.this.globals.running;
            return Running.varargsOf(r, (Varargs)Running.valueOf(r.isMainThread()));
        }
    }

    static final class Status
    extends LibFunction {
        Status() {
        }

        @Override
        public LuaValue call(LuaValue t2) {
            LuaThread lt = t2.checkthread();
            return Status.valueOf(lt.getStatus());
        }
    }

    final class Yield
    extends VarArgFunction {
        Yield() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            return CoroutineLib.this.globals.yield(args);
        }
    }

    final class Wrap
    extends LibFunction {
        Wrap() {
        }

        @Override
        public LuaValue call(LuaValue f) {
            LuaFunction func = f.checkfunction();
            LuaThread thread = new LuaThread(CoroutineLib.this.globals, func);
            return new Wrapper(thread);
        }
    }

    static final class Wrapper
    extends VarArgFunction {
        final LuaThread luathread;

        Wrapper(LuaThread luathread) {
            this.luathread = luathread;
        }

        @Override
        public Varargs invoke(Varargs args) {
            Varargs result = this.luathread.resume(args);
            if (result.arg1().toboolean()) {
                return result.subargs(2);
            }
            return Wrapper.error(result.arg(2).tojstring());
        }
    }
}

