/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.function.LongPredicate;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.jni.JNINativeInterface;
import sun.misc.Unsafe;

public class UnsafeWrapper {
    public static final Unsafe UNSAFE = UnsafeWrapper.getUnsafeInstance();
    public static final long ADDRESS = UnsafeWrapper.getAddressOffset();

    private static Unsafe getUnsafeInstance() {
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            return (Unsafe)theUnsafe.get(null);
        }
        catch (Exception theUnsafe) {
            Field[] fields;
            for (Field field : fields = Unsafe.class.getDeclaredFields()) {
                int modifiers;
                if (!field.getType().equals(Unsafe.class) || !Modifier.isStatic(modifiers = field.getModifiers()) || !Modifier.isFinal(modifiers)) continue;
                try {
                    field.setAccessible(true);
                    return (Unsafe)field.get(null);
                }
                catch (Exception exception) {
                    break;
                }
            }
            throw new UnsupportedOperationException("Axiom requires sun.misc.Unsafe to be available.");
        }
    }

    private static long getAddressOffset() {
        long MAGIC_ADDRESS = 0xDEADBEEF8BADF00DL & (Pointer.BITS32 ? 0xFFFFFFFFL : -1L);
        ByteBuffer bb = Objects.requireNonNull(JNINativeInterface.NewDirectByteBuffer((long)MAGIC_ADDRESS, (long)0L));
        return UnsafeWrapper.getFieldOffset(bb.getClass(), Long.TYPE, offset -> UNSAFE.getLong(bb, offset) == MAGIC_ADDRESS);
    }

    private static long getFieldOffset(Class<?> containerType, Class<?> fieldType, LongPredicate predicate) {
        for (Class<?> c = containerType; c != Object.class; c = c.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = c.getDeclaredFields()) {
                long offset;
                if (!field.getType().isAssignableFrom(fieldType) || Modifier.isStatic(field.getModifiers()) || field.isSynthetic() || !predicate.test(offset = UNSAFE.objectFieldOffset(field))) continue;
                return offset;
            }
        }
        throw new UnsupportedOperationException("Failed to find field offset in class.");
    }
}

