/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.utils;

public class ColourUtils {
    public static int blendARGB(int srcColour, int dstColour) {
        float srcA = (float)(srcColour >> 24 & 0xFF) / 255.0f;
        float srcR = (float)(srcColour >> 16 & 0xFF) / 255.0f;
        float srcG = (float)(srcColour >> 8 & 0xFF) / 255.0f;
        float srcB = (float)(srcColour & 0xFF) / 255.0f;
        float dstA = (float)(dstColour >> 24 & 0xFF) / 255.0f;
        float dstR = (float)(dstColour >> 16 & 0xFF) / 255.0f;
        float dstG = (float)(dstColour >> 8 & 0xFF) / 255.0f;
        float dstB = (float)(dstColour & 0xFF) / 255.0f;
        float resultAlpha = 1.0f - (1.0f - dstA) * (1.0f - srcA);
        if ((double)resultAlpha < 1.0E-6) {
            return (int)(resultAlpha * 255.0f) << 24;
        }
        float resultRed = dstR * dstA / resultAlpha + srcR * srcA * (1.0f - dstA) / resultAlpha;
        float resultGreen = dstG * dstA / resultAlpha + srcG * srcA * (1.0f - dstA) / resultAlpha;
        float resultBlue = dstB * dstA / resultAlpha + srcB * srcA * (1.0f - dstA) / resultAlpha;
        return (int)(resultAlpha * 255.0f) << 24 | (int)(resultRed * 255.0f) << 16 | (int)(resultGreen * 255.0f) << 8 | (int)(resultBlue * 255.0f);
    }
}

