/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.path;

import com.mojang.blaze3d.systems.RenderSystem;
import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.block_maps.HDVoxelMap;
import com.moulberry.axiom.capabilities.Tinker;
import com.moulberry.axiom.collections.Position2FloatMap;
import com.moulberry.axiom.collections.Position2ObjectMap;
import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.custom_blocks.CustomBlockState;
import com.moulberry.axiom.custom_blocks.ServerCustomBlocks;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.EditorWindowType;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.widgets.PresetWidget;
import com.moulberry.axiom.editor.widgets.SelectBlockWidget;
import com.moulberry.axiom.gizmo.ExtrudedGizmo;
import com.moulberry.axiom.gizmo.Gizmo;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.mask.MaskContext;
import com.moulberry.axiom.mask.MaskElement;
import com.moulberry.axiom.mask.MaskManager;
import com.moulberry.axiom.noise.WhiteNoise;
import com.moulberry.axiom.rasterization.Rasterization3D;
import com.moulberry.axiom.render.ChunkRenderOverrider;
import com.moulberry.axiom.render.Shapes;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.tools.path.CatmullRomSpline;
import com.moulberry.axiom.tools.path.Easings;
import com.moulberry.axiom.tools.path.PathRasterizer;
import com.moulberry.axiom.tools.path.PointConfig;
import com.moulberry.axiom.utils.BezierOperator;
import com.moulberry.axiom.utils.NbtGetter;
import com.moulberry.axiom.utils.RegionHelper;
import com.moulberry.axiom.world_modification.Dispatcher;
import com.moulberry.axiom.world_modification.HistoryEntry;
import com.moulberry.axiom.world_modification.undo.CreatePathAdditionalUndoOperation;
import imgui.ImGui;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatUnaryOperator;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2482;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2510;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_757;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class PathTool
implements Tool {
    private final ChunkedBlockRegion chunkedBlockRegion = new ChunkedBlockRegion();
    private final List<Gizmo> gizmos = new ArrayList<Gizmo>();
    private final SelectBlockWidget selectBlockWidget = new SelectBlockWidget(false);
    private boolean cutout = false;
    private boolean recalculate = false;
    private class_2680 lastActiveBlock = null;
    private boolean maskWindowOpen = false;
    private ExtrudedGizmo extrudedGizmo = null;
    private final int[] curveType = new int[]{0};
    private boolean looped = false;
    private boolean useStairsAndSlabs = false;
    private final int[] shape = new int[]{0};
    private final int[] radius = new int[]{0};
    private final int[] depth = new int[]{0};
    private final List<PointConfig> pointConfigs = new ArrayList<PointConfig>();
    private int activePoint = -1;
    private int justDeselectedPoint = -1;
    private boolean inverted = false;
    private final int[] slack = new int[]{20};
    private boolean keepExisting = false;
    private boolean extendToGround = false;
    private final PresetWidget presetWidget = new PresetWidget(this, "path");

    @Override
    public void reset() {
        this.gizmos.clear();
        this.pointConfigs.clear();
        this.chunkedBlockRegion.clear();
        this.activePoint = -1;
        this.recalculate = true;
        if (this.cutout) {
            ChunkRenderOverrider.INSTANCE.release("Path Tool");
            this.cutout = false;
        }
    }

    public void restore(List<class_2338> positions, List<PointConfig> pointConfigs, int curveType, boolean looped, boolean useStairsAndSlabs, int shape, int radius, int depth, boolean inverted, int slack, boolean keepExisting, boolean extendToGround) {
        this.reset();
        for (class_2338 position : positions) {
            this.gizmos.add(new Gizmo(position));
        }
        for (PointConfig pointConfig : pointConfigs) {
            this.pointConfigs.add(new PointConfig(pointConfig));
        }
        this.curveType[0] = curveType;
        this.looped = looped;
        this.useStairsAndSlabs = useStairsAndSlabs;
        this.shape[0] = shape;
        this.radius[0] = radius;
        this.depth[0] = depth;
        this.inverted = inverted;
        this.slack[0] = slack;
        this.keepExisting = keepExisting;
        this.extendToGround = extendToGround;
    }

    public void markDirty() {
        this.recalculate = true;
    }

    @Override
    public UserAction.ActionResult callAction(UserAction action, Object object) {
        switch (action) {
            case EXTRUDE: {
                for (Gizmo gizmo : this.gizmos) {
                    if (!gizmo.enableAxes) continue;
                    this.extrudedGizmo = new ExtrudedGizmo(class_310.method_1551().field_1724, gizmo.getTargetPosition());
                    gizmo.enableAxes = false;
                    return UserAction.ActionResult.USED_STOP;
                }
                break;
            }
            case ENTER: {
                if (this.extrudedGizmo != null) {
                    this.finishExtrudeGizmo();
                    return UserAction.ActionResult.USED_STOP;
                }
                this.recalculate();
                if (this.chunkedBlockRegion.isEmpty()) {
                    return UserAction.ActionResult.USED_STOP;
                }
                class_638 level = class_310.method_1551().field_1687;
                if (this.extendToGround && level != null) {
                    class_2680 activeBlock;
                    HDVoxelMap.HDVoxelBaseBlocks blocks;
                    Position2ObjectMap<class_2680> newBlocks = new Position2ObjectMap<class_2680>(k -> new class_2680[4096]);
                    class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
                    class_2680 full = this.useStairsAndSlabs ? ((blocks = HDVoxelMap.getAssociatedBlocks((activeBlock = Tool.getActiveBlock()).method_26204())) == null ? class_2246.field_10340.method_9564() : blocks.full().method_9564()) : null;
                    this.chunkedBlockRegion.forEachEntry((arg_0, arg_1, arg_2, arg_3) -> this.lambda$callAction$1(newBlocks, full, (class_1937)level, mutableBlockPos, arg_0, arg_1, arg_2, arg_3));
                    newBlocks.forEachEntry(this.chunkedBlockRegion::addBlock);
                }
                int modifiers = this.keepExisting ? HistoryEntry.MODIFIER_KEEP_EXISTING : 0;
                class_2487 sourceInfo = Dispatcher.simpleSourceInfo("Path Tool");
                String countString = NumberFormat.getInstance().format(this.chunkedBlockRegion.count());
                String historyDescription = AxiomI18n.get("axiom.history_description.placed", countString);
                ArrayList<class_2338> positions = new ArrayList<class_2338>();
                ArrayList<PointConfig> pointConfigs = new ArrayList<PointConfig>();
                for (Gizmo gizmo : this.gizmos) {
                    positions.add(gizmo.getTargetPosition());
                }
                for (PointConfig pointConfig : this.pointConfigs) {
                    pointConfigs.add(new PointConfig(pointConfig));
                }
                CreatePathAdditionalUndoOperation operation = new CreatePathAdditionalUndoOperation(positions, pointConfigs, this.curveType[0], this.looped, this.useStairsAndSlabs, this.shape[0], this.radius[0], this.depth[0], this.inverted, this.slack[0], this.keepExisting, this.extendToGround);
                RegionHelper.pushBlockRegionChange(this.chunkedBlockRegion, null, historyDescription, sourceInfo, modifiers, operation);
                this.gizmos.clear();
                this.chunkedBlockRegion.clear();
                this.activePoint = -1;
                this.recalculate = true;
                if (this.cutout) {
                    ChunkRenderOverrider.INSTANCE.release("Path Tool");
                    this.cutout = false;
                }
                return UserAction.ActionResult.USED_STOP;
            }
            case RIGHT_MOUSE: {
                if (this.extrudedGizmo != null) {
                    this.finishExtrudeGizmo();
                    return UserAction.ActionResult.USED_STOP;
                }
                RayCaster.RaycastResult result = Tool.raycastBlock(false, true, true);
                if (result != null) {
                    if (this.gizmos.size() >= this.getPointLimit()) {
                        return UserAction.ActionResult.USED_STOP;
                    }
                    this.recalculate = true;
                    for (Gizmo gizmo : this.gizmos) {
                        gizmo.enableAxes = false;
                    }
                    int activePoint = this.activePoint;
                    if (activePoint < 0) {
                        activePoint = this.justDeselectedPoint;
                    }
                    if (activePoint >= 0 && activePoint < this.gizmos.size() - 1) {
                        this.gizmos.add(activePoint + 1, new Gizmo(result.getBlockPos()));
                        if (this.pointConfigs.size() < this.gizmos.size()) {
                            this.pointConfigs.add(activePoint + 1, new PointConfig(false, false, (CustomBlockState)class_2246.field_10340.method_9564(), this.radius[0]));
                        }
                        this.activePoint = activePoint + 1;
                    } else {
                        this.gizmos.add(new Gizmo(result.getBlockPos()));
                        while (this.pointConfigs.size() < this.gizmos.size()) {
                            this.pointConfigs.add(new PointConfig(false, false, (CustomBlockState)class_2246.field_10340.method_9564(), this.radius[0]));
                        }
                        this.activePoint = this.gizmos.size() - 1;
                    }
                }
                return UserAction.ActionResult.USED_STOP;
            }
            case LEFT_MOUSE: {
                if (this.extrudedGizmo != null) {
                    this.finishExtrudeGizmo();
                    return UserAction.ActionResult.USED_STOP;
                }
                for (Gizmo gizmo : this.gizmos) {
                    if (!gizmo.enableAxes || !gizmo.leftClick()) continue;
                    return UserAction.ActionResult.USED_STOP;
                }
                Gizmo disableExcept = null;
                for (int i = 0; i < this.gizmos.size(); ++i) {
                    Gizmo gizmo = this.gizmos.get(i);
                    if (gizmo.enableAxes || !gizmo.leftClick()) continue;
                    this.activePoint = i;
                    disableExcept = gizmo;
                    break;
                }
                if (disableExcept != null) {
                    for (Gizmo gizmo : this.gizmos) {
                        if (gizmo == disableExcept) continue;
                        gizmo.enableAxes = false;
                    }
                    return UserAction.ActionResult.USED_STOP;
                }
                if (!EditorUI.isCtrlOrCmdDown()) {
                    if (this.activePoint >= 0) {
                        this.justDeselectedPoint = this.activePoint;
                    }
                    for (Gizmo gizmo : this.gizmos) {
                        gizmo.enableAxes = false;
                    }
                    this.activePoint = -1;
                }
                return UserAction.ActionResult.NOT_HANDLED;
            }
            case ESCAPE: {
                if (this.activePoint >= 0 && this.activePoint < this.gizmos.size()) {
                    for (Gizmo gizmo : this.gizmos) {
                        gizmo.enableAxes = false;
                    }
                    this.activePoint = -1;
                    return UserAction.ActionResult.USED_STOP;
                }
                if (this.gizmos.isEmpty()) break;
                this.reset();
                return UserAction.ActionResult.USED_STOP;
            }
            case DELETE: {
                if (this.activePoint >= 0 && this.activePoint < this.gizmos.size()) {
                    this.gizmos.remove(this.activePoint);
                    this.pointConfigs.remove(this.activePoint);
                    this.activePoint = -1;
                    this.recalculate = true;
                    return UserAction.ActionResult.USED_STOP;
                }
                if (this.gizmos.isEmpty()) break;
                this.reset();
                return UserAction.ActionResult.USED_STOP;
            }
            case REDO: {
                if (this.gizmos.size() <= 0) break;
                return UserAction.ActionResult.USED_STOP;
            }
            case UNDO: {
                if (this.activePoint >= 0 && this.activePoint < this.gizmos.size()) {
                    this.gizmos.remove(this.activePoint);
                    this.pointConfigs.remove(this.activePoint);
                    this.activePoint = -1;
                    this.recalculate = true;
                    return UserAction.ActionResult.USED_STOP;
                }
                if (this.gizmos.size() <= 0) break;
                int removeIndex = this.gizmos.size() - 1;
                this.gizmos.remove(removeIndex);
                this.pointConfigs.remove(removeIndex);
                this.activePoint = -1;
                this.recalculate = true;
                return UserAction.ActionResult.USED_STOP;
            }
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }

    private void finishExtrudeGizmo() {
        class_243 lookDirection = Tool.getLookDirection();
        if (lookDirection != null && this.gizmos.size() < this.getPointLimit()) {
            this.recalculate = true;
            for (Gizmo gizmo : this.gizmos) {
                gizmo.enableAxes = false;
            }
            class_2338 pos = this.extrudedGizmo.getBlockPos(lookDirection);
            if (pos != null) {
                if (this.activePoint >= 0 && this.activePoint < this.gizmos.size() - 1) {
                    this.gizmos.add(this.activePoint + 1, new Gizmo(pos));
                    if (this.pointConfigs.size() < this.gizmos.size()) {
                        this.pointConfigs.add(this.activePoint + 1, new PointConfig(false, false, (CustomBlockState)class_2246.field_10340.method_9564(), this.radius[0]));
                    }
                    ++this.activePoint;
                } else {
                    this.gizmos.add(new Gizmo(pos));
                    while (this.pointConfigs.size() < this.gizmos.size()) {
                        this.pointConfigs.add(new PointConfig(false, false, (CustomBlockState)class_2246.field_10340.method_9564(), this.radius[0]));
                    }
                    this.activePoint = this.gizmos.size() - 1;
                }
            }
        }
        this.extrudedGizmo = null;
    }

    @Override
    public void render(class_4184 camera, float tickDelta, long time, class_4587 matrices, Matrix4f projection) {
        RayCaster.RaycastResult raycastResult;
        boolean maskWindowOpen;
        boolean showGizmo;
        class_243 lookDirection = Tool.getLookDirection();
        boolean isLeftDown = Tool.isMouseDown(0);
        boolean isCtrlDown = EditorUI.isCtrlOrCmdDown();
        boolean renderGizmos = showGizmo = !EditorUI.isActive() || !isCtrlDown;
        if (lookDirection != null && this.extrudedGizmo != null) {
            this.extrudedGizmo.render(matrices, camera, lookDirection);
        }
        int pointLimit = this.getPointLimit();
        while (this.gizmos.size() > pointLimit) {
            this.gizmos.remove(this.gizmos.size() - 1);
            this.recalculate = true;
        }
        this.justDeselectedPoint = -1;
        for (Gizmo gizmo : this.gizmos) {
            class_2338 before = gizmo.getTargetPosition();
            gizmo.update(time, lookDirection, isLeftDown, isCtrlDown, showGizmo);
            gizmo.setAxisDirections(camera.method_19326().field_1352 > (double)gizmo.getTargetPosition().method_10263(), camera.method_19326().field_1351 > (double)gizmo.getTargetPosition().method_10264(), camera.method_19326().field_1350 > (double)gizmo.getTargetPosition().method_10260());
            if (gizmo.isGrabbed()) {
                renderGizmos = true;
            }
            if (gizmo.getTargetPosition().equals((Object)before)) continue;
            this.recalculate = true;
        }
        if (Tool.getActiveBlock() != this.lastActiveBlock) {
            this.lastActiveBlock = Tool.getActiveBlock();
            this.recalculate = true;
        }
        if (this.maskWindowOpen != (maskWindowOpen = EditorWindowType.TOOL_MASKS.isOpen())) {
            this.maskWindowOpen = maskWindowOpen;
            this.recalculate = true;
        }
        if (this.recalculate) {
            this.recalculate();
        }
        matrices.method_22903();
        matrices.method_22904(-camera.method_19326().field_1352, -camera.method_19326().field_1351, -camera.method_19326().field_1350);
        class_2338 raycastPos = null;
        if (this.activePoint >= 0 && this.extrudedGizmo == null && (raycastResult = Tool.raycastBlock()) != null) {
            raycastPos = raycastResult.blockPos();
        }
        RenderSystem.enableDepthTest();
        this.drawPoints(matrices, 1.0f, raycastPos);
        RenderSystem.disableDepthTest();
        this.drawPoints(matrices, 0.35f, raycastPos);
        RenderSystem.enableDepthTest();
        matrices.method_22909();
        float opacity = (float)Math.sin((float)time / 1000000.0f / 50.0f / 8.0f);
        this.chunkedBlockRegion.render(camera, class_243.field_1353, matrices, projection, 0.75f + opacity * 0.25f, 0.3f - opacity * 0.2f);
        if (renderGizmos) {
            for (Gizmo gizmo : this.gizmos) {
                gizmo.render(matrices, camera, isCtrlDown);
            }
        }
    }

    private void drawPoints(class_4587 matrices, float opacity, class_2338 raycastPos) {
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.lineWidth((float)2.0f);
        RenderSystem.setShader(class_757::method_34535);
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27377, class_290.field_29337);
        class_4587.class_4665 pose = matrices.method_23760();
        int count = this.activePoint < 0 || raycastPos == null ? this.gizmos.size() - 1 : this.gizmos.size();
        for (int i = 0; i < count; ++i) {
            class_243 to;
            class_243 from;
            if (this.activePoint >= 0 && raycastPos != null) {
                if (i == this.activePoint) {
                    from = this.gizmos.get(i).getInterpPosition();
                    to = class_243.method_24953((class_2382)raycastPos);
                } else if (i == this.activePoint + 1) {
                    from = class_243.method_24953((class_2382)raycastPos);
                    to = this.gizmos.get(i).getInterpPosition();
                } else if (i > this.activePoint + 1) {
                    from = this.gizmos.get(i - 1).getInterpPosition();
                    to = this.gizmos.get(i).getInterpPosition();
                } else {
                    from = this.gizmos.get(i).getInterpPosition();
                    to = this.gizmos.get(i + 1).getInterpPosition();
                }
            } else {
                from = this.gizmos.get(i).getInterpPosition();
                to = this.gizmos.get(i + 1).getInterpPosition();
            }
            Shapes.line(bufferBuilder, pose, from, to);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)0.1f, (float)0.1f, (float)opacity);
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableCull();
    }

    private int getPointLimit() {
        return this.curveType[0] == 4 ? 50 : 256;
    }

    private void recalculate() {
        boolean forceDDA;
        ChunkedBlockRegion targetRegion;
        this.recalculate = false;
        this.chunkedBlockRegion.clear();
        if (this.gizmos.isEmpty()) {
            if (this.cutout) {
                ChunkRenderOverrider.INSTANCE.release("Path Tool");
                this.cutout = false;
            }
            return;
        }
        MaskElement destinationMask = MaskManager.getDestMask();
        MaskContext maskContext = new MaskContext((class_1937)class_310.method_1551().field_1687);
        boolean useStairsAndSlabs = this.useStairsAndSlabs;
        int scaleMult = useStairsAndSlabs ? 2 : 1;
        ChunkedBlockRegion chunkedBlockRegion = targetRegion = useStairsAndSlabs ? new ChunkedBlockRegion(){

            @Override
            public void addBlockWithoutDirty(int x, int y, int z, class_2680 block) {
                super.addBlockWithoutDirty(x, y, z, block);
                super.addBlockWithoutDirty(x, y, z + 1, block);
                super.addBlockWithoutDirty(x, y + 1, z, block);
                super.addBlockWithoutDirty(x, y + 1, z + 1, block);
                super.addBlockWithoutDirty(x + 1, y, z, block);
                super.addBlockWithoutDirty(x + 1, y, z + 1, block);
                super.addBlockWithoutDirty(x + 1, y + 1, z, block);
                super.addBlockWithoutDirty(x + 1, y + 1, z + 1, block);
            }
        } : this.chunkedBlockRegion;
        if (this.gizmos.size() == 1) {
            Gizmo gizmo = this.gizmos.get(0);
            PointConfig pointConfig = this.pointConfigs.get(0);
            class_2338 pos = gizmo.getTargetPosition().method_35830(scaleMult);
            class_2680 blockState = pointConfig.overrideBlock ? pointConfig.block.getVanillaState() : Tool.getActiveBlock();
            int radius = this.curveType[0] == 0 ? 0 : (pointConfig.overrideRadius ? pointConfig.radius[0] * scaleMult : this.radius[0] * scaleMult);
            int maxRadiusSq = radius * radius + radius;
            for (int xo = -radius; xo <= radius; ++xo) {
                for (int yo = -radius; yo <= radius; ++yo) {
                    for (int zo = -radius; zo <= radius; ++zo) {
                        if (xo * xo + yo * yo + zo * zo > maxRadiusSq || !destinationMask.test(maskContext.reset(), pos.method_10263() + xo, pos.method_10264() + yo, pos.method_10260() + zo)) continue;
                        targetRegion.addBlockWithoutDirty(pos.method_10263() + xo, pos.method_10264() + yo, pos.method_10260() + zo, blockState);
                    }
                }
            }
            if (useStairsAndSlabs) {
                if (this.cutout) {
                    ChunkRenderOverrider.INSTANCE.release("Path Tool");
                    this.cutout = false;
                }
                this.downsize(targetRegion);
                this.chunkedBlockRegion.dirtyAll();
                return;
            }
            this.chunkedBlockRegion.dirtyAll();
            if (blockState.method_26215() || blockState.method_26204() instanceof class_2404) {
                if (!this.cutout) {
                    ChunkRenderOverrider.INSTANCE.acquire("Path Tool");
                    this.cutout = true;
                }
                PositionSet positionSet = new PositionSet();
                this.chunkedBlockRegion.forEachEntry((x, y, z, b) -> positionSet.add(x, y, z));
                ChunkRenderOverrider.INSTANCE.cutoutBoolean(positionSet, class_2338.field_10980);
            } else if (this.cutout) {
                ChunkRenderOverrider.INSTANCE.release("Path Tool");
                this.cutout = false;
            }
            return;
        }
        boolean loop = this.gizmos.size() >= 3 && this.looped;
        boolean bl = forceDDA = this.gizmos.size() < 3 && (this.curveType[0] == 3 || this.curveType[0] == 4);
        if (this.curveType[0] == 0) {
            class_2338 last = loop ? this.gizmos.get(this.gizmos.size() - 1).getTargetPosition().method_35830(scaleMult) : null;
            class_2680 blockState = Tool.getActiveBlock();
            for (Gizmo gizmo : this.gizmos) {
                class_2338 pos = gizmo.getTargetPosition().method_35830(scaleMult);
                if (last != null) {
                    Rasterization3D.bresenham(last, pos, (x, y, z) -> {
                        if (destinationMask.test(maskContext.reset(), x, y, z)) {
                            targetRegion.addBlockWithoutDirty(x, y, z, blockState);
                        }
                    });
                }
                last = pos;
            }
            if (useStairsAndSlabs) {
                if (this.cutout) {
                    ChunkRenderOverrider.INSTANCE.release("Path Tool");
                    this.cutout = false;
                }
                this.downsize(targetRegion);
                this.chunkedBlockRegion.dirtyAll();
                return;
            }
            this.chunkedBlockRegion.dirtyAll();
            if (blockState.method_26215() || blockState.method_26204() instanceof class_2404) {
                if (!this.cutout) {
                    ChunkRenderOverrider.INSTANCE.acquire("Path Tool");
                    this.cutout = true;
                }
                PositionSet positionSet = new PositionSet();
                this.chunkedBlockRegion.forEachEntry((x, y, z, b) -> positionSet.add(x, y, z));
                ChunkRenderOverrider.INSTANCE.cutoutBoolean(positionSet, class_2338.field_10980);
            } else if (this.cutout) {
                ChunkRenderOverrider.INSTANCE.release("Path Tool");
                this.cutout = false;
            }
            return;
        }
        HashSet<class_2680> blockSet = new HashSet<class_2680>();
        ArrayList<class_2680> blocks = new ArrayList<class_2680>();
        IntOpenHashSet radiusSet = new IntOpenHashSet();
        IntArrayList radii = new IntArrayList();
        ArrayList<class_2338> positions = new ArrayList<class_2338>();
        ArrayList<FloatUnaryOperator> easings = new ArrayList<FloatUnaryOperator>();
        FloatArrayList angles = new FloatArrayList();
        FloatArrayList lineAngles = new FloatArrayList();
        for (int i = 0; i < this.gizmos.size(); ++i) {
            int j;
            Gizmo gizmo = this.gizmos.get(i);
            PointConfig pointConfig = this.pointConfigs.get(i);
            class_2338 targetPos = gizmo.getTargetPosition().method_35830(scaleMult);
            positions.add(targetPos);
            if (pointConfig.overrideBlock) {
                blockSet.add(pointConfig.block.getVanillaState());
                blocks.add(pointConfig.block.getVanillaState());
            } else {
                blockSet.add(Tool.getActiveBlock());
                blocks.add(Tool.getActiveBlock());
            }
            if (pointConfig.overrideRadius) {
                radiusSet.add(pointConfig.radius[0] * scaleMult);
                radii.add(pointConfig.radius[0] * scaleMult);
            } else {
                radiusSet.add(this.radius[0] * scaleMult);
                radii.add(this.radius[0] * scaleMult);
            }
            FloatUnaryOperator easing = switch (pointConfig.easing[0]) {
                default -> Easings.LINEAR;
                case 1 -> {
                    switch (pointConfig.easingType[0]) {
                        default: {
                            yield Easings.EASE_IN_SLIGHT;
                        }
                        case 1: {
                            yield Easings.EASE_OUT_SLIGHT;
                        }
                        case 2: 
                    }
                    yield Easings.EASE_IN_OUT_SLIGHT;
                }
                case 2 -> {
                    switch (pointConfig.easingType[0]) {
                        default: {
                            yield Easings.EASE_IN_QUAD;
                        }
                        case 1: {
                            yield Easings.EASE_OUT_QUAD;
                        }
                        case 2: 
                    }
                    yield Easings.EASE_IN_OUT_QUAD;
                }
                case 3 -> {
                    switch (pointConfig.easingType[0]) {
                        default: {
                            yield Easings.EASE_IN_CUBIC;
                        }
                        case 1: {
                            yield Easings.EASE_OUT_CUBIC;
                        }
                        case 2: 
                    }
                    yield Easings.EASE_IN_OUT_CUBIC;
                }
                case 4 -> {
                    switch (pointConfig.easingType[0]) {
                        default: {
                            yield Easings.EASE_IN_QUARTIC;
                        }
                        case 1: {
                            yield Easings.EASE_OUT_QUARTIC;
                        }
                        case 2: 
                    }
                    yield Easings.EASE_IN_OUT_QUARTIC;
                }
            };
            easings.add(easing);
            float angleLeft = Float.NaN;
            float angleRight = Float.NaN;
            if (i < this.gizmos.size() - 1 || loop) {
                j = i < this.gizmos.size() - 1 ? i + 1 : 0;
                class_2338 to = this.gizmos.get(j).getTargetPosition().method_35830(scaleMult);
                angleLeft = (float)Math.atan2(to.method_10263() - targetPos.method_10263(), to.method_10260() - targetPos.method_10260());
                lineAngles.add(angleLeft);
            }
            if (i > 0 || loop) {
                j = i > 0 ? i - 1 : this.gizmos.size() - 1;
                class_2338 from = this.gizmos.get(j).getTargetPosition().method_35830(scaleMult);
                angleRight = (float)Math.atan2(targetPos.method_10263() - from.method_10263(), targetPos.method_10260() - from.method_10260());
            }
            if (Float.isNaN(angleLeft) && Float.isNaN(angleRight)) {
                angles.add(0.0f);
                continue;
            }
            if (Float.isNaN(angleLeft)) {
                angles.add(angleRight);
                continue;
            }
            if (Float.isNaN(angleRight)) {
                angles.add(angleLeft);
                continue;
            }
            float delta = angleLeft - angleRight;
            if ((double)(delta = (float)((double)delta % (Math.PI * 2))) < -Math.PI) {
                delta = (float)((double)delta + Math.PI * 2);
            }
            if ((double)delta > Math.PI) {
                delta = (float)((double)delta - Math.PI * 2);
            }
            angles.add(angleRight + delta / 2.0f);
        }
        if (useStairsAndSlabs) {
            blockSet.clear();
            blocks.clear();
            blockSet.add(class_2246.field_10340.method_9564());
            blocks.add(class_2246.field_10340.method_9564());
        }
        if (loop) {
            positions.add((class_2338)positions.get(0));
            blocks.add((class_2680)blocks.get(0));
            radii.add(radii.getInt(0));
            easings.add((FloatUnaryOperator)easings.get(0));
            angles.add(angles.getFloat(0));
        }
        boolean constantBlockType = blockSet.size() == 1;
        boolean constantRadius = radiusSet.size() == 1;
        boolean zeroRadius = constantRadius && radii.getInt(0) <= 0;
        FloatUnaryOperator[] easingsArray = easings.toArray(new FloatUnaryOperator[0]);
        float[] anglesArray = angles.toFloatArray();
        float[] lineAnglesArray = lineAngles.toFloatArray();
        Record pathRasterizer = zeroRadius ? (constantBlockType ? new PathRasterizer.ZeroRadiusConstantBlock((class_2680)blocks.get(0)) : new PathRasterizer.ZeroRadiusDynamicBlock(easingsArray, blocks.toArray(new class_2680[0]), new WhiteNoise(1705875030L))) : (constantRadius ? (constantBlockType ? (this.shape[0] == 0 ? new PathRasterizer.ConstantRadiusConstantBlock(radii.getInt(0), (class_2680)blocks.get(0)) : new PathRasterizer.FlatConstantRadiusConstantBlock(easingsArray, anglesArray, lineAnglesArray, radii.getInt(0), this.depth[0] * scaleMult, (class_2680)blocks.get(0))) : (this.shape[0] == 0 ? new PathRasterizer.ConstantRadiusDynamicBlock(easingsArray, radii.getInt(0), blocks.toArray(new class_2680[0]), new WhiteNoise(1705875030L), new Position2FloatMap(Float.MAX_VALUE)) : new PathRasterizer.FlatConstantRadiusDynamicBlock(easingsArray, anglesArray, lineAnglesArray, radii.getInt(0), this.depth[0] * scaleMult, blocks.toArray(new class_2680[0]), new WhiteNoise(1705875030L), new Position2FloatMap(Float.MAX_VALUE)))) : (constantBlockType ? (this.shape[0] == 0 ? new PathRasterizer.DynamicRadiusConstantBlock(easingsArray, radii.toIntArray(), (class_2680)blocks.get(0)) : new PathRasterizer.FlatDynamicRadiusConstantBlock(easingsArray, anglesArray, lineAnglesArray, radii.toIntArray(), this.depth[0] * scaleMult, (class_2680)blocks.get(0))) : (this.shape[0] == 0 ? new PathRasterizer.DynamicRadiusDynamicBlock(easingsArray, radii.toIntArray(), blocks.toArray(new class_2680[0]), new WhiteNoise(1705875030L), new Position2FloatMap(Float.MAX_VALUE)) : new PathRasterizer.FlatDynamicRadiusDynamicBlock(easingsArray, anglesArray, lineAnglesArray, radii.toIntArray(), this.depth[0] * scaleMult, blocks.toArray(new class_2680[0]), new WhiteNoise(1705875030L), new Position2FloatMap(Float.MAX_VALUE)))));
        if (this.curveType[0] == 1 || forceDDA) {
            for (int i = 0; i < positions.size() - 1; ++i) {
                fromBlock = (class_2338)positions.get(i);
                class_2338 toBlock = (class_2338)positions.get(i + 1);
                Vector3f from = new Vector3f((float)fromBlock.method_10263() + 0.5f, (float)fromBlock.method_10264() + 0.5f, (float)fromBlock.method_10260() + 0.5f);
                Vector3f to = new Vector3f((float)toBlock.method_10263() + 0.5f, (float)toBlock.method_10264() + 0.5f, (float)toBlock.method_10260() + 0.5f);
                pathRasterizer.rasterize(targetRegion, destinationMask, maskContext, from, to, i, 0.0f, 1.0f);
            }
        } else if (this.curveType[0] == 2) {
            for (int i = 0; i < positions.size() - 1; ++i) {
                fromBlock = (class_2338)positions.get(i);
                class_2338 toBlock = (class_2338)positions.get(i + 1);
                int fromX = fromBlock.method_10263();
                int fromY = fromBlock.method_10264();
                int fromZ = fromBlock.method_10260();
                int toX = toBlock.method_10263();
                int toY = toBlock.method_10264();
                int toZ = toBlock.method_10260();
                if (fromX == toX && fromZ == toZ) {
                    Vector3f from = new Vector3f((float)fromBlock.method_10263() + 0.5f, (float)fromBlock.method_10264() + 0.5f, (float)fromBlock.method_10260() + 0.5f);
                    Vector3f to = new Vector3f((float)toBlock.method_10263() + 0.5f, (float)toBlock.method_10264() + 0.5f, (float)toBlock.method_10260() + 0.5f);
                    pathRasterizer.rasterize(targetRegion, destinationMask, maskContext, from, to, i, 0.0f, 1.0f);
                    continue;
                }
                double dx = toX - fromX;
                double dy = toY - fromY;
                double dz = toZ - fromZ;
                double dh = Math.sqrt(dx * dx + dz * dz);
                double distanceSq = dx * dx + dy * dy + dz * dz;
                double l = Math.sqrt(distanceSq) * (1.0 + (double)this.slack[0] / 100.0);
                double r = Math.sqrt(l * l - dy * dy) / dh;
                if (r <= 1.0) {
                    Vector3f from = new Vector3f((float)fromBlock.method_10263() + 0.5f, (float)fromBlock.method_10264() + 0.5f, (float)fromBlock.method_10260() + 0.5f);
                    Vector3f to = new Vector3f((float)toBlock.method_10263() + 0.5f, (float)toBlock.method_10264() + 0.5f, (float)toBlock.method_10260() + 0.5f);
                    pathRasterizer.rasterize(targetRegion, destinationMask, maskContext, from, to, i, 0.0f, 1.0f);
                    continue;
                }
                double bigA = PathTool.findBigA(r);
                double a = dh / (2.0 * bigA);
                double b2 = dh / 2.0 - a * PathTool.atanh(dy / l);
                double c = (double)(toY + fromY) / 2.0 - l / (2.0 * Math.tanh(bigA));
                int iterations = Math.max((int)Math.ceil(l / 2.0), 4) - 1;
                Vector3f last = null;
                double lastAmount = 0.0;
                for (int j = 0; j <= iterations; ++j) {
                    double amount = (double)j / (double)iterations;
                    float y2 = (float)(a * Math.cosh((dh * amount - b2) / a) + c);
                    if (this.inverted) {
                        amount = 1.0 - amount;
                        y2 = (float)(fromY + toY) - y2;
                    }
                    float x2 = (float)((double)toX * amount + (double)fromX * (1.0 - amount));
                    float z2 = (float)((double)toZ * amount + (double)fromZ * (1.0 - amount));
                    Vector3f pos = new Vector3f(x2 + 0.5f, y2 + 0.5f, z2 + 0.5f);
                    if (last != null) {
                        pathRasterizer.rasterize(targetRegion, destinationMask, maskContext, last, pos, i, (float)lastAmount, (float)(amount - lastAmount));
                    }
                    last = pos;
                    lastAmount = amount;
                }
            }
        } else if (this.curveType[0] == 3) {
            if (loop) {
                positions.remove(positions.size() - 1);
            }
            ArrayList<Vector3f> positionsF = new ArrayList<Vector3f>();
            for (Gizmo gizmo : this.gizmos) {
                class_2338 pos = gizmo.getTargetPosition();
                positionsF.add(new Vector3f((float)pos.method_10263() + 0.5f, (float)pos.method_10264() + 0.5f, (float)pos.method_10260() + 0.5f).mul((float)scaleMult));
            }
            int size = positionsF.size();
            int maxI = loop ? size : size - 1;
            for (int i = 0; i < maxI; ++i) {
                int i0 = i - 1;
                int i1 = i + 1;
                int i2 = i + 2;
                if (loop) {
                    i1 %= size;
                    i2 %= size;
                    if ((i0 %= size) < 0) {
                        i0 += size;
                    }
                } else {
                    if (i0 < 0) {
                        i0 = 0;
                    }
                    if (i1 >= size) {
                        i1 = size - 1;
                    }
                    if (i2 >= size) {
                        i2 = size - 1;
                    }
                }
                if (i == i1) continue;
                float distance = ((Vector3f)positionsF.get(i)).distance((Vector3fc)positionsF.get(i1));
                int numPoints = Math.max(4, (int)Math.ceil(distance / 2.0f));
                List<Vector4f> spline = CatmullRomSpline.createCatmullRomSplineWithPartial((Vector3f)positionsF.get(i0), (Vector3f)positionsF.get(i), (Vector3f)positionsF.get(i1), (Vector3f)positionsF.get(i2), numPoints, 0.0f);
                for (int k = 0; k < spline.size() - 1; ++k) {
                    Vector4f item1 = spline.get(k);
                    Vector4f item2 = spline.get(k + 1);
                    Vector3f pos1 = new Vector3f(item1.x, item1.y, item1.z);
                    Vector3f pos2 = new Vector3f(item2.x, item2.y, item2.z);
                    pathRasterizer.rasterize(targetRegion, destinationMask, maskContext, pos1, pos2, i, item1.w, item2.w - item1.w);
                }
            }
        } else if (this.curveType[0] == 4) {
            float totalLength = 0.0f;
            int count = loop ? this.gizmos.size() + 1 : this.gizmos.size();
            BezierOperator[] factors = new BezierOperator[count];
            class_2338 lastBlockPos = null;
            for (int i = 0; i < this.gizmos.size(); ++i) {
                class_2338 pos = this.gizmos.get(i).getTargetPosition().method_35830(scaleMult);
                if (lastBlockPos != null) {
                    totalLength = (float)((double)totalLength + Math.sqrt(pos.method_10262(lastBlockPos)));
                }
                factors[i] = new BezierOperator(i, count);
                lastBlockPos = pos;
            }
            if (loop) {
                factors[count - 1] = new BezierOperator(count - 1, count);
            }
            int iterations = Math.max((int)Math.ceil(totalLength / 2.0f), 4) - 1;
            Vector3f last = null;
            double lastAmount = 0.0;
            for (int i = 0; i <= iterations; ++i) {
                double amount = (double)i / (double)iterations;
                double x3 = 0.0;
                double y3 = 0.0;
                double z3 = 0.0;
                for (int j = 0; j < positions.size(); ++j) {
                    class_2338 position = (class_2338)positions.get(j);
                    double factor = factors[j].applyAsDouble(amount);
                    x3 += factor * (double)position.method_10263();
                    y3 += factor * (double)position.method_10264();
                    z3 += factor * (double)position.method_10260();
                }
                Vector3f pos = new Vector3f((float)x3 + 0.5f, (float)y3 + 0.5f, (float)z3 + 0.5f);
                if (last != null) {
                    double lastFull = lastAmount * (double)(count - 1);
                    double lastPartial = lastFull % 1.0;
                    int lastIndex = (int)Math.floor(lastFull);
                    if (lastPartial == 0.0 && lastIndex > 0) {
                        lastPartial = 1.0;
                        --lastIndex;
                    }
                    double currFull = amount * (double)(count - 1);
                    double currPartial = currFull % 1.0;
                    int currIndex = (int)Math.floor(currFull);
                    if (currPartial == 0.0 && currIndex > 0) {
                        currPartial = 1.0;
                        --currIndex;
                    }
                    if (lastIndex != currIndex) {
                        double to = 1.0 - lastPartial;
                        float mid = (float)(to / (to + currPartial));
                        float midX = last.x * (1.0f - mid) + pos.x * mid;
                        float midY = last.y * (1.0f - mid) + pos.y * mid;
                        float midZ = last.z * (1.0f - mid) + pos.z * mid;
                        Vector3f midVec = new Vector3f(midX, midY, midZ);
                        pathRasterizer.rasterize(targetRegion, destinationMask, maskContext, last, midVec, lastIndex, (float)lastPartial, (float)to);
                        pathRasterizer.rasterize(targetRegion, destinationMask, maskContext, midVec, pos, currIndex, 0.0f, (float)currPartial);
                    } else {
                        pathRasterizer.rasterize(targetRegion, destinationMask, maskContext, last, pos, currIndex, (float)lastPartial, (float)(currPartial - lastPartial));
                    }
                }
                last = pos;
                lastAmount = amount;
            }
        }
        if (useStairsAndSlabs) {
            if (this.cutout) {
                ChunkRenderOverrider.INSTANCE.release("Path Tool");
                this.cutout = false;
            }
            this.downsize(targetRegion);
            this.chunkedBlockRegion.dirtyAll();
            return;
        }
        this.chunkedBlockRegion.dirtyAll();
        boolean hasInvisible = false;
        boolean hasVisible = false;
        for (class_2680 blockState : blockSet) {
            if (blockState.method_26215() || blockState.method_26204() instanceof class_2404) {
                hasInvisible = true;
                continue;
            }
            hasVisible = true;
        }
        if (hasInvisible) {
            if (!this.cutout) {
                ChunkRenderOverrider.INSTANCE.acquire("Path Tool");
                this.cutout = true;
            }
            PositionSet positionSet = new PositionSet();
            if (hasVisible) {
                this.chunkedBlockRegion.forEachEntry((x, y, z, b) -> {
                    if (b.method_26215() || b.method_26204() instanceof class_2404) {
                        positionSet.add(x, y, z);
                    }
                });
            } else {
                this.chunkedBlockRegion.forEachEntry((x, y, z, b) -> positionSet.add(x, y, z));
            }
            ChunkRenderOverrider.INSTANCE.cutoutBoolean(positionSet, class_2338.field_10980);
        } else if (this.cutout) {
            ChunkRenderOverrider.INSTANCE.release("Path Tool");
            this.cutout = false;
        }
    }

    private void downsize(ChunkedBlockRegion doubleSizeRegion) {
        class_2680 slab;
        class_2680 stair;
        class_2680 full;
        PositionSet tempSet = new PositionSet();
        doubleSizeRegion.forEachChunk((cx, cy, cz, blocks) -> {
            class_2680[] minusX = doubleSizeRegion.getChunk(cx - 1, cy, cz);
            class_2680[] plusX = doubleSizeRegion.getChunk(cx + 1, cy, cz);
            class_2680[] minusY = doubleSizeRegion.getChunk(cx, cy - 1, cz);
            class_2680[] plusY = doubleSizeRegion.getChunk(cx, cy + 1, cz);
            class_2680[] minusZ = doubleSizeRegion.getChunk(cx, cy, cz - 1);
            class_2680[] plusZ = doubleSizeRegion.getChunk(cx, cy, cz + 1);
            for (int x = 0; x < 16; x += 2) {
                for (int y = 0; y < 16; y += 2) {
                    for (int z = 0; z < 16; z += 2) {
                        int bits = 0;
                        if (blocks[x + y * 16 + z * 16 * 16] != null) {
                            bits |= 0x80;
                        }
                        if (blocks[x + y * 16 + (z + 1) * 16 * 16] != null) {
                            bits |= 0x40;
                        }
                        if (blocks[x + 1 + y * 16 + z * 16 * 16] != null) {
                            bits |= 0x20;
                        }
                        if (blocks[x + 1 + y * 16 + (z + 1) * 16 * 16] != null) {
                            bits |= 0x10;
                        }
                        if (blocks[x + (y + 1) * 16 + z * 16 * 16] != null) {
                            bits |= 8;
                        }
                        if (blocks[x + (y + 1) * 16 + (z + 1) * 16 * 16] != null) {
                            bits |= 4;
                        }
                        if (blocks[x + 1 + (y + 1) * 16 + z * 16 * 16] != null) {
                            bits |= 2;
                        }
                        if (blocks[x + 1 + (y + 1) * 16 + (z + 1) * 16 * 16] != null) {
                            bits |= 1;
                        }
                        if (bits == 0) continue;
                        int minError = Integer.MAX_VALUE;
                        int closestValid = 255;
                        for (int voxel : Tinker.validVoxel222) {
                            int different = (bits ^ voxel) & 0xFF;
                            int error2 = Integer.bitCount(different) * 3;
                            if ((different & 0x80) != 0 && (voxel & 0x80) != 0) {
                                error2 += this.penalizeJagged(x, y, z, (class_2680[])blocks, minusX, plusX, minusY, plusY, minusZ, plusZ) * 2;
                            }
                            if ((different & 0x40) != 0 && (voxel & 0x40) != 0) {
                                error2 += this.penalizeJagged(x, y, z + 1, (class_2680[])blocks, minusX, plusX, minusY, plusY, minusZ, plusZ) * 2;
                            }
                            if ((different & 0x20) != 0 && (voxel & 0x20) != 0) {
                                error2 += this.penalizeJagged(x + 1, y, z, (class_2680[])blocks, minusX, plusX, minusY, plusY, minusZ, plusZ) * 2;
                            }
                            if ((different & 0x10) != 0 && (voxel & 0x10) != 0) {
                                error2 += this.penalizeJagged(x + 1, y, z + 1, (class_2680[])blocks, minusX, plusX, minusY, plusY, minusZ, plusZ) * 2;
                            }
                            if ((different & 8) != 0 && (voxel & 8) != 0) {
                                error2 += this.penalizeJagged(x, y + 1, z, (class_2680[])blocks, minusX, plusX, minusY, plusY, minusZ, plusZ) * 2;
                            }
                            if ((different & 4) != 0 && (voxel & 4) != 0) {
                                error2 += this.penalizeJagged(x, y + 1, z + 1, (class_2680[])blocks, minusX, plusX, minusY, plusY, minusZ, plusZ) * 2;
                            }
                            if ((different & 2) != 0 && (voxel & 2) != 0) {
                                error2 += this.penalizeJagged(x + 1, y + 1, z, (class_2680[])blocks, minusX, plusX, minusY, plusY, minusZ, plusZ) * 2;
                            }
                            if ((different & 1) != 0 && (voxel & 1) != 0) {
                                error2 += this.penalizeJagged(x + 1, y + 1, z + 1, (class_2680[])blocks, minusX, plusX, minusY, plusY, minusZ, plusZ) * 2;
                            }
                            error2 *= 16;
                            if ((error2 += 8 - Integer.bitCount(voxel & 0xFF)) >= minError) continue;
                            minError = error2;
                            closestValid = voxel;
                        }
                        if ((closestValid & 0x80) != 0) {
                            tempSet.add(cx * 16 + x, cy * 16 + y, cz * 16 + z);
                        }
                        if ((closestValid & 0x40) != 0) {
                            tempSet.add(cx * 16 + x, cy * 16 + y, cz * 16 + z + 1);
                        }
                        if ((closestValid & 0x20) != 0) {
                            tempSet.add(cx * 16 + x + 1, cy * 16 + y, cz * 16 + z);
                        }
                        if ((closestValid & 0x10) != 0) {
                            tempSet.add(cx * 16 + x + 1, cy * 16 + y, cz * 16 + z + 1);
                        }
                        if ((closestValid & 8) != 0) {
                            tempSet.add(cx * 16 + x, cy * 16 + y + 1, cz * 16 + z);
                        }
                        if ((closestValid & 4) != 0) {
                            tempSet.add(cx * 16 + x, cy * 16 + y + 1, cz * 16 + z + 1);
                        }
                        if ((closestValid & 2) != 0) {
                            tempSet.add(cx * 16 + x + 1, cy * 16 + y + 1, cz * 16 + z);
                        }
                        if ((closestValid & 1) == 0) continue;
                        tempSet.add(cx * 16 + x + 1, cy * 16 + y + 1, cz * 16 + z + 1);
                    }
                }
            }
        });
        PositionSet tempSet2 = new PositionSet();
        tempSet.forEach((x, y, z) -> {
            tempSet2.add(x, y, z);
            if (tempSet.contains(x + 2, y, z)) {
                tempSet2.add(x + 1, y, z);
            }
            if (tempSet.contains(x, y + 2, z)) {
                tempSet2.add(x, y + 1, z);
            }
            if (tempSet.contains(x, y, z + 2)) {
                tempSet2.add(x, y, z + 1);
            }
        });
        class_2680 activeBlock = Tool.getActiveBlock();
        HDVoxelMap.HDVoxelBaseBlocks blocks2 = HDVoxelMap.getAssociatedBlocks(activeBlock.method_26204());
        if (blocks2 == null) {
            full = class_2246.field_10340.method_9564();
            stair = class_2246.field_10440.method_9564();
            slab = class_2246.field_10454.method_9564();
        } else {
            full = blocks2.full().method_9564();
            stair = blocks2.stair().method_9564();
            slab = blocks2.slab().method_9564();
        }
        tempSet2.forEachChunk((cx, cy, cz, chunk) -> {
            for (int x = 0; x < 16; x += 2) {
                for (int y = 0; y < 16; y += 2) {
                    for (int z = 0; z < 16; z += 2) {
                        int bits = 0;
                        if ((chunk[y + z * 16] & 1 << x) != 0) {
                            bits |= 0x80;
                        }
                        if ((chunk[y + (z + 1) * 16] & 1 << x) != 0) {
                            bits |= 0x40;
                        }
                        if ((chunk[y + z * 16] & 1 << x + 1) != 0) {
                            bits |= 0x20;
                        }
                        if ((chunk[y + (z + 1) * 16] & 1 << x + 1) != 0) {
                            bits |= 0x10;
                        }
                        if ((chunk[y + 1 + z * 16] & 1 << x) != 0) {
                            bits |= 8;
                        }
                        if ((chunk[y + 1 + (z + 1) * 16] & 1 << x) != 0) {
                            bits |= 4;
                        }
                        if ((chunk[y + 1 + z * 16] & 1 << x + 1) != 0) {
                            bits |= 2;
                        }
                        if ((chunk[y + 1 + (z + 1) * 16] & 1 << x + 1) != 0) {
                            bits |= 1;
                        }
                        if (bits == 0) continue;
                        class_2680 validBlock = Tinker.createFromVoxel222(bits, full, stair, slab);
                        this.chunkedBlockRegion.addBlockWithoutDirty(cx * 8 + x / 2, cy * 8 + y / 2, cz * 8 + z / 2, validBlock);
                    }
                }
            }
        });
    }

    private int penalizeJagged(int x, int y, int z, class_2680[] blocks, class_2680[] minusX, class_2680[] plusX, class_2680[] minusY, class_2680[] plusY, class_2680[] minusZ, class_2680[] plusZ) {
        boolean minusEmpty;
        boolean plusEmpty;
        int jagged = 0;
        boolean bl = x == 15 ? plusX == null || plusX[0 + y * 16 + z * 16 * 16] == null : (plusEmpty = blocks[x + 1 + y * 16 + z * 16 * 16] == null);
        boolean bl2 = x == 0 ? minusX == null || minusX[15 + y * 16 + z * 16 * 16] == null : (minusEmpty = blocks[x - 1 + y * 16 + z * 16 * 16] == null);
        if (plusEmpty && minusEmpty) {
            ++jagged;
        }
        boolean bl3 = y == 15 ? plusY == null || plusY[x + 0 + z * 16 * 16] == null : (plusEmpty = blocks[x + (y + 1) * 16 + z * 16 * 16] == null);
        boolean bl4 = y == 0 ? minusY == null || minusY[x + 240 + z * 16 * 16] == null : (minusEmpty = blocks[x + (y - 1) * 16 + z * 16 * 16] == null);
        if (plusEmpty && minusEmpty) {
            ++jagged;
        }
        boolean bl5 = z == 15 ? plusZ == null || plusZ[x + y * 16 + 0] == null : (plusEmpty = blocks[x + y * 16 + (z + 1) * 16 * 16] == null);
        boolean bl6 = z == 0 ? minusZ == null || minusZ[x + y * 16 + 3840] == null : (minusEmpty = blocks[x + y * 16 + (z - 1) * 16 * 16] == null);
        if (plusEmpty && minusEmpty) {
            ++jagged;
        }
        return jagged;
    }

    private static double atanh(double v) {
        return 0.5 * Math.log((1.0 + v) / (1.0 - v));
    }

    private static double findBigA(double r) {
        double bigA = r < 3.0 ? Math.sqrt(6.0 * (r - 1.0)) : Math.log(2.0 * r) + Math.log(Math.log(2.0 * r));
        for (int i = 0; i < 5; ++i) {
            bigA -= (Math.sinh(bigA) - r * bigA) / (Math.cosh(bigA) - r);
        }
        return bigA;
    }

    @Override
    public void displayImguiOptions() {
        class_2680 activeBlock;
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.path.curve_category"));
        boolean changed = ImGuiHelper.combo(AxiomI18n.get("axiom.tool.path.curve_type"), this.curveType, new String[]{AxiomI18n.get("axiom.tool.path.curve_bresenham"), AxiomI18n.get("axiom.tool.path.curve_dda"), AxiomI18n.get("axiom.tool.path.curve_catenary"), AxiomI18n.get("axiom.tool.path.curve_catmull_rom"), AxiomI18n.get("axiom.tool.path.curve_bezier")});
        if (ImGui.checkbox(AxiomI18n.get("axiom.tool.path.looped"), this.looped)) {
            this.looped = !this.looped;
            changed = true;
        }
        if (HDVoxelMap.getAssociatedBlocks((activeBlock = Tool.getActiveBlock()).method_26204()) != null) {
            if (ImGui.checkbox(AxiomI18n.get("axiom.tool.path.use_stairs_and_slabs"), this.useStairsAndSlabs)) {
                this.useStairsAndSlabs = !this.useStairsAndSlabs;
                changed = true;
            }
        } else if (this.useStairsAndSlabs) {
            this.useStairsAndSlabs = false;
            changed = true;
        }
        if (this.curveType[0] == 2) {
            if (ImGui.checkbox(AxiomI18n.get("axiom.tool.path.inverted"), this.inverted)) {
                this.inverted = !this.inverted;
                changed = true;
            }
            changed |= ImGui.sliderInt(AxiomI18n.get("axiom.tool.path.slack"), this.slack, 0, 200, "%d%%");
        }
        if (this.curveType[0] != 0) {
            ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.path.width"));
            if (this.gizmos.size() > 1) {
                changed |= ImGuiHelper.combo(AxiomI18n.get("axiom.tool.generic.brush_shape"), this.shape, new String[]{AxiomI18n.get("axiom.tool.shape.sphere"), AxiomI18n.get("axiom.tool.path.flat")});
                if (this.shape[0] == 1) {
                    changed |= ImGui.sliderInt(AxiomI18n.get("axiom.tool.path.depth"), this.depth, 0, 32);
                }
            }
            changed |= ImGui.sliderInt(AxiomI18n.get("axiom.tool.path.radius"), this.radius, 0, 32);
        }
        if (this.activePoint >= 0 && this.activePoint < this.pointConfigs.size() && this.activePoint < this.gizmos.size()) {
            PointConfig pointConfig = this.pointConfigs.get(this.activePoint);
            Gizmo gizmo = this.gizmos.get(this.activePoint);
            class_2338 pos = gizmo.getTargetPosition();
            ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.ruler.point_i", this.activePoint + 1));
            int[] positionInput = new int[]{pos.method_10263(), pos.method_10264(), pos.method_10260()};
            if (ImGuiHelper.inputInt(AxiomI18n.get("axiom.tool.box_select.position"), positionInput)) {
                gizmo.moveTo(new class_2338(positionInput[0], positionInput[1], positionInput[2]));
                changed = true;
            }
            if (this.curveType[0] != 0) {
                CustomBlockState newBlock;
                if (this.activePoint < this.gizmos.size() - 1 || this.gizmos.size() >= 3 && this.looped) {
                    changed |= ImGuiHelper.combo(AxiomI18n.get("axiom.tool.path.easing"), pointConfig.easing, new String[]{AxiomI18n.get("axiom.tool.path.easing_linear"), AxiomI18n.get("axiom.tool.path.easing_slight"), AxiomI18n.get("axiom.tool.path.easing_quadratic"), AxiomI18n.get("axiom.tool.path.easing_cubic"), AxiomI18n.get("axiom.tool.path.easing_quartic")});
                    if (pointConfig.easing[0] != 0) {
                        changed |= ImGuiHelper.combo(AxiomI18n.get("axiom.tool.path.easing_type"), pointConfig.easingType, new String[]{AxiomI18n.get("axiom.tool.path.easing_type_easein"), AxiomI18n.get("axiom.tool.path.easing_type_easeout"), AxiomI18n.get("axiom.tool.path.easing_type_easeinout")});
                    }
                }
                if (ImGui.checkbox(AxiomI18n.get("axiom.tool.path.override_block"), pointConfig.overrideBlock)) {
                    pointConfig.overrideBlock = !pointConfig.overrideBlock;
                    changed = true;
                }
                ImGui.sameLine();
                if (ImGui.checkbox(AxiomI18n.get("axiom.tool.path.override_radius"), pointConfig.overrideRadius)) {
                    pointConfig.overrideRadius = !pointConfig.overrideRadius;
                    changed = true;
                }
                if (pointConfig.overrideBlock && (newBlock = ImGuiHelper.blockStateWidget(this.selectBlockWidget, pointConfig.block, null, 0)) != pointConfig.block) {
                    pointConfig.block = newBlock;
                    changed = true;
                }
                if (pointConfig.overrideRadius) {
                    changed |= ImGui.sliderInt(AxiomI18n.get("axiom.tool.path.radius") + "##Point", pointConfig.radius, 0, 32);
                }
            }
            if (ImGui.button(AxiomI18n.get("axiom.tool.path.remove"))) {
                this.gizmos.remove(this.activePoint);
                this.pointConfigs.remove(this.activePoint);
                this.activePoint = -1;
                changed = true;
            }
        }
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.shape.paste_options"));
        if (ImGui.checkbox(AxiomI18n.get("axiom.editorui.window.clipboard.placement_options.keep_existing"), this.keepExisting)) {
            this.keepExisting = !this.keepExisting;
            changed = true;
        }
        if (ImGui.checkbox(AxiomI18n.get("axiom.tool.path.extend_to_ground"), this.extendToGround)) {
            this.extendToGround = !this.extendToGround;
            changed = true;
        }
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.widget.presets"));
        this.presetWidget.displayImgui(changed);
        if (this.activePoint >= 0) {
            ImGui.separator();
            ImGui.text(AxiomI18n.get("axiom.tool.shape.extrude_tip"));
        }
        this.recalculate |= changed;
    }

    @Override
    public String listenForEsc() {
        if (this.activePoint >= 0 && this.activePoint < this.gizmos.size()) {
            return AxiomI18n.get("axiom.tool.path.deselect_point_n", this.activePoint + 1);
        }
        if (!this.gizmos.isEmpty()) {
            return AxiomI18n.get("axiom.widget.cancel");
        }
        return null;
    }

    @Override
    public String listenForEnter() {
        if (!this.chunkedBlockRegion.isEmpty()) {
            return AxiomI18n.get("axiom.widget.confirm");
        }
        return null;
    }

    @Override
    public String name() {
        return AxiomI18n.get("axiom.tool.path");
    }

    @Override
    public void writeSourceInfo(class_2487 tag, boolean includeSettings) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeSettings(class_2487 tag) {
        tag.method_10569("CurveType", this.curveType[0]);
        tag.method_10556("Looped", this.looped);
        tag.method_10569("Radius", this.radius[0]);
        tag.method_10556("CatenaryInverted", this.inverted);
        tag.method_10569("CatenarySlack", this.slack[0]);
        tag.method_10556("KeepExisting", this.keepExisting);
        tag.method_10556("ExtendToGround", this.extendToGround);
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            class_2338 pos = player.method_24515();
            tag.method_10569("PlayerPosX", pos.method_10263());
            tag.method_10569("PlayerPosY", pos.method_10264());
            tag.method_10569("PlayerPosZ", pos.method_10260());
        }
        class_2499 pathPointsTag = new class_2499();
        for (int i = 0; i < this.gizmos.size(); ++i) {
            class_2338 position = this.gizmos.get(i).getTargetPosition();
            PointConfig pointConfig = this.pointConfigs.get(i);
            class_2487 pathPoint = new class_2487();
            pathPoint.method_10569("X", position.method_10263());
            pathPoint.method_10569("Y", position.method_10264());
            pathPoint.method_10569("Z", position.method_10260());
            pathPoint.method_10556("OverrideBlock", pointConfig.overrideBlock);
            pathPoint.method_10556("OverrideRadius", pointConfig.overrideRadius);
            if (pointConfig.overrideBlock) {
                pathPoint.method_10582("Block", ServerCustomBlocks.serialize(pointConfig.block));
            }
            if (pointConfig.overrideRadius) {
                pathPoint.method_10569("Radius", pointConfig.radius[0]);
            }
            pathPoint.method_10569("Easing", pointConfig.easing[0]);
            pathPoint.method_10569("EasingType", pointConfig.easingType[0]);
            pathPointsTag.add((Object)pathPoint);
        }
        tag.method_10566("PathPoints", (class_2520)pathPointsTag);
    }

    @Override
    public void loadSettings(class_2487 tag) {
        this.curveType[0] = NbtGetter.getIntOrDefault(tag, "CurveType", 0);
        this.looped = NbtGetter.getBoolOrDefault(tag, "Looped", false);
        this.radius[0] = NbtGetter.getIntOrDefault(tag, "Radius", 0);
        this.inverted = NbtGetter.getBoolOrDefault(tag, "CatenaryInverted", false);
        this.slack[0] = NbtGetter.getIntOrDefault(tag, "CatenarySlack", 20);
        this.keepExisting = NbtGetter.getBoolOrDefault(tag, "KeepExisting", false);
        this.extendToGround = NbtGetter.getBoolOrDefault(tag, "ExtendToGround", false);
        class_2338 offset = class_2338.field_10980;
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            if (tag.method_10573("PlayerPosX", 99)) {
                offset = new class_2338(player.method_31477() - tag.method_10550("PlayerPosX"), offset.method_10264(), offset.method_10260());
            }
            if (tag.method_10573("PlayerPosY", 99)) {
                offset = new class_2338(offset.method_10263(), player.method_31478() - tag.method_10550("PlayerPosY"), offset.method_10260());
            }
            if (tag.method_10573("PlayerPosZ", 99)) {
                offset = new class_2338(offset.method_10263(), offset.method_10264(), player.method_31479() - tag.method_10550("PlayerPosZ"));
            }
        }
        this.gizmos.clear();
        this.pointConfigs.clear();
        class_2499 pathPointsTag = tag.method_10554("PathPoints", 10);
        for (class_2520 pathPointTag : pathPointsTag) {
            class_2487 pathPoint = (class_2487)pathPointTag;
            int x = pathPoint.method_10550("X") + offset.method_10263();
            int y = pathPoint.method_10550("Y") + offset.method_10264();
            int z = pathPoint.method_10550("Z") + offset.method_10260();
            boolean overrideBlock = pathPoint.method_10577("OverrideBlock");
            boolean overrideRadius = pathPoint.method_10577("OverrideRadius");
            CustomBlockState customBlockState = (CustomBlockState)class_2246.field_10340.method_9564();
            if (overrideBlock) {
                String blockString = pathPoint.method_10558("Block");
                customBlockState = Objects.requireNonNullElse(ServerCustomBlocks.deserialize(blockString), customBlockState);
            }
            int radius = this.radius[0];
            if (overrideRadius) {
                radius = NbtGetter.getIntOrDefault(tag, "Radius", radius);
            }
            int easing = NbtGetter.getIntOrDefault(tag, "Easing", 0);
            int easingType = NbtGetter.getIntOrDefault(tag, "EasingType", 0);
            this.gizmos.add(new Gizmo(new class_2338(x, y, z)));
            this.pointConfigs.add(new PointConfig(overrideBlock, overrideRadius, customBlockState, radius, easing, easingType));
        }
        this.recalculate = true;
    }

    @Override
    public char iconChar() {
        return '\ue900';
    }

    @Override
    public String keybindId() {
        return "path";
    }

    private /* synthetic */ void lambda$callAction$1(Position2ObjectMap newBlocks, class_2680 full, class_1937 level, class_2338.class_2339 mutableBlockPos, int x, int y, int z, class_2680 block) {
        for (int yo = 1; yo < 256 && this.chunkedBlockRegion.getBlockStateOrAir(x, y - yo, z).method_26215(); ++yo) {
            class_2680 below;
            if (this.useStairsAndSlabs && yo == 1) {
                if (block.method_26204() instanceof class_2510 && block.method_11654((class_2769)class_2510.field_11572) == class_2760.field_12619) {
                    newBlocks.put(x, y, z, full);
                } else if (block.method_26204() instanceof class_2482 && block.method_11654((class_2769)class_2482.field_11501) == class_2771.field_12679) {
                    newBlocks.put(x, y, z, full);
                }
                block = full;
            }
            if ((below = level.method_8320((class_2338)mutableBlockPos.method_10103(x, y - yo, z))).method_26204() == class_2246.field_10243 || !below.method_45474()) break;
            newBlocks.put(x, y - yo, z, block);
        }
    }
}

