/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.path;

import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatList;
import java.util.ArrayList;
import java.util.List;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class CatmullRomSpline {
    private static float tj(float ti, Vector3f p1, Vector3f p2, float alpha) {
        float dx = p2.x - p1.x;
        float dy = p2.y - p1.y;
        float dz = p2.z - p1.z;
        return (float)Math.pow(Math.sqrt(dx * dx + dy * dy + dz * dz), alpha) + ti;
    }

    private static FloatList linspace(float t1, float t2, int points) {
        FloatArrayList list = new FloatArrayList(points);
        float delta = t2 - t1;
        for (int i = 0; i < points; ++i) {
            list.add(t1 + delta * ((float)i / (float)(points - 1)));
        }
        return list;
    }

    private static List<Vector3f> catmullInterp(FloatList list, Vector3f p1, Vector3f p2, float t1, float t0) {
        ArrayList<Vector3f> newList = new ArrayList<Vector3f>();
        for (int i = 0; i < list.size(); ++i) {
            float t2 = list.getFloat(i);
            Vector3f p1_2 = p1.mul((t1 - t2) / (t1 - t0), new Vector3f());
            Vector3f p2_2 = p2.mul((t2 - t0) / (t1 - t0), new Vector3f());
            newList.add(p1_2.add((Vector3fc)p2_2));
        }
        return newList;
    }

    private static List<Vector3f> catmullInterp(FloatList list, List<Vector3f> p1, List<Vector3f> p2, float t1, float t0) {
        ArrayList<Vector3f> newList = new ArrayList<Vector3f>();
        for (int i = 0; i < list.size(); ++i) {
            float t2 = list.getFloat(i);
            Vector3f p1_2 = p1.get(i).mul((t1 - t2) / (t1 - t0), new Vector3f());
            Vector3f p2_2 = p2.get(i).mul((t2 - t0) / (t1 - t0), new Vector3f());
            newList.add(p1_2.add((Vector3fc)p2_2));
        }
        return newList;
    }

    public static List<Vector3f> createCatmullRomSpline(Vector3f p1, Vector3f p2, Vector3f p3, Vector3f p4, int pointNum, float alpha) {
        float t0 = 0.0f;
        float t1 = CatmullRomSpline.tj(t0, p1, p2, alpha);
        float t2 = CatmullRomSpline.tj(t1, p2, p3, alpha);
        float t3 = CatmullRomSpline.tj(t2, p3, p4, alpha);
        FloatList points = CatmullRomSpline.linspace(t1, t2, pointNum);
        List<Vector3f> A1 = CatmullRomSpline.catmullInterp(points, p1, p2, t1, t0);
        List<Vector3f> A2 = CatmullRomSpline.catmullInterp(points, p2, p3, t2, t1);
        List<Vector3f> A3 = CatmullRomSpline.catmullInterp(points, p3, p4, t3, t2);
        List<Vector3f> B1 = CatmullRomSpline.catmullInterp(points, A1, A2, t2, t0);
        List<Vector3f> B2 = CatmullRomSpline.catmullInterp(points, A2, A3, t3, t1);
        List<Vector3f> C2 = CatmullRomSpline.catmullInterp(points, B1, B2, t2, t1);
        return C2;
    }

    public static List<Vector4f> createCatmullRomSplineWithPartial(Vector3f p1, Vector3f p2, Vector3f p3, Vector3f p4, int pointNum, float alpha) {
        float t0 = 0.0f;
        float t1 = CatmullRomSpline.tj(t0, p1, p2, alpha);
        float t2 = CatmullRomSpline.tj(t1, p2, p3, alpha);
        float t3 = CatmullRomSpline.tj(t2, p3, p4, alpha);
        FloatList points = CatmullRomSpline.linspace(t1, t2, pointNum);
        List<Vector3f> A1 = CatmullRomSpline.catmullInterp(points, p1, p2, t1, t0);
        List<Vector3f> A2 = CatmullRomSpline.catmullInterp(points, p2, p3, t2, t1);
        List<Vector3f> A3 = CatmullRomSpline.catmullInterp(points, p3, p4, t3, t2);
        List<Vector3f> B1 = CatmullRomSpline.catmullInterp(points, A1, A2, t2, t0);
        List<Vector3f> B2 = CatmullRomSpline.catmullInterp(points, A2, A3, t3, t1);
        List<Vector3f> C2 = CatmullRomSpline.catmullInterp(points, B1, B2, t2, t1);
        ArrayList<Vector4f> result = new ArrayList<Vector4f>();
        for (int i = 0; i < C2.size(); ++i) {
            Vector3f vector3f = C2.get(i);
            result.add(new Vector4f(vector3f.x, vector3f.y, vector3f.z, points.getFloat(i) - 1.0f));
        }
        return result;
    }

    public static List<Vector3f> getCatmullRomChain(List<Vector3f> points, boolean looped) {
        if (points.size() < 2) {
            return new ArrayList<Vector3f>();
        }
        ArrayList<Vector3f> interpPoints = new ArrayList<Vector3f>();
        int size = points.size();
        int maxI = looped ? size : size - 1;
        for (int i = 0; i < maxI; ++i) {
            int i0 = i - 1;
            int i1 = i + 1;
            int i2 = i + 2;
            if (looped) {
                i1 %= size;
                i2 %= size;
                if ((i0 %= size) < 0) {
                    i0 += size;
                }
            } else {
                if (i0 < 0) {
                    i0 = 0;
                }
                if (i1 >= size) {
                    i1 = size - 1;
                }
                if (i2 >= size) {
                    i2 = size - 1;
                }
            }
            if (i == i1) continue;
            float distance = points.get(i).distance((Vector3fc)points.get(i1));
            int numPoints = Math.max(4, (int)Math.ceil(distance / 2.0f));
            interpPoints.addAll(CatmullRomSpline.createCatmullRomSpline(points.get(i0), points.get(i), points.get(i1), points.get(i2), numPoints, 0.0f));
        }
        return interpPoints;
    }
}

