/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.modify;

import com.moulberry.axiom.clipboard.SelectionBuffer;
import com.moulberry.axiom.rasterization.Rasterization2D;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2470;
import net.minecraft.class_2680;

public class ModifyRevolve {
    public static ChunkedBlockRegion revolve(class_1937 level, SelectionBuffer selectionBuffer, class_2338 point, float angle, int axis) {
        if (selectionBuffer instanceof SelectionBuffer.AABB) {
            SelectionBuffer.AABB aabb = (SelectionBuffer.AABB)selectionBuffer;
            return ModifyRevolve.revolveAABB(level, aabb, point, angle, axis);
        }
        if (selectionBuffer instanceof SelectionBuffer.Set) {
            SelectionBuffer.Set set = (SelectionBuffer.Set)selectionBuffer;
            return ModifyRevolve.revolveSet(level, set, point, angle, axis);
        }
        return new ChunkedBlockRegion();
    }

    private static ChunkedBlockRegion revolveAABB(class_1937 level, SelectionBuffer.AABB aabb, class_2338 point, float angle, int axis) {
        int minX = aabb.min().method_10263();
        int minY = aabb.min().method_10264();
        int minZ = aabb.min().method_10260();
        int maxX = aabb.max().method_10263();
        int maxY = aabb.max().method_10264();
        int maxZ = aabb.max().method_10260();
        int revolveX = point.method_10263();
        int revolveY = point.method_10264();
        int revolveZ = point.method_10260();
        ChunkedBlockRegion chunkedBlockRegion = new ChunkedBlockRegion();
        boolean limitAngle = angle > -359.0f && angle < 359.0f;
        class_2470[] rotations = class_2470.values();
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    int dx;
                    float toAngle;
                    float fromAngle;
                    int radius;
                    int dz;
                    class_2680 blockState = level.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
                    if (blockState.method_26215()) continue;
                    if (axis == 0) {
                        int dy = revolveY - y;
                        dz = revolveZ - z;
                        int finalX = x;
                        radius = (int)Math.round(Math.sqrt(dy * dy + dz * dz));
                        if (limitAngle) {
                            fromAngle = (float)Math.atan2(dy, dz);
                            toAngle = fromAngle + angle;
                            Rasterization2D.ddaCircle(radius, (y1, z1) -> {
                                float blockAngle = (float)Math.atan2(y1, z1);
                                if (blockAngle < fromAngle) {
                                    blockAngle = (float)((double)blockAngle + Math.PI * 2);
                                }
                                if (blockAngle >= fromAngle && blockAngle <= toAngle) {
                                    chunkedBlockRegion.addBlockWithoutDirty(finalX, revolveY + y1, revolveZ + z1, blockState);
                                }
                            });
                            continue;
                        }
                        Rasterization2D.ddaCircle(radius, (y1, z1) -> chunkedBlockRegion.addBlockWithoutDirty(finalX, revolveY + y1, revolveZ + z1, blockState));
                        continue;
                    }
                    if (axis == 1) {
                        dx = revolveX - x;
                        dz = revolveZ - z;
                        int finalY = y;
                        radius = (int)Math.round(Math.sqrt(dx * dx + dz * dz));
                        fromAngle = (float)Math.atan2(dx, -dz);
                        if (limitAngle) {
                            toAngle = fromAngle + angle;
                            Rasterization2D.ddaCircle(radius, (x1, z1) -> {
                                float blockAngle = (float)Math.atan2(x1, -z1);
                                if (blockAngle < fromAngle) {
                                    blockAngle = (float)((double)blockAngle + Math.PI * 2);
                                }
                                if (blockAngle >= fromAngle && blockAngle <= toAngle) {
                                    int rotationCount = (int)Math.round((double)(blockAngle - fromAngle) / 1.5707963267948966) + 2;
                                    if ((rotationCount %= 4) < 0) {
                                        rotationCount += 4;
                                    }
                                    chunkedBlockRegion.addBlockWithoutDirty(revolveX + x1, finalY, revolveZ + z1, blockState.method_26186(rotations[rotationCount]));
                                }
                            });
                            continue;
                        }
                        Rasterization2D.ddaCircle(radius, (x1, z1) -> {
                            float blockAngle = (float)Math.atan2(x1, -z1);
                            int rotationCount = (int)Math.round((double)(blockAngle - fromAngle) / 1.5707963267948966) + 2;
                            if ((rotationCount %= 4) < 0) {
                                rotationCount += 4;
                            }
                            chunkedBlockRegion.addBlockWithoutDirty(revolveX + x1, finalY, revolveZ + z1, blockState.method_26186(rotations[rotationCount]));
                        });
                        continue;
                    }
                    if (axis != 2) continue;
                    dx = revolveX - x;
                    int dy = revolveY - y;
                    int finalZ = z;
                    radius = (int)Math.round(Math.sqrt(dx * dx + dy * dy));
                    if (limitAngle) {
                        fromAngle = (float)Math.atan2(dx, dy);
                        toAngle = fromAngle + angle;
                        Rasterization2D.ddaCircle(radius, (x1, y1) -> {
                            float blockAngle = (float)Math.atan2(x1, y1);
                            if (blockAngle < fromAngle) {
                                blockAngle = (float)((double)blockAngle + Math.PI * 2);
                            }
                            if (blockAngle >= fromAngle && blockAngle <= toAngle) {
                                chunkedBlockRegion.addBlockWithoutDirty(revolveX + x1, revolveY + y1, finalZ, blockState);
                            }
                        });
                        continue;
                    }
                    Rasterization2D.ddaCircle(radius, (x1, y1) -> chunkedBlockRegion.addBlockWithoutDirty(revolveX + x1, revolveY + y1, finalZ, blockState));
                }
            }
        }
        return chunkedBlockRegion;
    }

    private static ChunkedBlockRegion revolveSet(class_1937 level, SelectionBuffer.Set set, class_2338 point, float angle, int axis) {
        int revolveX = point.method_10263();
        int revolveY = point.method_10264();
        int revolveZ = point.method_10260();
        ChunkedBlockRegion chunkedBlockRegion = new ChunkedBlockRegion();
        boolean limitAngle = angle > -359.0f && angle < 359.0f;
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        set.forEach((x, y, z) -> {
            class_2680 blockState = level.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
            if (blockState.method_26215()) {
                return;
            }
            if (axis == 0) {
                int dy = revolveY - y;
                int dz = revolveZ - z;
                int finalX = x;
                int radius = (int)Math.round(Math.sqrt(dy * dy + dz * dz));
                if (limitAngle) {
                    float fromAngle = (float)Math.atan2(dy, dz);
                    float toAngle = fromAngle + angle;
                    Rasterization2D.ddaCircle(radius, (y1, z1) -> {
                        float blockAngle = (float)Math.atan2(y1, z1);
                        if (blockAngle < fromAngle) {
                            blockAngle = (float)((double)blockAngle + Math.PI * 2);
                        }
                        if (blockAngle >= fromAngle && blockAngle <= toAngle) {
                            chunkedBlockRegion.addBlockWithoutDirty(finalX, revolveY + y1, revolveZ + z1, blockState);
                        }
                    });
                } else {
                    Rasterization2D.ddaCircle(radius, (y1, z1) -> chunkedBlockRegion.addBlockWithoutDirty(finalX, revolveY + y1, revolveZ + z1, blockState));
                }
            } else if (axis == 1) {
                int dx = revolveX - x;
                int dz = revolveZ - z;
                int finalY = y;
                int radius = (int)Math.round(Math.sqrt(dx * dx + dz * dz));
                if (limitAngle) {
                    float fromAngle = (float)Math.atan2(dx, dz);
                    float toAngle = fromAngle + angle;
                    Rasterization2D.ddaCircle(radius, (x1, z1) -> {
                        float blockAngle = (float)Math.atan2(x1, z1);
                        if (blockAngle < fromAngle) {
                            blockAngle = (float)((double)blockAngle + Math.PI * 2);
                        }
                        if (blockAngle >= fromAngle && blockAngle <= toAngle) {
                            chunkedBlockRegion.addBlockWithoutDirty(revolveX + x1, finalY, revolveZ + z1, blockState);
                        }
                    });
                } else {
                    Rasterization2D.ddaCircle(radius, (x1, z1) -> chunkedBlockRegion.addBlockWithoutDirty(revolveX + x1, finalY, revolveZ + z1, blockState));
                }
            } else if (axis == 2) {
                int dx = revolveX - x;
                int dy = revolveY - y;
                int finalZ = z;
                int radius = (int)Math.round(Math.sqrt(dx * dx + dy * dy));
                if (limitAngle) {
                    float fromAngle = (float)Math.atan2(dx, dy);
                    float toAngle = fromAngle + angle;
                    Rasterization2D.ddaCircle(radius, (x1, y1) -> {
                        float blockAngle = (float)Math.atan2(x1, y1);
                        if (blockAngle < fromAngle) {
                            blockAngle = (float)((double)blockAngle + Math.PI * 2);
                        }
                        if (blockAngle >= fromAngle && blockAngle <= toAngle) {
                            chunkedBlockRegion.addBlockWithoutDirty(revolveX + x1, revolveY + y1, finalZ, blockState);
                        }
                    });
                } else {
                    Rasterization2D.ddaCircle(radius, (x1, y1) -> chunkedBlockRegion.addBlockWithoutDirty(revolveX + x1, revolveY + y1, finalZ, blockState));
                }
            }
        });
        return chunkedBlockRegion;
    }
}

