/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.magic_select;

import com.moulberry.axiom.collections.Position2ByteMap;
import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.mask.MaskElement;
import com.moulberry.axiom.tools.magic_select.MagicSelectionTask;
import com.moulberry.axiom.utils.IntWrapper;
import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public class MagicSelectionRangedTask
extends MagicSelectionTask {
    private final Position2ByteMap distanceMap = new Position2ByteMap();
    private final byte baseDistance;

    public MagicSelectionRangedTask(PositionSet positionSet, class_1937 world, class_2338 position, int compareMode, MaskElement maskElement, int distance) {
        super(positionSet, world, position, compareMode, maskElement);
        if (distance > 5) {
            distance = 5;
        }
        this.baseDistance = (byte)(distance + 1);
        this.distanceMap.put(position.method_10263(), position.method_10264(), position.method_10260(), this.baseDistance);
    }

    @Override
    public void fill(int until) {
        if (until < 0) {
            throw new IllegalArgumentException();
        }
        this.until = until;
        IntWrapper count = this.fillCount;
        LongArrayFIFOQueue toCheck = this.toCheck;
        while (!toCheck.isEmpty() && count.value < until) {
            long pos = toCheck.dequeueLong();
            int x = class_2338.method_10061((long)pos);
            int y = class_2338.method_10071((long)pos);
            int z = class_2338.method_10083((long)pos);
            byte distance = this.distanceMap.get(x, y, z);
            byte neighborDistance = (byte)(distance - 1);
            this.tryQueue(x - 1, y, z, neighborDistance);
            this.tryQueue(x + 1, y, z, neighborDistance);
            this.tryQueue(x, y, z - 1, neighborDistance);
            this.tryQueue(x, y, z + 1, neighborDistance);
            this.tryQueue(x, y - 1, z, neighborDistance);
            this.tryQueue(x, y + 1, z, neighborDistance);
        }
    }

    private void tryQueue(int x1, int y1, int z1, byte distance) {
        block11: {
            block12: {
                byte previousDistance = this.distanceMap.get(x1, y1, z1);
                if (distance <= previousDistance) break block11;
                if (previousDistance != 0) break block12;
                class_2680 blockState = this.chunkProvider.get(x1, y1, z1);
                switch (this.compareMode) {
                    default: {
                        if (blockState.method_26204() == this.originalBlock) {
                            break;
                        }
                        break block12;
                    }
                    case 1: {
                        if (blockState == this.originalBlockState) {
                            break;
                        }
                        break block12;
                    }
                    case 2: {
                        if (blockState.method_51366()) {
                            break;
                        }
                        break block12;
                    }
                    case 3: {
                        if (blockState.method_26215()) break block12;
                    }
                }
                if (this.maskElement.test(this.maskContext.reset(), x1, y1, z1)) {
                    if (this.fillCount.value >= this.until) {
                        return;
                    }
                    this.distanceMap.put(x1, y1, z1, this.baseDistance);
                    this.toCheck.enqueue(class_2338.method_10064((int)x1, (int)y1, (int)z1));
                    this.positionSet.add(x1, y1, z1);
                    ++this.fillCount.value;
                    return;
                }
            }
            if (distance > 1) {
                this.distanceMap.put(x1, y1, z1, distance);
                this.toCheck.enqueue(class_2338.method_10064((int)x1, (int)y1, (int)z1));
            }
        }
    }
}

