/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.render.regions;

import com.mojang.blaze3d.systems.RenderSystem;
import com.moulberry.axiom.GlobalCleaner;
import com.moulberry.axiom.collections.Position2ObjectMap;
import com.moulberry.axiom.collections.list.IntrusiveLinkedElement;
import com.moulberry.axiom.collections.list.IntrusiveLinkedList;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.hooks.VertexBufferExt;
import com.moulberry.axiom.render.CleaningBufferBuilder;
import com.moulberry.axiom.render.regions.ChunkedRegionPool;
import com.moulberry.axiom.render.regions.MapBlockAndTintGetter;
import com.moulberry.axiom.utils.AxiomVertexFormats;
import com.moulberry.axiom.utils.RenderHelper;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Comparator;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_1059;
import net.minecraft.class_1060;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_4076;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5819;
import net.minecraft.class_5944;
import net.minecraft.class_757;
import net.minecraft.class_776;
import net.minecraft.class_8251;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class OneshotBlockRegion {
    private boolean closed = false;
    private GlobalCleaner.LeakChecker leakChecker = null;
    private final Long2ObjectMap<ChunkData> chunkDataMap;
    private final IntrusiveLinkedList<ChunkData> sortedChunkData;
    private boolean pendingVertexUpload = true;
    private long compiledSortMillis;
    private float compiledSortX;
    private float compiledSortY;
    private float compiledSortZ;
    private int compiledSortChunkX;
    private int compiledSortChunkY;
    private int compiledSortChunkZ;

    public OneshotBlockRegion(Long2ObjectMap<ChunkData> chunkDataMap, IntrusiveLinkedList<ChunkData> sortedChunkData) {
        this.chunkDataMap = chunkDataMap;
        this.sortedChunkData = sortedChunkData;
    }

    public void render(class_4184 camera, class_243 translation, class_4587 matrix, Matrix4f projection, float blockOpacity, float outlineOpacity) {
        if (this.sortedChunkData.isEmpty()) {
            return;
        }
        this.doVertexUpload();
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.lineWidth((float)2.0f);
        RenderSystem.defaultBlendFunc();
        matrix.method_22903();
        if (camera != null) {
            matrix.method_22904(-camera.method_19326().field_1352, -camera.method_19326().field_1351, -camera.method_19326().field_1350);
        }
        matrix.method_22904(translation.field_1352, translation.field_1351, translation.field_1350);
        class_5944 shaderInstance = class_757.method_34548();
        if (shaderInstance != null && blockOpacity > 0.01f) {
            RenderSystem.enableCull();
            RenderSystem.enablePolygonOffset();
            RenderSystem.polygonOffset((float)-1.0f, (float)-1.0f);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)blockOpacity);
            class_1060 textureManager = class_310.method_1551().method_1531();
            textureManager.method_4619(class_1059.field_5275).method_4527(false, true);
            RenderSystem.setShaderTexture((int)0, (class_2960)class_1059.field_5275);
            Matrix4f modelViewMatrix = matrix.method_23760().method_23761();
            RenderHelper.setupShader(shaderInstance, modelViewMatrix, projection);
            Matrix4f translatedMatrix = new Matrix4f();
            for (ChunkData data : this.sortedChunkData) {
                if (data.block == null) continue;
                if (shaderInstance.field_29470 != null) {
                    translatedMatrix.set((Matrix4fc)modelViewMatrix);
                    translatedMatrix.translate((float)data.offsetX, (float)data.offsetY, (float)data.offsetZ);
                    shaderInstance.field_29470.method_1250(translatedMatrix);
                    shaderInstance.field_29470.method_1300();
                }
                data.block.method_1353();
                data.block.method_35665();
            }
            RenderHelper.finishShader(shaderInstance);
        }
        if ((shaderInstance = class_757.method_34535()) != null && outlineOpacity > 0.01f) {
            RenderSystem.disableCull();
            RenderSystem.lineWidth((float)2.0f);
            RenderSystem.setShaderColor((float)0.7f, (float)0.7f, (float)1.0f, (float)outlineOpacity);
            Matrix4f modelViewMatrix = matrix.method_23760().method_23761();
            RenderHelper.setupShader(shaderInstance, modelViewMatrix, projection);
            Matrix4f translatedMatrix = new Matrix4f();
            for (ChunkData data : this.sortedChunkData) {
                if (data.outline == null) continue;
                if (shaderInstance.field_29470 != null) {
                    translatedMatrix.set((Matrix4fc)modelViewMatrix);
                    translatedMatrix.translate((float)data.offsetX, (float)data.offsetY, (float)data.offsetZ);
                    shaderInstance.field_29470.method_1250(translatedMatrix);
                    shaderInstance.field_29470.method_1300();
                }
                data.outline.method_1353();
                data.outline.method_35665();
            }
            RenderHelper.finishShader(shaderInstance);
        }
        matrix.method_22909();
        RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableDepthTest();
        RenderSystem.disablePolygonOffset();
        RenderSystem.enableCull();
    }

    private void doVertexUpload() {
        RenderSystem.assertOnRenderThread();
        if (this.pendingVertexUpload) {
            this.pendingVertexUpload = false;
            for (ChunkData chunkData : this.chunkDataMap.values()) {
                chunkData.upload();
            }
            class_291.method_1354();
        }
    }

    private void setSortInfo(long sortMillis, float sortX, float sortY, float sortZ, int sortChunkX, int sortChunkY, int sortChunkZ) {
        this.compiledSortMillis = sortMillis;
        this.compiledSortX = sortX;
        this.compiledSortY = sortY;
        this.compiledSortZ = sortZ;
        this.compiledSortChunkX = sortChunkX;
        this.compiledSortChunkY = sortChunkY;
        this.compiledSortChunkZ = sortChunkZ;
    }

    public void close() {
        if (this.closed) {
            throw new FaultyImplementationError();
        }
        this.closed = true;
        for (ChunkData chunkDatum : this.chunkDataMap.values()) {
            if (chunkDatum.block != null) {
                chunkDatum.block.close();
            }
            if (chunkDatum.outline == null) continue;
            chunkDatum.outline.close();
        }
        this.chunkDataMap.clear();
        this.sortedChunkData.clear();
        if (this.leakChecker != null) {
            this.leakChecker.disarm();
        }
    }

    public static CompileFuture compile(Position2ObjectMap<class_2680> blockData, class_4184 camera, class_243 translation) {
        CompileFuture future = new CompileFuture();
        ChunkedRegionPool.submit(() -> {
            try {
                LongOpenHashSet dirtyChunks = new LongOpenHashSet();
                LongIterator longIterator = blockData.chunkKeySet().longIterator();
                while (longIterator.hasNext()) {
                    long pos = longIterator.nextLong();
                    int chunkX = class_2338.method_10061((long)pos);
                    int chunkY = class_2338.method_10071((long)pos);
                    int chunkZ = class_2338.method_10083((long)pos);
                    dirtyChunks.add(class_2338.method_10064((int)(chunkX - 1), (int)chunkY, (int)chunkZ));
                    dirtyChunks.add(class_2338.method_10064((int)(chunkX - 1), (int)(chunkY - 1), (int)chunkZ));
                    dirtyChunks.add(class_2338.method_10064((int)(chunkX - 1), (int)chunkY, (int)(chunkZ - 1)));
                    dirtyChunks.add(class_2338.method_10064((int)chunkX, (int)(chunkY - 1), (int)chunkZ));
                    dirtyChunks.add(class_2338.method_10064((int)chunkX, (int)(chunkY - 1), (int)(chunkZ - 1)));
                    dirtyChunks.add(class_2338.method_10064((int)chunkX, (int)chunkY, (int)(chunkZ - 1)));
                    dirtyChunks.add(class_2338.method_10064((int)(chunkX + 1), (int)chunkY, (int)chunkZ));
                    dirtyChunks.add(class_2338.method_10064((int)chunkX, (int)(chunkY + 1), (int)chunkZ));
                    dirtyChunks.add(class_2338.method_10064((int)chunkX, (int)chunkY, (int)(chunkZ + 1)));
                    dirtyChunks.add(class_2338.method_10064((int)chunkX, (int)chunkY, (int)chunkZ));
                }
                Long2ObjectOpenHashMap chunkDataMap = new Long2ObjectOpenHashMap();
                IntrusiveLinkedList<ChunkData> sortedChunkData = new IntrusiveLinkedList<ChunkData>();
                OneshotBlockRegion.compileInner(future, blockData, (LongSet)dirtyChunks, (Long2ObjectMap<ChunkData>)chunkDataMap, sortedChunkData, camera, translation);
            }
            catch (Exception e) {
                future.exception.set(new ExecutionException(e));
            }
        });
        return future;
    }

    private static void compileInner(CompileFuture compileFuture, Position2ObjectMap<class_2680> blockData, LongSet dirtyChunks, Long2ObjectMap<ChunkData> chunkDataMap, IntrusiveLinkedList<ChunkData> sortedChunkData, class_4184 camera, class_243 translation) {
        float sortX = (float)((camera != null ? camera.method_19326().field_1352 : 0.0) - translation.field_1352);
        float sortY = (float)((camera != null ? camera.method_19326().field_1351 : 0.0) - translation.field_1351);
        float sortZ = (float)((camera != null ? camera.method_19326().field_1350 : 0.0) - translation.field_1350);
        int sortChunkX = class_4076.method_32204((double)sortX);
        int sortChunkY = class_4076.method_32204((double)sortY);
        int sortChunkZ = class_4076.method_32204((double)sortZ);
        CleaningBufferBuilder outlineBuilder = new CleaningBufferBuilder(256);
        CleaningBufferBuilder blockBuilder = new CleaningBufferBuilder(256);
        class_776 renderManager = class_310.method_1551().method_1541();
        class_2338.class_2339 blockPos = new class_2338.class_2339();
        class_5819 rand = class_5819.method_43047();
        class_4587 matrices = new class_4587();
        MapBlockAndTintGetter blockAndTintGetter = new MapBlockAndTintGetter(blockData);
        LongIterator longIterator = dirtyChunks.longIterator();
        while (longIterator.hasNext()) {
            class_2680 dataState;
            boolean blockPlusYZ;
            boolean blockPlusXZ;
            boolean blockPlusXY;
            boolean blockPlusZ;
            boolean blockPlusY;
            boolean blockPlusYZ2;
            boolean blockPlusXZ2;
            boolean blockPlusXY2;
            boolean blockPlusZ2;
            boolean blockPlusY2;
            boolean blockPlusX;
            int index;
            if (compileFuture.cancelled.get()) {
                RenderSystem.recordRenderCall(() -> {
                    for (ChunkData chunkData : chunkDataMap.values()) {
                        if (chunkData.block != null) {
                            chunkData.block.close();
                            chunkData.block = null;
                        }
                        if (chunkData.outline == null) continue;
                        chunkData.outline.close();
                        chunkData.outline = null;
                    }
                });
                return;
            }
            long pos = longIterator.nextLong();
            int chunkX = class_2338.method_10061((long)pos);
            int chunkY = class_2338.method_10071((long)pos);
            int chunkZ = class_2338.method_10083((long)pos);
            int offsetX = chunkX * 16;
            int offsetY = chunkY * 16;
            int offsetZ = chunkZ * 16;
            blockBuilder.method_1328(class_293.class_5596.field_27382, AxiomVertexFormats.NOT_BLOCK);
            outlineBuilder.method_1328(class_293.class_5596.field_27377, class_290.field_29337);
            class_2680[] blocks = blockData.getChunk(pos);
            class_2680[] plusX = blockData.getChunk(class_2338.method_10064((int)(chunkX + 1), (int)chunkY, (int)chunkZ));
            class_2680[] plusY = blockData.getChunk(class_2338.method_10064((int)chunkX, (int)(chunkY + 1), (int)chunkZ));
            class_2680[] plusXY = blockData.getChunk(class_2338.method_10064((int)(chunkX + 1), (int)(chunkY + 1), (int)chunkZ));
            class_2680[] plusZ = blockData.getChunk(class_2338.method_10064((int)chunkX, (int)chunkY, (int)(chunkZ + 1)));
            class_2680[] plusXZ = blockData.getChunk(class_2338.method_10064((int)(chunkX + 1), (int)chunkY, (int)(chunkZ + 1)));
            class_2680[] plusYZ = blockData.getChunk(class_2338.method_10064((int)chunkX, (int)(chunkY + 1), (int)(chunkZ + 1)));
            boolean hasBlocks = false;
            Matrix4f currentPoseMatrix = matrices.method_23760().method_23761();
            Matrix4f basePoseMatrix = new Matrix4f((Matrix4fc)currentPoseMatrix);
            for (int z = 0; z < 15; ++z) {
                class_2680 dataState2;
                for (int y = 0; y < 15; ++y) {
                    class_2680 dataState3;
                    if (blocks != null) {
                        for (int x = 0; x < 15; ++x) {
                            index = z * 16 * 16 + y * 16 + x;
                            class_2680 dataState4 = blocks[index];
                            if (dataState4 != null) {
                                hasBlocks = true;
                                blockPos.method_10103(offsetX + x, offsetY + y, offsetZ + z);
                                OneshotBlockRegion.renderBlock(blockBuilder, renderManager, blockPos, rand, matrices, blockAndTintGetter, currentPoseMatrix, basePoseMatrix, x, y, z, dataState4);
                            }
                            boolean blockOutline = OneshotBlockRegion.shouldBlockBeOutlined(dataState4);
                            boolean blockPlusX2 = OneshotBlockRegion.shouldBlockBeOutlined(blocks[index + 1]);
                            boolean blockPlusY3 = OneshotBlockRegion.shouldBlockBeOutlined(blocks[index + 16]);
                            boolean blockPlusZ3 = OneshotBlockRegion.shouldBlockBeOutlined(blocks[index + 256]);
                            boolean blockPlusXY3 = OneshotBlockRegion.shouldBlockBeOutlined(blocks[index + 17]);
                            boolean blockPlusXZ3 = OneshotBlockRegion.shouldBlockBeOutlined(blocks[index + 257]);
                            boolean blockPlusYZ3 = OneshotBlockRegion.shouldBlockBeOutlined(blocks[index + 272]);
                            OneshotBlockRegion.renderOutline(outlineBuilder, x, y, z, blockOutline, blockPlusX2, blockPlusY3, blockPlusZ3, blockPlusXY3, blockPlusXZ3, blockPlusYZ3);
                        }
                    }
                    index = z * 16 * 16 + y * 16 + 15;
                    class_2680 class_26802 = dataState3 = blocks == null ? null : blocks[index];
                    if (dataState3 != null) {
                        hasBlocks = true;
                        blockPos.method_10103(offsetX + 15, offsetY + y, offsetZ + z);
                        OneshotBlockRegion.renderBlock(blockBuilder, renderManager, blockPos, rand, matrices, blockAndTintGetter, currentPoseMatrix, basePoseMatrix, 15, y, z, dataState3);
                    }
                    boolean blockOutline = OneshotBlockRegion.shouldBlockBeOutlined(dataState3);
                    blockPlusX = plusX != null && OneshotBlockRegion.shouldBlockBeOutlined(plusX[y * 16 + z * 16 * 16]);
                    blockPlusY2 = blocks != null && OneshotBlockRegion.shouldBlockBeOutlined(blocks[index + 16]);
                    blockPlusZ2 = blocks != null && OneshotBlockRegion.shouldBlockBeOutlined(blocks[index + 256]);
                    blockPlusXY2 = plusX != null && OneshotBlockRegion.shouldBlockBeOutlined(plusX[(y + 1) * 16 + z * 16 * 16]);
                    blockPlusXZ2 = plusX != null && OneshotBlockRegion.shouldBlockBeOutlined(plusX[y * 16 + (z + 1) * 16 * 16]);
                    blockPlusYZ2 = blocks != null && OneshotBlockRegion.shouldBlockBeOutlined(blocks[index + 272]);
                    OneshotBlockRegion.renderOutline(outlineBuilder, 15, y, z, blockOutline, blockPlusX, blockPlusY2, blockPlusZ2, blockPlusXY2, blockPlusXZ2, blockPlusYZ2);
                }
                for (int x = 0; x < 15; ++x) {
                    class_2680 dataState5;
                    index = z * 16 * 16 + 240 + x;
                    class_2680 class_26803 = dataState5 = blocks == null ? null : blocks[index];
                    if (dataState5 != null) {
                        hasBlocks = true;
                        blockPos.method_10103(offsetX + x, offsetY + 15, offsetZ + z);
                        OneshotBlockRegion.renderBlock(blockBuilder, renderManager, blockPos, rand, matrices, blockAndTintGetter, currentPoseMatrix, basePoseMatrix, x, 15, z, dataState5);
                    }
                    boolean blockOutline = OneshotBlockRegion.shouldBlockBeOutlined(dataState5);
                    blockPlusX = blocks != null && OneshotBlockRegion.shouldBlockBeOutlined(blocks[index + 1]);
                    blockPlusY2 = plusY != null && OneshotBlockRegion.shouldBlockBeOutlined(plusY[x + z * 16 * 16]);
                    blockPlusZ2 = blocks != null && OneshotBlockRegion.shouldBlockBeOutlined(blocks[index + 256]);
                    blockPlusXY2 = plusY != null && OneshotBlockRegion.shouldBlockBeOutlined(plusY[x + 1 + z * 16 * 16]);
                    blockPlusXZ2 = blocks != null && OneshotBlockRegion.shouldBlockBeOutlined(blocks[index + 257]);
                    blockPlusYZ2 = plusY != null && OneshotBlockRegion.shouldBlockBeOutlined(plusY[x + (z + 1) * 16 * 16]);
                    OneshotBlockRegion.renderOutline(outlineBuilder, x, 15, z, blockOutline, blockPlusX, blockPlusY2, blockPlusZ2, blockPlusXY2, blockPlusXZ2, blockPlusYZ2);
                }
                index = z * 16 * 16 + 240 + 15;
                class_2680 class_26804 = dataState2 = blocks == null ? null : blocks[index];
                if (dataState2 != null) {
                    hasBlocks = true;
                    blockPos.method_10103(offsetX + 15, offsetY + 15, offsetZ + z);
                    OneshotBlockRegion.renderBlock(blockBuilder, renderManager, blockPos, rand, matrices, blockAndTintGetter, currentPoseMatrix, basePoseMatrix, 15, 15, z, dataState2);
                }
                boolean blockOutline = OneshotBlockRegion.shouldBlockBeOutlined(dataState2);
                boolean blockPlusX3 = plusX != null && OneshotBlockRegion.shouldBlockBeOutlined(plusX[240 + z * 16 * 16]);
                blockPlusY = plusY != null && OneshotBlockRegion.shouldBlockBeOutlined(plusY[15 + z * 16 * 16]);
                blockPlusZ = blocks != null && OneshotBlockRegion.shouldBlockBeOutlined(blocks[index + 256]);
                blockPlusXY = plusXY != null && OneshotBlockRegion.shouldBlockBeOutlined(plusXY[z * 16 * 16]);
                blockPlusXZ = plusX != null && OneshotBlockRegion.shouldBlockBeOutlined(plusX[240 + (z + 1) * 16 * 16]);
                blockPlusYZ = plusY != null && OneshotBlockRegion.shouldBlockBeOutlined(plusY[15 + (z + 1) * 16 * 16]);
                OneshotBlockRegion.renderOutline(outlineBuilder, 15, 15, z, blockOutline, blockPlusX3, blockPlusY, blockPlusZ, blockPlusXY, blockPlusXZ, blockPlusYZ);
            }
            for (int y = 0; y < 15; ++y) {
                class_2680 dataState6;
                for (int x = 0; x < 15; ++x) {
                    class_2680 dataState7;
                    index = 3840 + y * 16 + x;
                    class_2680 class_26805 = dataState7 = blocks == null ? null : blocks[index];
                    if (dataState7 != null) {
                        hasBlocks = true;
                        blockPos.method_10103(offsetX + x, offsetY + y, offsetZ + 15);
                        OneshotBlockRegion.renderBlock(blockBuilder, renderManager, blockPos, rand, matrices, blockAndTintGetter, currentPoseMatrix, basePoseMatrix, x, y, 15, dataState7);
                    }
                    boolean blockOutline = OneshotBlockRegion.shouldBlockBeOutlined(dataState7);
                    blockPlusX = blocks != null && OneshotBlockRegion.shouldBlockBeOutlined(blocks[index + 1]);
                    blockPlusY2 = blocks != null && OneshotBlockRegion.shouldBlockBeOutlined(blocks[index + 16]);
                    blockPlusZ2 = plusZ != null && OneshotBlockRegion.shouldBlockBeOutlined(plusZ[x + y * 16]);
                    blockPlusXY2 = blocks != null && OneshotBlockRegion.shouldBlockBeOutlined(blocks[index + 17]);
                    blockPlusXZ2 = plusZ != null && OneshotBlockRegion.shouldBlockBeOutlined(plusZ[x + 1 + y * 16]);
                    blockPlusYZ2 = plusZ != null && OneshotBlockRegion.shouldBlockBeOutlined(plusZ[x + (y + 1) * 16]);
                    OneshotBlockRegion.renderOutline(outlineBuilder, x, y, 15, blockOutline, blockPlusX, blockPlusY2, blockPlusZ2, blockPlusXY2, blockPlusXZ2, blockPlusYZ2);
                }
                index = 3840 + y * 16 + 15;
                class_2680 class_26806 = dataState6 = blocks == null ? null : blocks[index];
                if (dataState6 != null) {
                    hasBlocks = true;
                    blockPos.method_10103(offsetX + 15, offsetY + y, offsetZ + 15);
                    OneshotBlockRegion.renderBlock(blockBuilder, renderManager, blockPos, rand, matrices, blockAndTintGetter, currentPoseMatrix, basePoseMatrix, 15, y, 15, dataState6);
                }
                boolean blockOutline = OneshotBlockRegion.shouldBlockBeOutlined(dataState6);
                boolean blockPlusX4 = plusX != null && OneshotBlockRegion.shouldBlockBeOutlined(plusX[y * 16 + 3840]);
                blockPlusY = blocks != null && OneshotBlockRegion.shouldBlockBeOutlined(blocks[index + 16]);
                blockPlusZ = plusZ != null && OneshotBlockRegion.shouldBlockBeOutlined(plusZ[15 + y * 16]);
                blockPlusXY = plusX != null && OneshotBlockRegion.shouldBlockBeOutlined(plusX[(y + 1) * 16 + 3840]);
                blockPlusXZ = plusXZ != null && OneshotBlockRegion.shouldBlockBeOutlined(plusXZ[y * 16]);
                blockPlusYZ = plusZ != null && OneshotBlockRegion.shouldBlockBeOutlined(plusZ[15 + (y + 1) * 16]);
                OneshotBlockRegion.renderOutline(outlineBuilder, 15, y, 15, blockOutline, blockPlusX4, blockPlusY, blockPlusZ, blockPlusXY, blockPlusXZ, blockPlusYZ);
            }
            for (int x = 0; x < 15; ++x) {
                class_2680 dataState8;
                index = 4080 + x;
                class_2680 class_26807 = dataState8 = blocks == null ? null : blocks[index];
                if (dataState8 != null) {
                    hasBlocks = true;
                    blockPos.method_10103(offsetX + x, offsetY + 15, offsetZ + 15);
                    OneshotBlockRegion.renderBlock(blockBuilder, renderManager, blockPos, rand, matrices, blockAndTintGetter, currentPoseMatrix, basePoseMatrix, x, 15, 15, dataState8);
                }
                boolean blockOutline = OneshotBlockRegion.shouldBlockBeOutlined(dataState8);
                boolean blockPlusX5 = blocks != null && OneshotBlockRegion.shouldBlockBeOutlined(blocks[index + 1]);
                blockPlusY = plusY != null && OneshotBlockRegion.shouldBlockBeOutlined(plusY[x + 3840]);
                blockPlusZ = plusZ != null && OneshotBlockRegion.shouldBlockBeOutlined(plusZ[x + 240]);
                blockPlusXY = plusY != null && OneshotBlockRegion.shouldBlockBeOutlined(plusY[x + 1 + 3840]);
                blockPlusXZ = plusZ != null && OneshotBlockRegion.shouldBlockBeOutlined(plusZ[x + 1 + 240]);
                blockPlusYZ = plusYZ != null && OneshotBlockRegion.shouldBlockBeOutlined(plusYZ[x]);
                OneshotBlockRegion.renderOutline(outlineBuilder, x, 15, 15, blockOutline, blockPlusX5, blockPlusY, blockPlusZ, blockPlusXY, blockPlusXZ, blockPlusYZ);
            }
            index = 4095;
            class_2680 class_26808 = dataState = blocks == null ? null : blocks[index];
            if (dataState != null) {
                hasBlocks = true;
                blockPos.method_10103(offsetX + 15, offsetY + 15, offsetZ + 15);
                OneshotBlockRegion.renderBlock(blockBuilder, renderManager, blockPos, rand, matrices, blockAndTintGetter, currentPoseMatrix, basePoseMatrix, 15, 15, 15, dataState);
            }
            boolean blockOutline = OneshotBlockRegion.shouldBlockBeOutlined(dataState);
            boolean blockPlusX6 = plusX != null && OneshotBlockRegion.shouldBlockBeOutlined(plusX[4080]);
            boolean blockPlusY4 = plusY != null && OneshotBlockRegion.shouldBlockBeOutlined(plusY[3855]);
            boolean blockPlusZ4 = plusZ != null && OneshotBlockRegion.shouldBlockBeOutlined(plusZ[255]);
            boolean blockPlusXY4 = plusXY != null && OneshotBlockRegion.shouldBlockBeOutlined(plusXY[3840]);
            boolean blockPlusXZ4 = plusXZ != null && OneshotBlockRegion.shouldBlockBeOutlined(plusXZ[240]);
            boolean blockPlusYZ4 = plusYZ != null && OneshotBlockRegion.shouldBlockBeOutlined(plusYZ[15]);
            OneshotBlockRegion.renderOutline(outlineBuilder, 15, 15, 15, blockOutline, blockPlusX6, blockPlusY4, blockPlusZ4, blockPlusXY4, blockPlusXZ4, blockPlusYZ4);
            currentPoseMatrix.set((Matrix4fc)basePoseMatrix);
            if (!blockBuilder.method_43574() || !outlineBuilder.method_43574()) {
                ChunkData chunkData = new ChunkData(offsetX, offsetY, offsetZ);
                chunkDataMap.put(pos, (Object)chunkData);
                sortedChunkData.add(chunkData);
                float dx = sortChunkX * 16 - chunkData.offsetX;
                float dy = sortChunkY * 16 - chunkData.offsetY;
                float dz = sortChunkZ * 16 - chunkData.offsetZ;
                chunkData.distanceSqToCamera = dx * dx + dy * dy + dz * dz;
                blockBuilder.method_49904(class_8251.method_49906((float)(sortX - (float)chunkData.offsetX), (float)(sortY - (float)chunkData.offsetY), (float)(sortZ - (float)chunkData.offsetZ)));
                chunkData.sortState = blockBuilder.method_1334();
                chunkData.renderedBufferBlocks = blockBuilder.method_43575();
                chunkData.renderedBufferOutline = outlineBuilder.method_43575();
                chunkData.hasBlocks = hasBlocks;
                continue;
            }
            blockBuilder.method_43575();
            outlineBuilder.method_43575();
        }
        sortedChunkData.sort(Comparator.comparingDouble(c -> -c.distanceSqToCamera));
        OneshotBlockRegion oneshotBlockRegion = new OneshotBlockRegion(chunkDataMap, sortedChunkData);
        oneshotBlockRegion.setSortInfo(System.currentTimeMillis(), sortX, sortY, sortZ, sortChunkX, sortChunkY, sortChunkZ);
        compileFuture.value.set(oneshotBlockRegion);
        if (compileFuture.cancelled.get()) {
            RenderSystem.recordRenderCall(() -> {
                for (ChunkData chunkData : chunkDataMap.values()) {
                    if (chunkData.block != null) {
                        chunkData.block.close();
                        chunkData.block = null;
                    }
                    if (chunkData.outline == null) continue;
                    chunkData.outline.close();
                    chunkData.outline = null;
                }
            });
        }
    }

    private static void renderOutline(class_287 outlineBuilder, int x, int y, int z, boolean blockOutline, boolean blockPlusX, boolean blockPlusY, boolean blockPlusZ, boolean blockPlusXY, boolean blockPlusXZ, boolean blockPlusYZ) {
        if (blockOutline ^ blockPlusZ ^ blockPlusY ^ blockPlusYZ) {
            outlineBuilder.method_22912((double)x, (double)(y + 1), (double)(z + 1)).method_39415(-1).method_22914(1.0f, 0.0f, 0.0f).method_1344();
            outlineBuilder.method_22912((double)(x + 1), (double)(y + 1), (double)(z + 1)).method_39415(-1).method_22914(1.0f, 0.0f, 0.0f).method_1344();
        }
        if (blockOutline ^ blockPlusZ ^ blockPlusX ^ blockPlusXZ) {
            outlineBuilder.method_22912((double)(x + 1), (double)y, (double)(z + 1)).method_39415(-1).method_22914(0.0f, 1.0f, 0.0f).method_1344();
            outlineBuilder.method_22912((double)(x + 1), (double)(y + 1), (double)(z + 1)).method_39415(-1).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        }
        if (blockOutline ^ blockPlusX ^ blockPlusY ^ blockPlusXY) {
            outlineBuilder.method_22912((double)(x + 1), (double)(y + 1), (double)z).method_39415(-1).method_22914(0.0f, 0.0f, 1.0f).method_1344();
            outlineBuilder.method_22912((double)(x + 1), (double)(y + 1), (double)(z + 1)).method_39415(-1).method_22914(0.0f, 0.0f, 1.0f).method_1344();
        }
    }

    private static void renderBlock(class_287 blockBuilder, class_776 renderManager, class_2338.class_2339 blockPos, class_5819 rand, class_4587 matrices, MapBlockAndTintGetter blockAndTintGetter, Matrix4f currentPoseMatrix, Matrix4f basePoseMatrix, int x, int y, int z, class_2680 dataState) {
        class_3610 fluid;
        class_2464 renderShape = dataState.method_26217();
        if (renderShape == class_2464.field_11458) {
            currentPoseMatrix.set((Matrix4fc)basePoseMatrix);
            currentPoseMatrix.translate((float)x, (float)y, (float)z);
            renderManager.method_3350().method_3373((class_1920)blockAndTintGetter, renderManager.method_3349(dataState), dataState, (class_2338)blockPos, matrices, (class_4588)blockBuilder, true, rand, dataState.method_26190((class_2338)blockPos), class_4608.field_21444);
        }
        if (!(fluid = dataState.method_26227()).method_15769()) {
            renderManager.method_3352((class_2338)blockPos, (class_1920)blockAndTintGetter, (class_4588)blockBuilder, dataState, fluid);
        }
    }

    public boolean wantsResort(class_4184 camera, class_243 translation) {
        if (this.sortedChunkData.isEmpty()) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.compiledSortMillis < 250L) {
            return false;
        }
        float sortX = (float)((camera != null ? camera.method_19326().field_1352 : 0.0) - translation.field_1352);
        float sortY = (float)((camera != null ? camera.method_19326().field_1351 : 0.0) - translation.field_1351);
        float sortZ = (float)((camera != null ? camera.method_19326().field_1350 : 0.0) - translation.field_1350);
        double dX = sortX - this.compiledSortX;
        double dY = sortY - this.compiledSortY;
        double dZ = sortZ - this.compiledSortZ;
        return dX * dX + dY * dY + dZ * dZ > 1.0;
    }

    public CompileFuture copyResort(class_4184 camera, class_243 translation) {
        this.doVertexUpload();
        float sortX = (float)((camera != null ? camera.method_19326().field_1352 : 0.0) - translation.field_1352);
        float sortY = (float)((camera != null ? camera.method_19326().field_1351 : 0.0) - translation.field_1351);
        float sortZ = (float)((camera != null ? camera.method_19326().field_1350 : 0.0) - translation.field_1350);
        int sortChunkX = class_4076.method_32204((double)sortX);
        int sortChunkY = class_4076.method_32204((double)sortY);
        int sortChunkZ = class_4076.method_32204((double)sortZ);
        boolean resortChunkList = sortChunkX != this.compiledSortChunkX || sortChunkY != this.compiledSortChunkY || sortChunkZ != this.compiledSortChunkZ;
        Long2ObjectOpenHashMap chunkDataMap = new Long2ObjectOpenHashMap();
        IntrusiveLinkedList<ChunkData> sortedChunkData = new IntrusiveLinkedList<ChunkData>();
        if (resortChunkList) {
            for (Long2ObjectMap.Entry entry : this.chunkDataMap.long2ObjectEntrySet()) {
                ChunkData newChunkData = new ChunkData((ChunkData)entry.getValue());
                chunkDataMap.put(entry.getLongKey(), (Object)newChunkData);
                sortedChunkData.add(newChunkData);
            }
        } else {
            for (ChunkData chunkData : this.sortedChunkData) {
                int chunkX = chunkData.offsetX >> 4;
                int chunkY = chunkData.offsetY >> 4;
                int chunkZ = chunkData.offsetZ >> 4;
                long pos = class_2338.method_10064((int)chunkX, (int)chunkY, (int)chunkZ);
                ChunkData newChunkData = new ChunkData(chunkData);
                chunkDataMap.put(pos, (Object)newChunkData);
                sortedChunkData.add(newChunkData);
            }
        }
        CompileFuture compileFuture = new CompileFuture();
        ChunkedRegionPool.submit(() -> OneshotBlockRegion.lambda$copyResort$7(sortedChunkData, sortX, sortY, sortZ, resortChunkList, sortChunkX, sortChunkY, sortChunkZ, (Long2ObjectMap)chunkDataMap, compileFuture));
        return compileFuture;
    }

    public CompileFuture copyCompile(Position2ObjectMap<class_2680> blockData, LongSet changed, class_4184 camera, class_243 translation) {
        int chunkZ;
        int chunkY;
        int chunkX;
        if (this.sortedChunkData.isEmpty()) {
            return OneshotBlockRegion.compile(blockData, camera, translation);
        }
        this.doVertexUpload();
        LongSet keep = blockData.chunkKeySet();
        LongOpenHashSet dirtyChunks = new LongOpenHashSet();
        LongIterator longIterator = changed.longIterator();
        while (longIterator.hasNext()) {
            long pos = longIterator.nextLong();
            int chunkX2 = class_2338.method_10061((long)pos);
            int chunkY2 = class_2338.method_10071((long)pos);
            int chunkZ2 = class_2338.method_10083((long)pos);
            dirtyChunks.add(class_2338.method_10064((int)(chunkX2 - 1), (int)chunkY2, (int)chunkZ2));
            dirtyChunks.add(class_2338.method_10064((int)(chunkX2 - 1), (int)(chunkY2 - 1), (int)chunkZ2));
            dirtyChunks.add(class_2338.method_10064((int)(chunkX2 - 1), (int)chunkY2, (int)(chunkZ2 - 1)));
            dirtyChunks.add(class_2338.method_10064((int)chunkX2, (int)(chunkY2 - 1), (int)chunkZ2));
            dirtyChunks.add(class_2338.method_10064((int)chunkX2, (int)(chunkY2 - 1), (int)(chunkZ2 - 1)));
            dirtyChunks.add(class_2338.method_10064((int)chunkX2, (int)chunkY2, (int)(chunkZ2 - 1)));
            dirtyChunks.add(class_2338.method_10064((int)(chunkX2 + 1), (int)chunkY2, (int)chunkZ2));
            dirtyChunks.add(class_2338.method_10064((int)chunkX2, (int)(chunkY2 + 1), (int)chunkZ2));
            dirtyChunks.add(class_2338.method_10064((int)chunkX2, (int)chunkY2, (int)(chunkZ2 + 1)));
            dirtyChunks.add(class_2338.method_10064((int)chunkX2, (int)chunkY2, (int)chunkZ2));
        }
        for (Long2ObjectMap.Entry entry : this.chunkDataMap.long2ObjectEntrySet()) {
            long pos = entry.getLongKey();
            if (!((ChunkData)entry.getValue()).hasBlocks || keep.contains(pos)) continue;
            chunkX = class_2338.method_10061((long)pos);
            chunkY = class_2338.method_10071((long)pos);
            chunkZ = class_2338.method_10083((long)pos);
            long nx = class_2338.method_10064((int)(chunkX - 1), (int)chunkY, (int)chunkZ);
            long nxy = class_2338.method_10064((int)(chunkX - 1), (int)(chunkY - 1), (int)chunkZ);
            long nxz = class_2338.method_10064((int)(chunkX - 1), (int)chunkY, (int)(chunkZ - 1));
            long ny = class_2338.method_10064((int)chunkX, (int)(chunkY - 1), (int)chunkZ);
            long nyz = class_2338.method_10064((int)chunkX, (int)(chunkY - 1), (int)(chunkZ - 1));
            long nz = class_2338.method_10064((int)chunkX, (int)chunkY, (int)(chunkZ - 1));
            long px = class_2338.method_10064((int)(chunkX + 1), (int)chunkY, (int)chunkZ);
            long py = class_2338.method_10064((int)chunkX, (int)(chunkY + 1), (int)chunkZ);
            long pz = class_2338.method_10064((int)chunkX, (int)chunkY, (int)(chunkZ + 1));
            if (keep.contains(nx)) {
                dirtyChunks.add(nx);
            }
            if (keep.contains(nxy)) {
                dirtyChunks.add(nxy);
            }
            if (keep.contains(nxz)) {
                dirtyChunks.add(nxz);
            }
            if (keep.contains(ny)) {
                dirtyChunks.add(ny);
            }
            if (keep.contains(nyz)) {
                dirtyChunks.add(nyz);
            }
            if (keep.contains(nz)) {
                dirtyChunks.add(nz);
            }
            if (keep.contains(px)) {
                dirtyChunks.add(px);
            }
            if (keep.contains(py)) {
                dirtyChunks.add(py);
            }
            if (!keep.contains(pz)) continue;
            dirtyChunks.add(pz);
        }
        Long2ObjectOpenHashMap chunkDataMap = new Long2ObjectOpenHashMap();
        IntrusiveLinkedList<ChunkData> sortedChunkData = new IntrusiveLinkedList<ChunkData>();
        longIterator = keep.longIterator();
        while (longIterator.hasNext()) {
            long pos = longIterator.nextLong();
            chunkX = class_2338.method_10061((long)pos);
            chunkY = class_2338.method_10071((long)pos);
            chunkZ = class_2338.method_10083((long)pos);
            this.tryCopyChunkData((LongSet)dirtyChunks, (Long2ObjectMap<ChunkData>)chunkDataMap, sortedChunkData, pos);
            this.tryCopyChunkData((LongSet)dirtyChunks, (Long2ObjectMap<ChunkData>)chunkDataMap, sortedChunkData, class_2338.method_10064((int)(chunkX - 1), (int)chunkY, (int)chunkZ));
            this.tryCopyChunkData((LongSet)dirtyChunks, (Long2ObjectMap<ChunkData>)chunkDataMap, sortedChunkData, class_2338.method_10064((int)(chunkX - 1), (int)(chunkY - 1), (int)chunkZ));
            this.tryCopyChunkData((LongSet)dirtyChunks, (Long2ObjectMap<ChunkData>)chunkDataMap, sortedChunkData, class_2338.method_10064((int)(chunkX - 1), (int)chunkY, (int)(chunkZ - 1)));
            this.tryCopyChunkData((LongSet)dirtyChunks, (Long2ObjectMap<ChunkData>)chunkDataMap, sortedChunkData, class_2338.method_10064((int)chunkX, (int)(chunkY - 1), (int)chunkZ));
            this.tryCopyChunkData((LongSet)dirtyChunks, (Long2ObjectMap<ChunkData>)chunkDataMap, sortedChunkData, class_2338.method_10064((int)chunkX, (int)(chunkY - 1), (int)(chunkZ - 1)));
            this.tryCopyChunkData((LongSet)dirtyChunks, (Long2ObjectMap<ChunkData>)chunkDataMap, sortedChunkData, class_2338.method_10064((int)chunkX, (int)chunkY, (int)(chunkZ - 1)));
        }
        CompileFuture future = new CompileFuture();
        ChunkedRegionPool.submit(() -> OneshotBlockRegion.lambda$copyCompile$9(future, blockData, (LongSet)dirtyChunks, (Long2ObjectMap)chunkDataMap, sortedChunkData, camera, translation));
        return future;
    }

    private void tryCopyChunkData(LongSet dirtyChunks, Long2ObjectMap<ChunkData> chunkDataMap, IntrusiveLinkedList<ChunkData> sortedChunkData, long pos) {
        ChunkData chunkData;
        if (!dirtyChunks.contains(pos) && !chunkDataMap.containsKey(pos) && (chunkData = (ChunkData)this.chunkDataMap.get(pos)) != null) {
            ChunkData clonedChunkData = new ChunkData(chunkData);
            chunkDataMap.put(pos, (Object)clonedChunkData);
            sortedChunkData.add(clonedChunkData);
        }
    }

    private static boolean shouldBlockBeOutlined(class_2680 blockState) {
        return blockState != null && !blockState.method_26215();
    }

    private static /* synthetic */ void lambda$copyCompile$9(CompileFuture future, Position2ObjectMap blockData, LongSet dirtyChunks, Long2ObjectMap chunkDataMap, IntrusiveLinkedList sortedChunkData, class_4184 camera, class_243 translation) {
        try {
            OneshotBlockRegion.compileInner(future, blockData, dirtyChunks, (Long2ObjectMap<ChunkData>)chunkDataMap, sortedChunkData, camera, translation);
        }
        catch (Exception e) {
            future.exception.set(new ExecutionException(e));
            RenderSystem.recordRenderCall(() -> {
                for (ChunkData chunkData : chunkDataMap.values()) {
                    if (chunkData.block != null) {
                        chunkData.block.close();
                        chunkData.block = null;
                    }
                    if (chunkData.outline == null) continue;
                    chunkData.outline.close();
                    chunkData.outline = null;
                }
            });
        }
    }

    private static /* synthetic */ void lambda$copyResort$7(IntrusiveLinkedList sortedChunkData, float sortX, float sortY, float sortZ, boolean resortChunkList, int sortChunkX, int sortChunkY, int sortChunkZ, Long2ObjectMap chunkDataMap, CompileFuture compileFuture) {
        try {
            CleaningBufferBuilder blockBuilder = new CleaningBufferBuilder(256);
            for (ChunkData chunkData : sortedChunkData) {
                float relSortX = sortX - (float)chunkData.offsetX;
                float relSortY = sortY - (float)chunkData.offsetY;
                float relSortZ = sortZ - (float)chunkData.offsetZ;
                if (chunkData.block != null) {
                    blockBuilder.method_1328(class_293.class_5596.field_27382, AxiomVertexFormats.NOT_BLOCK);
                    blockBuilder.method_1324(chunkData.sortState);
                    blockBuilder.method_49904(class_8251.method_49906((float)relSortX, (float)relSortY, (float)relSortZ));
                    chunkData.sortState = blockBuilder.method_1334();
                    chunkData.renderedBufferBlocks = blockBuilder.method_1326();
                }
                if (!resortChunkList) continue;
                float dx = sortChunkX * 16 - chunkData.offsetX;
                float dy = sortChunkY * 16 - chunkData.offsetY;
                float dz = sortChunkZ * 16 - chunkData.offsetZ;
                chunkData.distanceSqToCamera = dx * dx + dy * dy + dz * dz;
            }
            if (resortChunkList) {
                sortedChunkData.sort(Comparator.comparingDouble(c -> -c.distanceSqToCamera));
            }
            OneshotBlockRegion oneshotBlockRegion = new OneshotBlockRegion((Long2ObjectMap<ChunkData>)chunkDataMap, sortedChunkData);
            oneshotBlockRegion.setSortInfo(System.currentTimeMillis(), sortX, sortY, sortZ, sortChunkX, sortChunkY, sortChunkZ);
            compileFuture.value.set(oneshotBlockRegion);
            if (compileFuture.cancelled.get()) {
                RenderSystem.recordRenderCall(() -> {
                    for (ChunkData chunkData : chunkDataMap.values()) {
                        if (chunkData.block != null) {
                            chunkData.block.close();
                            chunkData.block = null;
                        }
                        if (chunkData.outline == null) continue;
                        chunkData.outline.close();
                        chunkData.outline = null;
                    }
                });
            }
        }
        catch (Exception e) {
            compileFuture.exception.set(new ExecutionException(e));
            RenderSystem.recordRenderCall(() -> {
                for (ChunkData chunkData : chunkDataMap.values()) {
                    if (chunkData.block != null) {
                        chunkData.block.close();
                        chunkData.block = null;
                    }
                    if (chunkData.outline == null) continue;
                    chunkData.outline.close();
                    chunkData.outline = null;
                }
            });
        }
    }

    private static final class ChunkData
    extends IntrusiveLinkedElement<ChunkData> {
        class_291 block = null;
        class_291 outline = null;
        class_287.class_7433 renderedBufferBlocks = null;
        class_287.class_7433 renderedBufferOutline = null;
        class_287.class_5594 sortState = null;
        boolean hasBlocks = false;
        final int offsetX;
        final int offsetY;
        final int offsetZ;
        float distanceSqToCamera;

        public ChunkData(int offsetX, int offsetY, int offsetZ) {
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.offsetZ = offsetZ;
        }

        public void upload() {
            if (this.renderedBufferBlocks != null) {
                if (this.block == null) {
                    this.block = new class_291(class_291.class_8555.field_44793);
                }
                this.block.method_1353();
                this.block.method_1352(this.renderedBufferBlocks);
                this.renderedBufferBlocks = null;
            }
            if (this.renderedBufferOutline != null) {
                if (this.outline == null) {
                    this.outline = new class_291(class_291.class_8555.field_44793);
                }
                this.outline.method_1353();
                this.outline.method_1352(this.renderedBufferOutline);
                this.renderedBufferOutline = null;
            }
        }

        public ChunkData(ChunkData other) {
            if (other.block != null) {
                this.block = new class_291(class_291.class_8555.field_44793);
                ((VertexBufferExt)this.block).copyFrom(other.block);
            }
            if (other.outline != null) {
                this.outline = new class_291(class_291.class_8555.field_44793);
                ((VertexBufferExt)this.outline).copyFrom(other.outline);
            }
            this.sortState = other.sortState;
            this.hasBlocks = other.hasBlocks;
            this.offsetX = other.offsetX;
            this.offsetY = other.offsetY;
            this.offsetZ = other.offsetZ;
            this.distanceSqToCamera = other.distanceSqToCamera;
        }
    }

    public static class CompileFuture {
        private final AtomicBoolean cancelled = new AtomicBoolean(false);
        private final AtomicReference<OneshotBlockRegion> value = new AtomicReference<Object>(null);
        private final AtomicReference<ExecutionException> exception = new AtomicReference();

        public void cancel() {
            this.cancelled.set(true);
            OneshotBlockRegion value = this.value.get();
            if (value != null) {
                value.close();
            }
        }

        public OneshotBlockRegion getIfDone() throws CancellationException, ExecutionException {
            OneshotBlockRegion value = this.value.get();
            boolean cancelled = this.cancelled.get();
            ExecutionException executionException = this.exception.get();
            if (executionException != null) {
                if (value != null) {
                    value.close();
                }
                throw executionException;
            }
            if (cancelled) {
                if (value != null) {
                    value.close();
                }
                throw new CancellationException();
            }
            return value;
        }
    }
}

