/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.render.regions;

import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_243;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL15;

public class InstancedBlockRegion {
    private final ChunkedBlockRegion chunkedBlockRegion;
    private final ByteBuffer byteBuffer = ByteBuffer.allocateDirect(16384).order(ByteOrder.nativeOrder());
    private List<class_243> lastTranslations = new ArrayList<class_243>();
    private final IntList uniformBufferObjects = new IntArrayList();
    private final IntList instanceCounts = new IntArrayList();

    public InstancedBlockRegion(ChunkedBlockRegion chunkedBlockRegion) {
        this.chunkedBlockRegion = chunkedBlockRegion;
    }

    public void render(class_4184 camera, class_4587 matrix, Matrix4f projection, float outlineOpacity, boolean polygonOffset) {
        this.chunkedBlockRegion.renderInstanced(camera, this.uniformBufferObjects, this.instanceCounts, matrix, projection, outlineOpacity, polygonOffset);
    }

    public void setTranslations(List<class_243> translations) {
        int ubo;
        this.instanceCounts.clear();
        for (int b = 0; b < translations.size(); b += 1000) {
            int count = Math.min(1000, translations.size() - b);
            if (this.lastTranslations.size() >= b + count) {
                for (int i = 0; i < count; ++i) {
                    class_243 translation = translations.get(b + i);
                    if (this.lastTranslations.get(b + i).equals((Object)translation)) continue;
                    int ubo2 = this.getUbo(b / 1000);
                    this.upload(ubo2, translations, b, b + count);
                    break;
                }
            } else {
                ubo = this.getUbo(b / 1000);
                this.upload(ubo, translations, b, b + count);
            }
            this.instanceCounts.add(count);
        }
        int toRemove = this.uniformBufferObjects.size() - this.instanceCounts.size();
        for (int i = 0; i < toRemove; ++i) {
            ubo = this.uniformBufferObjects.removeInt(this.uniformBufferObjects.size() - 1);
            GL15.glDeleteBuffers((int)ubo);
        }
        this.lastTranslations = new ArrayList<class_243>(translations);
    }

    private int getUbo(int index) {
        if (index < this.uniformBufferObjects.size()) {
            return this.uniformBufferObjects.getInt(index);
        }
        for (int i = this.uniformBufferObjects.size(); i <= index; ++i) {
            int ubo = GL15.glGenBuffers();
            this.uniformBufferObjects.add(ubo);
        }
        return this.uniformBufferObjects.getInt(this.uniformBufferObjects.size() - 1);
    }

    private void upload(int ubo, List<class_243> translations, int from, int to) {
        this.byteBuffer.clear();
        for (int i = from; i < to; ++i) {
            class_243 translation = translations.get(i);
            this.byteBuffer.putFloat((float)translation.field_1352);
            this.byteBuffer.putFloat((float)translation.field_1351);
            this.byteBuffer.putFloat((float)translation.field_1350);
            this.byteBuffer.putFloat(0.0f);
        }
        this.byteBuffer.flip();
        GL15.glBindBuffer((int)35345, (int)ubo);
        GL15.glBufferData((int)35345, (ByteBuffer)this.byteBuffer, (int)35044);
        GL15.glBindBuffer((int)35345, (int)0);
    }

    public void close() {
        for (int i = 0; i < this.uniformBufferObjects.size(); ++i) {
            int ubo = this.uniformBufferObjects.getInt(i);
            GL15.glDeleteBuffers((int)ubo);
        }
        this.lastTranslations.clear();
        this.uniformBufferObjects.clear();
        this.instanceCounts.clear();
    }
}

