/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.render.regions;

import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.render.regions.OneshotBooleanRegion;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import net.minecraft.class_243;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import org.joml.Matrix4f;

public class BufferedAsyncBooleanRegion {
    private OneshotBooleanRegion renderedBooleanRegion = null;
    private OneshotBooleanRegion.CompileFuture compilingBooleanRegion = null;
    private BufferedState previousState = null;
    private BufferedState pendingState = null;

    public void clear() {
        if (this.renderedBooleanRegion != null) {
            this.renderedBooleanRegion.close();
            this.renderedBooleanRegion = null;
        }
        if (this.compilingBooleanRegion != null) {
            this.compilingBooleanRegion.cancel();
            this.compilingBooleanRegion = null;
        }
        this.previousState = null;
        this.pendingState = null;
    }

    public boolean render(class_4184 camera, class_243 translation, class_4587 matrix, Matrix4f projection, long time, int effects) {
        if (this.compilingBooleanRegion != null) {
            try {
                OneshotBooleanRegion compiled = this.compilingBooleanRegion.getIfDone();
                if (compiled != null) {
                    if (this.renderedBooleanRegion != null) {
                        this.renderedBooleanRegion.close();
                    }
                    this.renderedBooleanRegion = compiled;
                    this.compilingBooleanRegion = null;
                    this.applyPending(camera, translation);
                }
            }
            catch (ExecutionException e) {
                this.compilingBooleanRegion = null;
            }
            catch (CancellationException e) {
                this.compilingBooleanRegion = null;
            }
        }
        if (this.compilingBooleanRegion == null && this.renderedBooleanRegion != null && this.renderedBooleanRegion.wantsResort(camera, class_243.field_1353)) {
            this.compilingBooleanRegion = this.renderedBooleanRegion.copyResort(camera, class_243.field_1353);
        }
        if (this.renderedBooleanRegion != null) {
            this.renderedBooleanRegion.render(camera, translation, matrix, projection, time, effects);
            return true;
        }
        return false;
    }

    public void pushState(BufferedState bufferedState, class_4184 camera, class_243 translation) {
        this.pendingState = bufferedState;
        this.applyPending(camera, translation);
    }

    private void applyPending(class_4184 camera, class_243 translation) {
        if (this.pendingState == null) {
            return;
        }
        if (this.compilingBooleanRegion != null) {
            return;
        }
        PositionSet pendingBlocks = this.pendingState.getBlocks();
        if (this.renderedBooleanRegion == null || this.previousState == null || this.pendingState.shouldForceRecompileFromScratch(this.previousState)) {
            this.compilingBooleanRegion = OneshotBooleanRegion.compile(pendingBlocks, camera, translation);
        } else {
            PositionSet previousBlocks = this.previousState.getBlocks();
            if (pendingBlocks == previousBlocks) {
                return;
            }
            LongSet changed = pendingBlocks.calculateChunksChanged(previousBlocks);
            if (changed.isEmpty() && pendingBlocks.chunkKeySet().size() == previousBlocks.chunkKeySet().size()) {
                this.previousState = this.pendingState;
                this.pendingState = null;
                return;
            }
            this.compilingBooleanRegion = this.renderedBooleanRegion.copyCompile(pendingBlocks, changed, camera, translation);
        }
        this.previousState = this.pendingState;
        this.pendingState = null;
    }

    public static interface BufferedState {
        public boolean shouldForceRecompileFromScratch(BufferedState var1);

        public PositionSet getBlocks();
    }
}

