/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.render.regions;

import com.moulberry.axiom.collections.Position2ObjectMap;
import com.moulberry.axiom.render.regions.OneshotBlockRegion;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import org.joml.Matrix4f;

public class BufferedAsyncBlockRegion {
    private OneshotBlockRegion renderedBlockRegion = null;
    private OneshotBlockRegion.CompileFuture compilingBlockRegion = null;
    private BufferedState previousState = null;
    private BufferedState pendingState = null;

    public void clear() {
        if (this.renderedBlockRegion != null) {
            this.renderedBlockRegion.close();
            this.renderedBlockRegion = null;
        }
        if (this.compilingBlockRegion != null) {
            this.compilingBlockRegion.cancel();
            this.compilingBlockRegion = null;
        }
        this.previousState = null;
        this.pendingState = null;
    }

    public void render(class_4184 camera, class_243 translation, class_4587 matrix, Matrix4f projection, float blockOpacity, float outlineOpacity) {
        if (this.compilingBlockRegion != null) {
            try {
                OneshotBlockRegion compiled = this.compilingBlockRegion.getIfDone();
                if (compiled != null) {
                    if (this.renderedBlockRegion != null) {
                        this.renderedBlockRegion.close();
                    }
                    this.renderedBlockRegion = compiled;
                    this.compilingBlockRegion = null;
                    this.applyPending(camera, translation);
                }
            }
            catch (ExecutionException e) {
                this.compilingBlockRegion = null;
            }
            catch (CancellationException e) {
                this.compilingBlockRegion = null;
            }
        }
        if (this.compilingBlockRegion == null && this.renderedBlockRegion != null && this.renderedBlockRegion.wantsResort(camera, class_243.field_1353)) {
            this.compilingBlockRegion = this.renderedBlockRegion.copyResort(camera, class_243.field_1353);
        }
        if (this.renderedBlockRegion != null) {
            this.renderedBlockRegion.render(camera, translation, matrix, projection, blockOpacity, outlineOpacity);
        }
    }

    public void pushState(BufferedState bufferedState, class_4184 camera, class_243 translation) {
        this.pendingState = bufferedState;
        this.applyPending(camera, translation);
    }

    private void applyPending(class_4184 camera, class_243 translation) {
        if (this.pendingState == null) {
            return;
        }
        if (this.compilingBlockRegion != null) {
            return;
        }
        Position2ObjectMap<class_2680> pendingBlocks = this.pendingState.getBlocks();
        if (this.renderedBlockRegion == null || this.previousState == null || this.pendingState.shouldForceRecompileFromScratch(this.previousState)) {
            this.compilingBlockRegion = OneshotBlockRegion.compile(pendingBlocks, camera, translation);
        } else {
            Position2ObjectMap<class_2680> previousBlocks = this.previousState.getBlocks();
            if (pendingBlocks == previousBlocks) {
                return;
            }
            LongSet changed = pendingBlocks.calculateChunksChanged(previousBlocks);
            if (changed.isEmpty() && pendingBlocks.chunkKeySet().size() == previousBlocks.chunkKeySet().size()) {
                this.previousState = this.pendingState;
                this.pendingState = null;
                return;
            }
            this.compilingBlockRegion = this.renderedBlockRegion.copyCompile(pendingBlocks, changed, camera, translation);
        }
        this.previousState = this.pendingState;
        this.pendingState = null;
    }

    public static interface BufferedState {
        public boolean shouldForceRecompileFromScratch(BufferedState var1);

        public Position2ObjectMap<class_2680> getBlocks();
    }
}

