/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.render.cache;

import com.google.common.collect.UnmodifiableIterator;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.utils.AxiomVertexFormats;
import com.moulberry.axiom.utils.UnsafeWrapper;
import it.unimi.dsi.fastutil.ints.Int2LongOpenHashMap;
import java.nio.ByteBuffer;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_293;
import net.minecraft.class_296;
import net.minecraft.class_311;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5819;
import net.minecraft.class_776;
import org.lwjgl.system.MemoryUtil;
import sun.misc.Unsafe;

public class TessellatedBlockCache {
    private class_2680 blockState = class_2246.field_10124.method_9564();
    private final class_5819 rand = class_5819.method_43047();
    private final class_4587 emptyPoseStack = new class_4587();
    private final class_287 bufferBuilder = new class_287(1024);
    private final Int2LongOpenHashMap offsets = new Int2LongOpenHashMap();
    private ByteBuffer vertexInformation = class_311.method_1596((int)1024);
    private class_293 format = null;
    private int formatStride = 0;
    private int formatPositionOffset = 0;

    public void clear() {
        this.offsets.clear();
        this.vertexInformation.clear();
    }

    public void setBlockState(class_2680 blockState) {
        if (this.blockState != blockState) {
            this.blockState = blockState;
            this.clear();
        }
    }

    public void close() {
        long address = UnsafeWrapper.UNSAFE.getAndSetLong(this.vertexInformation, UnsafeWrapper.ADDRESS, 0L);
        if (address != 0L) {
            class_311.field_34054.free(address);
        }
        if ((address = UnsafeWrapper.UNSAFE.getAndSetLong(this.bufferBuilder.field_1555, UnsafeWrapper.ADDRESS, 0L)) != 0L) {
            class_311.field_34054.free(address);
        }
        this.bufferBuilder.field_1555 = null;
    }

    public void setVertexFormat(class_293 vertexFormat) {
        class_296 element;
        if (this.format == vertexFormat) {
            return;
        }
        this.format = vertexFormat;
        this.formatStride = this.format.method_1362();
        this.formatPositionOffset = 0;
        UnmodifiableIterator unmodifiableIterator = this.format.method_1357().iterator();
        while (unmodifiableIterator.hasNext() && (!(element = (class_296)unmodifiableIterator.next()).method_35667() || element.method_1386() != class_296.class_297.field_1623 || element.method_34451() != 3)) {
            this.formatPositionOffset += element.method_1387();
        }
        if (this.formatPositionOffset >= this.formatStride) {
            this.formatPositionOffset = -1;
        }
        this.clear();
    }

    public void renderBlock(class_287 blockBuilder, class_776 renderManager, ChunkedBlockRegion region, class_2338 blockPos, int x, int y, int z) {
        int vertexCount;
        int position;
        Unsafe unsafe = UnsafeWrapper.UNSAFE;
        int wx = blockPos.method_10263();
        int wy = blockPos.method_10264();
        int wz = blockPos.method_10260();
        int neighborInfo = 0;
        if (region.getBlockStateOrNull(wx, wy, wz - 1) != null) {
            neighborInfo |= 0x20;
        }
        if (region.getBlockStateOrNull(wx, wy - 1, wz) != null) {
            neighborInfo |= 0x800;
        }
        if (region.getBlockStateOrNull(wx - 1, wy, wz) != null) {
            neighborInfo |= 0x2000;
        }
        if (region.getBlockStateOrNull(wx + 1, wy, wz) != null) {
            neighborInfo |= 0x8000;
        }
        if (region.getBlockStateOrNull(wx, wy + 1, wz) != null) {
            neighborInfo |= 0x20000;
        }
        if (region.getBlockStateOrNull(wx, wy, wz + 1) != null) {
            neighborInfo |= 0x800000;
        }
        if (neighborInfo != 8562720) {
            if (region.getBlockStateOrNull(wx - 1, wy - 1, wz - 1) != null) {
                neighborInfo |= 2;
            }
            if (region.getBlockStateOrNull(wx, wy - 1, wz - 1) != null) {
                neighborInfo |= 4;
            }
            if (region.getBlockStateOrNull(wx + 1, wy - 1, wz - 1) != null) {
                neighborInfo |= 8;
            }
            if (region.getBlockStateOrNull(wx - 1, wy, wz - 1) != null) {
                neighborInfo |= 0x10;
            }
            if (region.getBlockStateOrNull(wx + 1, wy, wz - 1) != null) {
                neighborInfo |= 0x40;
            }
            if (region.getBlockStateOrNull(wx - 1, wy + 1, wz - 1) != null) {
                neighborInfo |= 0x80;
            }
            if (region.getBlockStateOrNull(wx, wy + 1, wz - 1) != null) {
                neighborInfo |= 0x100;
            }
            if (region.getBlockStateOrNull(wx + 1, wy + 1, wz - 1) != null) {
                neighborInfo |= 0x200;
            }
            if (region.getBlockStateOrNull(wx - 1, wy - 1, wz) != null) {
                neighborInfo |= 0x400;
            }
            if (region.getBlockStateOrNull(wx + 1, wy - 1, wz) != null) {
                neighborInfo |= 0x1000;
            }
            if (region.getBlockStateOrNull(wx - 1, wy + 1, wz) != null) {
                neighborInfo |= 0x10000;
            }
            if (region.getBlockStateOrNull(wx + 1, wy + 1, wz) != null) {
                neighborInfo |= 0x40000;
            }
            if (region.getBlockStateOrNull(wx - 1, wy - 1, wz + 1) != null) {
                neighborInfo |= 0x80000;
            }
            if (region.getBlockStateOrNull(wx, wy - 1, wz + 1) != null) {
                neighborInfo |= 0x100000;
            }
            if (region.getBlockStateOrNull(wx + 1, wy - 1, wz + 1) != null) {
                neighborInfo |= 0x200000;
            }
            if (region.getBlockStateOrNull(wx - 1, wy, wz + 1) != null) {
                neighborInfo |= 0x400000;
            }
            if (region.getBlockStateOrNull(wx + 1, wy, wz + 1) != null) {
                neighborInfo |= 0x1000000;
            }
            if (region.getBlockStateOrNull(wx - 1, wy + 1, wz + 1) != null) {
                neighborInfo |= 0x2000000;
            }
            if (region.getBlockStateOrNull(wx, wy + 1, wz + 1) != null) {
                neighborInfo |= 0x4000000;
            }
            if (region.getBlockStateOrNull(wx + 1, wy + 1, wz + 1) != null) {
                neighborInfo |= 0x8000000;
            }
        }
        if (!this.offsets.containsKey(neighborInfo)) {
            class_287.class_7433 buffer;
            ByteBuffer data;
            class_3610 fluid;
            this.bufferBuilder.method_1328(class_293.class_5596.field_27382, AxiomVertexFormats.NOT_BLOCK);
            class_2464 renderShape = this.blockState.method_26217();
            if (renderShape == class_2464.field_11458) {
                class_1087 bakedModel = renderManager.method_3349(this.blockState);
                if (this.blockState.method_26213() == 0 && bakedModel.method_4708()) {
                    renderManager.method_3350().method_3361((class_1920)region, bakedModel, this.blockState, blockPos, this.emptyPoseStack, (class_4588)this.bufferBuilder, true, this.rand, this.blockState.method_26190(class_2338.field_10980), class_4608.field_21444);
                } else {
                    renderManager.method_3350().method_3373((class_1920)region, bakedModel, this.blockState, blockPos, this.emptyPoseStack, (class_4588)this.bufferBuilder, true, this.rand, this.blockState.method_26190(class_2338.field_10980), class_4608.field_21444);
                }
            }
            if (!(fluid = this.blockState.method_26227()).method_15769()) {
                long addr = MemoryUtil.memAddress((ByteBuffer)this.bufferBuilder.field_1555, (int)this.bufferBuilder.field_20884) + (long)this.formatPositionOffset;
                int oldVertices = this.bufferBuilder.field_1554;
                renderManager.method_3352(blockPos, (class_1920)region, (class_4588)this.bufferBuilder, this.blockState, fluid);
                if (this.formatPositionOffset >= 0) {
                    int liquidVertexCount = this.bufferBuilder.field_1554 - oldVertices;
                    for (int i = 0; i < liquidVertexCount; ++i) {
                        unsafe.putFloat(addr, unsafe.getFloat(addr) - (float)(blockPos.method_10263() & 0xF));
                        unsafe.putFloat(addr + 4L, unsafe.getFloat(addr + 4L) - (float)(blockPos.method_10264() & 0xF));
                        unsafe.putFloat(addr + 8L, unsafe.getFloat(addr + 8L) - (float)(blockPos.method_10260() & 0xF));
                        addr += (long)this.formatStride;
                    }
                }
            }
            if ((data = (buffer = this.bufferBuilder.method_1326()).method_43581()).limit() % this.formatStride != 0) {
                throw new FaultyImplementationError();
            }
            int needed = this.vertexInformation.position() + data.limit() + this.formatStride;
            if (needed >= this.vertexInformation.capacity()) {
                int newCapacity = class_3532.method_15339((int)needed);
                ByteBuffer newBuffer = class_311.method_37465((ByteBuffer)this.vertexInformation, (int)newCapacity);
                newBuffer.position(this.vertexInformation.position());
                this.vertexInformation = newBuffer;
            }
            unsafe.copyMemory(MemoryUtil.memAddress((ByteBuffer)data), MemoryUtil.memAddress((ByteBuffer)this.vertexInformation), data.limit());
            position = this.vertexInformation.position();
            vertexCount = data.limit() / this.formatStride;
            long info = (long)position & 0xFFFFFFFFL | ((long)vertexCount & 0xFFFFFFFFL) << 32;
            this.offsets.put(neighborInfo, info);
            this.vertexInformation.position(this.vertexInformation.position() + data.limit());
            buffer.method_43585();
            this.bufferBuilder.method_1343();
        } else {
            long info = this.offsets.get(neighborInfo);
            position = (int)(info & 0xFFFFFFFFL);
            vertexCount = (int)(info >>> 32 & 0xFFFFFFFFL);
        }
        if (vertexCount > 0) {
            int numBytes = vertexCount * this.formatStride;
            blockBuilder.method_1335(numBytes + this.formatStride);
            unsafe.copyMemory(MemoryUtil.memAddress((ByteBuffer)this.vertexInformation, (int)position), MemoryUtil.memAddress((ByteBuffer)blockBuilder.field_1555, (int)blockBuilder.field_20884), numBytes);
            if (this.formatPositionOffset >= 0) {
                long addr = MemoryUtil.memAddress((ByteBuffer)blockBuilder.field_1555, (int)blockBuilder.field_20884) + (long)this.formatPositionOffset;
                for (int i = 0; i < vertexCount; ++i) {
                    unsafe.putFloat(addr, unsafe.getFloat(addr) + (float)x);
                    unsafe.putFloat(addr + 4L, unsafe.getFloat(addr + 4L) + (float)y);
                    unsafe.putFloat(addr + 8L, unsafe.getFloat(addr + 8L) + (float)z);
                    addr += (long)this.formatStride;
                }
            }
            blockBuilder.field_1554 += vertexCount;
            blockBuilder.field_20884 += numBytes;
        }
    }
}

