/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.render;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.systems.RenderSystem;
import com.moulberry.axiom.configuration.Configuration;
import com.moulberry.axiom.render.ShaderManager;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.utils.FramebufferUtils;
import com.moulberry.axiom.utils.RenderHelper;
import com.moulberry.axiom.utils.UnsafeWrapper;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2682;
import net.minecraft.class_276;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2841;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_311;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4696;
import net.minecraft.class_5944;
import net.minecraft.class_638;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.lwjgl.opengl.GL11;

public enum CollisionMeshOverlayRenderer {
    INSTANCE;

    private static final class_293 COLLISION_MESH_VERTEX_FORMAT;
    private final Long2ObjectMap<class_291> chunkDataMap = new Long2ObjectOpenHashMap();
    private final LongSet tickDirtyChunkSet = new LongOpenHashSet();
    private final LongSet forgetChunkSet = new LongOpenHashSet();
    private boolean clearChunkData = false;
    private class_276 renderTarget;
    private static final int QUEUE_SIZE = 16;
    private final LongSet buildingChunkList = new LongOpenHashSet();
    private final LongSet ignoreBuiltChunkSet = new LongOpenHashSet();
    private final ArrayBlockingQueue<BuildTask> buildTasks = new ArrayBlockingQueue(16);
    private final ArrayBlockingQueue<BuildResult> buildResults = new ArrayBlockingQueue(16);

    public void render(class_4587 poseStack, Matrix4f projection, class_4184 camera) {
        class_638 level;
        if (this.clearChunkData) {
            BuildResult buildResult;
            BuildTask buildTask;
            this.clearChunkData = false;
            this.chunkDataMap.values().forEach(class_291::close);
            this.chunkDataMap.clear();
            while ((buildTask = this.buildTasks.poll()) != null) {
                this.buildingChunkList.remove(class_1923.method_8331((int)buildTask.chunkX, (int)buildTask.chunkZ));
            }
            while ((buildResult = this.buildResults.poll()) != null) {
                this.buildingChunkList.remove(class_1923.method_8331((int)buildResult.chunkX, (int)buildResult.chunkZ));
                ByteBuffer buffer = buildResult.bufferBuilder.field_1555;
                long address = UnsafeWrapper.UNSAFE.getAndSetLong(buffer, UnsafeWrapper.ADDRESS, 0L);
                if (address != 0L) {
                    class_311.field_34054.free(address);
                }
                buildResult.bufferBuilder.field_1555 = null;
            }
            this.ignoreBuiltChunkSet.addAll((LongCollection)this.buildingChunkList);
            this.buildingChunkList.clear();
        }
        if ((level = class_310.method_1551().field_1687) == null) {
            return;
        }
        if (!Configuration.blockAttributes.showCollisionMesh) {
            return;
        }
        class_5944 shader = ShaderManager.collisionMeshShader;
        if (shader == null) {
            return;
        }
        this.uploadDirty();
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
        GL11.glCullFace((int)1029);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)1, (int)0, (int)1, (int)0);
        float offsetY = level.method_31607();
        int mainWidth = class_310.method_1551().method_1522().field_1482;
        int mainHeight = class_310.method_1551().method_1522().field_1481;
        this.renderTarget = FramebufferUtils.resizeOrCreateFramebuffer(this.renderTarget, mainWidth, mainHeight);
        this.renderTarget.method_1230(class_310.field_1703);
        this.renderTarget.method_29329(class_310.method_1551().method_1522());
        this.renderTarget.method_1235(true);
        poseStack.method_22903();
        poseStack.method_22904(-camera.method_19326().field_1352, -camera.method_19326().field_1351, -camera.method_19326().field_1350);
        Matrix4f modelViewMatrix = poseStack.method_23760().method_23761();
        RenderHelper.setupShader(shader, modelViewMatrix, projection);
        Matrix4f translatedMatrix = new Matrix4f();
        for (Long2ObjectMap.Entry entry : this.chunkDataMap.long2ObjectEntrySet()) {
            if (shader.field_29470 != null) {
                int offsetX = class_1923.method_8325((long)entry.getLongKey()) * 16;
                int offsetZ = class_1923.method_8332((long)entry.getLongKey()) * 16;
                translatedMatrix.set((Matrix4fc)modelViewMatrix);
                translatedMatrix.translate((float)offsetX, offsetY, (float)offsetZ);
                shader.field_29470.method_1250(translatedMatrix);
                shader.field_29470.method_1300();
            }
            class_291 buffer = (class_291)entry.getValue();
            buffer.method_1353();
            buffer.method_35665();
        }
        RenderHelper.finishShader(shader);
        class_291.method_1354();
        poseStack.method_22909();
        RenderSystem.defaultBlendFunc();
        class_310.method_1551().method_1522().method_1235(true);
        FramebufferUtils.blitToScreenBlend(this.renderTarget, mainWidth, mainHeight);
    }

    public void uploadDirty() {
        BuildResult buildResult;
        long pos;
        LongIterator longIterator;
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        if (!this.forgetChunkSet.isEmpty()) {
            LongOpenHashSet removeBuilding = new LongOpenHashSet();
            longIterator = this.forgetChunkSet.longIterator();
            while (longIterator.hasNext()) {
                pos = longIterator.nextLong();
                class_291 vertexBuffer = (class_291)this.chunkDataMap.remove(pos);
                if (vertexBuffer != null) {
                    vertexBuffer.close();
                }
                if (!this.buildingChunkList.remove(pos)) continue;
                removeBuilding.add(pos);
            }
            this.forgetChunkSet.clear();
            this.buildTasks.removeIf(arg_0 -> CollisionMeshOverlayRenderer.lambda$uploadDirty$1((LongSet)removeBuilding, arg_0));
            this.buildResults.removeIf(arg_0 -> CollisionMeshOverlayRenderer.lambda$uploadDirty$2((LongSet)removeBuilding, arg_0));
            this.ignoreBuiltChunkSet.addAll((LongCollection)removeBuilding);
        }
        while ((buildResult = this.buildResults.poll()) != null) {
            long pos2 = class_1923.method_8331((int)buildResult.chunkX, (int)buildResult.chunkZ);
            if (!this.ignoreBuiltChunkSet.remove(pos2)) {
                class_291 vertexBuffer = (class_291)this.chunkDataMap.computeIfAbsent(pos2, k -> new class_291(class_291.class_8555.field_44793));
                vertexBuffer.method_1353();
                vertexBuffer.method_1352(buildResult.bufferBuilder.method_1326());
                class_291.method_1354();
            }
            this.buildingChunkList.remove(pos2);
            ByteBuffer buffer = buildResult.bufferBuilder.field_1555;
            long address = UnsafeWrapper.UNSAFE.getAndSetLong(buffer, UnsafeWrapper.ADDRESS, 0L);
            if (address != 0L) {
                class_311.field_34054.free(address);
            }
            buildResult.bufferBuilder.field_1555 = null;
        }
        if (this.tickDirtyChunkSet.isEmpty()) {
            return;
        }
        longIterator = this.tickDirtyChunkSet.longIterator();
        while (longIterator.hasNext()) {
            int chunkZ;
            pos = longIterator.nextLong();
            if (this.buildTasks.size() == 16) break;
            if (this.buildingChunkList.contains(pos) || this.ignoreBuiltChunkSet.contains(pos)) continue;
            longIterator.remove();
            int chunkX = class_1923.method_8325((long)pos);
            class_2818 chunk = (class_2818)level.method_8402(chunkX, chunkZ = class_1923.method_8332((long)pos), class_2806.field_12803, false);
            if (chunk == null) continue;
            ArrayList<class_2841<class_2680>> sections = new ArrayList<class_2841<class_2680>>();
            int sectionsCount = chunk.method_32890();
            for (int y = 0; y < sectionsCount; ++y) {
                class_2826 section = chunk.method_38259(y);
                if (section.method_38292()) {
                    sections.add(null);
                    continue;
                }
                sections.add((class_2841<class_2680>)section.method_12265().method_39957());
            }
            this.buildTasks.add(new BuildTask(sections, chunkX, chunkZ));
        }
    }

    private static void renderChunk(List<class_2841<class_2680>> sections, class_287 bufferBuilder) {
        bufferBuilder.method_1328(class_293.class_5596.field_27382, COLLISION_MESH_VERTEX_FORMAT);
        BoxConsumer consumer = new BoxConsumer();
        consumer.bufferBuilder = bufferBuilder;
        for (int x = 0; x < 16; ++x) {
            consumer.x = x;
            for (int z = 0; z < 16; ++z) {
                consumer.z = z;
                for (int sectionIndex = 0; sectionIndex < sections.size(); ++sectionIndex) {
                    class_2841<class_2680> container = sections.get(sectionIndex);
                    if (container == null) continue;
                    for (int y = 0; y < 16; ++y) {
                        class_265 collision;
                        class_2680 blockState = (class_2680)container.method_12321(x, y, z);
                        if (blockState.method_26215() || (collision = blockState.method_26220((class_1922)class_2682.field_12294, class_2338.field_10980)) == class_259.method_1077() && blockState.method_26217() == class_2464.field_11458 && class_4696.method_23679((class_2680)blockState) == class_1921.method_23577() || collision == class_259.method_1073() || collision.method_1110()) continue;
                        consumer.y = y + sectionIndex * 16;
                        collision.method_1089((class_259.class_260)consumer);
                    }
                }
            }
        }
    }

    public void clear() {
        this.tickDirtyChunkSet.clear();
        this.forgetChunkSet.clear();
        this.clearChunkData = true;
    }

    public void markDirty(int chunkX, int chunkZ) {
        long pos = class_1923.method_8331((int)chunkX, (int)chunkZ);
        this.tickDirtyChunkSet.add(pos);
    }

    public void forgetChunk(int chunkX, int chunkZ) {
        long pos = class_1923.method_8331((int)chunkX, (int)chunkZ);
        this.forgetChunkSet.add(pos);
        this.tickDirtyChunkSet.remove(pos);
    }

    private static /* synthetic */ boolean lambda$uploadDirty$2(LongSet removeBuilding, BuildResult buildResult) {
        if (removeBuilding.remove(class_1923.method_8331((int)buildResult.chunkX, (int)buildResult.chunkZ))) {
            ByteBuffer buffer = buildResult.bufferBuilder.field_1555;
            long address = UnsafeWrapper.UNSAFE.getAndSetLong(buffer, UnsafeWrapper.ADDRESS, 0L);
            if (address != 0L) {
                class_311.field_34054.free(address);
            }
            buildResult.bufferBuilder.field_1555 = null;
            return true;
        }
        return false;
    }

    private static /* synthetic */ boolean lambda$uploadDirty$1(LongSet removeBuilding, BuildTask buildTask) {
        return removeBuilding.remove(class_1923.method_8331((int)buildTask.chunkX, (int)buildTask.chunkZ));
    }

    static {
        COLLISION_MESH_VERTEX_FORMAT = new class_293(ImmutableMap.builder().put((Object)"Position", (Object)class_290.field_1587).put((Object)"Color", (Object)class_290.field_1581).put((Object)"UV0", (Object)class_290.field_1591).build());
        Tool.sharedPoolThreadExecutor.submit(() -> {
            try {
                while (true) {
                    BuildTask task = CollisionMeshOverlayRenderer.INSTANCE.buildTasks.take();
                    class_287 bufferBuilder = new class_287(256);
                    CollisionMeshOverlayRenderer.renderChunk(task.sections, bufferBuilder);
                    CollisionMeshOverlayRenderer.INSTANCE.buildResults.put(new BuildResult(bufferBuilder, task.chunkX, task.chunkZ));
                }
            }
            catch (Throwable t2) {
                t2.printStackTrace();
                return;
            }
        });
    }

    private record BuildTask(List<class_2841<class_2680>> sections, int chunkX, int chunkZ) {
    }

    private record BuildResult(class_287 bufferBuilder, int chunkX, int chunkZ) {
    }

    private static class BoxConsumer
    implements class_259.class_260 {
        public class_287 bufferBuilder;
        public int x;
        public int y;
        public int z;

        private BoxConsumer() {
        }

        public void consume(double x1, double y1, double z1, double x2, double y2, double z2) {
            float widthX = 1.0f / (float)Math.abs(x2 - x1);
            float widthY = 1.0f / (float)Math.abs(y2 - y1);
            float widthZ = 1.0f / (float)Math.abs(z2 - z1);
            this.bufferBuilder.method_22912((double)this.x + x1, (double)this.y + y1, (double)this.z + z1).method_22915(1.0f, 0.0f, 0.0f, 1.0f).method_22913(-widthY, -widthZ).method_1344();
            this.bufferBuilder.method_22912((double)this.x + x1, (double)this.y + y1, (double)this.z + z2).method_22915(1.0f, 0.0f, 0.0f, 1.0f).method_22913(-widthY, widthZ).method_1344();
            this.bufferBuilder.method_22912((double)this.x + x1, (double)this.y + y2, (double)this.z + z2).method_22915(1.0f, 0.0f, 0.0f, 1.0f).method_22913(widthY, widthZ).method_1344();
            this.bufferBuilder.method_22912((double)this.x + x1, (double)this.y + y2, (double)this.z + z1).method_22915(1.0f, 0.0f, 0.0f, 1.0f).method_22913(widthY, -widthZ).method_1344();
            this.bufferBuilder.method_22912((double)this.x + x2, (double)this.y + y2, (double)this.z + z1).method_22915(1.0f, 0.0f, 0.0f, 1.0f).method_22913(widthY, -widthZ).method_1344();
            this.bufferBuilder.method_22912((double)this.x + x2, (double)this.y + y2, (double)this.z + z2).method_22915(1.0f, 0.0f, 0.0f, 1.0f).method_22913(widthY, widthZ).method_1344();
            this.bufferBuilder.method_22912((double)this.x + x2, (double)this.y + y1, (double)this.z + z2).method_22915(1.0f, 0.0f, 0.0f, 1.0f).method_22913(-widthY, widthZ).method_1344();
            this.bufferBuilder.method_22912((double)this.x + x2, (double)this.y + y1, (double)this.z + z1).method_22915(1.0f, 0.0f, 0.0f, 1.0f).method_22913(-widthY, -widthZ).method_1344();
            this.bufferBuilder.method_22912((double)this.x + x1, (double)this.y + y2, (double)this.z + z1).method_22915(1.0f, 0.0f, 0.0f, 1.0f).method_22913(-widthX, -widthZ).method_1344();
            this.bufferBuilder.method_22912((double)this.x + x1, (double)this.y + y2, (double)this.z + z2).method_22915(1.0f, 0.0f, 0.0f, 1.0f).method_22913(-widthX, widthZ).method_1344();
            this.bufferBuilder.method_22912((double)this.x + x2, (double)this.y + y2, (double)this.z + z2).method_22915(1.0f, 0.0f, 0.0f, 1.0f).method_22913(widthX, widthZ).method_1344();
            this.bufferBuilder.method_22912((double)this.x + x2, (double)this.y + y2, (double)this.z + z1).method_22915(1.0f, 0.0f, 0.0f, 1.0f).method_22913(widthX, -widthZ).method_1344();
            this.bufferBuilder.method_22912((double)this.x + x2, (double)this.y + y1, (double)this.z + z1).method_22915(1.0f, 0.0f, 0.0f, 1.0f).method_22913(widthX, -widthZ).method_1344();
            this.bufferBuilder.method_22912((double)this.x + x2, (double)this.y + y1, (double)this.z + z2).method_22915(1.0f, 0.0f, 0.0f, 1.0f).method_22913(widthX, widthZ).method_1344();
            this.bufferBuilder.method_22912((double)this.x + x1, (double)this.y + y1, (double)this.z + z2).method_22915(1.0f, 0.0f, 0.0f, 1.0f).method_22913(-widthX, widthZ).method_1344();
            this.bufferBuilder.method_22912((double)this.x + x1, (double)this.y + y1, (double)this.z + z1).method_22915(1.0f, 0.0f, 0.0f, 1.0f).method_22913(-widthX, -widthZ).method_1344();
            this.bufferBuilder.method_22912((double)this.x + x1, (double)this.y + y1, (double)this.z + z2).method_22915(1.0f, 0.0f, 0.0f, 1.0f).method_22913(-widthY, -widthX).method_1344();
            this.bufferBuilder.method_22912((double)this.x + x2, (double)this.y + y1, (double)this.z + z2).method_22915(1.0f, 0.0f, 0.0f, 1.0f).method_22913(-widthY, widthX).method_1344();
            this.bufferBuilder.method_22912((double)this.x + x2, (double)this.y + y2, (double)this.z + z2).method_22915(1.0f, 0.0f, 0.0f, 1.0f).method_22913(widthY, widthX).method_1344();
            this.bufferBuilder.method_22912((double)this.x + x1, (double)this.y + y2, (double)this.z + z2).method_22915(1.0f, 0.0f, 0.0f, 1.0f).method_22913(widthY, -widthX).method_1344();
            this.bufferBuilder.method_22912((double)this.x + x1, (double)this.y + y2, (double)this.z + z1).method_22915(1.0f, 0.0f, 0.0f, 1.0f).method_22913(widthY, -widthX).method_1344();
            this.bufferBuilder.method_22912((double)this.x + x2, (double)this.y + y2, (double)this.z + z1).method_22915(1.0f, 0.0f, 0.0f, 1.0f).method_22913(widthY, widthX).method_1344();
            this.bufferBuilder.method_22912((double)this.x + x2, (double)this.y + y1, (double)this.z + z1).method_22915(1.0f, 0.0f, 0.0f, 1.0f).method_22913(-widthY, widthX).method_1344();
            this.bufferBuilder.method_22912((double)this.x + x1, (double)this.y + y1, (double)this.z + z1).method_22915(1.0f, 0.0f, 0.0f, 1.0f).method_22913(-widthY, -widthX).method_1344();
        }
    }
}

