/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.moulberry.axiom.collections.Position2ObjectMap;
import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.utils.NvidiumApiWrapper;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.blockview.v2.FabricBlockView;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachedBlockView;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_284;
import net.minecraft.class_2841;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3568;
import net.minecraft.class_3610;
import net.minecraft.class_4076;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_5944;
import net.minecraft.class_638;
import net.minecraft.class_6539;
import net.minecraft.class_750;
import net.minecraft.class_776;
import net.minecraft.class_778;
import net.minecraft.class_8251;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public final class ChunkRenderOverrider
extends Enum<ChunkRenderOverrider> {
    public static final /* enum */ ChunkRenderOverrider INSTANCE = new ChunkRenderOverrider();
    private final Position2ObjectMap<class_2680> blocksOverride = new Position2ObjectMap(k -> new class_2680[4096]);
    private final AtomicBoolean stopBuilding = new AtomicBoolean(false);
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final Lock lock = new ReentrantLock();
    private String lockedBy = null;
    private AABBCutoutMode aabbCutoutMode = null;
    private AABBCutoutMode pendingAabbCutoutMode = null;
    private BooleanCutoutMode pendingBooleanCutoutMode = null;
    private final class_750 chunkBufferBuilderPack = new class_750();
    private final Long2ObjectMap<RenderedChunkData> chunkData = new Long2ObjectOpenHashMap();
    private LongSet dirtyChunks = new LongOpenHashSet();
    private Future<CompileData> compileFuture = null;
    private final Set<class_1921> globalHasBlocks = new ObjectArraySet(class_1921.method_22720().size());
    private long lastSortMillis;
    private float lastSortX;
    private float lastSortY;
    private float lastSortZ;
    private int lastSortChunkX;
    private int lastSortChunkY;
    private int lastSortChunkZ;
    private final List<RenderedChunkData> sortedChunkData = new ArrayList<RenderedChunkData>();
    private static final /* synthetic */ ChunkRenderOverrider[] $VALUES;

    public static ChunkRenderOverrider[] values() {
        return (ChunkRenderOverrider[])$VALUES.clone();
    }

    public static ChunkRenderOverrider valueOf(String name) {
        return Enum.valueOf(ChunkRenderOverrider.class, name);
    }

    private static <T> Map<class_1921, T> createRenderTypeMap(Supplier<T> supplier) {
        Object2ObjectArrayMap map = new Object2ObjectArrayMap();
        for (class_1921 renderType : class_1921.method_22720()) {
            map.put(renderType, supplier.get());
        }
        return map;
    }

    private static class_2680[] loadBlocks(long k) {
        class_2338 pos;
        class_2791 chunk;
        Object[] array = new class_2680[4096];
        if (class_310.method_1551().field_1687 != null && (chunk = class_310.method_1551().field_1687.method_8402((pos = class_2338.method_10092((long)k)).method_10263(), pos.method_10260(), class_2806.field_12803, false)) != null) {
            int sectionIndex = chunk.method_31603(pos.method_10264());
            class_2841 states = chunk.method_38259(sectionIndex).method_12265();
            int index = 0;
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 16; ++y) {
                    for (int x = 0; x < 16; ++x) {
                        array[index++] = (class_2680)states.method_12321(x, y, z);
                    }
                }
            }
            return array;
        }
        Arrays.fill(array, class_2246.field_10124.method_9564());
        return array;
    }

    public void acquire(String identifier) {
        if (this.lockedBy != null || !this.lock.tryLock()) {
            throw new Error("ChunkRenderOverrider: '" + identifier + "' tried to acquire() when it shouldn't have OR '" + this.lockedBy + "' forgot to call release()... naughty naughty");
        }
        this.lockedBy = identifier;
    }

    public void release(String identifier) {
        if (!identifier.equals(this.lockedBy)) {
            throw new Error("ChunkRenderOverrider: '" + identifier + "' tried to release() even though '" + this.lockedBy + "' owns it");
        }
        this.lockedBy = null;
        this.clear();
        this.lock.unlock();
    }

    public void invalidateChunkSection(int x, int y, int z) {
        if (this.chunkData.isEmpty()) {
            return;
        }
        long key = class_2338.method_10064((int)x, (int)y, (int)z);
        if (this.chunkData.containsKey(key)) {
            this.dirtyChunks.add(key);
        }
    }

    public void clear() {
        if (this.compileFuture != null) {
            this.stopBuilding.set(true);
        }
        this.blocksOverride.clear();
        this.dirtyChunks.clear();
        this.sortedChunkData.forEach(data -> data.buffers.forEach((type2, buffer) -> buffer.close()));
        this.pendingAabbCutoutMode = null;
        this.aabbCutoutMode = null;
        this.pendingBooleanCutoutMode = null;
        this.globalHasBlocks.clear();
        this.sortedChunkData.clear();
        if (NvidiumApiWrapper.isNvidiumAvailable()) {
            this.unhideAllNvidium();
        }
        this.chunkData.clear();
    }

    private void unhideAllNvidium() {
        LongIterator longIterator = this.chunkData.keySet().longIterator();
        while (longIterator.hasNext()) {
            long pos = longIterator.nextLong();
            NvidiumApiWrapper.showSection(class_2338.method_10061((long)pos), class_2338.method_10071((long)pos), class_2338.method_10083((long)pos));
        }
    }

    public boolean isOverridingSection(int sx, int sy, int sz) {
        if (this.aabbCutoutMode != null) {
            return this.aabbCutoutMode.minSection.method_18674() <= sx && this.aabbCutoutMode.minSection.method_18683() <= sy && this.aabbCutoutMode.minSection.method_18687() <= sz && this.aabbCutoutMode.maxSection.method_18674() >= sx && this.aabbCutoutMode.maxSection.method_18683() >= sy && this.aabbCutoutMode.maxSection.method_18687() >= sz;
        }
        return this.chunkData.containsKey(class_2338.method_10064((int)sx, (int)sy, (int)sz));
    }

    public void render(class_1921 renderType, Matrix4f modelViewMatrix, Matrix4f projection, double cameraX, double cameraY, double cameraZ) {
        if (this.sortedChunkData.isEmpty()) {
            return;
        }
        if (!this.globalHasBlocks.contains(renderType)) {
            return;
        }
        renderType.method_23516();
        class_5944 shaderInstance = Objects.requireNonNull(RenderSystem.getShader());
        for (int n = 0; n < 12; ++n) {
            int o = RenderSystem.getShaderTexture((int)n);
            shaderInstance.method_34583("Sampler" + n, (Object)o);
        }
        if (shaderInstance.field_29470 != null) {
            shaderInstance.field_29470.method_1250(modelViewMatrix);
        }
        if (shaderInstance.field_29471 != null) {
            shaderInstance.field_29471.method_1250(projection);
        }
        if (shaderInstance.field_29474 != null) {
            shaderInstance.field_29474.method_1253(RenderSystem.getShaderColor());
        }
        if (shaderInstance.field_42231 != null) {
            shaderInstance.field_42231.method_1251(RenderSystem.getShaderGlintAlpha());
        }
        if (shaderInstance.field_29477 != null) {
            shaderInstance.field_29477.method_1251(RenderSystem.getShaderFogStart());
        }
        if (shaderInstance.field_29478 != null) {
            shaderInstance.field_29478.method_1251(RenderSystem.getShaderFogEnd());
        }
        if (shaderInstance.field_29479 != null) {
            shaderInstance.field_29479.method_1253(RenderSystem.getShaderFogColor());
        }
        if (shaderInstance.field_36373 != null) {
            shaderInstance.field_36373.method_35649(RenderSystem.getShaderFogShape().method_40036());
        }
        if (shaderInstance.field_29472 != null) {
            shaderInstance.field_29472.method_1250(RenderSystem.getTextureMatrix());
        }
        if (shaderInstance.field_29481 != null) {
            shaderInstance.field_29481.method_1251(RenderSystem.getShaderGameTime());
        }
        RenderSystem.setupShaderLights((class_5944)shaderInstance);
        shaderInstance.method_34586();
        class_284 uniform = shaderInstance.field_29482;
        if (renderType == class_1921.method_23583()) {
            for (int i = this.sortedChunkData.size() - 1; i >= 0; --i) {
                RenderedChunkData chunkDatum = this.sortedChunkData.get(i);
                if (!chunkDatum.hasBlocks.contains(renderType)) continue;
                if (uniform != null) {
                    uniform.method_1249((float)((double)chunkDatum.offsetX - cameraX), (float)((double)chunkDatum.offsetY - cameraY), (float)((double)chunkDatum.offsetZ - cameraZ));
                    uniform.method_1300();
                }
                class_291 buffer = chunkDatum.buffers.get(renderType);
                buffer.method_1353();
                buffer.method_35665();
            }
        } else {
            for (RenderedChunkData chunkDatum : this.sortedChunkData) {
                if (!chunkDatum.hasBlocks.contains(renderType)) continue;
                if (uniform != null) {
                    uniform.method_1249((float)((double)chunkDatum.offsetX - cameraX), (float)((double)chunkDatum.offsetY - cameraY), (float)((double)chunkDatum.offsetZ - cameraZ));
                    uniform.method_1300();
                }
                class_291 buffer = chunkDatum.buffers.get(renderType);
                buffer.method_1353();
                buffer.method_35665();
            }
        }
        if (uniform != null) {
            uniform.method_1249(0.0f, 0.0f, 0.0f);
        }
        shaderInstance.method_34585();
        class_291.method_1354();
        renderType.method_23518();
    }

    public void revertBlock(int x, int y, int z) {
        int mz;
        int pz;
        int my;
        int py;
        int mx;
        class_638 level = class_310.method_1551().field_1687;
        if (level == null || y < level.method_31607() || y > level.method_31600() - 1) {
            return;
        }
        int cx = x >> 4;
        int cy = y >> 4;
        int cz = z >> 4;
        this.blocksOverride.put(x, y, z, null);
        this.dirtyChunks.add(class_2338.method_10064((int)cx, (int)cy, (int)cz));
        int px = x + 1 >> 4;
        if (px != cx) {
            long pos = class_2338.method_10064((int)px, (int)cy, (int)cz);
            this.blocksOverride.getOrCreateChunk(pos);
            this.dirtyChunks.add(pos);
        }
        if ((mx = x - 1 >> 4) != cx) {
            long pos = class_2338.method_10064((int)mx, (int)cy, (int)cz);
            this.blocksOverride.getOrCreateChunk(pos);
            this.dirtyChunks.add(pos);
        }
        if ((py = y + 1 >> 4) != cy && py <= level.method_31597() - 1) {
            long pos = class_2338.method_10064((int)cx, (int)py, (int)cz);
            this.blocksOverride.getOrCreateChunk(pos);
            this.dirtyChunks.add(pos);
        }
        if ((my = y - 1 >> 4) != cy && my >= level.method_32891()) {
            long pos = class_2338.method_10064((int)cx, (int)my, (int)cz);
            this.blocksOverride.getOrCreateChunk(pos);
            this.dirtyChunks.add(pos);
        }
        if ((pz = z + 1 >> 4) != cz) {
            long pos = class_2338.method_10064((int)cx, (int)cy, (int)pz);
            this.blocksOverride.getOrCreateChunk(pos);
            this.dirtyChunks.add(pos);
        }
        if ((mz = z - 1 >> 4) != cz) {
            long pos = class_2338.method_10064((int)cx, (int)cy, (int)mz);
            this.blocksOverride.getOrCreateChunk(pos);
            this.dirtyChunks.add(pos);
        }
    }

    public void setBlock(int x, int y, int z, class_2680 block) {
        int mz;
        int pz;
        int my;
        int py;
        int mx;
        class_638 level = class_310.method_1551().field_1687;
        if (level == null || y < level.method_31607() || y > level.method_31600() - 1) {
            return;
        }
        int cx = x >> 4;
        int cy = y >> 4;
        int cz = z >> 4;
        this.blocksOverride.put(x, y, z, block);
        this.dirtyChunks.add(class_2338.method_10064((int)cx, (int)cy, (int)cz));
        int px = x + 1 >> 4;
        if (px != cx) {
            long pos = class_2338.method_10064((int)px, (int)cy, (int)cz);
            this.blocksOverride.getOrCreateChunk(pos);
            this.dirtyChunks.add(pos);
        }
        if ((mx = x - 1 >> 4) != cx) {
            long pos = class_2338.method_10064((int)mx, (int)cy, (int)cz);
            this.blocksOverride.getOrCreateChunk(pos);
            this.dirtyChunks.add(pos);
        }
        if ((py = y + 1 >> 4) != cy && py <= level.method_31597() - 1) {
            long pos = class_2338.method_10064((int)cx, (int)py, (int)cz);
            this.blocksOverride.getOrCreateChunk(pos);
            this.dirtyChunks.add(pos);
        }
        if ((my = y - 1 >> 4) != cy && my >= level.method_32891()) {
            long pos = class_2338.method_10064((int)cx, (int)my, (int)cz);
            this.blocksOverride.getOrCreateChunk(pos);
            this.dirtyChunks.add(pos);
        }
        if ((pz = z + 1 >> 4) != cz) {
            long pos = class_2338.method_10064((int)cx, (int)cy, (int)pz);
            this.blocksOverride.getOrCreateChunk(pos);
            this.dirtyChunks.add(pos);
        }
        if ((mz = z - 1 >> 4) != cz) {
            long pos = class_2338.method_10064((int)cx, (int)cy, (int)mz);
            this.blocksOverride.getOrCreateChunk(pos);
            this.dirtyChunks.add(pos);
        }
    }

    public void uploadDirty(double sortX, double sortY, double sortZ) {
        if (this.compileFuture != null && this.compileFuture.isDone()) {
            CompileData asyncCompileChunkData;
            try {
                asyncCompileChunkData = this.compileFuture.get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (asyncCompileChunkData == null || this.stopBuilding.get()) {
                this.chunkBufferBuilderPack.method_23501();
            } else {
                boolean hasNvidium = NvidiumApiWrapper.isNvidiumAvailable();
                if (asyncCompileChunkData.clear()) {
                    if (hasNvidium) {
                        this.unhideAllNvidium();
                    }
                    this.sortedChunkData.forEach(data -> data.buffers.forEach((type2, buffer) -> buffer.close()));
                    this.sortedChunkData.clear();
                    this.chunkData.clear();
                }
                this.aabbCutoutMode = asyncCompileChunkData.aabbCutoutMode();
                for (CompiledChunkData compiled : asyncCompileChunkData.compiledChunks()) {
                    long pos = class_2338.method_10064((int)(compiled.offsetX >> 4), (int)(compiled.offsetY >> 4), (int)(compiled.offsetZ >> 4));
                    RenderedChunkData chunkDatum = (RenderedChunkData)this.chunkData.get(pos);
                    if (chunkDatum == null) {
                        chunkDatum = new RenderedChunkData(compiled.offsetX, compiled.offsetY, compiled.offsetZ);
                        this.chunkData.put(pos, (Object)chunkDatum);
                        if (hasNvidium) {
                            NvidiumApiWrapper.hideSection(compiled.offsetX >> 4, compiled.offsetY >> 4, compiled.offsetZ >> 4);
                        }
                        float dx = this.lastSortChunkX * 16 - chunkDatum.offsetX;
                        float dy = this.lastSortChunkY * 16 - chunkDatum.offsetY;
                        float dz = this.lastSortChunkZ * 16 - chunkDatum.offsetZ;
                        chunkDatum.distanceSqToCamera = dx * dx + dy * dy + dz * dz;
                        int min2 = 0;
                        int max2 = this.sortedChunkData.size();
                        int pivot = (min2 + max2) / 2;
                        while (min2 != max2) {
                            RenderedChunkData pivotElement = this.sortedChunkData.get(pivot);
                            if (chunkDatum.distanceSqToCamera < pivotElement.distanceSqToCamera) {
                                max2 = pivot;
                            } else {
                                min2 = pivot + 1;
                            }
                            pivot = (min2 + max2) / 2;
                        }
                        this.sortedChunkData.add(pivot, chunkDatum);
                    }
                    assert (chunkDatum.offsetX == compiled.offsetX);
                    assert (chunkDatum.offsetY == compiled.offsetY);
                    assert (chunkDatum.offsetZ == compiled.offsetZ);
                    chunkDatum.hasBlocks.clear();
                    chunkDatum.hasBlocks.addAll(compiled.buffers.keySet());
                    chunkDatum.sortState = compiled.sortState;
                    for (Map.Entry<class_1921, class_287.class_7433> entry : compiled.buffers.entrySet()) {
                        class_291 buffer = chunkDatum.buffers.get(entry.getKey());
                        buffer.method_1353();
                        buffer.method_1352(entry.getValue());
                    }
                    class_291.method_1354();
                    this.globalHasBlocks.addAll(chunkDatum.hasBlocks);
                }
                this.chunkBufferBuilderPack.method_22705();
            }
            this.compileFuture = null;
            this.stopBuilding.set(false);
        }
        if (this.compileFuture == null) {
            class_638 level;
            if (!this.dirtyChunks.isEmpty()) {
                this.pendingAabbCutoutMode = null;
                this.pendingBooleanCutoutMode = null;
            } else if (this.pendingAabbCutoutMode != null) {
                int y2;
                level = class_310.method_1551().field_1687;
                if (level == null) {
                    throw new IllegalStateException();
                }
                class_4076 minSection = this.pendingAabbCutoutMode.minSection;
                class_4076 maxSection = this.pendingAabbCutoutMode.maxSection;
                class_2338 min3 = this.pendingAabbCutoutMode.min;
                class_2338 max3 = this.pendingAabbCutoutMode.max;
                if (minSection.method_18683() < level.method_32891()) {
                    minSection = class_4076.method_18676((int)minSection.method_18674(), (int)level.method_32891(), (int)minSection.method_18687());
                }
                if (maxSection.method_18683() > level.method_31597() - 1) {
                    maxSection = class_4076.method_18676((int)maxSection.method_18674(), (int)(level.method_31597() - 1), (int)maxSection.method_18687());
                }
                this.blocksOverride.clear();
                for (int x2 = minSection.method_18674(); x2 <= maxSection.method_18674(); ++x2) {
                    for (int z2 = minSection.method_18687(); z2 <= maxSection.method_18687(); ++z2) {
                        this.cutoutAABBSection(x2, minSection.method_18683(), z2, min3, max3);
                        if (minSection.method_18683() == maxSection.method_18683()) continue;
                        this.cutoutAABBSection(x2, maxSection.method_18683(), z2, min3, max3);
                    }
                }
                for (y2 = minSection.method_18683() + 1; y2 <= maxSection.method_18683() - 1; ++y2) {
                    for (int x3 = minSection.method_18674(); x3 <= maxSection.method_18674(); ++x3) {
                        this.cutoutAABBSection(x3, y2, minSection.method_18687(), min3, max3);
                        if (minSection.method_18687() == maxSection.method_18687()) continue;
                        this.cutoutAABBSection(x3, y2, maxSection.method_18687(), min3, max3);
                    }
                }
                for (y2 = minSection.method_18683() + 1; y2 <= maxSection.method_18683() - 1; ++y2) {
                    for (int z3 = minSection.method_18687() + 1; z3 <= maxSection.method_18687() - 1; ++z3) {
                        this.cutoutAABBSection(minSection.method_18674(), y2, z3, min3, max3);
                        if (minSection.method_18674() == maxSection.method_18674()) continue;
                        this.cutoutAABBSection(maxSection.method_18674(), y2, z3, min3, max3);
                    }
                }
            } else if (this.pendingBooleanCutoutMode != null) {
                this.blocksOverride.clear();
                class_2338 offset = this.pendingBooleanCutoutMode.offset();
                int offsetX = offset.method_10263();
                int offsetY = offset.method_10264();
                int offsetZ = offset.method_10260();
                this.pendingBooleanCutoutMode.positionSet().forEach((x, y, z) -> this.setBlock(x + offsetX, y + offsetY, z + offsetZ, class_2246.field_10124.method_9564()));
            }
            if (!this.dirtyChunks.isEmpty()) {
                level = class_310.method_1551().field_1687;
                if (level == null) {
                    throw new IllegalStateException();
                }
                LongSet chunksToUpload = this.dirtyChunks;
                this.dirtyChunks = new LongOpenHashSet();
                boolean clear = this.pendingAabbCutoutMode != null || this.pendingBooleanCutoutMode != null;
                AABBCutoutMode compilingAabbCutoutMode = this.pendingAabbCutoutMode;
                Position2ObjectMap<class_2680> copied = new Position2ObjectMap<class_2680>(ChunkRenderOverrider::loadBlocks);
                LongOpenHashSet chunksToUploadAndNeighbors = new LongOpenHashSet();
                LongIterator iter = chunksToUpload.iterator();
                while (iter.hasNext()) {
                    long l = iter.nextLong();
                    int cx = class_2338.method_10061((long)l);
                    int cy = class_2338.method_10071((long)l);
                    int cz = class_2338.method_10083((long)l);
                    chunksToUploadAndNeighbors.add(l);
                    int minY = cy > level.method_32891() ? -1 : 0;
                    int maxY = cy < level.method_31597() - 1 ? 1 : 0;
                    for (int oy = minY; oy <= maxY; ++oy) {
                        for (int ox = -1; ox <= 1; ++ox) {
                            for (int oz = -1; oz <= 1; ++oz) {
                                chunksToUploadAndNeighbors.add(class_2338.method_10064((int)(cx + ox), (int)(cy + oy), (int)(cz + oz)));
                            }
                        }
                    }
                }
                copied.mergeAllFrom(this.blocksOverride, (LongSet)chunksToUploadAndNeighbors);
                MappedBlockAndTintGetter blockAndTintGetter = new MappedBlockAndTintGetter(copied, (class_1937)class_310.method_1551().field_1687);
                this.compileFuture = this.executor.submit(() -> {
                    ArrayList<CompiledChunkData> list = new ArrayList<CompiledChunkData>(chunksToUpload.size());
                    class_776 blockRenderDispatcher = class_310.method_1551().method_1541();
                    class_4587 poseStack = new class_4587();
                    class_2338.class_2339 blockPos = new class_2338.class_2339();
                    LongIterator longIterator = chunksToUpload.iterator();
                    while (longIterator.hasNext()) {
                        class_287 translucentBuilder;
                        long pos = (Long)longIterator.next();
                        if (this.stopBuilding.compareAndSet(true, false)) {
                            return null;
                        }
                        int offsetX = class_2338.method_10061((long)pos) * 16;
                        int offsetY = class_2338.method_10071((long)pos) * 16;
                        int offsetZ = class_2338.method_10083((long)pos) * 16;
                        CompiledChunkData compiled = new CompiledChunkData(offsetX, offsetY, offsetZ);
                        ObjectArraySet hasBlocks = new ObjectArraySet(class_1921.method_22720().size());
                        class_2680[] blocks = (class_2680[])copied.getChunk(pos);
                        if (blocks == null) continue;
                        class_5819 rand = class_5819.method_43047();
                        class_778.method_20544();
                        int index = 0;
                        for (int z = 0; z < 16; ++z) {
                            for (int y = 0; y < 16; ++y) {
                                for (int x = 0; x < 16; ++x) {
                                    class_287 bufferBuilder;
                                    class_1921 renderType;
                                    class_2680 blockState = blocks[index++];
                                    blockPos.method_10103(offsetX + x, offsetY + y, offsetZ + z);
                                    class_3610 fluidState = blockState.method_26227();
                                    if (!fluidState.method_15769()) {
                                        renderType = class_4696.method_23680((class_3610)fluidState);
                                        bufferBuilder = this.chunkBufferBuilderPack.method_3154(renderType);
                                        if (hasBlocks.add(renderType)) {
                                            bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1590);
                                        }
                                        blockRenderDispatcher.method_3352((class_2338)blockPos, blockAndTintGetter, (class_4588)bufferBuilder, blockState, fluidState);
                                    }
                                    if (blockState.method_26217() != class_2464.field_11458) continue;
                                    renderType = class_4696.method_23679((class_2680)blockState);
                                    bufferBuilder = this.chunkBufferBuilderPack.method_3154(renderType);
                                    if (hasBlocks.add(renderType)) {
                                        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1590);
                                    }
                                    poseStack.method_22903();
                                    poseStack.method_46416((float)x, (float)y, (float)z);
                                    blockRenderDispatcher.method_3355(blockState, (class_2338)blockPos, blockAndTintGetter, poseStack, (class_4588)bufferBuilder, true, rand);
                                    poseStack.method_22909();
                                }
                            }
                        }
                        if (hasBlocks.contains(class_1921.method_23583()) && !(translucentBuilder = this.chunkBufferBuilderPack.method_3154(class_1921.method_23583())).method_43574()) {
                            translucentBuilder.method_49904(class_8251.method_49906((float)((float)(sortX - (double)compiled.offsetX)), (float)((float)(sortY - (double)compiled.offsetY)), (float)((float)(sortZ - (double)compiled.offsetZ))));
                            compiled.sortState = translucentBuilder.method_1334();
                        }
                        for (class_1921 renderType : hasBlocks) {
                            class_287.class_7433 renderedBuffer = this.chunkBufferBuilderPack.method_3154(renderType).method_43575();
                            if (renderedBuffer == null) continue;
                            compiled.buffers.put(renderType, renderedBuffer);
                        }
                        list.add(compiled);
                        class_778.method_20545();
                    }
                    return new CompileData(list, compilingAabbCutoutMode, clear);
                });
            }
            this.pendingBooleanCutoutMode = null;
            this.pendingAabbCutoutMode = null;
        }
        if (!this.globalHasBlocks.contains(class_1921.method_23583())) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastSortMillis < 200L) {
            return;
        }
        this.lastSortMillis = currentTime;
        double dX = sortX - (double)this.lastSortX;
        double dY = sortY - (double)this.lastSortY;
        double dZ = sortZ - (double)this.lastSortZ;
        if (dX * dX + dY * dY + dZ * dZ > 1.0) {
            this.lastSortX = (float)sortX;
            this.lastSortY = (float)sortY;
            this.lastSortZ = (float)sortZ;
            int chunkX = class_4076.method_32204((double)sortX);
            int chunkY = class_4076.method_32204((double)sortY);
            int chunkZ = class_4076.method_32204((double)sortZ);
            boolean resortChunkList = chunkX != this.lastSortChunkX || chunkY != this.lastSortChunkY || chunkZ != this.lastSortChunkZ;
            class_287 bufferBuilder = class_289.method_1348().method_1349();
            for (RenderedChunkData chunkDatum : this.sortedChunkData) {
                if (chunkDatum.hasBlocks.contains(class_1921.method_23583())) {
                    float relSortX = (float)(sortX - (double)chunkDatum.offsetX);
                    float relSortY = (float)(sortY - (double)chunkDatum.offsetY);
                    float relSortZ = (float)(sortZ - (double)chunkDatum.offsetZ);
                    bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1590);
                    bufferBuilder.method_1324(chunkDatum.sortState);
                    bufferBuilder.method_49904(class_8251.method_49906((float)relSortX, (float)relSortY, (float)relSortZ));
                    chunkDatum.sortState = bufferBuilder.method_1334();
                    class_291 buffer = chunkDatum.buffers.get(class_1921.method_23583());
                    buffer.method_1353();
                    buffer.method_1352(bufferBuilder.method_1326());
                }
                if (!resortChunkList) continue;
                float dx = chunkX * 16 - chunkDatum.offsetX;
                float dy = chunkY * 16 - chunkDatum.offsetY;
                float dz = chunkZ * 16 - chunkDatum.offsetZ;
                chunkDatum.distanceSqToCamera = dx * dx + dy * dy + dz * dz;
            }
            if (resortChunkList) {
                this.lastSortChunkX = chunkX;
                this.lastSortChunkY = chunkY;
                this.lastSortChunkZ = chunkZ;
                this.sortedChunkData.sort(Comparator.comparingDouble(c -> -c.distanceSqToCamera));
            }
        }
    }

    public void cutoutBoolean(PositionSet set, class_2338 offset) {
        if (set.isEmpty()) {
            return;
        }
        this.pendingAabbCutoutMode = null;
        this.pendingBooleanCutoutMode = new BooleanCutoutMode(set, offset);
    }

    public void cutoutAABB(class_2338 min2, class_2338 max2) {
        class_4076 minSection = class_4076.method_18682((class_2338)min2.method_10062().method_10069(-1, -1, -1));
        class_4076 maxSection = class_4076.method_18682((class_2338)max2.method_10062().method_10069(1, 1, 1));
        this.pendingAabbCutoutMode = new AABBCutoutMode(minSection, maxSection, min2, max2);
        this.pendingBooleanCutoutMode = null;
    }

    private void cutoutAABBSection(int sx, int sy, int sz, class_2338 min2, class_2338 max2) {
        if (!this.dirtyChunks.add(class_2338.method_10064((int)sx, (int)sy, (int)sz))) {
            return;
        }
        class_2680[] array = this.blocksOverride.getOrCreateChunk(sx, sy, sz);
        for (int z = Math.max(0, min2.method_10260() - sz * 16); z <= Math.min(15, max2.method_10260() - sz * 16); ++z) {
            for (int y = Math.max(0, min2.method_10264() - sy * 16); y <= Math.min(15, max2.method_10264() - sy * 16); ++y) {
                for (int x = Math.max(0, min2.method_10263() - sx * 16); x <= Math.min(15, max2.method_10263() - sx * 16); ++x) {
                    array[x + y * 16 + z * 16 * 16] = class_2246.field_10124.method_9564();
                }
            }
        }
    }

    private static /* synthetic */ ChunkRenderOverrider[] $values() {
        return new ChunkRenderOverrider[]{INSTANCE};
    }

    static {
        $VALUES = ChunkRenderOverrider.$values();
    }

    private record AABBCutoutMode(class_4076 minSection, class_4076 maxSection, class_2338 min, class_2338 max) {
    }

    private record BooleanCutoutMode(PositionSet positionSet, class_2338 offset) {
    }

    private static final class RenderedChunkData {
        Map<class_1921, class_291> buffers = ChunkRenderOverrider.createRenderTypeMap(() -> new class_291(class_291.class_8555.field_44793));
        Set<class_1921> hasBlocks = new ObjectArraySet(class_1921.method_22720().size());
        class_287.class_5594 sortState = null;
        int offsetX;
        int offsetY;
        int offsetZ;
        float distanceSqToCamera;

        public RenderedChunkData(int offsetX, int offsetY, int offsetZ) {
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.offsetZ = offsetZ;
        }
    }

    private record CompileData(List<CompiledChunkData> compiledChunks, AABBCutoutMode aabbCutoutMode, boolean clear) {
    }

    private static final class CompiledChunkData {
        Map<class_1921, class_287.class_7433> buffers = new Object2ObjectArrayMap();
        class_287.class_5594 sortState = null;
        int offsetX;
        int offsetY;
        int offsetZ;

        public CompiledChunkData(int offsetX, int offsetY, int offsetZ) {
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.offsetZ = offsetZ;
        }
    }

    private record MappedBlockAndTintGetter(Position2ObjectMap<class_2680> map, class_1937 level) implements RenderAttachedBlockView,
    FabricBlockView,
    class_1920
    {
        public float method_24852(class_2350 direction, boolean hasShade) {
            return this.level.method_24852(direction, hasShade);
        }

        @NotNull
        public class_3568 method_22336() {
            throw new UnsupportedOperationException();
        }

        public int method_8314(@NotNull class_1944 lightLayer, @NotNull class_2338 blockPos) {
            return lightLayer == class_1944.field_9282 ? 0 : 15;
        }

        public int method_22335(@NotNull class_2338 blockPos, int i) {
            return 15;
        }

        public int method_23752(@NotNull class_2338 blockPos, @NotNull class_6539 colorResolver) {
            return this.level.method_23752(blockPos, colorResolver);
        }

        @Nullable
        public class_2586 method_8321(@NotNull class_2338 blockPos) {
            return null;
        }

        @NotNull
        public class_2680 method_8320(class_2338 blockPos) {
            class_2680 mapped = this.map.get(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
            return Objects.requireNonNullElse(mapped, class_2246.field_10124.method_9564());
        }

        @NotNull
        public class_3610 method_8316(@NotNull class_2338 blockPos) {
            return this.method_8320(blockPos).method_26227();
        }

        public int method_31605() {
            return this.level.method_31605();
        }

        public int method_31607() {
            return this.level.method_31607();
        }
    }
}

