/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.rasterization;

import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.rasterization.Rasterization3D;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import it.unimi.dsi.fastutil.ints.Int2ByteOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.PriorityQueue;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector4d;

public class SmartSurfaceRasterization {
    private static final class_2680[] VISUALIZATION_BLOCKS = new class_2680[]{class_2246.field_10446.method_9564(), class_2246.field_10095.method_9564(), class_2246.field_10215.method_9564(), class_2246.field_10294.method_9564(), class_2246.field_10490.method_9564(), class_2246.field_10028.method_9564(), class_2246.field_10459.method_9564(), class_2246.field_10423.method_9564(), class_2246.field_10222.method_9564(), class_2246.field_10619.method_9564(), class_2246.field_10259.method_9564(), class_2246.field_10514.method_9564(), class_2246.field_10113.method_9564(), class_2246.field_10170.method_9564(), class_2246.field_10314.method_9564(), class_2246.field_10146.method_9564()};

    public static void smartSurface(ChunkedBlockRegion region, class_2680 block, class_2338[] points, boolean visualizeMesh) {
        if (points.length == 0) {
            return;
        }
        if (points.length == 1) {
            if (visualizeMesh) {
                region.addBlock(points[0], VISUALIZATION_BLOCKS[1]);
            } else {
                region.addBlock(points[0], block);
            }
            return;
        }
        if (points.length == 2) {
            if (visualizeMesh) {
                Rasterization3D.bresenham(points[0], points[1], (x, y, z) -> region.addBlock(x, y, z, VISUALIZATION_BLOCKS[1]));
            } else {
                Rasterization3D.bresenham(points[0], points[1], (x, y, z) -> region.addBlock(x, y, z, block));
            }
            return;
        }
        if (points.length == 3) {
            if (visualizeMesh) {
                Rasterization3D.triangle(points[0], points[1], points[2], (x, y, z) -> region.addBlock(x, y, z, VISUALIZATION_BLOCKS[1]));
            } else {
                Rasterization3D.triangle(points[0], points[1], points[2], (x, y, z) -> region.addBlock(x, y, z, block));
            }
            return;
        }
        PriorityQueue<Triangle> triangles = new PriorityQueue<Triangle>(Comparator.comparingDouble(Triangle::heuristic));
        IntOpenHashSet addedTriangles = new IntOpenHashSet();
        Triangle minTriangle = null;
        for (int i = 0; i < points.length - 2; ++i) {
            class_2338 one = points[i];
            for (int j = i + 1; j < points.length - 1; ++j) {
                class_2338 two = points[j];
                for (int k = i + 2; k < points.length; ++k) {
                    double heuristic;
                    class_2338 three = points[k];
                    if (SmartSurfaceRasterization.calculateNormal(one, two, three) == null || !((heuristic = SmartSurfaceRasterization.calculateHeuristic(one, two, three)) >= 0.0) || minTriangle != null && !(heuristic < minTriangle.heuristic)) continue;
                    minTriangle = new Triangle(i, j, k, heuristic);
                }
            }
        }
        if (minTriangle == null) {
            return;
        }
        triangles.add(minTriangle);
        addedTriangles.add(SmartSurfaceRasterization.calculateTriangleId(minTriangle.v1, minTriangle.v2, minTriangle.v3, points.length));
        BitSet usedVertices = new BitSet();
        Int2ByteOpenHashMap edgeConnections = new Int2ByteOpenHashMap();
        int remainingVertices = points.length;
        IntOpenHashSet bannedTriangles = new IntOpenHashSet();
        int blockIndex = 0;
        boolean nearlyDone = false;
        ArrayList<Triangle> failedNearlyDone = new ArrayList<Triangle>();
        while (!triangles.isEmpty()) {
            int edge3;
            byte edge3Connections;
            int edge2;
            byte edge2Connections;
            int edge1;
            byte edge1Connections;
            class_2338 three;
            class_2338 two;
            class_2338 one;
            Vector3d normal;
            Triangle triangle = triangles.poll();
            int thisTriangleId = SmartSurfaceRasterization.calculateTriangleId(triangle.v1, triangle.v2, triangle.v3, points.length);
            if (bannedTriangles.contains(thisTriangleId) || (normal = SmartSurfaceRasterization.calculateNormal(one = points[triangle.v1], two = points[triangle.v2], three = points[triangle.v3])) == null || (edge1Connections = edgeConnections.getOrDefault(edge1 = triangle.v2 < triangle.v3 ? triangle.v2 + triangle.v3 * points.length : triangle.v3 + triangle.v2 * points.length, (byte)0)) >= 2 || (edge2Connections = edgeConnections.getOrDefault(edge2 = triangle.v1 < triangle.v3 ? triangle.v1 + triangle.v3 * points.length : triangle.v3 + triangle.v1 * points.length, (byte)0)) >= 2 || (edge3Connections = edgeConnections.getOrDefault(edge3 = triangle.v1 < triangle.v2 ? triangle.v1 + triangle.v2 * points.length : triangle.v2 + triangle.v1 * points.length, (byte)0)) >= 2) continue;
            boolean usedVert1 = usedVertices.get(triangle.v1);
            boolean usedVert2 = usedVertices.get(triangle.v2);
            boolean usedVert3 = usedVertices.get(triangle.v3);
            if (usedVert1 && edge2Connections == 0 && edge3Connections == 0) {
                failedNearlyDone.add(triangle);
                continue;
            }
            if (usedVert2 && edge1Connections == 0 && edge3Connections == 0) {
                failedNearlyDone.add(triangle);
                continue;
            }
            if (usedVert3 && edge1Connections == 0 && edge2Connections == 0) {
                failedNearlyDone.add(triangle);
                continue;
            }
            if (nearlyDone) {
                boolean allow = false;
                if (edge1Connections + edge2Connections + edge3Connections == 2) {
                    double angle;
                    if (edge1Connections == 0) {
                        angle = SmartSurfaceRasterization.getAngle(one, two, three);
                    } else if (edge2Connections == 0) {
                        angle = SmartSurfaceRasterization.getAngle(two, three, one);
                    } else if (edge3Connections == 0) {
                        angle = SmartSurfaceRasterization.getAngle(three, one, two);
                    } else {
                        throw new FaultyImplementationError();
                    }
                    if (Math.toDegrees(angle) <= 120.0) {
                        allow = true;
                    }
                }
                if (!(allow |= edge1Connections == 1 && edge2Connections == 1 && edge3Connections == 1)) {
                    failedNearlyDone.add(triangle);
                    continue;
                }
                triangles.addAll(failedNearlyDone);
                failedNearlyDone.clear();
            }
            edgeConnections.put(edge1, (byte)(edge1Connections + 1));
            edgeConnections.put(edge2, (byte)(edge2Connections + 1));
            edgeConnections.put(edge3, (byte)(edge3Connections + 1));
            if (visualizeMesh) {
                if (++blockIndex >= VISUALIZATION_BLOCKS.length) {
                    blockIndex = 0;
                }
                class_2680 visualizationBlock = VISUALIZATION_BLOCKS[blockIndex];
                Rasterization3D.triangle(one, two, three, (x, y, z) -> region.addBlock(x, y, z, visualizationBlock));
            } else {
                Rasterization3D.triangle(one, two, three, (x, y, z) -> region.addBlock(x, y, z, block));
            }
            int best1 = -1;
            double heuristic1 = Double.MAX_VALUE;
            int best2 = -1;
            double heuristic2 = Double.MAX_VALUE;
            int best3 = -1;
            double heuristic3 = Double.MAX_VALUE;
            Vector4d edgeDirection1 = SmartSurfaceRasterization.calculateEdgeDirection(two, three, one, normal);
            Vector4d edgeDirection2 = SmartSurfaceRasterization.calculateEdgeDirection(one, three, two, normal);
            Vector4d edgeDirection3 = SmartSurfaceRasterization.calculateEdgeDirection(one, two, three, normal);
            for (int k = 0; k < points.length; ++k) {
                double heuristic;
                int triangleId;
                class_2338 kPos = points[k];
                if (k != triangle.v2 && k != triangle.v3) {
                    triangleId = SmartSurfaceRasterization.calculateTriangleId(k, triangle.v2, triangle.v3, points.length);
                    if ((double)kPos.method_10263() * edgeDirection1.x + (double)kPos.method_10264() * edgeDirection1.y + (double)kPos.method_10260() * edgeDirection1.z < edgeDirection1.w) {
                        bannedTriangles.add(triangleId);
                    } else if (!nearlyDone && !addedTriangles.contains(triangleId) && SmartSurfaceRasterization.calculateNormal(kPos, two, three) != null && (heuristic = SmartSurfaceRasterization.calculateHeuristic(kPos, two, three)) >= 0.0 && heuristic < heuristic1) {
                        heuristic1 = heuristic;
                        best1 = k;
                    }
                }
                if (k != triangle.v1 && k != triangle.v3) {
                    triangleId = SmartSurfaceRasterization.calculateTriangleId(triangle.v1, k, triangle.v3, points.length);
                    if ((double)kPos.method_10263() * edgeDirection2.x + (double)kPos.method_10264() * edgeDirection2.y + (double)kPos.method_10260() * edgeDirection2.z < edgeDirection2.w) {
                        bannedTriangles.add(triangleId);
                    } else if (!nearlyDone && !addedTriangles.contains(triangleId) && SmartSurfaceRasterization.calculateNormal(one, kPos, three) != null && (heuristic = SmartSurfaceRasterization.calculateHeuristic(one, kPos, three)) >= 0.0 && heuristic < heuristic2) {
                        heuristic2 = heuristic;
                        best2 = k;
                    }
                }
                if (k == triangle.v1 || k == triangle.v2) continue;
                triangleId = SmartSurfaceRasterization.calculateTriangleId(triangle.v1, triangle.v2, k, points.length);
                if ((double)kPos.method_10263() * edgeDirection3.x + (double)kPos.method_10264() * edgeDirection3.y + (double)kPos.method_10260() * edgeDirection3.z < edgeDirection3.w) {
                    bannedTriangles.add(triangleId);
                    continue;
                }
                if (nearlyDone || addedTriangles.contains(triangleId) || SmartSurfaceRasterization.calculateNormal(one, two, kPos) == null || !((heuristic = SmartSurfaceRasterization.calculateHeuristic(one, two, kPos)) >= 0.0) || !(heuristic < heuristic3)) continue;
                heuristic3 = heuristic;
                best3 = k;
            }
            if (best1 >= 0) {
                triangles.add(new Triangle(best1, triangle.v2, triangle.v3, heuristic1));
                addedTriangles.add(SmartSurfaceRasterization.calculateTriangleId(best1, triangle.v2, triangle.v3, points.length));
            }
            if (best2 >= 0) {
                triangles.add(new Triangle(triangle.v1, best2, triangle.v3, heuristic2));
                addedTriangles.add(SmartSurfaceRasterization.calculateTriangleId(triangle.v1, best2, triangle.v3, points.length));
            }
            if (best3 >= 0) {
                triangles.add(new Triangle(triangle.v1, triangle.v2, best3, heuristic3));
                addedTriangles.add(SmartSurfaceRasterization.calculateTriangleId(triangle.v1, triangle.v2, best3, points.length));
            }
            if (nearlyDone) continue;
            if (!usedVert1) {
                usedVertices.set(triangle.v1);
                --remainingVertices;
            }
            if (!usedVert2) {
                usedVertices.set(triangle.v2);
                --remainingVertices;
            }
            if (!usedVert3) {
                usedVertices.set(triangle.v3);
                --remainingVertices;
            }
            if (remainingVertices > 0) continue;
            triangles.addAll(failedNearlyDone);
            nearlyDone = true;
        }
    }

    private static int calculateTriangleId(int v1, int v2, int v3, int numPoints) {
        int min3;
        int min2;
        int min1;
        if (v1 < v2 && v1 < v3) {
            min1 = v1;
            if (v2 < v3) {
                min2 = v2;
                min3 = v3;
            } else {
                min2 = v3;
                min3 = v2;
            }
        } else if (v2 < v3) {
            min1 = v2;
            if (v1 < v3) {
                min2 = v1;
                min3 = v3;
            } else {
                min2 = v3;
                min3 = v1;
            }
        } else {
            min1 = v3;
            if (v1 < v2) {
                min2 = v1;
                min3 = v2;
            } else {
                min2 = v2;
                min3 = v1;
            }
        }
        return min1 + min2 * numPoints + min3 * numPoints * numPoints;
    }

    private static double calculateHeuristic(class_2338 one, class_2338 two, class_2338 three) {
        double angle3;
        double angle2;
        int leftX = one.method_10263() - two.method_10263();
        int leftY = one.method_10264() - two.method_10264();
        int leftZ = one.method_10260() - two.method_10260();
        int rightX = one.method_10263() - three.method_10263();
        int rightY = one.method_10264() - three.method_10264();
        int rightZ = one.method_10260() - three.method_10260();
        double angle1 = SmartSurfaceRasterization.getAngle(one, two, three);
        double maxAngle = Math.toDegrees(Math.max(angle1, Math.max(angle2 = SmartSurfaceRasterization.getAngle(three, one, two), angle3 = SmartSurfaceRasterization.getAngle(two, three, one))));
        if (maxAngle > 160.0) {
            return -1.0;
        }
        double multiplier = maxAngle <= 120.0 ? 1.0 : 60.0 / (180.0 - maxAngle);
        int otherX = two.method_10263() - three.method_10263();
        int otherY = two.method_10264() - three.method_10264();
        int otherZ = two.method_10260() - three.method_10260();
        double edgeLength1 = Math.sqrt(leftX * leftX + leftY * leftY + leftZ * leftZ);
        double edgeLength2 = Math.sqrt(rightX * rightX + rightY * rightY + rightZ * rightZ);
        double edgeLength3 = Math.sqrt(otherX * otherX + otherY * otherY + otherZ * otherZ);
        double edgeLength = Math.max(edgeLength1, Math.max(edgeLength2, edgeLength3));
        return edgeLength * multiplier;
    }

    private static double getAngle(class_2338 one, class_2338 two, class_2338 three) {
        int x1 = one.method_10263();
        int x2 = two.method_10263();
        int x3 = three.method_10263();
        int y1 = one.method_10264();
        int y2 = two.method_10264();
        int y3 = three.method_10264();
        int z1 = one.method_10260();
        int z2 = two.method_10260();
        int z3 = three.method_10260();
        int num = (x2 - x1) * (x3 - x1) + (y2 - y1) * (y3 - y1) + (z2 - z1) * (z3 - z1);
        double den = Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0) + Math.pow(z2 - z1, 2.0)) * Math.sqrt(Math.pow(x3 - x1, 2.0) + Math.pow(y3 - y1, 2.0) + Math.pow(z3 - z1, 2.0));
        return Math.acos((double)num / den);
    }

    @Nullable
    private static Vector3d calculateNormal(class_2338 one, class_2338 two, class_2338 three) {
        long normalZ;
        long normalY;
        int leftX = one.method_10263() - two.method_10263();
        int leftY = one.method_10264() - two.method_10264();
        int leftZ = one.method_10260() - two.method_10260();
        int rightX = one.method_10263() - three.method_10263();
        int rightY = one.method_10264() - three.method_10264();
        int rightZ = one.method_10260() - three.method_10260();
        long normalX = (long)leftY * (long)rightZ - (long)leftZ * (long)rightY;
        long normalLengthSq = normalX * normalX + (normalY = (long)leftZ * (long)rightX - (long)leftX * (long)rightZ) * normalY + (normalZ = (long)leftX * (long)rightY - (long)leftY * (long)rightX) * normalZ;
        if ((double)normalLengthSq > 1.0E-5) {
            double normalLength = Math.sqrt(normalLengthSq);
            return new Vector3d((double)normalX / normalLength, (double)normalY / normalLength, (double)normalZ / normalLength);
        }
        return null;
    }

    private static Vector4d calculateEdgeDirection(class_2338 one, class_2338 two, class_2338 three, Vector3d normal) {
        double leftX = one.method_10263() - two.method_10263();
        double leftY = one.method_10264() - two.method_10264();
        double leftZ = one.method_10260() - two.method_10260();
        double rightX = normal.x;
        double rightY = normal.y;
        double rightZ = normal.z;
        double crossX = leftY * rightZ - leftZ * rightY;
        double crossY = leftZ * rightX - leftX * rightZ;
        double crossZ = leftX * rightY - leftY * rightX;
        double k = (double)one.method_10263() * crossX + (double)one.method_10264() * crossY + (double)one.method_10260() * crossZ;
        if ((double)three.method_10263() * crossX + (double)three.method_10264() * crossY + (double)three.method_10260() * crossZ >= k) {
            k = (double)one.method_10263() * (crossX *= -1.0) + (double)one.method_10264() * (crossY *= -1.0) + (double)one.method_10260() * (crossZ *= -1.0);
        }
        return new Vector4d(crossX, crossY, crossZ, k);
    }

    record Triangle(int v1, int v2, int v3, double heuristic) {
    }
}

