/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.rasterization;

import com.github.quickhull3d.QuickHull3D;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.rasterization.GrahamScan2d;
import com.moulberry.axiom.rasterization.Rasterization3D;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import org.joml.Vector2d;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class HullRasterization {
    public static void quickHull(ChunkedBlockRegion region, class_2680 block, double[] points, boolean hollow) {
        if (points.length % 3 != 0) {
            throw new IllegalArgumentException();
        }
        if (points.length == 0) {
            return;
        }
        if (points.length == 3) {
            region.addBlock((int)Math.round(points[0]), (int)Math.round(points[1]), (int)Math.round(points[2]), block);
            return;
        }
        if (points.length == 6) {
            class_2338 from = new class_2338((int)Math.round(points[0]), (int)Math.round(points[1]), (int)Math.round(points[2]));
            class_2338 to = new class_2338((int)Math.round(points[3]), (int)Math.round(points[4]), (int)Math.round(points[5]));
            Rasterization3D.bresenham(from, to, (x, y, z) -> region.addBlock(x, y, z, block));
            return;
        }
        if (points.length == 9) {
            if (HullRasterization.coplanar(region, block, points)) {
                return;
            }
            class_2338 from = new class_2338((int)Math.round(points[0]), (int)Math.round(points[1]), (int)Math.round(points[2]));
            for (int i = 3; i < points.length; i += 3) {
                class_2338 to = new class_2338((int)Math.round(points[i]), (int)Math.round(points[i + 1]), (int)Math.round(points[i + 2]));
                Rasterization3D.bresenham(from, to, (x, y, z) -> region.addBlock(x, y, z, block));
                from = to;
            }
            return;
        }
        QuickHull3D hull = new QuickHull3D();
        try {
            hull.build(points);
        }
        catch (IllegalArgumentException exception) {
            if (exception.getMessage().contains("coplanar") && HullRasterization.coplanar(region, block, points)) {
                return;
            }
            class_2338 from = new class_2338((int)Math.round(points[0]), (int)Math.round(points[1]), (int)Math.round(points[2]));
            for (int i = 3; i < points.length; i += 3) {
                class_2338 to = new class_2338((int)Math.round(points[i]), (int)Math.round(points[i + 1]), (int)Math.round(points[i + 2]));
                Rasterization3D.bresenham(from, to, (x, y, z) -> region.addBlock(x, y, z, block));
                from = to;
            }
            return;
        }
        catch (Exception e) {
            return;
        }
        int numVertices = hull.getNumVertices();
        double[] vertices = new double[numVertices * 3];
        hull.getVertices(vertices);
        int[][] faceIndices = hull.getFaces();
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (int i = 0; i < numVertices; ++i) {
            int x2 = (int)vertices[i * 3];
            int y2 = (int)vertices[i * 3 + 1];
            int z2 = (int)vertices[i * 3 + 2];
            minX = Math.min(minX, x2);
            minY = Math.min(minY, y2);
            minZ = Math.min(minZ, z2);
            maxX = Math.max(maxX, x2);
            maxY = Math.max(maxY, y2);
            maxZ = Math.max(maxZ, z2);
        }
        if (minX > maxX || minY > maxY || minZ > maxZ) {
            return;
        }
        int offsetX = (maxX + minX) / 2;
        int offsetY = (maxY + minY) / 2;
        int offsetZ = (maxZ + minZ) / 2;
        minX -= offsetX;
        minY -= offsetY;
        minZ -= offsetZ;
        maxX -= offsetX;
        maxY -= offsetY;
        maxZ -= offsetZ;
        for (int i = 0; i < vertices.length; i += 3) {
            int n = i;
            vertices[n] = vertices[n] - (double)offsetX;
            int n2 = i + 1;
            vertices[n2] = vertices[n2] - (double)offsetY;
            int n3 = i + 2;
            vertices[n3] = vertices[n3] - (double)offsetZ;
        }
        int numFaces = faceIndices.length;
        DoubleArrayList planes = new DoubleArrayList(4 * numFaces);
        for (int i = 0; i < faceIndices.length; ++i) {
            int[] face = faceIndices[i];
            int vert0 = face[0];
            int vert1 = face[1];
            int vert2 = face[2];
            double x3 = vertices[vert0 * 3];
            double y3 = vertices[vert0 * 3 + 1];
            double z3 = vertices[vert0 * 3 + 2];
            Vector3d vector1 = new Vector3d(x3 - vertices[vert1 * 3], y3 - vertices[vert1 * 3 + 1], z3 - vertices[vert1 * 3 + 2]);
            Vector3d vector2 = new Vector3d(x3 - vertices[vert2 * 3], y3 - vertices[vert2 * 3 + 1], z3 - vertices[vert2 * 3 + 2]);
            vector1.cross((Vector3dc)vector2);
            vector1.normalize();
            double k = vector1.x * x3 + vector1.y * y3 + vector1.z * z3;
            planes.add(vector1.x);
            planes.add(vector1.y);
            planes.add(vector1.z);
            planes.add(k);
        }
        HullRasterization.add2dConstraints((DoubleList)planes, vertices, 0, true);
        HullRasterization.add2dConstraints((DoubleList)planes, vertices, 1, true);
        HullRasterization.add2dConstraints((DoubleList)planes, vertices, 2, true);
        double[] planesArray = planes.toDoubleArray();
        for (int x4 = minX; x4 <= maxX; ++x4) {
            for (int y4 = minY; y4 <= maxY; ++y4) {
                block10: for (int z4 = minZ; z4 <= maxZ; ++z4) {
                    for (int j = 0; j < planesArray.length; j += 4) {
                        if ((double)x4 * planesArray[j] + (double)y4 * planesArray[j + 1] + (double)z4 * planesArray[j + 2] > planesArray[j + 3] + 0.5) continue block10;
                    }
                    region.addBlock(x4 + offsetX, y4 + offsetY, z4 + offsetZ, block);
                }
            }
        }
    }

    private static void add2dConstraints(DoubleList doubles, double[] vertices, int ignoreAxis, boolean make3d) {
        Vector2d[] points2d = new Vector2d[vertices.length / 3];
        for (int i = 0; i < vertices.length; i += 3) {
            if (ignoreAxis == 0) {
                points2d[i / 3] = new Vector2d(vertices[i + 1], vertices[i + 2]);
                continue;
            }
            if (ignoreAxis == 1) {
                points2d[i / 3] = new Vector2d(vertices[i], vertices[i + 2]);
                continue;
            }
            if (ignoreAxis == 2) {
                points2d[i / 3] = new Vector2d(vertices[i], vertices[i + 1]);
                continue;
            }
            throw new FaultyImplementationError();
        }
        Vector2d[] points = GrahamScan2d.getVertices(points2d);
        if (points != null && points.length >= 3) {
            for (int i = 0; i < points.length; ++i) {
                Vector2d point = points[i];
                Vector2d nextPoint = i == points.length - 1 ? points[0] : points[i + 1];
                double dx = point.x - nextPoint.x;
                double dy = point.y - nextPoint.y;
                double normalX = -dy;
                double normalY = dx;
                double invLength = 1.0 / Math.sqrt(normalX * normalX + normalY * normalY);
                double k = point.x * (normalX *= invLength) + point.y * (normalY *= invLength);
                if (make3d && ignoreAxis == 0) {
                    doubles.add(0.0);
                }
                doubles.add(normalX);
                if (make3d && ignoreAxis == 1) {
                    doubles.add(0.0);
                }
                doubles.add(normalY);
                if (make3d && ignoreAxis == 2) {
                    doubles.add(0.0);
                }
                doubles.add(k);
            }
        }
    }

    private static boolean coplanar(ChunkedBlockRegion region, class_2680 block, double[] points) {
        int y;
        double normalX = 0.0;
        double normalY = 0.0;
        double normalZ = 0.0;
        boolean foundNormal = false;
        block0: for (int i = 0; i < points.length - 6; i += 3) {
            double oneX = points[i];
            double oneY = points[i + 1];
            double oneZ = points[i + 2];
            for (int j = i + 3; j < points.length - 3; j += 3) {
                double leftX = oneX - points[j];
                double leftY = oneY - points[j + 1];
                double leftZ = oneZ - points[j + 2];
                for (int k = i + 6; k < points.length; k += 3) {
                    double rightZ = oneZ - points[k + 2];
                    double rightY = oneY - points[k + 1];
                    normalX = leftY * rightZ - leftZ * rightY;
                    double dx = normalX * normalX;
                    double rightX = oneX - points[k];
                    normalY = leftZ * rightX - leftX * rightZ;
                    double dy = normalY * normalY;
                    normalZ = leftX * rightY - leftY * rightX;
                    double dz = normalZ * normalZ;
                    double normalLengthSq = dx * dx + dy * dy + dz * dz;
                    if (!(normalLengthSq > 1.0E-5)) continue;
                    foundNormal = true;
                    break block0;
                }
            }
        }
        if (!foundNormal) {
            return false;
        }
        double k = -(points[0] * normalX + points[1] * normalY + points[2] * normalZ);
        double absNormalX = Math.abs(normalX);
        double absNormalY = Math.abs(normalY);
        double absNormalZ = Math.abs(normalZ);
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (int i = 0; i < points.length; i += 3) {
            int x = (int)points[i];
            y = (int)points[i + 1];
            int z = (int)points[i + 2];
            minX = Math.min(minX, x);
            minY = Math.min(minY, y);
            minZ = Math.min(minZ, z);
            maxX = Math.max(maxX, x);
            maxY = Math.max(maxY, y);
            maxZ = Math.max(maxZ, z);
        }
        if (absNormalX > absNormalY && absNormalX > absNormalZ) {
            DoubleArrayList doubleList = new DoubleArrayList();
            HullRasterization.add2dConstraints((DoubleList)doubleList, points, 0, false);
            double[] edges = doubleList.toDoubleArray();
            for (y = minY; y <= maxY; ++y) {
                block5: for (int z = minZ; z <= maxZ; ++z) {
                    for (int j = 0; j < edges.length; j += 3) {
                        if ((double)y * edges[j] + (double)z * edges[j + 1] > edges[j + 2] + 0.5) continue block5;
                    }
                    int x = (int)Math.round(-((double)y * normalY + (double)z * normalZ + k) / normalX);
                    region.addBlock(x, y, z, block);
                }
            }
        } else if (absNormalY > absNormalZ) {
            DoubleArrayList doubleList = new DoubleArrayList();
            HullRasterization.add2dConstraints((DoubleList)doubleList, points, 1, false);
            double[] edges = doubleList.toDoubleArray();
            for (x = minX; x <= maxX; ++x) {
                block8: for (int z = minZ; z <= maxZ; ++z) {
                    for (int j = 0; j < edges.length; j += 3) {
                        if ((double)x * edges[j] + (double)z * edges[j + 1] > edges[j + 2] + 0.5) continue block8;
                    }
                    int y2 = (int)Math.round(-((double)x * normalX + (double)z * normalZ + k) / normalY);
                    region.addBlock(x, y2, z, block);
                }
            }
        } else {
            DoubleArrayList doubleList = new DoubleArrayList();
            HullRasterization.add2dConstraints((DoubleList)doubleList, points, 2, false);
            double[] edges = doubleList.toDoubleArray();
            for (x = minX; x <= maxX; ++x) {
                block11: for (int y3 = minY; y3 <= maxY; ++y3) {
                    for (int j = 0; j < edges.length; j += 3) {
                        if ((double)x * edges[j] + (double)y3 * edges[j + 1] > edges[j + 2] + 0.5) continue block11;
                    }
                    int z = (int)Math.round(-((double)x * normalX + (double)y3 * normalY + k) / normalZ);
                    region.addBlock(x, y3, z, block);
                }
            }
        }
        return true;
    }
}

