/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.pather.async;

import com.moulberry.axiom.GlobalCleaner;
import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.pather.async.AsyncToolPather;
import com.moulberry.axiom.rasterization.Rasterization3D;
import com.moulberry.axiom.tools.Tool;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;

public class AsyncToolPathProvider {
    private class_243 lastLookDirection = null;
    private class_2338.class_2339 lastPosition = null;
    private final ArrayBlockingQueue<long[]> inputPositions = new ArrayBlockingQueue(128);
    private final AsyncToolPather pather;
    private final AtomicBoolean stopTask = new AtomicBoolean(false);
    private final GlobalCleaner.LeakChecker leakChecker;
    private boolean includeNonSolid = true;

    public AsyncToolPathProvider(@NotNull AsyncToolPather pather) {
        Tool.sharedPoolThreadExecutor.submit(new AsyncTask(this.inputPositions, this.stopTask, pather));
        this.pather = pather;
        this.leakChecker = GlobalCleaner.createLeakChecker(this, "AsyncToolPathProvider");
    }

    public AsyncToolPathProvider includeNonSolid(boolean includeNonSolid) {
        this.includeNonSolid = includeNonSolid;
        return this;
    }

    public void close() {
        this.stopTask.set(true);
        this.leakChecker.disarm();
    }

    public void update() {
        if (this.stopTask.get()) {
            throw new FaultyImplementationError();
        }
        this.pather.update();
        class_746 entity = class_310.method_1551().field_1724;
        if (entity == null || entity != class_310.method_1551().method_1560()) {
            return;
        }
        if (!EditorUI.isActive()) {
            return;
        }
        if (EditorUI.isMovingCamera()) {
            return;
        }
        class_243 currentLookDirection = EditorUI.getMouseLookVector();
        if (currentLookDirection == null) {
            return;
        }
        class_243 start = entity.method_33571();
        boolean includeFluids = Tool.defaultIncludeFluids();
        if (this.lastLookDirection == null || this.lastPosition == null) {
            RayCaster.RaycastResult raycastResult = RayCaster.raycast(entity.method_37908(), start.method_46409(), currentLookDirection.method_46409(), false, includeFluids, this.includeNonSolid);
            if (raycastResult != null) {
                this.lastLookDirection = currentLookDirection;
                this.lastPosition = raycastResult.getBlockPos().method_25503();
                try {
                    this.inputPositions.put(new long[]{this.lastPosition.method_10063()});
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            List<class_241> mousePositions = EditorUI.imguiGlfw.getCapturedInterframeMousePositions();
            LongArrayList positions = new LongArrayList();
            for (class_241 mousePosition : mousePositions) {
                class_243 lookDirection = EditorUI.getMouseLookVector(mousePosition.field_1343, mousePosition.field_1342);
                if (lookDirection == null) continue;
                double dot = this.lastLookDirection.method_1026(lookDirection);
                double angleChange = Math.toDegrees(Math.acos(dot));
                int steps = 1;
                if (angleChange > 1.0) {
                    steps = (int)Math.ceil(angleChange);
                }
                for (int i = 1; i <= steps; ++i) {
                    class_2338 rayTarget;
                    float f = (float)i / (float)steps;
                    class_243 look = this.lastLookDirection.method_35590(lookDirection, (double)f);
                    RayCaster.RaycastResult raycastResult = RayCaster.raycast(entity.method_37908(), start.method_46409(), look.method_46409(), false, includeFluids, this.includeNonSolid);
                    if (raycastResult == null || (rayTarget = raycastResult.blockPos()).equals((Object)this.lastPosition)) continue;
                    Rasterization3D.ddaSkipFrom((class_2338)this.lastPosition, raycastResult.getBlockPos(), (x, y, z) -> positions.add(class_2338.method_10064((int)x, (int)y, (int)z)));
                    this.lastPosition.method_10101((class_2382)rayTarget);
                }
                this.lastLookDirection = lookDirection;
            }
            if (!positions.isEmpty()) {
                try {
                    this.inputPositions.put(positions.toLongArray());
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public record AsyncTask(ArrayBlockingQueue<long[]> in, AtomicBoolean stopTask, AsyncToolPather pather) implements Runnable
    {
        @Override
        public void run() {
            try {
                long[] firstPosition = this.in.take();
                if (firstPosition.length != 1) {
                    throw new FaultyImplementationError();
                }
                this.pather.acceptInitial(firstPosition[0]);
                while (!this.stopTask.get()) {
                    long[] polled = this.in.poll(100L, TimeUnit.MILLISECONDS);
                    if (polled == null) continue;
                    this.pather.accept(polled);
                }
            }
            catch (Throwable t2) {
                t2.printStackTrace();
                this.stopTask.set(true);
            }
        }
    }
}

