/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.packets;

import com.moulberry.axiom.custom_blocks.ServerCustomBlocks;
import com.moulberry.axiom.custom_blocks.StringProperty;
import com.moulberry.axiom.packets.AxiomClientboundPacket;
import com.moulberry.axiom.utils.NetworkHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3542;
import net.minecraft.class_5455;
import net.minecraft.class_7923;

public class AxiomClientboundCustomBlocks
implements AxiomClientboundPacket {
    private static final class_2960 IDENTIFIER = new class_2960("axiom:custom_blocks");
    private final List<CustomBlockEntry> customBlockEntries;
    private static final Set<Class<? extends Enum<?>>> allPropertyEnums = new HashSet();

    public AxiomClientboundCustomBlocks(List<CustomBlockEntry> customBlockEntries) {
        this.customBlockEntries = List.copyOf(customBlockEntries);
    }

    public AxiomClientboundCustomBlocks(class_2540 friendlyByteBuf) {
        this.customBlockEntries = friendlyByteBuf.method_34066(CustomBlockEntry::read);
    }

    @Override
    public class_2960 packetIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public void write(class_2540 friendlyByteBuf) {
        friendlyByteBuf.method_34062(this.customBlockEntries, CustomBlockEntry::write);
    }

    @Override
    public void handle(class_310 client, class_5455 registryAccess) {
        ServerCustomBlocks.clearRegisteredCustomBlocks();
        for (CustomBlockEntry customBlockEntry : this.customBlockEntries) {
            ServerCustomBlocks.registerCustomBlock(customBlockEntry.id, customBlockEntry.translationKey, customBlockEntry.pickBlockStack, customBlockEntry.doNormalInteractions, customBlockEntry.properties, customBlockEntry.updaters, customBlockEntry.blockStates);
        }
        ServerCustomBlocks.update();
    }

    public static void register() {
        AxiomClientboundPacket.register(IDENTIFIER, AxiomClientboundCustomBlocks::new);
    }

    private static class_2769<?> readProperty(class_2540 friendlyByteBuf) {
        byte type2 = friendlyByteBuf.readByte();
        return switch (type2) {
            default -> throw new RuntimeException("Unknown property type: " + type2);
            case 0 -> {
                String name = friendlyByteBuf.method_19772();
                yield class_2746.method_11825((String)name);
            }
            case 1 -> {
                String name = friendlyByteBuf.method_19772();
                int min = friendlyByteBuf.readInt();
                int max = friendlyByteBuf.readInt();
                yield class_2758.method_11867((String)name, (int)min, (int)max);
            }
            case 2 -> {
                String name = friendlyByteBuf.method_19772();
                List values = friendlyByteBuf.method_34066(class_2540::method_19772);
                if (values.size() < 2) {
                    throw new IllegalArgumentException("Size of list must be greater than 1");
                }
                HashSet<String> seenValues = new HashSet<String>();
                for (int i = 0; i < values.size(); ++i) {
                    String value = ((String)values.get(i)).toLowerCase(Locale.ROOT);
                    values.set(i, value);
                    if (seenValues.contains(value)) {
                        throw new IllegalArgumentException("Duplicate property name: " + value);
                    }
                    seenValues.add(value);
                }
                for (Class<Enum<?>> propertyEnum : allPropertyEnums) {
                    Enum<?>[] variants = propertyEnum.getEnumConstants();
                    if (values.size() > variants.length) continue;
                    ArrayList matchingEnums = new ArrayList();
                    block20: for (String value : values) {
                        for (Enum<?> variant : variants) {
                            if (!value.equalsIgnoreCase(((class_3542)variant).method_15434())) continue;
                            matchingEnums.add(variant);
                            continue block20;
                        }
                    }
                    if (matchingEnums.size() != values.size()) continue;
                    if (propertyEnum.equals(class_2350.class)) {
                        yield class_2753.method_11843((String)name, (Collection)matchingEnums);
                    }
                    yield AxiomClientboundCustomBlocks.createEnumProperty(name, propertyEnum, matchingEnums);
                }
                yield new StringProperty(name, values);
            }
            case 3 -> class_2741.field_12496;
            case 4 -> class_2741.field_12529;
            case 5 -> class_2741.field_12525;
            case 6 -> class_2741.field_12481;
            case 7 -> class_2741.field_12519;
            case 8 -> class_2741.field_12546;
            case 9 -> class_2741.field_12489;
            case 10 -> class_2741.field_12487;
            case 11 -> class_2741.field_12540;
            case 12 -> class_2741.field_12527;
            case 13 -> class_2741.field_12508;
            case 14 -> class_2741.field_12518;
            case 15 -> class_2741.field_28062;
        };
    }

    private static <T extends Enum<T>> class_2754<T> createEnumProperty(String name, Class<?> clazz, List<Enum<?>> values) {
        return class_2754.method_11847((String)name, clazz, values);
    }

    private static void writeProperty(class_2540 friendlyByteBuf, class_2769<?> property) {
        if (property == class_2741.field_12496) {
            friendlyByteBuf.method_52997(3);
        } else if (property == class_2741.field_12529) {
            friendlyByteBuf.method_52997(4);
        } else if (property == class_2741.field_12525) {
            friendlyByteBuf.method_52997(5);
        } else if (property == class_2741.field_12481) {
            friendlyByteBuf.method_52997(6);
        } else if (property == class_2741.field_12519) {
            friendlyByteBuf.method_52997(7);
        } else if (property == class_2741.field_12546) {
            friendlyByteBuf.method_52997(8);
        } else if (property == class_2741.field_12489) {
            friendlyByteBuf.method_52997(9);
        } else if (property == class_2741.field_12487) {
            friendlyByteBuf.method_52997(10);
        } else if (property == class_2741.field_12540) {
            friendlyByteBuf.method_52997(11);
        } else if (property == class_2741.field_12527) {
            friendlyByteBuf.method_52997(12);
        } else if (property == class_2741.field_12508) {
            friendlyByteBuf.method_52997(13);
        } else if (property == class_2741.field_12518) {
            friendlyByteBuf.method_52997(14);
        } else if (property == class_2741.field_28062) {
            friendlyByteBuf.method_52997(15);
        } else if (property instanceof class_2746) {
            friendlyByteBuf.method_52997(0);
            friendlyByteBuf.method_10814(property.method_11899());
        } else if (property instanceof class_2758) {
            class_2758 integerProperty = (class_2758)property;
            friendlyByteBuf.method_52997(1);
            friendlyByteBuf.method_10814(property.method_11899());
            friendlyByteBuf.method_53002(integerProperty.field_37655);
            friendlyByteBuf.method_53002(integerProperty.field_37656);
        } else if (property instanceof StringProperty) {
            StringProperty stringProperty = (StringProperty)property;
            friendlyByteBuf.method_52997(2);
            friendlyByteBuf.method_10814(property.method_11899());
            friendlyByteBuf.method_34062(stringProperty.method_11898(), class_2540::method_10814);
        } else if (property instanceof class_2754) {
            class_2754 enumProperty = (class_2754)property;
            friendlyByteBuf.method_52997(2);
            friendlyByteBuf.method_10814(property.method_11899());
            friendlyByteBuf.method_34062(enumProperty.method_11898(), (buf, e) -> buf.method_10814(((class_3542)e).method_15434()));
        } else {
            throw new UnsupportedOperationException("Unknown property type: " + String.valueOf(property.getClass()));
        }
    }

    static {
        for (class_2248 block : class_7923.field_41175) {
            for (class_2769 property : block.method_9595().method_11659()) {
                if (!(property instanceof class_2754)) continue;
                class_2754 enumProperty = (class_2754)property;
                allPropertyEnums.add(enumProperty.method_11902());
            }
        }
    }

    public record CustomBlockEntry(class_2960 id, String translationKey, class_1799 pickBlockStack, boolean doNormalInteractions, List<class_2769<?>> properties, List<class_2960> updaters, List<class_2680> blockStates) {
        public static CustomBlockEntry read(class_2540 friendlyByteBuf) {
            class_2960 id = friendlyByteBuf.method_10810();
            String translationKey = friendlyByteBuf.method_19772();
            class_1799 pickBlockStack = NetworkHelper.readItemStack(friendlyByteBuf);
            boolean doNormalInteractions = friendlyByteBuf.readBoolean();
            List properties = friendlyByteBuf.method_34066(AxiomClientboundCustomBlocks::readProperty);
            List updaters = friendlyByteBuf.method_34066(class_2540::method_10810);
            List blockStates = friendlyByteBuf.method_34066(NetworkHelper::readBlockState);
            return new CustomBlockEntry(id, translationKey, pickBlockStack, doNormalInteractions, properties, updaters, blockStates);
        }

        public static void write(class_2540 friendlyByteBuf, CustomBlockEntry entry) {
            friendlyByteBuf.method_10812(entry.id);
            friendlyByteBuf.method_10814(entry.translationKey);
            NetworkHelper.writeItemStack(friendlyByteBuf, entry.pickBlockStack);
            friendlyByteBuf.method_52964(entry.doNormalInteractions);
            friendlyByteBuf.method_34062(entry.properties, AxiomClientboundCustomBlocks::writeProperty);
            friendlyByteBuf.method_34062(entry.updaters, class_2540::method_10812);
            friendlyByteBuf.method_34062(entry.blockStates, NetworkHelper::writeBlockState);
        }
    }
}

