/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.operations;

import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.clipboard.SelectionBuffer;
import com.moulberry.axiom.collections.Position2FloatMap;
import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.packets.AxiomServerboundSetBlock;
import com.moulberry.axiom.packets.AxiomServerboundSetBuffer;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.utils.RegionHelper;
import com.moulberry.axiom.world_modification.BlockBuffer;
import com.moulberry.axiom.world_modification.Dispatcher;
import it.unimi.dsi.fastutil.objects.ObjectHeapPriorityQueue;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_1268;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import net.minecraft.class_638;

public class RebuildOperation {
    private static final Position2FloatMap priorityMap = new Position2FloatMap(Float.MAX_VALUE);
    private static final PositionSet processed = new PositionSet();
    private static final ObjectHeapPriorityQueue<QueueObject> queue = new ObjectHeapPriorityQueue(Comparator.comparingDouble(k -> k.priority));
    private static ChunkedBlockRegion rebuildRegion = null;
    private static double currentPriority = 0.0;
    private static RebuildParameters rebuildParameters = null;

    public static void rebuild(RebuildParameters parameters) {
        SelectionBuffer selectionBuffer = Selection.getSelectionBuffer();
        ChunkedBlockRegion region = new ChunkedBlockRegion();
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        ChunkedBlockRegion clear = new ChunkedBlockRegion();
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        selectionBuffer.forEach((x, y, z) -> {
            class_2680 blockState = level.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
            if (blockState.method_26204() != class_2246.field_10243) {
                region.addBlockWithoutDirty(x, y, z, blockState);
                clear.addBlockWithoutDirty(x, y, z, class_2246.field_10124.method_9564());
            }
        });
        if (region.isEmpty()) {
            return;
        }
        RegionHelper.pushBlockRegionChange(clear, "Animated Rebuild", Dispatcher.simpleSourceInfo("Animated Rebuild"));
        RebuildOperation.rebuild(region, parameters);
    }

    public static void resetRebuildState() {
        priorityMap.clear();
        queue.clear();
        processed.clear();
        rebuildRegion = null;
        rebuildParameters = null;
        currentPriority = 0.0;
    }

    private static void rebuild(ChunkedBlockRegion region, RebuildParameters parameters) {
        RebuildOperation.resetRebuildState();
        rebuildRegion = region;
        rebuildParameters = parameters;
        region.forEachEntry((x, y, z, blockState) -> {
            if (blockState.method_26204() == class_2246.field_10465) {
                queue.enqueue((Object)new QueueObject(x, y, z, parameters.startDelay));
                priorityMap.put(x, y, z, parameters.startDelay);
            }
        });
        if (queue.isEmpty()) {
            class_2338 min2 = region.min();
            class_2338 max2 = region.max();
            int x2 = Math.floorDiv(min2.method_10263() + max2.method_10263(), 2);
            int y2 = Math.floorDiv(min2.method_10264() + max2.method_10264(), 2);
            int z2 = Math.floorDiv(min2.method_10260() + max2.method_10260(), 2);
            queue.enqueue((Object)new QueueObject(x2, y2, z2, parameters.startDelay));
            priorityMap.put(x2, y2, z2, parameters.startDelay);
        }
    }

    public static void tick() {
        QueueObject object;
        if (rebuildRegion == null || rebuildParameters == null) {
            return;
        }
        if (class_310.method_1551().field_1724 == null || class_310.method_1551().field_1687 == null) {
            RebuildOperation.resetRebuildState();
            return;
        }
        do {
            if (queue.isEmpty()) {
                RebuildOperation.resetRebuildState();
                return;
            }
            object = (QueueObject)queue.dequeue();
        } while (processed.contains(object.x, object.y, object.z));
        queue.enqueue((Object)object);
        currentPriority += 1.0;
        object = (QueueObject)queue.first();
        if (RebuildOperation.rebuildParameters.maxDelay >= 0.0f && (double)object.priority > currentPriority + (double)(RebuildOperation.rebuildParameters.maxDelay * 20.0f)) {
            currentPriority = object.priority - RebuildOperation.rebuildParameters.maxDelay * 20.0f;
        }
        HashMap<class_2338, class_2680> blocks = new HashMap<class_2338, class_2680>();
        BlockBuffer blockBuffer = null;
        while (true) {
            if (queue.isEmpty()) {
                RebuildOperation.resetRebuildState();
                break;
            }
            object = (QueueObject)queue.dequeue();
            if ((double)object.priority > currentPriority) {
                queue.enqueue((Object)object);
                break;
            }
            if (!processed.add(object.x, object.y, object.z)) continue;
            class_2680 blockState = rebuildRegion.getBlockStateOrAir(object.x, object.y, object.z);
            for (class_2350 direction : class_2350.values()) {
                int neighborZ;
                int neighborY;
                int neighborX = object.x + direction.method_10148();
                class_2680 neighbor = rebuildRegion.getBlockStateOrNull(neighborX, neighborY = object.y + direction.method_10164(), neighborZ = object.z + direction.method_10165());
                if (neighbor == null) continue;
                float penalty = neighbor.method_26215() ? RebuildOperation.rebuildParameters.airDelay * 20.0f : (neighbor.method_26204() == blockState.method_26204() ? RebuildOperation.rebuildParameters.sameBlockDelay * 20.0f : RebuildOperation.rebuildParameters.differentBlockDelay * 20.0f);
                if (RebuildOperation.rebuildParameters.randomExtraDelay > 0.0f) {
                    penalty += ThreadLocalRandom.current().nextFloat(RebuildOperation.rebuildParameters.randomExtraDelay * 20.0f);
                }
                penalty = direction.method_10164() != 0 ? (penalty *= RebuildOperation.rebuildParameters.verticalDelayMultiplier) : (penalty *= RebuildOperation.rebuildParameters.horizontalDelayMultiplier);
                float priority = object.priority + penalty;
                if (!(priority < priorityMap.get(neighborX, neighborY, neighborZ))) continue;
                priorityMap.put(neighborX, neighborY, neighborZ, priority);
                queue.enqueue((Object)new QueueObject(neighborX, neighborY, neighborZ, priority));
            }
            if (blockState.method_26204() == class_2246.field_10465) continue;
            if (blocks != null) {
                if (blocks.size() >= 500) {
                    blockBuffer = new BlockBuffer();
                    for (Map.Entry entry : blocks.entrySet()) {
                        class_2338 pos = (class_2338)entry.getKey();
                        blockBuffer.set(pos.method_10263(), pos.method_10264(), pos.method_10260(), (class_2680)entry.getValue());
                    }
                    blocks = null;
                } else {
                    blocks.put(new class_2338(object.x, object.y, object.z), blockState);
                }
            }
            if (blockBuffer == null) continue;
            blockBuffer.set(object.x, object.y, object.z, blockState);
        }
        if (blocks != null) {
            if (!blocks.isEmpty()) {
                new AxiomServerboundSetBlock(blocks, false, 0, false, class_3965.method_17778((class_243)class_243.field_1353, (class_2350)class_2350.field_11036, (class_2338)class_2338.field_10980), class_1268.field_5810, -1).send();
            }
        } else if (blockBuffer != null) {
            class_5321 worldKey = class_310.method_1551().field_1687.method_27983();
            AxiomServerboundSetBuffer.sendMulti((class_5321<class_1937>)worldKey, blockBuffer, Dispatcher.simpleSourceInfo("Animated Rebuild"));
        }
    }

    public record RebuildParameters(float startDelay, float maxDelay, float airDelay, float sameBlockDelay, float differentBlockDelay, float randomExtraDelay, float horizontalDelayMultiplier, float verticalDelayMultiplier) {
    }

    private record QueueObject(int x, int y, int z, float priority) {
    }
}

