/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.operations;

import com.moulberry.axiom.block_maps.BlockColourMap;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.clipboard.SelectionBuffer;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.utils.RegionHelper;
import com.moulberry.axiom.world_modification.Dispatcher;
import com.moulberry.axiom.world_modification.HistoryEntry;
import java.text.NumberFormat;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2384;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_7923;

public class GenerateColourFieldOperation {
    public static void generateColourField() {
        SelectionBuffer selectionBuffer = Selection.getSelectionBuffer();
        if (selectionBuffer instanceof SelectionBuffer.AABB) {
            SelectionBuffer.AABB aabb = (SelectionBuffer.AABB)selectionBuffer;
            GenerateColourFieldOperation.generateColourFieldAABB(aabb);
        }
    }

    private static void generateColourFieldAABB(SelectionBuffer.AABB aabb) {
        int minX = aabb.min().method_10263();
        int minY = aabb.min().method_10264();
        int minZ = aabb.min().method_10260();
        int maxX = aabb.max().method_10263();
        int maxY = aabb.max().method_10264();
        int maxZ = aabb.max().method_10260();
        ChunkedBlockRegion blockRegion = new ChunkedBlockRegion();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    blockRegion.addBlock(x, y, z, class_2246.field_10124.method_9564());
                }
            }
        }
        int collisions = 0;
        int missing = 0;
        for (class_2248 block : class_7923.field_41175) {
            int z;
            int y;
            double[] lab;
            if (block instanceof class_2384 || !BlockColourMap.isFullSolidOpaque(block.method_9564()) || (lab = BlockColourMap.getLab(block)) == null) continue;
            double doubleX = lab[0] / 100.0 * (double)(maxX - minX) + (double)minX;
            double doubleY = (lab[1] + 127.0) / 255.0 * (double)(maxY - minY) + (double)minY;
            double doubleZ = (lab[2] + 127.0) / 255.0 * (double)(maxZ - minZ) + (double)minZ;
            int x = (int)Math.round(doubleX);
            if (blockRegion.getBlockStateOrAir(x, y = (int)Math.round(doubleY), z = (int)Math.round(doubleZ)).method_26215()) {
                blockRegion.addBlock(x, y, z, block.method_9564());
                continue;
            }
            ++collisions;
            double minDistanceSq = Double.MAX_VALUE;
            int closestX = 0;
            int closestY = 0;
            int closestZ = 0;
            for (int xo = -3; xo <= 3; ++xo) {
                for (int yo = -3; yo <= 3; ++yo) {
                    for (int zo = -3; zo <= 3; ++zo) {
                        double dx = doubleX - (double)(x + xo);
                        double dy = doubleY - (double)(y + yo);
                        double dz = doubleZ - (double)(z + zo);
                        double distanceSq = dx * dx + dy * dy + dz * dz;
                        if (distanceSq > minDistanceSq || x + xo < minX || x + xo > maxX || y + yo < minY || y + yo > maxY || z + zo < minZ || z + zo > maxZ || !blockRegion.getBlockStateOrAir(x + xo, y + yo, z + zo).method_26215()) continue;
                        minDistanceSq = distanceSq;
                        closestX = xo;
                        closestY = yo;
                        closestZ = zo;
                    }
                }
            }
            if (closestX == 0 && closestY == 0 && closestZ == 0) {
                ++missing;
                continue;
            }
            blockRegion.addBlock(x + closestX, y + closestY, z + closestZ, block.method_9564());
        }
        if (collisions > 0) {
            class_310.method_1551().field_1724.method_43496((class_2561)class_2561.method_43470((String)("Encountered " + collisions + " collisions, tried to adjust positions to include every block")));
        }
        if (missing > 0) {
            class_310.method_1551().field_1724.method_43496((class_2561)class_2561.method_43470((String)("Missing " + missing + " blocks due to insufficient space")));
        }
        String blockCountString = NumberFormat.getNumberInstance().format(blockRegion.count());
        RegionHelper.pushBlockRegionChange(blockRegion, "Colour Field (" + blockCountString + " blocks)", Dispatcher.simpleSourceInfo("ColourField"), HistoryEntry.MODIFIER_SELECT_ON_BACKSTEP);
    }
}

