/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.mask;

import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.EditorWindowType;
import com.moulberry.axiom.editor.windows.global_mask.ToolMaskWindow;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.mask.MaskElement;
import com.moulberry.axiom.mask.MaskElementOptimizer;
import com.moulberry.axiom.mask.elements.AllMaskElement;
import com.moulberry.axiom.mask.elements.AnyMaskElement;
import com.moulberry.axiom.mask.elements.BlockConditionMaskElement;
import com.moulberry.axiom.mask.elements.BothMaskElement;
import com.moulberry.axiom.mask.elements.ConstantMaskElement;
import com.moulberry.axiom.mask.elements.EitherMaskElement;
import com.moulberry.axiom.mask.elements.LuaMaskElement;
import com.moulberry.axiom.mask.elements.NotMaskElement;
import com.moulberry.axiom.mask.elements.SelectedMaskElement;
import com.moulberry.axiom.mask.elements.SolidMaskElement;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.tools.ToolManager;
import com.moulberry.axiom.tools.path.PathTool;
import com.moulberry.axiom.tools.shape.ShapeTool;
import com.moulberry.axiom.utils.BlockCondition;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class MaskManager {
    private static MaskElement configuredMask = null;
    public static int[] mode = new int[]{0};
    public static boolean useLuaScript = false;
    public static String luaScript = null;
    private static final Set<class_2680> SOLID_BLOCKS = new HashSet<class_2680>();
    private static boolean calculatedSolidBlocks = false;

    private static void calculateSolidBlockSet() {
        if (calculatedSolidBlocks) {
            return;
        }
        calculatedSolidBlocks = true;
        SOLID_BLOCKS.clear();
        for (class_2248 block : class_7923.field_41175) {
            for (class_2680 possibleState : block.method_9595().method_11662()) {
                if (!possibleState.method_51366()) continue;
                SOLID_BLOCKS.add(possibleState);
            }
        }
    }

    public static MaskElement createSolidSourceMask() {
        return MaskManager.createSolidMask(2);
    }

    public static MaskElement createSolidDestMask() {
        return MaskManager.createSolidMask(1);
    }

    public static MaskElement getSourceMask() {
        return MaskManager.getMask(2);
    }

    public static MaskElement getDestMask() {
        return MaskManager.getMask(1);
    }

    private static MaskElement createSolidMask(int exclude) {
        boolean addSolid;
        if (!EditorUI.isActive()) {
            return new SolidMaskElement();
        }
        if (mode[0] == exclude || !EditorWindowType.TOOL_MASKS.isOpen()) {
            if (Selection.getSelectionBuffer().isEmpty()) {
                return new SolidMaskElement();
            }
            return new BothMaskElement(new SelectedMaskElement(), new SolidMaskElement());
        }
        if (useLuaScript && luaScript != null) {
            return MaskManager.getLuaMask(true);
        }
        if (configuredMask == null) {
            return new BothMaskElement(new SelectedMaskElement(), new SolidMaskElement());
        }
        boolean addSelection = !Selection.getSelectionBuffer().isEmpty() && !MaskManager.doesMaskContainSelection(configuredMask);
        MaybeNegatedSet possibleStates = MaskManager.possibleBlocks(configuredMask);
        if (possibleStates == null) {
            addSolid = true;
        } else if (possibleStates.negated) {
            MaskManager.calculateSolidBlockSet();
            addSolid = !possibleStates.set.containsAll(SOLID_BLOCKS);
        } else {
            addSolid = false;
            for (class_2680 blockState : possibleStates.set) {
                if (!blockState.method_51366()) continue;
                addSolid = true;
                break;
            }
        }
        if (addSolid && addSelection) {
            return new AllMaskElement(new SelectedMaskElement(), new SolidMaskElement(), configuredMask);
        }
        if (addSelection) {
            return new BothMaskElement(new SelectedMaskElement(), configuredMask);
        }
        if (addSolid) {
            return new BothMaskElement(new SolidMaskElement(), configuredMask);
        }
        return configuredMask;
    }

    public static MaskElement getSelectionMask() {
        if (!EditorUI.isActive()) {
            return new ConstantMaskElement(true);
        }
        if (!EditorWindowType.TOOL_MASKS.isOpen()) {
            return new ConstantMaskElement(true);
        }
        if (useLuaScript && luaScript != null) {
            return MaskManager.getLuaMask(false);
        }
        if (configuredMask == null) {
            return new ConstantMaskElement(true);
        }
        return configuredMask;
    }

    private static MaskElement getMask(int exclude) {
        if (!EditorUI.isActive()) {
            return new ConstantMaskElement(true);
        }
        if (mode[0] == exclude || !EditorWindowType.TOOL_MASKS.isOpen()) {
            if (Selection.getSelectionBuffer().isEmpty()) {
                return new ConstantMaskElement(true);
            }
            return new SelectedMaskElement();
        }
        if (useLuaScript && luaScript != null) {
            return MaskManager.getLuaMask(false);
        }
        if (configuredMask == null) {
            return new SelectedMaskElement();
        }
        if (Selection.getSelectionBuffer().isEmpty() || MaskManager.doesMaskContainSelection(configuredMask)) {
            return configuredMask;
        }
        return new BothMaskElement(new SelectedMaskElement(), configuredMask);
    }

    private static MaskElement getLuaMask(boolean solid) {
        LuaMaskElement luaMaskElement = new LuaMaskElement(luaScript);
        if (Selection.getSelectionBuffer().isEmpty()) {
            if (solid) {
                return new BothMaskElement(new SolidMaskElement(), luaMaskElement);
            }
            return luaMaskElement;
        }
        if (solid) {
            return new AllMaskElement(new SelectedMaskElement(), new SolidMaskElement(), luaMaskElement);
        }
        return new BothMaskElement(new SelectedMaskElement(), luaMaskElement);
    }

    public static boolean hasConfiguredMask() {
        return configuredMask != null;
    }

    public static void setConfiguredMask(MaskElement maskElement, boolean updateCmdString, boolean updateVisualCode) {
        Tool tool;
        if (maskElement != null) {
            maskElement = MaskElementOptimizer.optimizeStatic(maskElement);
        }
        configuredMask = maskElement;
        if (updateCmdString || updateVisualCode) {
            ToolMaskWindow.onMaskUpdated(maskElement, updateCmdString, updateVisualCode);
        }
        if ((tool = ToolManager.getCurrentTool()) instanceof PathTool) {
            PathTool pathTool = (PathTool)tool;
            pathTool.markDirty();
        }
        if ((tool = ToolManager.getCurrentTool()) instanceof ShapeTool) {
            ShapeTool shapeTool = (ShapeTool)tool;
            shapeTool.markDirty();
        }
    }

    private static boolean doesMaskContainSelection(MaskElement maskElement) {
        block7: {
            block6: {
                if (maskElement instanceof SelectedMaskElement) {
                    return true;
                }
                if (maskElement instanceof NotMaskElement) {
                    NotMaskElement notMaskElement = (NotMaskElement)maskElement;
                    return MaskManager.doesMaskContainSelection(notMaskElement.getChild());
                }
                if (maskElement instanceof BothMaskElement) {
                    BothMaskElement bothMaskElement = (BothMaskElement)maskElement;
                    return MaskManager.doesMaskContainSelection(bothMaskElement.getChild1()) || MaskManager.doesMaskContainSelection(bothMaskElement.getChild2());
                }
                if (!(maskElement instanceof AllMaskElement)) break block6;
                AllMaskElement allMaskElement = (AllMaskElement)maskElement;
                for (MaskElement child : allMaskElement.getChildren()) {
                    if (!MaskManager.doesMaskContainSelection(child)) continue;
                    return true;
                }
                break block7;
            }
            if (maskElement instanceof EitherMaskElement) {
                EitherMaskElement eitherMaskElement = (EitherMaskElement)maskElement;
                return MaskManager.doesMaskContainSelection(eitherMaskElement.getChild1()) || MaskManager.doesMaskContainSelection(eitherMaskElement.getChild2());
            }
            if (!(maskElement instanceof AnyMaskElement)) break block7;
            AnyMaskElement anyMaskElement = (AnyMaskElement)maskElement;
            for (MaskElement child : anyMaskElement.getChildren()) {
                if (!MaskManager.doesMaskContainSelection(child)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static MaybeNegatedSet possibleBlocks(MaskElement maskElement) {
        if (maskElement instanceof BothMaskElement) {
            BothMaskElement bothMaskElement = (BothMaskElement)maskElement;
            MaybeNegatedSet set1 = MaskManager.possibleBlocks(bothMaskElement.getChild1());
            MaybeNegatedSet set2 = MaskManager.possibleBlocks(bothMaskElement.getChild2());
            if (set1 == null) {
                return set2;
            }
            if (set2 == null) {
                return set1;
            }
            if (!set1.negated) {
                if (!set2.negated) {
                    set1.set.retainAll(set2.set);
                    return set1;
                }
                set1.set.removeAll(set2.set);
                return set1;
            }
            if (!set2.negated) {
                set2.set.removeAll(set1.set);
                return set2;
            }
            set1.set.addAll(set2.set);
            return set1;
        }
        if (maskElement instanceof AllMaskElement) {
            AllMaskElement allMaskElement = (AllMaskElement)maskElement;
            MaybeNegatedSet set1 = null;
            for (MaskElement child : allMaskElement.getChildren()) {
                MaybeNegatedSet set2 = MaskManager.possibleBlocks(child);
                if (set2 == null) continue;
                if (set1 == null) {
                    set1 = set2;
                    continue;
                }
                if (!set1.negated) {
                    if (!set2.negated) {
                        set1.set.retainAll(set2.set);
                        continue;
                    }
                    set1.set.removeAll(set2.set);
                    continue;
                }
                if (!set2.negated) {
                    set2.set.removeAll(set1.set);
                    set1 = set2;
                    continue;
                }
                set1.set.addAll(set2.set);
            }
            return set1;
        }
        if (maskElement instanceof EitherMaskElement) {
            EitherMaskElement eitherMaskElement = (EitherMaskElement)maskElement;
            MaybeNegatedSet set1 = MaskManager.possibleBlocks(eitherMaskElement.getChild1());
            MaybeNegatedSet set2 = MaskManager.possibleBlocks(eitherMaskElement.getChild2());
            if (set1 == null) {
                return set2;
            }
            if (set2 == null) {
                return set1;
            }
            if (!set1.negated) {
                if (!set2.negated) {
                    set1.set.addAll(set2.set);
                    return set1;
                }
                set2.set.removeAll(set1.set);
                return set2;
            }
            if (!set2.negated) {
                set1.set.removeAll(set2.set);
                return set1;
            }
            set1.set.retainAll(set2.set);
            return set1;
        }
        if (maskElement instanceof AnyMaskElement) {
            AnyMaskElement anyMaskElement = (AnyMaskElement)maskElement;
            MaybeNegatedSet set1 = null;
            for (MaskElement child : anyMaskElement.getChildren()) {
                set1 = MaskManager.union(set1, MaskManager.possibleBlocks(child));
            }
            return set1;
        }
        if (maskElement instanceof NotMaskElement) {
            NotMaskElement notMaskElement = (NotMaskElement)maskElement;
            MaybeNegatedSet set = MaskManager.possibleBlocks(notMaskElement.getChild());
            if (set != null) {
                set = new MaybeNegatedSet(set.set, !set.negated);
            }
            return set;
        }
        if (maskElement instanceof BlockConditionMaskElement) {
            BlockConditionMaskElement blockConditionMaskElement = (BlockConditionMaskElement)maskElement;
            return MaskManager.createSet(blockConditionMaskElement.getBlockCondition());
        }
        return null;
    }

    private static MaybeNegatedSet createSet(BlockCondition blockCondition) {
        if (blockCondition instanceof BlockCondition.MatchesTag) {
            BlockCondition.MatchesTag matchesTag = (BlockCondition.MatchesTag)blockCondition;
            HashSet<class_2680> possibleStates = new HashSet<class_2680>();
            for (class_6880 blockHolder : matchesTag.tag()) {
                possibleStates.addAll((Collection<class_2680>)((class_2248)blockHolder.comp_349()).method_9595().method_11662());
            }
            return new MaybeNegatedSet(possibleStates, false);
        }
        if (blockCondition instanceof BlockCondition.AnyState) {
            BlockCondition.AnyState anyState = (BlockCondition.AnyState)blockCondition;
            HashSet<class_2680> possibleStates = new HashSet<class_2680>((Collection<class_2680>)anyState.block().method_9595().method_11662());
            return new MaybeNegatedSet(possibleStates, false);
        }
        if (blockCondition instanceof BlockCondition.SpecificState) {
            BlockCondition.SpecificState specificState = (BlockCondition.SpecificState)blockCondition;
            HashSet<class_2680> possibleStates = new HashSet<class_2680>();
            possibleStates.add(specificState.blockState());
            return new MaybeNegatedSet(possibleStates, false);
        }
        if (blockCondition instanceof BlockCondition.StateSet) {
            BlockCondition.StateSet stateSet = (BlockCondition.StateSet)blockCondition;
            return new MaybeNegatedSet(new HashSet<class_2680>(stateSet.set()), false);
        }
        if (blockCondition instanceof BlockCondition.AnyCondition) {
            BlockCondition.AnyCondition anyCondition = (BlockCondition.AnyCondition)blockCondition;
            MaybeNegatedSet set1 = null;
            for (BlockCondition condition : anyCondition.conditions()) {
                set1 = MaskManager.union(set1, MaskManager.createSet(condition));
            }
            return set1;
        }
        throw new FaultyImplementationError("Don't know how to convert: " + String.valueOf(blockCondition.getClass()));
    }

    private static MaybeNegatedSet union(MaybeNegatedSet set1, MaybeNegatedSet set2) {
        if (set2 == null) {
            return set1;
        }
        if (set1 == null) {
            return set2;
        }
        if (!set1.negated) {
            if (!set2.negated) {
                set1.set.addAll(set2.set);
                return set1;
            }
            set2.set.removeAll(set1.set);
            return set2;
        }
        if (!set2.negated) {
            set1.set.removeAll(set2.set);
            return set1;
        }
        set1.set.retainAll(set2.set);
        return set1;
    }

    private record MaybeNegatedSet(Set<class_2680> set, boolean negated) {
    }
}

