/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.windows.operations;

import com.moulberry.axiom.BiomeDataManager;
import com.moulberry.axiom.editor.EditorWindowType;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.operations.SetBiomeOperation;
import imgui.ImGui;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class SetBiomeWindow {
    private static final int[] selectedBiome = new int[]{0};
    private static final List<BiomeWithIndex> filteredBiomes = new ArrayList<BiomeWithIndex>();
    private static String biomeFilter = "";
    private static boolean fillVertically = false;

    public static void render() {
        if (!EditorWindowType.SET_BIOME.isOpen()) {
            filteredBiomes.clear();
            biomeFilter = "";
            return;
        }
        if (EditorWindowType.SET_BIOME.begin("###SetBiome", true)) {
            List<BiomeDataManager.BiomeDataEntry> biomes;
            BiomeDataManager biomeDataManager = BiomeDataManager.get();
            if (biomeDataManager == null) {
                ImGui.text(AxiomI18n.get("axiom.widget.error_biome_registry"));
                EditorWindowType.SET_BIOME.end();
                return;
            }
            if (biomeDataManager.justRefreshed()) {
                filteredBiomes.clear();
                biomeFilter = "";
            }
            if ((biomes = biomeDataManager.biomes()).isEmpty()) {
                ImGui.text(AxiomI18n.get("axiom.widget.error_biome_registry"));
                EditorWindowType.SET_BIOME.end();
                return;
            }
            if (selectedBiome[0] >= biomes.size()) {
                SetBiomeWindow.selectedBiome[0] = 0;
            }
            String currentBiome = biomes.get(selectedBiome[0]).prettyName();
            if (ImGui.beginCombo("##Biomes", biomeFilter.isEmpty() ? currentBiome : biomeFilter)) {
                ImGui.captureKeyboardFromApp();
                String biomeFilterOld = biomeFilter;
                biomeFilter = ImGuiHelper.modifyFromInput(biomeFilter);
                if (biomeFilter.isEmpty()) {
                    for (int i = 0; i < biomes.size(); ++i) {
                        boolean selected;
                        ImGui.pushID(i);
                        boolean bl = selected = i == selectedBiome[0];
                        if (ImGui.selectable(biomes.get(i).prettyName(), selected) && !selected) {
                            SetBiomeWindow.selectedBiome[0] = i;
                        }
                        if (selected) {
                            ImGui.setItemDefaultFocus();
                        }
                        ImGui.popID();
                    }
                } else {
                    if (!biomeFilter.equals(biomeFilterOld)) {
                        String filterLower = biomeFilter.toLowerCase(Locale.ROOT);
                        filteredBiomes.clear();
                        for (int i = 0; i < biomes.size(); ++i) {
                            String biome = biomes.get(i).prettyName();
                            if (!biome.toLowerCase(Locale.ROOT).contains(filterLower)) continue;
                            filteredBiomes.add(new BiomeWithIndex(biome, i));
                        }
                    }
                    if (filteredBiomes.size() > 0 && ImGui.getIO().getKeysDown(257)) {
                        SetBiomeWindow.selectedBiome[0] = SetBiomeWindow.filteredBiomes.get((int)0).index;
                        ImGui.closeCurrentPopup();
                    }
                    for (int i = 0; i < filteredBiomes.size(); ++i) {
                        boolean selected;
                        ImGui.pushID(i);
                        BiomeWithIndex biomeWithIndex = filteredBiomes.get(i);
                        boolean bl = selected = biomeWithIndex.index == selectedBiome[0];
                        if (ImGui.selectable(biomeWithIndex.prettyName, selected) && !selected) {
                            SetBiomeWindow.selectedBiome[0] = biomeWithIndex.index;
                        }
                        if (selected) {
                            ImGui.setItemDefaultFocus();
                        }
                        ImGui.popID();
                    }
                }
                ImGui.endCombo();
            } else {
                biomeFilter = "";
            }
            if (ImGui.checkbox(AxiomI18n.get("axiom.editorui.window.set_biome.fill_vertically"), fillVertically)) {
                boolean bl = fillVertically = !fillVertically;
            }
            if (ImGui.button(AxiomI18n.get("axiom.editorui.window.set_biome.do_set_biome"))) {
                SetBiomeOperation.setBiome(biomes.get(selectedBiome[0]).key(), fillVertically);
            }
        }
        EditorWindowType.SET_BIOME.end();
    }

    private record BiomeWithIndex(String prettyName, int index) {
    }
}

