/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.views;

import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.ServerConfig;
import com.moulberry.axiom.editor.views.View;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.packets.AxiomServerboundSetEditorViews;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_310;

public class ViewManager {
    static UUID activeView = null;
    static int activeFrames = 0;
    private static final List<View> views = new ArrayList<View>();

    public static List<View> getViews() {
        return views;
    }

    public static void clear() {
        views.clear();
        ViewManager.addMainView();
    }

    public static void addNewView() {
        ServerConfig config = Axiom.getInstance().serverConfig;
        if (config.editableEditorViews() && views.size() < config.maximumEditorViews()) {
            views.add(new View(AxiomI18n.get("axiom.editorui.view.new_view_name"), UUID.randomUUID(), (class_1657)class_310.method_1551().field_1724));
            ViewManager.syncViews();
        }
    }

    private static void addMainView() {
        ServerConfig config = Axiom.getInstance().serverConfig;
        if (views.isEmpty() || config.editableEditorViews() && views.size() < config.maximumEditorViews()) {
            UUID uuid = UUID.randomUUID();
            views.add(new View(AxiomI18n.get("axiom.editorui.view.main_name"), uuid, (class_1657)class_310.method_1551().field_1724));
            activeView = uuid;
        }
    }

    public static void syncViews() {
        if (views.isEmpty()) {
            ViewManager.addMainView();
        }
        new AxiomServerboundSetEditorViews(activeView, new ArrayList<View>(views)).send();
    }

    public static void setFromServer(UUID activeView, List<View> views) {
        if (activeView.getLeastSignificantBits() != 0L || activeView.getMostSignificantBits() != 0L) {
            ViewManager.activeView = activeView;
        }
        ViewManager.views.clear();
        ViewManager.views.addAll(views);
        if (views.isEmpty()) {
            ViewManager.addMainView();
        }
        boolean activeViewIsValid = false;
        for (View view : ViewManager.views) {
            if (!view.uuid.equals(ViewManager.activeView)) continue;
            activeViewIsValid = true;
            break;
        }
        if (!activeViewIsValid) {
            ViewManager.activeView = ViewManager.views.get((int)0).uuid;
        }
    }

    static {
        ViewManager.addMainView();
    }
}

