/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.keybinds;

import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.editor.keybinds.KeybindHelper;
import com.moulberry.axiom.editor.keybinds.Keybinds;
import com.moulberry.axiom.i18n.AxiomI18n;
import imgui.ImGui;
import imgui.ImGuiIO;
import java.util.Locale;
import net.minecraft.class_156;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import org.lwjgl.glfw.GLFW;

public class Keybind {
    private final String description;
    private int key;
    private boolean shiftMod;
    private boolean ctrlMod;
    private boolean altMod;
    private boolean superMod;

    public Keybind(String description, int key, boolean shiftMod, boolean ctrlMod, boolean altMod, boolean superMod) {
        this.description = description;
        this.key = key;
        this.shiftMod = shiftMod;
        this.ctrlMod = ctrlMod;
        this.altMod = altMod;
        this.superMod = superMod;
        Keybinds.updateMapping(this, 0);
    }

    public int getKey() {
        return this.key;
    }

    public boolean isShiftMod() {
        return this.shiftMod;
    }

    public boolean isCtrlMod() {
        return this.ctrlMod;
    }

    public boolean isAltMod() {
        return this.altMod;
    }

    public boolean isSuperMod() {
        return this.superMod;
    }

    public void clear() {
        int oldKey = this.key;
        this.key = 0;
        this.shiftMod = false;
        this.ctrlMod = false;
        this.altMod = false;
        this.superMod = false;
        Keybinds.updateMapping(this, oldKey);
    }

    public void set(Keybind other) {
        if (other.description.equals(this.description)) {
            int oldKey = this.key;
            this.key = other.key;
            this.shiftMod = other.shiftMod;
            this.ctrlMod = other.ctrlMod;
            this.altMod = other.altMod;
            this.superMod = other.superMod;
            Keybinds.updateMapping(this, oldKey);
        }
    }

    public String toConfigValue() {
        if (this.key == 0) {
            return "none";
        }
        String key = KeybindHelper.glfwToConfig(this.key);
        if (key.equals("none")) {
            return "none";
        }
        StringBuilder builder = new StringBuilder();
        if (this.shiftMod) {
            builder.append("shift+");
        }
        if (this.ctrlMod) {
            builder.append("ctrl+");
        }
        if (this.altMod) {
            builder.append("alt+");
        }
        if (this.superMod) {
            builder.append("super+");
        }
        builder.append(key);
        return builder.toString();
    }

    public void loadFromConfigValue(String configValue) {
        String originalConfigValue = configValue;
        configValue = configValue.toLowerCase(Locale.ROOT);
        if ((configValue = configValue.replaceAll("[^a-z0-9+_]", "")).equals("none")) {
            int oldKey = this.key;
            this.key = 0;
            this.superMod = false;
            this.altMod = false;
            this.ctrlMod = false;
            this.shiftMod = false;
            Keybinds.updateMapping(this, oldKey);
            return;
        }
        boolean shiftMod = false;
        boolean ctrlMod = false;
        boolean altMod = false;
        boolean superMod = false;
        while (true) {
            if (configValue.startsWith("shift+")) {
                shiftMod = true;
                configValue = configValue.substring(6);
                continue;
            }
            if (configValue.startsWith("ctrl+")) {
                ctrlMod = true;
                configValue = configValue.substring(5);
                continue;
            }
            if (configValue.startsWith("alt+")) {
                altMod = true;
                configValue = configValue.substring(4);
                continue;
            }
            if (!configValue.startsWith("super+")) break;
            superMod = true;
            configValue = configValue.substring(6);
        }
        int key = KeybindHelper.configToGlfw(configValue = configValue.substring(configValue.lastIndexOf("+") + 1));
        if (key != 0) {
            int oldKey = this.key;
            this.key = key;
            this.shiftMod = shiftMod;
            this.ctrlMod = ctrlMod;
            this.altMod = altMod;
            this.superMod = superMod;
            Keybinds.updateMapping(this, oldKey);
        } else {
            Axiom.dbg("Invalid keybind in config for " + this.description + ": " + originalConfigValue);
        }
    }

    public Keybind copy() {
        return new Keybind(this.description, this.key, this.shiftMod, this.ctrlMod, this.altMod, this.superMod);
    }

    public void set(int key, boolean shiftMod, boolean ctrlMod, boolean altMod, boolean superMod) {
        int oldKey = this.key;
        this.key = key;
        this.shiftMod = shiftMod;
        this.ctrlMod = ctrlMod;
        this.altMod = altMod;
        this.superMod = superMod;
        Keybinds.updateMapping(this, oldKey);
    }

    public boolean hasSameMods(Keybind other) {
        return this.shiftMod == other.shiftMod && this.ctrlMod == other.ctrlMod && this.altMod == other.altMod && this.superMod == other.superMod;
    }

    public String shortKeyIdentifier() {
        if (this.key == 0) {
            return "";
        }
        Object keyName = this.key < 0 ? "M" + -this.key : class_3675.method_15985((int)this.key, (int)-1).method_27445().getString();
        if (!(this.shiftMod || this.ctrlMod || this.altMod || this.superMod)) {
            return keyName;
        }
        int macCmd = 8984;
        int alt = 9095;
        int shift = 8679;
        int superKey = 10070;
        StringBuilder builder = new StringBuilder();
        if (this.shiftMod) {
            builder.append('\u21e7');
        }
        if (this.ctrlMod) {
            if (class_310.field_1703) {
                builder.append('\u2318');
            } else {
                builder.append("Ctrl+");
            }
        }
        if (this.altMod) {
            builder.append('\u2387');
        }
        if (this.superMod) {
            if (class_310.field_1703) {
                builder.append("Ctrl+");
            } else {
                builder.append('\u2756');
            }
        }
        builder.append((String)keyName);
        return builder.toString();
    }

    public String longKeyIdentifier() {
        if (this.key == 0) {
            return AxiomI18n.get("key.keyboard.unknown");
        }
        String keyName = this.key < 0 ? class_3675.class_307.field_1672.method_1447(-this.key - 1).method_27445().getString() : class_3675.method_15985((int)this.key, (int)-1).method_27445().getString();
        if (!(this.shiftMod || this.ctrlMod || this.altMod || this.superMod)) {
            return keyName;
        }
        StringBuilder builder = new StringBuilder();
        if (this.shiftMod) {
            builder.append(AxiomI18n.get("axiom.keymod.shift")).append("+");
        }
        if (this.ctrlMod) {
            if (class_310.field_1703) {
                builder.append(AxiomI18n.get("axiom.keymod.mac_cmd")).append("+");
            } else {
                builder.append(AxiomI18n.get("axiom.keymod.ctrl")).append("+");
            }
        }
        if (this.altMod) {
            builder.append(AxiomI18n.get("axiom.keymod.alt")).append("+");
        }
        if (this.superMod) {
            if (class_310.field_1703) {
                builder.append(AxiomI18n.get("axiom.keymod.ctrl")).append("+");
            } else if (class_156.method_668() == class_156.class_158.field_1133) {
                builder.append(AxiomI18n.get("axiom.keymod.win_super")).append("+");
            } else {
                builder.append(AxiomI18n.get("axiom.keymod.super")).append("+");
            }
        }
        builder.append(keyName);
        return builder.toString();
    }

    public boolean wouldBePressed(int key, boolean shiftMod, boolean ctrlMod, boolean altMod, boolean superMod) {
        if (this.key == 0) {
            return false;
        }
        if (this.key != key) {
            return false;
        }
        if (this.shiftMod != shiftMod) {
            return false;
        }
        if (this.ctrlMod != (class_310.field_1703 ? superMod : ctrlMod)) {
            return false;
        }
        if (this.altMod != altMod) {
            return false;
        }
        return this.superMod == (class_310.field_1703 ? ctrlMod : superMod);
    }

    public boolean isDownUsingGLFW() {
        if (this.key == 0) {
            return false;
        }
        long window = class_310.method_1551().method_22683().method_4490();
        if (this.key < 0 ? GLFW.glfwGetMouseButton((long)window, (int)(-this.key - 1)) == 0 : GLFW.glfwGetKey((long)window, (int)this.key) == 0) {
            return false;
        }
        if (this.shiftMod != class_437.method_25442()) {
            return false;
        }
        if (this.ctrlMod != class_437.method_25441()) {
            return false;
        }
        return this.altMod == class_437.method_25443();
    }

    public boolean isDownIgnoreMods() {
        if (this.key == 0) {
            return false;
        }
        if (this.key < 0) {
            return ImGui.isMouseDown(-this.key - 1);
        }
        return ImGui.isKeyDown(this.key);
    }

    public boolean isPressedIgnoreMods() {
        if (this.key == 0) {
            return false;
        }
        if (this.key < 0) {
            return ImGui.isMouseClicked(-this.key - 1);
        }
        return ImGui.isKeyPressed(this.key);
    }

    public boolean isDown() {
        if (this.key == 0) {
            return false;
        }
        if (this.key < 0 ? !ImGui.isMouseDown(-this.key - 1) : !ImGui.isKeyDown(this.key)) {
            return false;
        }
        return this.areAllModifiersDown();
    }

    public boolean areAllModifiersDown() {
        if (this.key == 0) {
            return false;
        }
        ImGuiIO io = ImGui.getIO();
        if (this.shiftMod != io.getKeyShift()) {
            return false;
        }
        if (this.ctrlMod != (class_310.field_1703 ? io.getKeySuper() : io.getKeyCtrl())) {
            return false;
        }
        if (this.altMod != io.getKeyAlt()) {
            return false;
        }
        return this.superMod == (class_310.field_1703 ? io.getKeyCtrl() : io.getKeySuper());
    }

    public boolean isPressed(boolean repeat) {
        if (this.key == 0) {
            return false;
        }
        if (this.key < 0 ? !ImGui.isMouseClicked(-this.key - 1, repeat) : !ImGui.isKeyPressed(this.key, repeat)) {
            return false;
        }
        return this.areAllModifiersDown();
    }

    public boolean isReleased(boolean repeat) {
        if (this.key == 0) {
            return false;
        }
        if (this.key < 0 ? !ImGui.isMouseReleased(-this.key - 1) : !ImGui.isKeyReleased(this.key)) {
            return false;
        }
        ImGuiIO io = ImGui.getIO();
        if (this.shiftMod != io.getKeyShift()) {
            return false;
        }
        if (this.ctrlMod != (class_310.field_1703 ? io.getKeySuper() : io.getKeyCtrl())) {
            return false;
        }
        if (this.altMod != io.getKeyAlt()) {
            return false;
        }
        return this.superMod == (class_310.field_1703 ? io.getKeyCtrl() : io.getKeySuper());
    }

    public String getDescriptionRaw() {
        return this.description;
    }

    public String getDescription() {
        return AxiomI18n.get("axiom.keybinds." + this.description);
    }
}

