/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor;

import com.moulberry.axiom.configuration.Configuration;
import com.moulberry.axiom.editor.tutorial.TutorialManager;
import com.moulberry.axiom.editor.tutorial.TutorialStage;
import com.moulberry.axiom.i18n.AxiomI18n;
import imgui.ImGui;
import imgui.ImGuiViewport;
import imgui.type.ImBoolean;
import java.util.ArrayList;
import java.util.List;

public enum EditorWindowType {
    TOOLS("tools", true, true, 8),
    TOOL_OPTIONS("tool_options", true, true, 8),
    PALETTE("palette", true, true),
    ACTIVE_BLOCK("active_block", true, true, 24),
    HISTORY("history", true, true),
    WORLD_PROPERTIES("world_properties", true, true),
    CLIPBOARD("clipboard", true, true),
    TARGET_INFO("target_info", true, true),
    KEYBINDS("keybinds", true, false),
    BLUEPRINT_BROWSER("blueprint_browser", true, false),
    TOOL_MASKS("tool_masks", true, false),
    STYLE_EDITOR("style_editor", true, false),
    DEBUG_INFO("debug_info", false, false, 64),
    FILTER_SELECTION("filter_selection", false, false, 64),
    EXPAND_SELECTION("expand_selection", false, false, 64),
    SHRINK_SELECTION("shrink_selection", false, false, 64),
    DISTORT_SELECTION("distort_selection", false, false, 64),
    SMOOTH_SELECTION("smooth_selection", false, false, 64),
    FILL("fill", false, false, 88),
    REPLACE("replace", false, false, 88),
    TYPE_REPLACE("type_replace", false, false, 88),
    SET_BIOME("set_biome", false, false, 88),
    AUTOSHADE("autoshade", false, false, 72),
    ANALYZE("analyze", false, false, 64),
    ANIMATED_REBUILD("animated_rebuild", false, false, 64),
    ROTATE_PLACEMENT("rotate_placement", false, false, 64);

    private final String nameKey;
    private final boolean important;
    private final ImBoolean open;
    private final int extraFlags;
    private boolean justOpened = false;
    private boolean docked = false;
    private boolean focused = false;
    private boolean disabled = false;
    private boolean disabledDimBg = false;

    private EditorWindowType(String nameKey, boolean important, boolean openByDefault, int extraFlags) {
        this.nameKey = nameKey;
        this.important = important;
        this.open = new ImBoolean(openByDefault);
        this.extraFlags = extraFlags;
    }

    private EditorWindowType(String nameKey, boolean important, boolean openByDefault) {
        this(nameKey, important, openByDefault, 0);
    }

    public static List<String> getOpenByName() {
        ArrayList<String> open = new ArrayList<String>();
        for (EditorWindowType value : EditorWindowType.values()) {
            if (!value.open.get()) continue;
            open.add(value.nameKey);
        }
        return open;
    }

    public static void setOpenByName(List<String> open) {
        for (EditorWindowType value : EditorWindowType.values()) {
            value.open.set(open.contains(value.nameKey));
        }
    }

    public boolean begin(String suffix, boolean useFlags) {
        boolean begin;
        if (this.justOpened) {
            this.justOpened = false;
            if (!this.docked) {
                ImGuiViewport viewport = ImGui.getMainViewport();
                ImGui.setNextWindowPos(viewport.getCenterX(), viewport.getCenterY(), 8, 0.5f, 0.5f);
            }
        }
        int additionalFlags = 0;
        TutorialStage stage = TutorialManager.getCurrentStage();
        if (stage != null && stage.getLinkedWindow() != this) {
            ImGui.beginDisabled();
            additionalFlags |= 0x60200;
            this.disabled = true;
        }
        if (begin = !this.docked || Configuration.internal.showCloseWindowButton ? ImGui.begin(this.getName() + suffix, this.open, (useFlags ? this.getFlags() : 0) | additionalFlags) : ImGui.begin(this.getName() + suffix, (useFlags ? this.getFlags() : 0) | additionalFlags)) {
            this.docked = ImGui.isWindowDocked();
            this.focused = ImGui.isWindowFocused();
            this.disabledDimBg = this.disabled;
            return true;
        }
        this.disabledDimBg = false;
        return false;
    }

    public void end() {
        if (this.disabled) {
            this.disabled = false;
            if (this.disabledDimBg) {
                this.disabledDimBg = false;
                float x = ImGui.getWindowPosX();
                float y = ImGui.getWindowPosY();
                float width = ImGui.getWindowWidth();
                float height = ImGui.getWindowHeight();
                ImGui.getForegroundDrawList().addRectFilled(x, y, x + width, y + height, ImGui.getColorU32(54));
            }
            ImGui.end();
            ImGui.endDisabled();
        } else {
            ImGui.end();
        }
    }

    public int getFlags() {
        return this.extraFlags;
    }

    public boolean isOpen() {
        TutorialStage stage = TutorialManager.getCurrentStage();
        if (stage != null && stage.getLinkedWindow() == this) {
            return true;
        }
        return this.open.get();
    }

    public boolean isOpenAndActive() {
        return this.isOpen() && (!this.docked || this.focused);
    }

    public String getName() {
        return AxiomI18n.get("axiom.editorui.window." + this.nameKey);
    }

    public boolean isDocked() {
        return this.docked;
    }

    public boolean isImportant() {
        return this.important;
    }

    public void setOpen(boolean open) {
        if (this.open.get() == open) {
            return;
        }
        if (open) {
            this.justOpened = true;
        }
        this.open.set(open);
    }
}

