/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.configuration;

import com.moulberry.axiom.configuration.AbstractConfigurationCategory;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.EditorWindowType;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.palette.EditorPalette;
import com.moulberry.axiom.editor.styles.StyleHelper;
import com.moulberry.axiom.editor.styles.StyleManager;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;

public class InternalConfiguration
extends AbstractConfigurationCategory {
    public boolean shownIntroduction = this.load(Boolean.class, "shownIntroduction", false, null);
    public Set<String> completedTutorials = new LinkedHashSet<String>(this.load(List.class, "completedTutorials", List.of(), null));
    public List<String> openEditorWindowTypes = this.load(List.class, "openEditorWindowTypes", EditorWindowType.getOpenByName(), null);
    public int lastTranslationCount = ((Number)this.load(Number.class, "lastTranslationCount", 0, null)).intValue();
    public float globalScale = ((Number)this.load(Number.class, "globalScale", Float.valueOf(1.0f), null)).floatValue();
    public String savedCustomTheme = this.load(String.class, "savedCustomTheme", "", null);
    public boolean showCloseWindowButton = this.load(Boolean.class, "showCloseWindowButton", false, null);
    public boolean showToolMaskOpenWarning = this.load(Boolean.class, "showToolMaskOpenWarning", true, null);
    public boolean showNon90DegreeRotationWarning = this.load(Boolean.class, "showNon90DegreeRotationWarning", true, null);
    public EditorPalette rootEditorPalette;
    public Map<String, String> customDowngradeSuggestions;

    public InternalConfiguration(CommentedConfigurationNode node) {
        super(node);
        CommentedConfigurationNode rootEditorPaletteNode = (CommentedConfigurationNode)this.node.node(new Object[]{"rootEditorPalette"});
        try {
            this.rootEditorPalette = EditorPalette.load("", rootEditorPaletteNode);
        }
        catch (Exception e) {
            this.rootEditorPalette = new EditorPalette("");
        }
        EditorWindowType.setOpenByName(this.openEditorWindowTypes);
        EditorUI.newGlobalScale = this.globalScale;
        List customDowngradeSuggestions = this.load(List.class, "customDowngradeSuggestions", List.of(), null);
        this.customDowngradeSuggestions = new LinkedHashMap<String, String>();
        for (String suggestion : customDowngradeSuggestions) {
            String[] split = suggestion.split("->");
            if (split.length != 2) continue;
            this.customDowngradeSuggestions.put(split[0], split[1]);
        }
    }

    @Override
    public void save() {
        this.openEditorWindowTypes = EditorWindowType.getOpenByName();
        this.globalScale = EditorUI.newGlobalScale;
        ImGuiHelper.popAllStyleColors();
        ImGuiHelper.popAllStyleVars();
        StyleHelper.Theme theme = StyleManager.createTheme();
        if (theme != null) {
            this.savedCustomTheme = theme.convertToBase64();
        }
        this.set("shownIntroduction", this.shownIntroduction);
        this.set("completedTutorials", new ArrayList<String>(this.completedTutorials));
        this.set("openEditorWindowTypes", this.openEditorWindowTypes);
        this.set("lastTranslationCount", this.lastTranslationCount);
        this.set("globalScale", Float.valueOf(this.globalScale));
        this.set("savedCustomTheme", this.savedCustomTheme);
        this.set("showCloseWindowButton", this.showCloseWindowButton);
        this.set("showToolMaskOpenWarning", this.showToolMaskOpenWarning);
        this.set("showNon90DegreeRotationWarning", this.showNon90DegreeRotationWarning);
        try {
            this.node.removeChild("rootEditorPalette");
            this.rootEditorPalette.save(this.node.node(new Object[]{"rootEditorPalette"}));
        }
        catch (SerializationException serializationException) {
            // empty catch block
        }
        ArrayList<CallSite> customDowngradeSuggestions = new ArrayList<CallSite>();
        for (Map.Entry<String, String> entry : this.customDowngradeSuggestions.entrySet()) {
            customDowngradeSuggestions.add((CallSite)((Object)(entry.getKey() + "->" + entry.getValue())));
        }
        this.set("customDowngradeSuggestions", customDowngradeSuggestions);
    }
}

