/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.commands.parser;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.moulberry.axiom.commands.parser.Argument;
import com.moulberry.axiom.commands.parser.ArgumentParser;

public class ActiveArgumentParser
implements AutoCloseable {
    private final Argument.Positional[] positional;
    private final StringReader reader;
    private int positionalIndex = 0;
    private boolean ended = false;

    public ActiveArgumentParser(Argument.Positional[] positional, StringReader reader) {
        this.positional = positional;
        this.reader = reader;
    }

    public <T> T get() throws CommandSyntaxException {
        if (this.ended) {
            throw new IllegalStateException("Tried to get an argument after close()");
        }
        this.reader.skipWhitespace();
        if (!this.reader.canRead()) {
            ArgumentParser.throwNotEnoughArguments(this.reader, this.positionalIndex, this.positional);
        }
        Object value = this.positional[this.positionalIndex].parser().apply(this.reader);
        ++this.positionalIndex;
        return (T)value;
    }

    @Override
    public void close() throws CommandSyntaxException {
        this.reader.skipWhitespace();
        if (this.reader.canRead()) {
            throw ArgumentParser.TOO_MANY_ARGUMENTS.createWithContext((ImmutableStringReader)this.reader);
        }
        this.ended = true;
    }
}

