/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.commands.operations.impl;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.moulberry.axiom.commands.DispatcherMetadata;
import com.moulberry.axiom.commands.SpannedStyle;
import com.moulberry.axiom.commands.arguments.IntegerArgument;
import com.moulberry.axiom.commands.operations.CommandDefinition;
import com.moulberry.axiom.commands.operations.CommandOperation;
import com.moulberry.axiom.commands.parser.ActiveArgumentParser;
import com.moulberry.axiom.commands.parser.Argument;
import com.moulberry.axiom.commands.parser.ArgumentParser;
import com.moulberry.axiom.world_modification.BlockBuffer;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3532;

public class AxiomScatterCommand {

    public static class Operation
    extends CommandOperation {
        private final int radius;
        private final BlockBuffer blockBuffer = new BlockBuffer();

        public Operation(int radius) {
            this.radius = radius;
        }

        @Override
        public boolean requiresBlockState() {
            return true;
        }

        @Override
        public boolean executeSingle(DispatcherMetadata metadata, int x, int y, int z, float percentage, class_2680 block, BlockBuffer buffer) {
            this.blockBuffer.set(x, y, z, block);
            return true;
        }

        @Override
        public void executeWhole(DispatcherMetadata metadata, class_1937 level, BlockBuffer forwards, BlockBuffer backwards) {
            class_2338 min2 = metadata.selectionMin();
            class_2338 max2 = metadata.selectionMax();
            this.blockBuffer.forEach((x, y, z, state) -> {
                int fromZ;
                int fromY;
                float yaw = ThreadLocalRandom.current().nextFloat() * 2.0f * (float)Math.PI;
                float pitch = ThreadLocalRandom.current().nextFloat() * 2.0f * (float)Math.PI;
                float distance = ThreadLocalRandom.current().nextFloat() * (float)this.radius;
                float cosPitch = class_3532.method_15362((float)pitch);
                int xo = Math.round(class_3532.method_15374((float)yaw) * cosPitch * distance);
                int yo = Math.round(class_3532.method_15374((float)pitch) * distance);
                int zo = Math.round(class_3532.method_15362((float)yaw) * cosPitch * distance);
                int fromX = this.ensureInBounds(x, xo, min2.method_10263(), max2.method_10263());
                class_2680 block = this.blockBuffer.get(fromX, fromY = this.ensureInBounds(y, yo, min2.method_10264(), max2.method_10264()), fromZ = this.ensureInBounds(z, zo, min2.method_10260(), max2.method_10260()));
                if (block == null) {
                    block = state;
                }
                if (!super.executeSingle(metadata, x, y, z, -1.0f, block, forwards)) {
                    forwards.set(x, y, z, block);
                }
            });
            super.executeWhole(metadata, level, forwards, backwards);
        }

        private int ensureInBounds(int v, int vo, int min2, int max2) {
            if (v + vo < min2) {
                if (v - vo > max2) {
                    return min2 + ThreadLocalRandom.current().nextInt(max2 - min2 + 1);
                }
                return v - vo;
            }
            if (v + vo > max2) {
                if (v - vo < min2) {
                    return min2 + ThreadLocalRandom.current().nextInt(max2 - min2 + 1);
                }
                return v - vo;
            }
            return v + vo;
        }
    }

    public static class Definition
    implements CommandDefinition {
        private final ArgumentParser parser = new ArgumentParser(Argument.positional("radius", IntegerArgument::parse, IntegerArgument::highlight, IntegerArgument::suggest));

        @Override
        public CommandOperation createOperation(StringReader reader) throws CommandSyntaxException {
            try (ActiveArgumentParser parser = this.parser.start(reader);){
                int radius = (Integer)parser.get();
                Operation operation = new Operation(radius);
                return operation;
            }
        }

        @Override
        public void syntaxHighlight(List<SpannedStyle> styles, StringReader reader, boolean isLast) throws CommandSyntaxException {
            this.parser.syntaxHighlight(styles, reader, isLast);
        }

        @Override
        public Suggestions autocomplete(SuggestionsBuilder builder, StringReader reader) {
            return this.parser.autocomplete(builder, reader);
        }
    }
}

