/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.commands.operations.impl;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.commands.DispatcherMetadata;
import com.moulberry.axiom.commands.SpannedStyle;
import com.moulberry.axiom.commands.arguments.IntegerArgument;
import com.moulberry.axiom.commands.operations.CommandDefinition;
import com.moulberry.axiom.commands.operations.CommandOperation;
import com.moulberry.axiom.commands.parser.ActiveArgumentParser;
import com.moulberry.axiom.commands.parser.Argument;
import com.moulberry.axiom.commands.parser.ArgumentParser;
import com.moulberry.axiom.world_modification.BlockBuffer;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public class AxiomExpandCommand {

    public static class Operation
    extends CommandOperation {
        private final int radius;
        private final PositionSet expandFrom = new PositionSet();

        public Operation(int radius) {
            this.radius = radius;
        }

        @Override
        public boolean requiresBlockState() {
            return true;
        }

        @Override
        public boolean executeSingle(DispatcherMetadata metadata, int x, int y, int z, float percentage, class_2680 block, BlockBuffer buffer) {
            this.expandFrom.add(x, y, z);
            return super.executeSingle(metadata, x, y, z, percentage, block, buffer);
        }

        @Override
        public void executeWhole(DispatcherMetadata metadata, class_1937 level, BlockBuffer forwards, BlockBuffer backwards) {
            class_2338 min2 = metadata.selectionMin();
            class_2338 max2 = metadata.selectionMax();
            min2 = new class_2338(min2.method_10263() - this.radius, min2.method_10264() - this.radius, min2.method_10260() - this.radius);
            max2 = new class_2338(max2.method_10263() + this.radius, max2.method_10264() + this.radius, max2.method_10260() + this.radius);
            DispatcherMetadata metadataNew = new DispatcherMetadata(min2, max2);
            float radiusSquared = ((float)this.radius + 0.5f) * ((float)this.radius + 0.5f);
            boolean requiresBlockState = this.child.requiresBlockState();
            PositionSet expanded = new PositionSet();
            class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
            this.expandFrom.forEach((x, y, z) -> {
                int minRadiusX = this.expandFrom.contains(x - 1, y, z) ? 0 : -this.radius;
                int maxRadiusX = this.expandFrom.contains(x + 1, y, z) ? 0 : this.radius;
                int minRadiusY = this.expandFrom.contains(x, y - 1, z) ? 0 : -this.radius;
                int maxRadiusY = this.expandFrom.contains(x, y + 1, z) ? 0 : this.radius;
                int minRadiusZ = this.expandFrom.contains(x, y, z - 1) ? 0 : -this.radius;
                int maxRadiusZ = this.expandFrom.contains(x, y, z + 1) ? 0 : this.radius;
                for (int xo = minRadiusX; xo <= maxRadiusX; ++xo) {
                    for (int yo = minRadiusY; yo <= maxRadiusY; ++yo) {
                        for (int zo = minRadiusZ; zo <= maxRadiusZ; ++zo) {
                            int newZ;
                            int newY;
                            int newX;
                            if (!((float)(xo * xo + yo * yo + zo * zo) < radiusSquared) || this.expandFrom.contains(newX = x + xo, newY = y + yo, newZ = z + zo) || !expanded.add(newX, newY, newZ)) continue;
                            class_2680 block = null;
                            if (requiresBlockState) {
                                block = level.method_8320((class_2338)mutableBlockPos.method_10103(newX, newY, newZ));
                            }
                            if (!super.executeSingle(metadataNew, newX, newY, newZ, -1.0f, block, forwards)) continue;
                            if (block == null) {
                                block = level.method_8320((class_2338)mutableBlockPos.method_10103(newX, newY, newZ));
                            }
                            backwards.set(newX, newY, newZ, block);
                        }
                    }
                }
            });
            super.executeWhole(metadata, level, forwards, backwards);
        }
    }

    public static class Definition
    implements CommandDefinition {
        private final ArgumentParser parser = new ArgumentParser(Argument.positional("radius", IntegerArgument::parse, IntegerArgument::highlight, IntegerArgument::suggest));

        @Override
        public CommandOperation createOperation(StringReader reader) throws CommandSyntaxException {
            try (ActiveArgumentParser parser = this.parser.start(reader);){
                int radius = (Integer)parser.get();
                Operation operation = new Operation(radius);
                return operation;
            }
        }

        @Override
        public void syntaxHighlight(List<SpannedStyle> styles, StringReader reader, boolean isLast) throws CommandSyntaxException {
            this.parser.syntaxHighlight(styles, reader, isLast);
        }

        @Override
        public Suggestions autocomplete(SuggestionsBuilder builder, StringReader reader) {
            return this.parser.autocomplete(builder, reader);
        }
    }
}

