/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.commands.operations.impl;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.commands.DispatcherMetadata;
import com.moulberry.axiom.commands.SpannedStyle;
import com.moulberry.axiom.commands.arguments.IntegerArgument;
import com.moulberry.axiom.commands.operations.CommandDefinition;
import com.moulberry.axiom.commands.operations.CommandOperation;
import com.moulberry.axiom.commands.parser.ActiveArgumentParser;
import com.moulberry.axiom.commands.parser.Argument;
import com.moulberry.axiom.commands.parser.ArgumentParser;
import com.moulberry.axiom.world_modification.BlockBuffer;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public class AxiomCoverageCommand {

    public static class Operation
    extends CommandOperation {
        private final int radius;
        private final PositionSet set = new PositionSet();
        private final class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();

        public Operation(int radius) {
            this.radius = radius;
        }

        @Override
        public boolean requiresBlockState() {
            return true;
        }

        @Override
        public boolean executeSingle(DispatcherMetadata metadata, int x, int y, int z, float percentage, class_2680 block, BlockBuffer buffer) {
            if (!block.method_26215()) {
                this.set.add(x, y, z);
            }
            return false;
        }

        @Override
        public void executeWhole(DispatcherMetadata metadata, class_1937 level, BlockBuffer forwards, BlockBuffer backwards) {
            if (this.child != null) {
                boolean requiresBlockState = this.child.requiresBlockState();
                float radiusSquared = ((float)this.radius + 0.5f) * ((float)this.radius + 0.5f);
                float possibleSolid = 0.0f;
                for (int xo = -this.radius; xo <= this.radius; ++xo) {
                    for (int yo = -this.radius; yo <= this.radius; ++yo) {
                        for (int zo = -this.radius; zo <= this.radius; ++zo) {
                            int distanceSq = xo * xo + yo * yo + zo * zo;
                            if (!((float)distanceSq < radiusSquared)) continue;
                            possibleSolid += 1.0f;
                        }
                    }
                }
                float possibleSolidF = possibleSolid;
                this.set.forEach((x, y, z) -> {
                    float upAngle;
                    class_2680 block = forwards.get(x, y, z);
                    if (requiresBlockState && block == null) {
                        block = level.method_8320((class_2338)this.mutableBlockPos.method_10103(x, y, z));
                    }
                    int dirX = 0;
                    int dirY = 0;
                    int dirZ = 0;
                    float solid = 0.0f;
                    for (int xo = -this.radius; xo <= this.radius; ++xo) {
                        for (int yo = -this.radius; yo <= this.radius; ++yo) {
                            for (int zo = -this.radius; zo <= this.radius; ++zo) {
                                int distanceSq = xo * xo + yo * yo + zo * zo;
                                if (!((float)distanceSq < radiusSquared) || !this.set.contains(x + xo, y + yo + 1, z + zo)) continue;
                                solid += 1.0f;
                                dirX -= xo;
                                dirY -= yo;
                                dirZ -= zo;
                            }
                        }
                    }
                    float percentage = solid / possibleSolidF;
                    float dirSq = dirX * dirX + dirY * dirY + dirZ * dirZ;
                    if (dirSq > 0.0f && (upAngle = (float)dirY / (float)Math.sqrt(dirSq)) > 0.75f) {
                        percentage = (float)Math.pow(percentage, upAngle * 2.0f - 0.5f);
                    }
                    float newPercentage = (float)Math.sqrt(Math.abs(percentage * 2.0f - 1.0f));
                    if (this.child.executeSingle(metadata, x, y, z, percentage = percentage < 0.5f ? 0.5f - newPercentage * 0.5f : 0.5f + newPercentage * 0.5f, block, forwards)) {
                        if (block == null) {
                            block = level.method_8320((class_2338)this.mutableBlockPos.method_10103(x, y, z));
                        }
                        backwards.set(x, y, z, block);
                    }
                });
            }
            super.executeWhole(metadata, level, forwards, backwards);
        }
    }

    public static class Definition
    implements CommandDefinition {
        private final ArgumentParser parser = new ArgumentParser(Argument.positional("radius", IntegerArgument::parse, IntegerArgument::highlight, IntegerArgument::suggest));

        @Override
        public CommandOperation createOperation(StringReader reader) throws CommandSyntaxException {
            try (ActiveArgumentParser parser = this.parser.start(reader);){
                int radius = (Integer)parser.get();
                Operation operation = new Operation(radius);
                return operation;
            }
        }

        @Override
        public void syntaxHighlight(List<SpannedStyle> styles, StringReader reader, boolean isLast) throws CommandSyntaxException {
            this.parser.syntaxHighlight(styles, reader, isLast);
        }

        @Override
        public Suggestions autocomplete(SuggestionsBuilder builder, StringReader reader) {
            return this.parser.autocomplete(builder, reader);
        }
    }
}

