/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.commands;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.clipboard.SelectionBuffer;
import com.moulberry.axiom.commands.DispatcherMetadata;
import com.moulberry.axiom.commands.SpannedStyle;
import com.moulberry.axiom.commands.SyntaxStyles;
import com.moulberry.axiom.commands.exception.NotEnoughArgumentsCommandExceptionType;
import com.moulberry.axiom.commands.operations.CommandDefinition;
import com.moulberry.axiom.commands.operations.CommandOperation;
import com.moulberry.axiom.commands.operations.impl.AxiomCoverageCommand;
import com.moulberry.axiom.commands.operations.impl.AxiomExpandCommand;
import com.moulberry.axiom.commands.operations.impl.AxiomMaskCommand;
import com.moulberry.axiom.commands.operations.impl.AxiomMaskUpCommand;
import com.moulberry.axiom.commands.operations.impl.AxiomNoiseHeightCommand;
import com.moulberry.axiom.commands.operations.impl.AxiomPerlinCommand;
import com.moulberry.axiom.commands.operations.impl.AxiomScatterCommand;
import com.moulberry.axiom.commands.operations.impl.AxiomSetCommand;
import com.moulberry.axiom.commands.operations.impl.AxiomWaterlogCommand;
import com.moulberry.axiom.tools.ToolManager;
import com.moulberry.axiom.world_modification.BlockBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_638;

public class AxiomCommandDispatcher {
    private static final NavigableMap<String, CommandDefinition> commands = new TreeMap<String, CommandDefinition>(Map.ofEntries(Map.entry("mask", new AxiomMaskCommand.Definition()), Map.entry("set", new AxiomSetCommand.Definition()), Map.entry("noise", new AxiomPerlinCommand.Definition()), Map.entry("noiseheight", new AxiomNoiseHeightCommand.Definition()), Map.entry("waterlog", new AxiomWaterlogCommand.Definition()), Map.entry("scatter", new AxiomScatterCommand.Definition()), Map.entry("coverage", new AxiomCoverageCommand.Definition()), Map.entry("expand", new AxiomExpandCommand.Definition()), Map.entry("maskup", new AxiomMaskUpCommand.Definition())));

    private static List<StringReader> splitCommand(String command) {
        ArrayList<StringReader> readers = new ArrayList<StringReader>();
        StringReader reader = new StringReader(command);
        reader.skipWhitespace();
        int currentStart = reader.getCursor();
        int currentEnd = reader.getCursor();
        while (reader.canRead()) {
            char c = reader.read();
            if (c == '>') {
                if (currentEnd > currentStart) {
                    StringReader newReader = new StringReader(command.substring(0, currentEnd));
                    newReader.setCursor(currentStart);
                    readers.add(newReader);
                }
                reader.skipWhitespace();
                currentStart = reader.getCursor();
                continue;
            }
            if (Character.isWhitespace(c)) continue;
            currentEnd = reader.getCursor();
        }
        if (currentEnd > currentStart) {
            StringReader newReader = new StringReader(command.substring(0, currentEnd));
            newReader.setCursor(currentStart);
            readers.add(newReader);
        }
        return readers;
    }

    public static List<class_2561> dispatch(String command) throws CommandSyntaxException {
        CommandOperation operation = null;
        CommandOperation current = null;
        for (StringReader reader : AxiomCommandDispatcher.splitCommand(command)) {
            CommandOperation newOperation = AxiomCommandDispatcher.parseSingle(reader);
            if (operation == null) {
                operation = newOperation;
            } else {
                current.setChild(newOperation);
            }
            current = newOperation;
        }
        if (operation != null) {
            return AxiomCommandDispatcher.execute(operation);
        }
        return List.of();
    }

    private static class_2561 syntaxHighlightGaps(String gap) {
        class_5250 component = class_2561.method_43473();
        class_2583 style = null;
        int from = 0;
        for (int i = 0; i < gap.length(); ++i) {
            char c = gap.charAt(i);
            class_2583 newStyle = null;
            if (c == '>') {
                newStyle = SyntaxStyles.CHAIN_OPERATOR;
            } else if (!Character.isWhitespace(c)) {
                newStyle = SyntaxStyles.IGNORED;
            }
            if (newStyle == null) continue;
            if (!newStyle.equals(style) && style != null) {
                component.method_10852((class_2561)class_2561.method_43470((String)gap.substring(from, i)).method_10862(style));
                from = i;
            }
            style = newStyle;
        }
        if (gap.length() > from) {
            if (style == null) {
                component.method_10852((class_2561)class_2561.method_43470((String)gap.substring(from)));
            } else {
                component.method_10852((class_2561)class_2561.method_43470((String)gap.substring(from)).method_10862(style));
            }
        }
        return component;
    }

    public static SyntaxHighlightResult syntaxHighlight(String command) {
        class_5250 component = class_2561.method_43473();
        ArrayList<CommandSyntaxException> exceptions = new ArrayList<CommandSyntaxException>();
        StringBuilder hint = new StringBuilder();
        boolean endsWithArrow = command.trim().endsWith(">");
        List<StringReader> readers = AxiomCommandDispatcher.splitCommand(command);
        int current = 0;
        for (int i = 0; i < readers.size(); ++i) {
            StringReader reader = readers.get(i);
            reader.skipWhitespace();
            boolean isLast = !endsWithArrow && i == readers.size() - 1;
            try {
                int beforeOperationName = reader.getCursor();
                String operationName = reader.readString();
                int afterOperationName = reader.getCursor();
                reader.setCursor(beforeOperationName);
                CommandDefinition definition = (CommandDefinition)commands.get(operationName);
                if (definition != null) {
                    ArrayList<SpannedStyle> highlighted = new ArrayList<SpannedStyle>();
                    try {
                        definition.syntaxHighlight(highlighted, reader, isLast);
                    }
                    catch (CommandSyntaxException e) {
                        CommandExceptionType commandExceptionType = e.getType();
                        if (commandExceptionType instanceof NotEnoughArgumentsCommandExceptionType) {
                            NotEnoughArgumentsCommandExceptionType notEnoughArguments = (NotEnoughArgumentsCommandExceptionType)commandExceptionType;
                            boolean addSpace = false;
                            hint = new StringBuilder();
                            for (String missingArg : notEnoughArguments.missingArguments) {
                                if (addSpace) {
                                    hint.append(' ');
                                }
                                hint.append('<');
                                hint.append(missingArg);
                                hint.append('>');
                                addSpace = true;
                            }
                        }
                        exceptions.add(e);
                    }
                    for (SpannedStyle style : highlighted) {
                        if (style.start() > current) {
                            component.method_10852(AxiomCommandDispatcher.syntaxHighlightGaps(command.substring(current, style.start())));
                            current = style.start();
                        }
                        component.method_10852((class_2561)class_2561.method_43470((String)command.substring(style.start(), style.end())).method_10862(style.style()));
                        current = style.end();
                    }
                    continue;
                }
                if (beforeOperationName > current) {
                    component.method_10852(AxiomCommandDispatcher.syntaxHighlightGaps(command.substring(current, beforeOperationName)));
                    current = beforeOperationName;
                }
                component.method_10852((class_2561)class_2561.method_43470((String)operationName).method_10862(SyntaxStyles.ERROR));
                current = afterOperationName;
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().createWithContext((ImmutableStringReader)reader);
            }
            catch (CommandSyntaxException e) {
                exceptions.add(e);
            }
        }
        if (command.length() > current) {
            component.method_10852(AxiomCommandDispatcher.syntaxHighlightGaps(command.substring(current)));
        }
        return new SyntaxHighlightResult((class_2561)component, hint.toString(), exceptions);
    }

    public static Suggestions autocomplete(SuggestionsBuilder suggestionsBuilder) {
        try {
            List<StringReader> readers = AxiomCommandDispatcher.splitCommand(suggestionsBuilder.getInput());
            for (int i = readers.size() - 1; i >= 0; --i) {
                StringReader reader = readers.get(i);
                if (reader.getCursor() > suggestionsBuilder.getStart()) continue;
                int beforeOperationName = reader.getCursor();
                String operationName = reader.readString();
                reader.setCursor(beforeOperationName);
                CommandDefinition definition = (CommandDefinition)commands.get(operationName);
                if (definition != null) {
                    return definition.autocomplete(suggestionsBuilder, reader);
                }
                return null;
            }
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return null;
    }

    private static <T> Map<String, T> subMapWithKeysThatAreSuffixes(String prefix, NavigableMap<String, T> map) {
        if ("".equals(prefix)) {
            return map;
        }
        String lastKey = AxiomCommandDispatcher.createLexicographicallyNextStringOfTheSameLength(prefix);
        return map.subMap(prefix, true, lastKey, false);
    }

    private static String createLexicographicallyNextStringOfTheSameLength(String input) {
        int lastCharPosition = input.length() - 1;
        String inputWithoutLastChar = input.substring(0, lastCharPosition);
        char lastChar = input.charAt(lastCharPosition);
        char incrementedLastChar = (char)(lastChar + '\u0001');
        return inputWithoutLastChar + incrementedLastChar;
    }

    private static CommandOperation parseSingle(StringReader reader) throws CommandSyntaxException {
        reader.skipWhitespace();
        int start = reader.getCursor();
        String commandName = reader.readString();
        CommandDefinition definition = (CommandDefinition)commands.get(commandName);
        if (definition != null) {
            return definition.createOperation(reader);
        }
        reader.setCursor(start);
        throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().createWithContext((ImmutableStringReader)reader);
    }

    private static List<class_2561> execute(CommandOperation operation) {
        if (ToolManager.isToolActive()) {
            // empty if block
        }
        class_638 level = class_310.method_1551().field_1687;
        SelectionBuffer selection = Selection.getSelectionBuffer();
        if (level == null || selection.isEmpty()) {
            return List.of(class_2561.method_43470((String)"No selection").method_10862(SyntaxStyles.ERROR_MESSAGE));
        }
        DispatcherMetadata metadata = new DispatcherMetadata(selection.min(), selection.max());
        BlockBuffer forwards = new BlockBuffer();
        BlockBuffer backwards = new BlockBuffer();
        boolean requiresPrevious = operation.requiresBlockState();
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        selection.forEach((arg_0, arg_1, arg_2) -> AxiomCommandDispatcher.lambda$execute$0(requiresPrevious, (class_1937)level, mutableBlockPos, operation, metadata, forwards, backwards, arg_0, arg_1, arg_2));
        operation.executeWhole(metadata, (class_1937)level, forwards, backwards);
        ArrayList<class_2561> textOutput = new ArrayList<class_2561>();
        return textOutput;
    }

    private static /* synthetic */ void lambda$execute$0(boolean requiresPrevious, class_1937 level, class_2338.class_2339 mutableBlockPos, CommandOperation operation, DispatcherMetadata metadata, BlockBuffer forwards, BlockBuffer backwards, int x, int y, int z) {
        class_2680 previous = null;
        if (requiresPrevious) {
            previous = level.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
        }
        if (operation.executeSingle(metadata, x, y, z, -1.0f, previous, forwards)) {
            if (previous == null) {
                previous = level.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
            }
            backwards.set(x, y, z, previous);
        }
    }

    public record SyntaxHighlightResult(class_2561 component, String hint, List<CommandSyntaxException> exceptions) {
    }
}

