/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.collections;

import com.moulberry.axiom.collections.PositionConsumer;
import com.moulberry.axiom.utils.PositionUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Arrays;
import java.util.function.LongFunction;
import net.minecraft.class_2338;

public class Position2ObjectMap<T> {
    private final LongFunction<T[]> defaultChunkSupplier;
    private final Long2ObjectMap<T[]> map = new Long2ObjectOpenHashMap();
    private long lastChunkPos = PositionUtils.MIN_POSITION_LONG;
    private T[] lastChunk = null;

    public Position2ObjectMap(LongFunction<T[]> defaultChunkSupplier) {
        this.defaultChunkSupplier = defaultChunkSupplier;
    }

    public void clear() {
        this.map.clear();
        this.lastChunkPos = PositionUtils.MIN_POSITION_LONG;
        this.lastChunk = null;
    }

    public T get(int x, int y, int z) {
        int xC = x >> 4;
        int yC = y >> 4;
        int zC = z >> 4;
        T[] array = this.getChunk(xC, yC, zC);
        if (array == null) {
            return null;
        }
        return array[(x & 0xF) + (y & 0xF) * 16 + (z & 0xF) * 16 * 16];
    }

    public T getOrCreate(int x, int y, int z) {
        int xC = x >> 4;
        int yC = y >> 4;
        int zC = z >> 4;
        T[] array = this.getOrCreateChunk(xC, yC, zC);
        return array[(x & 0xF) + (y & 0xF) * 16 + (z & 0xF) * 16 * 16];
    }

    public void put(int x, int y, int z, T v) {
        int xC = x >> 4;
        int yC = y >> 4;
        int zC = z >> 4;
        T[] array = this.getOrCreateChunk(xC, yC, zC);
        array[(x & 0xF) + (y & 0xF) * 16 + (z & 0xF) * 16 * 16] = v;
    }

    public T getAndPut(int x, int y, int z, T v) {
        int xC = x >> 4;
        int yC = y >> 4;
        int zC = z >> 4;
        T[] array = this.getOrCreateChunk(xC, yC, zC);
        int index = (x & 0xF) + (y & 0xF) * 16 + (z & 0xF) * 16 * 16;
        T old = array[index];
        array[index] = v;
        return old;
    }

    public void forEachChunk(PositionConsumer<T[]> consumer) {
        for (Long2ObjectMap.Entry entry : this.map.long2ObjectEntrySet()) {
            int cx = class_2338.method_10061((long)entry.getLongKey());
            int cy = class_2338.method_10071((long)entry.getLongKey());
            int cz = class_2338.method_10083((long)entry.getLongKey());
            consumer.accept(cx, cy, cz, (Object[])entry.getValue());
        }
    }

    public void forEachEntry(PositionConsumer<T> consumer) {
        for (Long2ObjectMap.Entry entry : this.map.long2ObjectEntrySet()) {
            int cx = class_2338.method_10061((long)entry.getLongKey()) * 16;
            int cy = class_2338.method_10071((long)entry.getLongKey()) * 16;
            int cz = class_2338.method_10083((long)entry.getLongKey()) * 16;
            int index = 0;
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 16; ++y) {
                    for (int x = 0; x < 16; ++x) {
                        Object t2 = ((Object[])entry.getValue())[index++];
                        if (t2 == null) continue;
                        consumer.accept(cx + x, cy + y, cz + z, t2);
                    }
                }
            }
        }
    }

    public void mergeAllFrom(Position2ObjectMap<T> other, LongSet keys) {
        keys.forEach(value -> {
            Object[] currentChunk = (Object[])this.map.computeIfAbsent(value, this.defaultChunkSupplier);
            T[] otherChunk = other.getChunk(value);
            if (otherChunk != null) {
                for (int i = 0; i < otherChunk.length; ++i) {
                    T t2 = otherChunk[i];
                    if (t2 == null) continue;
                    currentChunk[i] = t2;
                }
            }
        });
    }

    public Position2ObjectMap<T> copy() {
        Position2ObjectMap<Object> newMap = new Position2ObjectMap<Object>(this.defaultChunkSupplier);
        for (Long2ObjectMap.Entry entry : this.map.long2ObjectEntrySet()) {
            newMap.putChunk(entry.getLongKey(), Arrays.copyOf((Object[])entry.getValue(), ((Object[])entry.getValue()).length));
        }
        return newMap;
    }

    public LongSet calculateChunksChanged(Position2ObjectMap<T> other) {
        LongOpenHashSet changed = new LongOpenHashSet();
        for (Long2ObjectMap.Entry entry : this.map.long2ObjectEntrySet()) {
            Object[] thisArray;
            Object[] otherArray = other.getChunk(entry.getLongKey());
            if (Arrays.equals(otherArray, thisArray = (Object[])entry.getValue())) continue;
            changed.add(entry.getLongKey());
        }
        return changed;
    }

    public LongSet chunkKeySet() {
        return this.map.keySet();
    }

    public void putChunk(int xC, int yC, int zC, T[] array) {
        this.putChunk(class_2338.method_10064((int)xC, (int)yC, (int)zC), array);
    }

    public void putChunk(long pos, T[] array) {
        this.map.put(pos, array);
        if (this.lastChunkPos == pos) {
            this.lastChunk = array;
        }
    }

    public T[] getChunk(int xC, int yC, int zC) {
        return this.getChunk(class_2338.method_10064((int)xC, (int)yC, (int)zC));
    }

    public T[] getChunk(long pos) {
        if (this.lastChunkPos != pos) {
            Object[] chunk = (Object[])this.map.get(pos);
            this.lastChunkPos = pos;
            this.lastChunk = chunk;
        }
        return this.lastChunk;
    }

    public T[] getOrCreateChunk(int xC, int yC, int zC) {
        return this.getOrCreateChunk(class_2338.method_10064((int)xC, (int)yC, (int)zC));
    }

    public T[] getOrCreateChunk(long pos) {
        if (this.lastChunk == null || this.lastChunkPos != pos) {
            Object[] chunk = (Object[])this.map.computeIfAbsent(pos, this.defaultChunkSupplier);
            this.lastChunkPos = pos;
            this.lastChunk = chunk;
        }
        return this.lastChunk;
    }

    public T[] removeChunk(int xC, int yC, int zC) {
        return this.removeChunk(class_2338.method_10064((int)xC, (int)yC, (int)zC));
    }

    public T[] removeChunk(long pos) {
        Object[] values = (Object[])this.map.remove(pos);
        if (this.lastChunkPos == pos) {
            this.lastChunkPos = PositionUtils.MIN_POSITION_LONG;
            this.lastChunk = null;
        }
        return values;
    }
}

