/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.clipboard;

import com.moulberry.axiom.blueprint.Blueprint;
import com.moulberry.axiom.editor.BlueprintPreview;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.world_modification.CompressedBlockEntity;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.text.NumberFormat;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_2487;
import org.jetbrains.annotations.Nullable;

public interface ClipboardObject {
    public ChunkedBlockRegion blockRegion();

    public Long2ObjectMap<CompressedBlockEntity> blockEntities();

    public String name();

    public String placementDescription();

    public int thumbnailTextureId();

    public void close();

    public record FromBlueprint(Blueprint blueprint) implements ClipboardObject
    {
        @Override
        public ChunkedBlockRegion blockRegion() {
            return this.blueprint.blockRegion();
        }

        @Override
        public Long2ObjectMap<CompressedBlockEntity> blockEntities() {
            return this.blueprint.blockEntities();
        }

        @Override
        public String name() {
            return this.blueprint.header().name();
        }

        @Override
        public String placementDescription() {
            return AxiomI18n.get("axiom.history_description.placed_blueprint", this.name());
        }

        @Override
        public int thumbnailTextureId() {
            class_1043 texture = this.blueprint.thumbnail();
            if (texture == null) {
                return 0;
            }
            return texture.method_4624();
        }

        @Override
        public void close() {
            EditorUI.deferredClose((AutoCloseable)this.blueprint.thumbnail());
        }
    }

    public static class Anonymous
    implements ClipboardObject {
        private final ChunkedBlockRegion blockRegion;
        private final Long2ObjectMap<CompressedBlockEntity> blockEntities;
        private final String name;
        private final float preferredYaw;
        private class_1043 texture = null;
        @Nullable
        private final class_2487 additionalSchematicData;

        public Anonymous(ChunkedBlockRegion blockRegion, Long2ObjectMap<CompressedBlockEntity> blockEntities, String name, float preferredYaw) {
            this(blockRegion, blockEntities, name, preferredYaw, null);
        }

        public Anonymous(ChunkedBlockRegion blockRegion, Long2ObjectMap<CompressedBlockEntity> blockEntities, String name, float preferredYaw, @Nullable class_2487 additionalSchematicData) {
            this.blockRegion = blockRegion;
            this.blockEntities = blockEntities;
            this.name = name;
            this.preferredYaw = preferredYaw;
            this.additionalSchematicData = additionalSchematicData;
        }

        @Override
        public ChunkedBlockRegion blockRegion() {
            return this.blockRegion;
        }

        @Override
        public Long2ObjectMap<CompressedBlockEntity> blockEntities() {
            return this.blockEntities;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Nullable
        public class_2487 additionalSchematicData() {
            return this.additionalSchematicData;
        }

        @Override
        public String placementDescription() {
            String formattedCount = NumberFormat.getInstance().format(this.blockRegion.count());
            return AxiomI18n.get("axiom.history_description.placed", formattedCount);
        }

        @Override
        public int thumbnailTextureId() {
            if (this.blockRegion.count() >= 0x1000000) {
                return -1;
            }
            if (this.texture == null) {
                BlueprintPreview blueprintPreview = new BlueprintPreview();
                blueprintPreview.setBlockRegion(this.blockRegion);
                blueprintPreview.setYaw(this.preferredYaw, true);
                blueprintPreview.render(960, false, false);
                class_1011 nativeImage = blueprintPreview.toNativeImage(96, true);
                this.texture = new class_1043(nativeImage);
            }
            return this.texture.method_4624();
        }

        @Override
        public void close() {
            if (this.texture != null) {
                EditorUI.deferredClose((AutoCloseable)this.texture);
            }
        }
    }
}

