/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.brush_shapes;

import com.moulberry.axiom.brush_shapes.BrushShape;
import com.moulberry.axiom.brush_shapes.SphereBrushShape;
import com.moulberry.axiom.utils.Box;

public interface CapsuleBrushShape
extends BrushShape {
    public static BrushShape create(int radius, int height) {
        if (height <= 0) {
            return SphereBrushShape.create(radius);
        }
        return new SimpleCapsuleBrushShape(radius, height);
    }

    public static final class SimpleCapsuleBrushShape
    implements CapsuleBrushShape {
        private final int maxRadiusSq;
        private final float invMaxRadiusSq;
        private final int cylinderHeight;
        private final int cylinderHeightSq;
        private final Box boundingBox;

        public SimpleCapsuleBrushShape(int radius, int height) {
            this.maxRadiusSq = radius * radius + radius;
            this.cylinderHeight = height;
            this.cylinderHeightSq = this.cylinderHeight * this.cylinderHeight;
            this.boundingBox = new Box(-radius, -height - radius, -radius, radius, height + radius, radius);
            float invMaxRadiusSq = 1.0f / (float)this.maxRadiusSq;
            if (!Float.isFinite(invMaxRadiusSq)) {
                invMaxRadiusSq = Float.MAX_VALUE;
            }
            this.invMaxRadiusSq = invMaxRadiusSq;
        }

        @Override
        public Box boundingBox() {
            return this.boundingBox;
        }

        @Override
        public boolean isInsideShape(int x, int y, int z) {
            if (y * y <= this.cylinderHeightSq) {
                return Math.max(y * y * this.maxRadiusSq, (x * x + z * z) * this.cylinderHeightSq) <= this.maxRadiusSq * this.cylinderHeightSq;
            }
            return x * x + (y = Math.abs(y) - this.cylinderHeight) * y + z * z <= this.maxRadiusSq;
        }

        @Override
        public float distanceSq(int x, int y, int z) {
            if (y * y <= this.cylinderHeightSq) {
                return x * x + z * z;
            }
            y = Math.abs(y) - this.cylinderHeight;
            return x * x + y * y + z * z;
        }

        @Override
        public float sdfSq(int x, int y, int z) {
            if (y * y <= this.cylinderHeightSq) {
                return (float)(x * x + z * z) * this.invMaxRadiusSq;
            }
            y = Math.abs(y) - this.cylinderHeight;
            return (float)(x * x + y * y + z * z) * this.invMaxRadiusSq;
        }
    }
}

