/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.blueprint;

import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.VersionUtils;
import com.moulberry.axiom.block_maps.BlockEntityMap;
import com.moulberry.axiom.blueprint.Blueprint;
import com.moulberry.axiom.blueprint.BlueprintHeader;
import com.moulberry.axiom.blueprint.RawBlueprint;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.utils.DFUHelper;
import com.moulberry.axiom.world_modification.CompressedBlockEntity;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1208;
import net.minecraft.class_155;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2259;
import net.minecraft.class_2338;
import net.minecraft.class_2359;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2841;
import net.minecraft.class_2960;
import net.minecraft.class_3551;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.system.MemoryStack;

public class BlueprintIo {
    private static final int MAGIC = 182827830;
    private static final IOException NOT_VALID_BLUEPRINT = new IOException("Not a valid Blueprint");
    public static final Codec<class_2841<class_2680>> BLOCK_STATE_CODEC = class_2841.method_44343((class_2359)class_2248.field_10651, (Codec)class_2680.field_24734, (class_2841.class_6563)class_2841.class_6563.field_34569, (Object)class_2246.field_10369.method_9564());

    public static BlueprintHeader readHeader(InputStream inputStream) throws IOException {
        if (inputStream.available() < 4) {
            throw NOT_VALID_BLUEPRINT;
        }
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int magic = dataInputStream.readInt();
        if (magic != 182827830) {
            throw NOT_VALID_BLUEPRINT;
        }
        dataInputStream.readInt();
        class_2487 headerTag = class_2507.method_10627((DataInput)dataInputStream);
        return BlueprintHeader.load(headerTag);
    }

    public static class_1043 readThumbnail(InputStream inputStream) throws IOException {
        class_1011 nativeImage;
        if (inputStream.available() < 4) {
            throw NOT_VALID_BLUEPRINT;
        }
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int magic = dataInputStream.readInt();
        if (magic != 182827830) {
            throw NOT_VALID_BLUEPRINT;
        }
        int headerLength = dataInputStream.readInt();
        if (dataInputStream.skip(headerLength) < (long)headerLength) {
            throw NOT_VALID_BLUEPRINT;
        }
        int thumbnailLength = dataInputStream.readInt();
        byte[] thumbnailBytes = dataInputStream.readNBytes(thumbnailLength);
        if (thumbnailBytes.length < thumbnailLength) {
            throw NOT_VALID_BLUEPRINT;
        }
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            ByteBuffer byteBuffer = memoryStack.malloc(thumbnailBytes.length);
            byteBuffer.put(thumbnailBytes);
            byteBuffer.rewind();
            nativeImage = class_1011.method_4324((ByteBuffer)byteBuffer);
        }
        return new class_1043(nativeImage);
    }

    public static RawBlueprint readRawBlueprint(InputStream inputStream) throws IOException {
        if (inputStream.available() < 4) {
            throw NOT_VALID_BLUEPRINT;
        }
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int magic = dataInputStream.readInt();
        if (magic != 182827830) {
            throw NOT_VALID_BLUEPRINT;
        }
        dataInputStream.readInt();
        class_2487 headerTag = class_2507.method_10627((DataInput)dataInputStream);
        BlueprintHeader header = BlueprintHeader.load(headerTag);
        int thumbnailLength = dataInputStream.readInt();
        byte[] thumbnailBytes = dataInputStream.readNBytes(thumbnailLength);
        if (thumbnailBytes.length < thumbnailLength) {
            throw NOT_VALID_BLUEPRINT;
        }
        int currentDataVersion = class_155.method_16673().method_37912().method_38494();
        dataInputStream.readInt();
        class_2487 blockDataTag = class_2507.method_10629((InputStream)dataInputStream, (class_2505)class_2505.method_53898());
        int blueprintDataVersion = blockDataTag.method_10550("DataVersion");
        if (blueprintDataVersion == 0) {
            blueprintDataVersion = currentDataVersion;
        }
        class_2499 listTag = blockDataTag.method_10554("BlockRegion", 10);
        Long2ObjectMap<class_2841<class_2680>> blockMap = BlueprintIo.readBlocks(listTag, blueprintDataVersion);
        class_2499 blockEntitiesTag = blockDataTag.method_10554("BlockEntities", 10);
        Long2ObjectOpenHashMap blockEntities = new Long2ObjectOpenHashMap();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        HashSet<String> loggedWarnings = new HashSet<String>();
        for (class_2520 tag : blockEntitiesTag) {
            class_2487 blockEntityCompound = (class_2487)tag;
            if (blueprintDataVersion != currentDataVersion) {
                Dynamic dynamic = new Dynamic((DynamicOps)class_2509.field_11560, (Object)blockEntityCompound);
                Dynamic output = class_3551.method_15450().update(class_1208.field_5727, dynamic, blueprintDataVersion, currentDataVersion);
                blockEntityCompound = (class_2487)output.getValue();
            }
            class_2338 blockPos = class_2586.method_38239((class_2487)blockEntityCompound);
            long pos = blockPos.method_10063();
            String id = blockEntityCompound.method_10558("id");
            class_2591 type2 = (class_2591)class_7923.field_41181.method_10223(new class_2960(id));
            if (type2 != null) {
                class_2841 container = (class_2841)blockMap.get(class_2338.method_10064((int)(blockPos.method_10263() >> 4), (int)(blockPos.method_10264() >> 4), (int)(blockPos.method_10260() >> 4)));
                if (container == null) continue;
                class_2680 blockState = (class_2680)container.method_12321(blockPos.method_10263() & 0xF, blockPos.method_10264() & 0xF, blockPos.method_10260() & 0xF);
                if (type2.method_20526(blockState)) {
                    class_2487 newTag = blockEntityCompound.method_10553();
                    newTag.method_10551("x");
                    newTag.method_10551("y");
                    newTag.method_10551("z");
                    newTag.method_10551("id");
                    CompressedBlockEntity compressedBlockEntity = CompressedBlockEntity.compress(newTag, baos);
                    blockEntities.put(pos, (Object)compressedBlockEntity);
                    continue;
                }
                if (!loggedWarnings.add(id)) continue;
                Axiom.LOGGER.info("BlockState " + class_2259.method_9685((class_2680)blockState) + " isn't valid for BlockEntity with id " + id);
                continue;
            }
            if (!loggedWarnings.add(id)) continue;
            Axiom.LOGGER.info("Unknown id for Block Entity: " + id);
        }
        return new RawBlueprint(header, thumbnailBytes, blockMap, (Long2ObjectMap<CompressedBlockEntity>)blockEntities);
    }

    public static Long2ObjectMap<class_2841<class_2680>> readBlocks(class_2499 list, int dataVersion) {
        Long2ObjectOpenHashMap map = new Long2ObjectOpenHashMap();
        for (class_2520 tag : list) {
            if (!(tag instanceof class_2487)) continue;
            class_2487 compoundTag = (class_2487)tag;
            int cx = compoundTag.method_10550("X");
            int cy = compoundTag.method_10550("Y");
            int cz = compoundTag.method_10550("Z");
            class_2487 blockStates = compoundTag.method_10562("BlockStates");
            blockStates = DFUHelper.updatePalettedContainer(blockStates, dataVersion);
            class_2841 container = (class_2841)VersionUtils.getOrThrow(BLOCK_STATE_CODEC.parse((DynamicOps)class_2509.field_11560, (Object)blockStates));
            map.put(class_2338.method_10064((int)cx, (int)cy, (int)cz), (Object)container);
        }
        return map;
    }

    public static Blueprint createFromRaw(RawBlueprint rawBlueprint) throws IOException {
        class_1011 nativeImage;
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            ByteBuffer byteBuffer = memoryStack.malloc(rawBlueprint.thumbnail().length);
            byteBuffer.put(rawBlueprint.thumbnail());
            byteBuffer.rewind();
            nativeImage = class_1011.method_4324((ByteBuffer)byteBuffer);
        }
        class_1043 thumbnail = new class_1043(nativeImage);
        ChunkedBlockRegion chunkedBlockRegion = new ChunkedBlockRegion();
        for (Long2ObjectMap.Entry entry : rawBlueprint.blocks().long2ObjectEntrySet()) {
            long key = entry.getLongKey();
            class_2841 value = (class_2841)entry.getValue();
            int cx = class_2338.method_10061((long)key);
            int cy = class_2338.method_10071((long)key);
            int cz = class_2338.method_10083((long)key);
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 16; ++y) {
                    for (int x = 0; x < 16; ++x) {
                        class_2680 state = (class_2680)value.method_12321(x, y, z);
                        if (state == class_2246.field_10369.method_9564()) continue;
                        chunkedBlockRegion.addBlockWithoutDirty(cx * 16 + x, cy * 16 + y, cz * 16 + z, state);
                    }
                }
            }
        }
        chunkedBlockRegion.dirtyAll();
        return new Blueprint(rawBlueprint.header(), thumbnail, chunkedBlockRegion, rawBlueprint.blockEntities());
    }

    public static Blueprint readBlueprint(InputStream inputStream) throws IOException {
        return BlueprintIo.createFromRaw(BlueprintIo.readRawBlueprint(inputStream));
    }

    public static void writeHeader(Path inPath, Path outPath, BlueprintHeader newHeader) throws IOException {
        byte[] thumbnailAndBlockBytes;
        try (BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(inPath, new OpenOption[0]));){
            if (((InputStream)inputStream).available() < 4) {
                throw NOT_VALID_BLUEPRINT;
            }
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            int magic = dataInputStream.readInt();
            if (magic != 182827830) {
                throw NOT_VALID_BLUEPRINT;
            }
            int headerLength = dataInputStream.readInt();
            if (dataInputStream.skip(headerLength) < (long)headerLength) {
                throw NOT_VALID_BLUEPRINT;
            }
            thumbnailAndBlockBytes = dataInputStream.readAllBytes();
        }
        try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(outPath, new OpenOption[0]));){
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            dataOutputStream.writeInt(182827830);
            class_2487 headerTag = newHeader.save(new class_2487());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (DataOutputStream os = new DataOutputStream(baos);){
                class_2507.method_10628((class_2487)headerTag, (DataOutput)os);
            }
            dataOutputStream.writeInt(baos.size());
            baos.writeTo(dataOutputStream);
            dataOutputStream.write(thumbnailAndBlockBytes);
        }
    }

    public static void writeRaw(OutputStream outputStream, RawBlueprint rawBlueprint) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.writeInt(182827830);
        class_2487 headerTag = rawBlueprint.header().save(new class_2487());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (DataOutputStream os = new DataOutputStream(baos);){
            class_2507.method_10628((class_2487)headerTag, (DataOutput)os);
        }
        dataOutputStream.writeInt(baos.size());
        baos.writeTo(dataOutputStream);
        dataOutputStream.writeInt(rawBlueprint.thumbnail().length);
        dataOutputStream.write(rawBlueprint.thumbnail());
        class_2487 compound = new class_2487();
        class_2499 savedBlockRegions = new class_2499();
        for (Long2ObjectMap.Entry entry : rawBlueprint.blocks().long2ObjectEntrySet()) {
            long pos2 = entry.getLongKey();
            class_2841 container = (class_2841)entry.getValue();
            int cx = class_2338.method_10061((long)pos2);
            int cy = class_2338.method_10071((long)pos2);
            int cz = class_2338.method_10083((long)pos2);
            class_2487 tag = new class_2487();
            tag.method_10569("X", cx);
            tag.method_10569("Y", cy);
            tag.method_10569("Z", cz);
            class_2520 encoded = (class_2520)VersionUtils.getOrThrow(BLOCK_STATE_CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)container));
            tag.method_10566("BlockStates", encoded);
            savedBlockRegions.add((Object)tag);
        }
        compound.method_10569("DataVersion", class_155.method_16673().method_37912().method_38494());
        compound.method_10566("BlockRegion", (class_2520)savedBlockRegions);
        class_2499 blockEntitiesTag = new class_2499();
        rawBlueprint.blockEntities().forEach((pos, compressedBlockEntity) -> {
            int x = class_2338.method_10061((long)pos);
            int y = class_2338.method_10071((long)pos);
            int z = class_2338.method_10083((long)pos);
            class_2841 container = (class_2841)rawBlueprint.blocks().get(class_2338.method_10064((int)(x >> 4), (int)(y >> 4), (int)(z >> 4)));
            class_2680 blockState = (class_2680)container.method_12321(x & 0xF, y & 0xF, z & 0xF);
            class_2591<?> type2 = BlockEntityMap.get(blockState.method_26204());
            if (type2 == null) {
                return;
            }
            class_2960 resourceLocation = class_2591.method_11033(type2);
            if (resourceLocation != null) {
                class_2487 tag = compressedBlockEntity.decompress();
                tag.method_10569("x", x);
                tag.method_10569("y", y);
                tag.method_10569("z", z);
                tag.method_10582("id", resourceLocation.toString());
                blockEntitiesTag.add((Object)tag);
            }
        });
        compound.method_10566("BlockEntities", (class_2520)blockEntitiesTag);
        baos.reset();
        class_2507.method_10634((class_2487)compound, (OutputStream)baos);
        dataOutputStream.writeInt(baos.size());
        baos.writeTo(dataOutputStream);
    }

    public static void write(OutputStream outputStream, @NotNull BlueprintHeader header, @NotNull class_1011 thumbnail, @NotNull ChunkedBlockRegion chunkedBlockRegion, Long2ObjectMap<CompressedBlockEntity> blockEntities) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.writeInt(182827830);
        class_2487 headerTag = header.save(new class_2487());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (DataOutputStream os = new DataOutputStream(baos);){
            class_2507.method_10628((class_2487)headerTag, (DataOutput)os);
        }
        dataOutputStream.writeInt(baos.size());
        baos.writeTo(dataOutputStream);
        byte[] thumbnailBytes = thumbnail.method_24036();
        dataOutputStream.writeInt(thumbnailBytes.length);
        dataOutputStream.write(thumbnailBytes);
        class_2487 compound = BlueprintIo.saveBlockData(new class_2487(), chunkedBlockRegion, blockEntities);
        baos.reset();
        class_2507.method_10634((class_2487)compound, (OutputStream)baos);
        dataOutputStream.writeInt(baos.size());
        baos.writeTo(dataOutputStream);
    }

    private static class_2487 saveBlockData(class_2487 compound, ChunkedBlockRegion chunkedBlockRegion, Long2ObjectMap<CompressedBlockEntity> blockEntities) {
        class_2499 savedBlockRegions = new class_2499();
        chunkedBlockRegion.save(savedBlockRegions);
        compound.method_10569("DataVersion", class_155.method_16673().method_37912().method_38494());
        compound.method_10566("BlockRegion", (class_2520)savedBlockRegions);
        class_2499 blockEntitiesTag = new class_2499();
        blockEntities.forEach((pos, compressedBlockEntity) -> {
            int z;
            int y;
            int x = class_2338.method_10061((long)pos);
            class_2680 blockState = chunkedBlockRegion.getBlockStateOrAir(x, y = class_2338.method_10071((long)pos), z = class_2338.method_10083((long)pos));
            class_2591<?> type2 = BlockEntityMap.get(blockState.method_26204());
            if (type2 == null) {
                return;
            }
            class_2960 resourceLocation = class_2591.method_11033(type2);
            if (resourceLocation != null) {
                class_2487 tag = compressedBlockEntity.decompress();
                tag.method_10569("x", x);
                tag.method_10569("y", y);
                tag.method_10569("z", z);
                tag.method_10582("id", resourceLocation.toString());
                blockEntitiesTag.add((Object)tag);
            }
        });
        compound.method_10566("BlockEntities", (class_2520)blockEntitiesTag);
        return compound;
    }
}

