/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.bedrock;

import com.moulberry.axiom.bedrock.BedrockGeometry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1093;
import net.minecraft.class_1100;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3665;
import net.minecraft.class_4590;
import net.minecraft.class_4730;
import net.minecraft.class_753;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_783;
import net.minecraft.class_787;
import net.minecraft.class_796;
import net.minecraft.class_804;
import net.minecraft.class_806;
import net.minecraft.class_809;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class BedrockModel
implements class_1100 {
    private static final class_809 BLOCK_TRANSFORMS = new class_809(new class_804(new Vector3f(75.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.15625f, 0.0f), new Vector3f(0.375f, 0.375f, 0.375f)), new class_804(new Vector3f(75.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.15625f, 0.0f), new Vector3f(0.375f, 0.375f, 0.375f)), new class_804(new Vector3f(0.0f, 225.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.4f, 0.4f, 0.4f)), new class_804(new Vector3f(0.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.4f, 0.4f, 0.4f)), class_804.field_4284, new class_804(new Vector3f(30.0f, 225.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.625f, 0.625f, 0.625f)), new class_804(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.1875f, 0.0f), new Vector3f(0.25f, 0.25f, 0.25f)), new class_804(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.5f, 0.5f, 0.5f)));
    private final BedrockGeometry geometry;
    private final String texture;
    private final boolean doubleSided;

    public BedrockModel(BedrockGeometry geometry, String texture, boolean doubleSided) {
        this.geometry = geometry;
        this.texture = texture;
        this.doubleSided = doubleSided;
    }

    public Collection<class_2960> method_4755() {
        return List.of();
    }

    public void method_45785(Function<class_2960, class_1100> function) {
    }

    @Nullable
    public class_1087 method_4753(class_7775 modelBaker, Function<class_4730, class_1058> function, class_3665 modelState, class_2960 resourceLocation) {
        ArrayList<class_777> unculledFaces = new ArrayList<class_777>();
        class_4730 material = new class_4730(class_1059.field_5275, new class_2960("axiom:block/bedrock_models/" + this.texture));
        class_1058 sprite = function.apply(material);
        record ParentData(Quaternionf rotation, Vector3f position, Vector3f pivot) {
        }
        HashMap<String, ParentData> parentMap = new HashMap<String, ParentData>();
        for (BedrockGeometry.Bone bone : this.geometry.bones) {
            Vector3f newPosition;
            Quaternionf boneRotation = new Quaternionf();
            if (bone.rotation != null) {
                boneRotation.rotateZYX((float)Math.toRadians(bone.rotation.z), (float)(-Math.toRadians(bone.rotation.y)), (float)(-Math.toRadians(bone.rotation.x)));
            }
            Vector3f bonePivot = new Vector3f();
            if (bone.pivot != null) {
                bonePivot.set(-bone.pivot.x, bone.pivot.y, bone.pivot.z);
            }
            if (bone.parent != null) {
                ParentData parent = (ParentData)parentMap.get(bone.parent);
                if (parent == null) {
                    throw new RuntimeException("Missing parent: " + bone.parent);
                }
                boneRotation = new Quaternionf((Quaternionfc)parent.rotation).mul((Quaternionfc)boneRotation);
                Vector3f offset = new Vector3f((Vector3fc)bonePivot).sub((Vector3fc)parent.pivot);
                offset.rotate((Quaternionfc)boneRotation);
                newPosition = offset.add((Vector3fc)parent.position);
            } else {
                newPosition = new Vector3f((Vector3fc)bonePivot);
            }
            if (parentMap.containsKey(bone.name)) {
                throw new RuntimeException("Duplicate bone: " + bone.name);
            }
            parentMap.put(bone.name, new ParentData(boneRotation, newPosition, new Vector3f((Vector3fc)bonePivot)));
            if (bone.cubes == null) continue;
            for (BedrockGeometry.Cube cube : bone.cubes) {
                for (Map.Entry<class_2350, float[]> entry : cube.uvs.entrySet()) {
                    float[] uvs = new float[]{entry.getValue()[0] * 16.0f / (float)this.geometry.description.textureWidth, entry.getValue()[1] * 16.0f / (float)this.geometry.description.textureHeight, entry.getValue()[2] * 16.0f / (float)this.geometry.description.textureWidth, entry.getValue()[3] * 16.0f / (float)this.geometry.description.textureHeight};
                    Vector3f pivot = cube.pivot != null ? new Vector3f((Vector3fc)cube.pivot).mul(-1.0f, 1.0f, 1.0f).add(8.0f, 0.0f, 8.0f).div(16.0f) : new Vector3f((Vector3fc)cube.size).mul(0.5f).add((Vector3fc)cube.origin).mul(-1.0f, 1.0f, 1.0f).add(8.0f, 0.0f, 8.0f).div(16.0f);
                    Quaternionf rotation = new Quaternionf((Quaternionfc)boneRotation);
                    if (cube.rotation != null) {
                        rotation.rotateZYX((float)Math.toRadians(cube.rotation.z), (float)(-Math.toRadians(cube.rotation.y)), (float)(-Math.toRadians(cube.rotation.x)));
                    }
                    Vector3f from = new Vector3f((Vector3fc)cube.origin).mul(-1.0f, 1.0f, 1.0f).add(8.0f, 0.0f, 8.0f);
                    Vector3f to = new Vector3f((Vector3fc)cube.origin).add((Vector3fc)cube.size).mul(-1.0f, 1.0f, 1.0f).add(8.0f, 0.0f, 8.0f);
                    float tempX = from.x;
                    from.x = to.x;
                    to.x = tempX;
                    Vector3f offset = new Vector3f((Vector3fc)newPosition).sub((Vector3fc)bonePivot);
                    from.add((Vector3fc)offset);
                    to.add((Vector3fc)offset);
                    pivot.add(offset.x / 16.0f, offset.y / 16.0f, offset.z / 16.0f);
                    unculledFaces.addAll(BedrockModel.bakeQuad(from, to, new class_783(entry.getKey(), -1, null, new class_787(uvs, 0)), sprite, entry.getKey(), modelState, pivot, rotation, true, null, this.doubleSided));
                }
            }
        }
        HashMap culled = new HashMap();
        for (class_2350 value : class_2350.values()) {
            culled.put(value, List.of());
        }
        return new class_1093(unculledFaces, culled, true, true, false, sprite, BLOCK_TRANSFORMS, class_806.field_4292);
    }

    private static List<class_777> bakeQuad(Vector3f vector3f, Vector3f vector3f2, class_783 blockElementFace, class_1058 textureAtlasSprite, class_2350 direction, class_3665 modelState, Vector3f pivot, Quaternionf rotation, boolean bl, class_2960 resourceLocation, boolean doubleSided) {
        class_787 blockFaceUV = blockElementFace.field_4227;
        if (modelState.method_3512()) {
            blockFaceUV = class_796.method_3454((class_787)blockElementFace.field_4227, (class_2350)direction, (class_4590)modelState.method_3509(), (class_2960)resourceLocation);
        }
        float[] fs = new float[blockFaceUV.field_4235.length];
        System.arraycopy(blockFaceUV.field_4235, 0, fs, 0, fs.length);
        float f = textureAtlasSprite.method_23842();
        float g2 = (blockFaceUV.field_4235[0] + blockFaceUV.field_4235[0] + blockFaceUV.field_4235[2] + blockFaceUV.field_4235[2]) / 4.0f;
        float h2 = (blockFaceUV.field_4235[1] + blockFaceUV.field_4235[1] + blockFaceUV.field_4235[3] + blockFaceUV.field_4235[3]) / 4.0f;
        blockFaceUV.field_4235[0] = class_3532.method_16439((float)f, (float)blockFaceUV.field_4235[0], (float)g2);
        blockFaceUV.field_4235[2] = class_3532.method_16439((float)f, (float)blockFaceUV.field_4235[2], (float)g2);
        blockFaceUV.field_4235[1] = class_3532.method_16439((float)f, (float)blockFaceUV.field_4235[1], (float)h2);
        blockFaceUV.field_4235[3] = class_3532.method_16439((float)f, (float)blockFaceUV.field_4235[3], (float)h2);
        int[] is = BedrockModel.makeVertices(blockFaceUV, textureAtlasSprite, direction, BedrockModel.setupShape(vector3f, vector3f2), modelState.method_3509(), pivot, rotation, bl, false);
        class_2350 direction2 = class_796.method_3467((int[])is);
        System.arraycopy(fs, 0, blockFaceUV.field_4235, 0, fs.length);
        class_777 mainQuad = new class_777(is, blockElementFace.field_4226, direction2, textureAtlasSprite, bl);
        if (!doubleSided) {
            return List.of(mainQuad);
        }
        is = BedrockModel.makeVertices(blockFaceUV, textureAtlasSprite, direction, BedrockModel.setupShape(vector3f, vector3f2), modelState.method_3509(), pivot, rotation, bl, true);
        direction2 = class_796.method_3467((int[])is);
        System.arraycopy(fs, 0, blockFaceUV.field_4235, 0, fs.length);
        class_777 secondQuad = new class_777(is, blockElementFace.field_4226, direction2, textureAtlasSprite, bl);
        return List.of(mainQuad, secondQuad);
    }

    private static float[] setupShape(Vector3f vector3f, Vector3f vector3f2) {
        float[] fs = new float[class_2350.values().length];
        fs[class_753.class_754.field_3967] = vector3f.x() / 16.0f;
        fs[class_753.class_754.field_3968] = vector3f.y() / 16.0f;
        fs[class_753.class_754.field_3969] = vector3f.z() / 16.0f;
        fs[class_753.class_754.field_3970] = vector3f2.x() / 16.0f;
        fs[class_753.class_754.field_3971] = vector3f2.y() / 16.0f;
        fs[class_753.class_754.field_3972] = vector3f2.z() / 16.0f;
        return fs;
    }

    private static int[] makeVertices(class_787 blockFaceUV, class_1058 textureAtlasSprite, class_2350 direction, float[] fs, class_4590 transformation, Vector3f pivot, Quaternionf rotation, boolean bl, boolean invert) {
        int[] is = new int[32];
        for (int i = 0; i < 4; ++i) {
            BedrockModel.bakeVertex(is, i, direction, blockFaceUV, fs, textureAtlasSprite, transformation, pivot, rotation, bl, invert);
        }
        return is;
    }

    private static void bakeVertex(int[] is, int i, class_2350 direction, class_787 blockFaceUV, float[] fs, class_1058 textureAtlasSprite, class_4590 transformation, Vector3f pivot, Quaternionf rotation, boolean bl, boolean invert) {
        class_753.class_755 vertexInfo = class_753.method_3163((class_2350)direction).method_3162(i);
        Vector3f vector3f = new Vector3f(fs[vertexInfo.field_3975], fs[vertexInfo.field_3974], fs[vertexInfo.field_3973]);
        BedrockModel.applyElementRotation(vector3f, pivot, rotation);
        if (transformation != class_4590.method_22931()) {
            BedrockModel.applyModelRotation(vector3f, transformation.method_22936());
        }
        BedrockModel.fillVertex(is, invert ? 3 - i : i, vector3f, textureAtlasSprite, blockFaceUV);
    }

    private static void applyElementRotation(Vector3f vector3f, Vector3f pivot, Quaternionf quaternionf) {
        if (pivot == null || quaternionf == null) {
            return;
        }
        BedrockModel.rotateVertexBy(vector3f, new Vector3f((Vector3fc)pivot), new Matrix4f().rotation((Quaternionfc)quaternionf), new Vector3f(1.0f, 1.0f, 1.0f));
    }

    public static void applyModelRotation(Vector3f vector3f, Matrix4f matrix4f) {
        BedrockModel.rotateVertexBy(vector3f, new Vector3f(0.5f, 0.5f, 0.5f), matrix4f, new Vector3f(1.0f, 1.0f, 1.0f));
    }

    private static void rotateVertexBy(Vector3f vector3f, Vector3f vector3f2, Matrix4f matrix4f, Vector3f vector3f3) {
        Vector4f vector4f = matrix4f.transform(new Vector4f(vector3f.x() - vector3f2.x(), vector3f.y() - vector3f2.y(), vector3f.z() - vector3f2.z(), 1.0f));
        vector4f.mul((Vector4fc)new Vector4f((Vector3fc)vector3f3, 1.0f));
        vector3f.set(vector4f.x() + vector3f2.x(), vector4f.y() + vector3f2.y(), vector4f.z() + vector3f2.z());
    }

    private static void fillVertex(int[] is, int i, Vector3f vector3f, class_1058 textureAtlasSprite, class_787 blockFaceUV) {
        int j = i * 8;
        is[j] = Float.floatToRawIntBits(vector3f.x());
        is[j + 1] = Float.floatToRawIntBits(vector3f.y());
        is[j + 2] = Float.floatToRawIntBits(vector3f.z());
        is[j + 3] = -1;
        is[j + 4] = Float.floatToRawIntBits(textureAtlasSprite.method_4580(blockFaceUV.method_3415(i) / 16.0f));
        is[j + 4 + 1] = Float.floatToRawIntBits(textureAtlasSprite.method_4570(blockFaceUV.method_3416(i) / 16.0f));
    }
}

