/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom;

import com.moulberry.axiom.GeneralGameFeatures;
import com.moulberry.axiom.buildertools.BuilderToolManager;
import com.moulberry.axiom.clipboard.Clipboard;
import com.moulberry.axiom.clipboard.Placement;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.displayentity.DisplayEntityManipulator;
import com.moulberry.axiom.marker.MarkerEntityManipulator;
import com.moulberry.axiom.tools.ToolManager;
import com.moulberry.axiom.world_modification.Dispatcher;
import java.util.List;
import net.minecraft.class_310;

public enum UserAction {
    ENTER,
    ESCAPE,
    CUT,
    COPY,
    PASTE,
    DELETE,
    UNDO,
    REDO,
    SAVE,
    EXTRUDE,
    ROTATE_PLACEMENT,
    FLIP_PLACEMENT,
    LEFT_MOUSE,
    RIGHT_MOUSE,
    SCROLL;

    private static final List<UserActionCallable> CALLABLES;

    public ActionResult call(Object object) {
        if (class_310.method_1551().field_1687 == null || class_310.method_1551().field_1724 == null) {
            return ActionResult.NOT_HANDLED;
        }
        ActionResult result = ActionResult.NOT_HANDLED;
        for (UserActionCallable callable : CALLABLES) {
            switch (callable.callAction(this, object).ordinal()) {
                case 0: {
                    return ActionResult.USED_STOP;
                }
                case 1: {
                    result = ActionResult.USED_CONT;
                }
            }
        }
        return result;
    }

    static {
        CALLABLES = List.of(Placement.INSTANCE::callAction, ToolManager::callAction, Selection::callAction, Clipboard.INSTANCE::callAction, BuilderToolManager::callAction, DisplayEntityManipulator::callAction, MarkerEntityManipulator::callAction, GeneralGameFeatures::callAction, Dispatcher::callAction);
    }

    public static enum ActionResult {
        USED_STOP,
        USED_CONT,
        NOT_HANDLED;

    }

    public static interface UserActionCallable {
        public ActionResult callAction(UserAction var1, Object var2);
    }

    public record ScrollAmount(int scrollX, int scrollY) {
    }
}

