/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom;

import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiomclientapi.funcinterfaces.TriIntConsumer;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2682;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2841;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_746;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class RayCaster {
    public static RaycastResult raycast(class_1937 level, Vector3f from, Vector3f direction, boolean includeSelection, boolean includeFluids) {
        return RayCaster.raycast(level, from, direction, includeSelection, includeFluids, true);
    }

    public static RaycastResult raycast(class_1937 level, Vector3f from, Vector3f direction, boolean includeSelection, boolean includeFluids, boolean includeNonSolid) {
        class_3965 result;
        if (Selection.getSelectionBuffer().isEmpty()) {
            includeSelection = false;
        }
        direction.normalize();
        if (from.y < (float)level.method_31607()) {
            yTarget = (float)level.method_31607() + 0.01f;
            if (direction.y <= 0.0f) {
                return null;
            }
            steps = (yTarget - from.y) / direction.y;
            from.x += direction.x * steps;
            from.y = yTarget;
            from.z += direction.z * steps;
        } else if (from.y >= (float)level.method_31600()) {
            yTarget = (float)level.method_31600() - 0.01f;
            if (direction.y >= 0.0f) {
                return null;
            }
            steps = (yTarget - from.y) / direction.y;
            from.x += direction.x * steps;
            from.y = yTarget;
            from.z += direction.z * steps;
        }
        class_243 fromVec3 = new class_243((double)from.x, (double)from.y, (double)from.z);
        int mapX = (int)Math.floor(from.x);
        int mapY = (int)Math.floor(from.y);
        int mapZ = (int)Math.floor(from.z);
        double deltaDistX = Math.abs(1.0f / direction.x);
        double deltaDistY = Math.abs(1.0f / direction.y);
        double deltaDistZ = Math.abs(1.0f / direction.z);
        int stepX = direction.x < 0.0f ? -1 : 1;
        int stepY = direction.y < 0.0f ? -1 : 1;
        int stepZ = direction.z < 0.0f ? -1 : 1;
        double sideDistX = (double)(direction.x > 0.0f ? 1.0f - from.x + (float)mapX : from.x - (float)mapX) * deltaDistX;
        double sideDistY = (double)(direction.y > 0.0f ? 1.0f - from.y + (float)mapY : from.y - (float)mapY) * deltaDistY;
        double sideDistZ = (double)(direction.z > 0.0f ? 1.0f - from.z + (float)mapZ : from.z - (float)mapZ) * deltaDistZ;
        if (Double.isNaN(sideDistX)) {
            sideDistX = Double.POSITIVE_INFINITY;
        }
        if (Double.isNaN(sideDistY)) {
            sideDistY = Double.POSITIVE_INFINITY;
        }
        if (Double.isNaN(sideDistZ)) {
            sideDistZ = Double.POSITIVE_INFINITY;
        }
        int oldChunkX = mapX >> 4;
        int oldChunkY = mapY >> 4;
        int oldChunkZ = mapZ >> 4;
        class_2818 chunk = (class_2818)level.method_8402(oldChunkX, oldChunkZ, class_2806.field_12803, false);
        if (chunk == null) {
            return null;
        }
        int sectionIndex = chunk.method_31603(oldChunkY);
        class_2826 section = chunk.method_38259(sectionIndex);
        class_2841 container = section.method_12265();
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        class_746 player = class_310.method_1551().field_1724;
        class_3726 collisionContext = player == null ? class_3726.method_16194() : class_3726.method_16195((class_1297)player);
        int limit = 0;
        while (true) {
            boolean updateSection;
            if (limit++ >= 3000) {
                return null;
            }
            if (sideDistZ < sideDistX && sideDistZ < sideDistY) {
                sideDistZ += deltaDistZ;
                mapZ += stepZ;
            } else if (sideDistX < sideDistY) {
                sideDistX += deltaDistX;
                mapX += stepX;
            } else {
                sideDistY += deltaDistY;
                mapY += stepY;
            }
            int newChunkX = mapX >> 4;
            int newChunkY = mapY >> 4;
            int newChunkZ = mapZ >> 4;
            boolean bl = updateSection = newChunkY != oldChunkY;
            if (newChunkX != oldChunkX || newChunkZ != oldChunkZ) {
                oldChunkX = newChunkX;
                oldChunkZ = newChunkZ;
                chunk = (class_2818)level.method_8402(oldChunkX, oldChunkZ, class_2806.field_12803, false);
                if (chunk == null) {
                    return null;
                }
                updateSection = true;
            }
            if (updateSection) {
                oldChunkY = newChunkY;
                if (oldChunkY < chunk.method_32891() || oldChunkY >= chunk.method_31597()) {
                    return null;
                }
                sectionIndex = chunk.method_31603(oldChunkY);
                section = chunk.method_38259(sectionIndex);
                container = section.method_12265();
            }
            if (includeSelection && Selection.contains(mapX, mapY, mapZ)) {
                return new RaycastResult(new class_2338(mapX, mapY, mapZ), class_243.method_24953((class_2382)new class_2338(mapX, mapY, mapZ)), class_2350.field_11036, true);
            }
            class_2680 blockState = (class_2680)container.method_12321(mapX & 0xF, mapY & 0xF, mapZ & 0xF);
            if (blockState.method_26215()) continue;
            mutableBlockPos.method_10103(mapX, mapY, mapZ);
            class_243 toVec3 = fromVec3.method_1031((double)(direction.x * (float)(limit + 5)), (double)(direction.y * (float)(limit + 5)), (double)(direction.z * (float)(limit + 5)));
            result = null;
            if (includeNonSolid || blockState.method_51366()) {
                class_265 voxelShape = blockState.method_26172((class_1922)class_2682.field_12294, (class_2338)mutableBlockPos, collisionContext);
                result = class_238.method_1010((Iterable)voxelShape.method_1090(), (class_243)fromVec3, (class_243)toVec3, (class_2338)mutableBlockPos);
            }
            if (includeFluids) {
                class_3610 fluidState = blockState.method_26227();
                class_265 fluidVoxelShape = fluidState.method_17776((class_1922)class_2682.field_12294, (class_2338)mutableBlockPos);
                class_3965 fluidBlockHitResult = class_238.method_1010((Iterable)fluidVoxelShape.method_1090(), (class_243)fromVec3, (class_243)toVec3, (class_2338)mutableBlockPos);
                if (result == null || result.method_17783() != class_239.class_240.field_1332) {
                    result = fluidBlockHitResult;
                } else if (fluidBlockHitResult != null && fluidBlockHitResult.method_17783() == class_239.class_240.field_1332) {
                    double blockDistance = fromVec3.method_1025(result.method_17784());
                    double fluidDistance = fromVec3.method_1025(fluidBlockHitResult.method_17784());
                    if (fluidDistance < blockDistance) {
                        result = fluidBlockHitResult;
                    }
                }
            }
            if (result != null && result.method_17783() == class_239.class_240.field_1332) break;
        }
        return new RaycastResult(result.method_17777(), result.method_17784(), result.method_17780(), false);
    }

    public static void ddaSkip(Vector3f from, Vector3f to, class_1937 level, boolean skipNonSolid, TriIntConsumer consumer) {
        if (from.y < (float)level.method_31607()) {
            direction = to.sub((Vector3fc)from, new Vector3f()).normalize();
            yTarget = (float)level.method_31607() + 0.01f;
            if (direction.y <= 0.0f) {
                return;
            }
            steps = (yTarget - from.y) / direction.y;
            from.x += direction.x * steps;
            from.y = yTarget;
            from.z += direction.z * steps;
        } else if (from.y >= (float)level.method_31600()) {
            direction = to.sub((Vector3fc)from, new Vector3f()).normalize();
            yTarget = (float)level.method_31600() - 0.01f;
            if (direction.y >= 0.0f) {
                return;
            }
            steps = (yTarget - from.y) / direction.y;
            from.x += direction.x * steps;
            from.y = yTarget;
            from.z += direction.z * steps;
        }
        int fromMapX = (int)Math.floor(from.x);
        int fromMapY = (int)Math.floor(from.y);
        int fromMapZ = (int)Math.floor(from.z);
        int toMapX = (int)Math.floor(to.x);
        int toMapY = (int)Math.floor(to.y);
        int toMapZ = (int)Math.floor(to.z);
        if (toMapX == fromMapX && toMapY == fromMapY && toMapZ == fromMapZ) {
            return;
        }
        Vector3f ray = to.sub((Vector3fc)from, new Vector3f()).normalize();
        int mapX = fromMapX;
        int mapY = fromMapY;
        int mapZ = fromMapZ;
        double deltaDistX = Math.abs(1.0f / ray.x);
        double deltaDistY = Math.abs(1.0f / ray.y);
        double deltaDistZ = Math.abs(1.0f / ray.z);
        int stepX = ray.x() < 0.0f ? -1 : 1;
        int stepY = ray.y() < 0.0f ? -1 : 1;
        int stepZ = ray.z() < 0.0f ? -1 : 1;
        double sideDistX = (double)(ray.x > 0.0f ? 1.0f - from.x + (float)mapX : from.x - (float)mapX) * deltaDistX;
        double sideDistY = (double)(ray.y > 0.0f ? 1.0f - from.y + (float)mapY : from.y - (float)mapY) * deltaDistY;
        double sideDistZ = (double)(ray.z > 0.0f ? 1.0f - from.z + (float)mapZ : from.z - (float)mapZ) * deltaDistZ;
        if (Double.isNaN(sideDistX)) {
            sideDistX = Double.POSITIVE_INFINITY;
        }
        if (Double.isNaN(sideDistY)) {
            sideDistY = Double.POSITIVE_INFINITY;
        }
        if (Double.isNaN(sideDistZ)) {
            sideDistZ = Double.POSITIVE_INFINITY;
        }
        int oldChunkX = mapX >> 4;
        int oldChunkY = mapY >> 4;
        int oldChunkZ = mapZ >> 4;
        class_2818 chunk = (class_2818)level.method_8402(oldChunkX, oldChunkZ, class_2806.field_12803, false);
        if (chunk == null) {
            return;
        }
        int sectionIndex = chunk.method_31603(oldChunkY);
        class_2826 section = chunk.method_38259(sectionIndex);
        class_2841 container = section.method_12265();
        class_2680 blockState = (class_2680)container.method_12321(mapX & 0xF, mapY & 0xF, mapZ & 0xF);
        if (blockState.method_51366() == skipNonSolid) {
            consumer.accept(mapX, mapY, mapZ);
        }
        while (true) {
            boolean updateSection;
            if (sideDistZ < sideDistX && sideDistZ < sideDistY) {
                sideDistZ += deltaDistZ;
                mapZ += stepZ;
            } else if (sideDistX < sideDistY) {
                sideDistX += deltaDistX;
                mapX += stepX;
            } else {
                sideDistY += deltaDistY;
                mapY += stepY;
            }
            if (mapX * stepX > toMapX * stepX || mapY * stepY > toMapY * stepY || mapZ * stepZ > toMapZ * stepZ) {
                return;
            }
            int newChunkX = mapX >> 4;
            int newChunkY = mapY >> 4;
            int newChunkZ = mapZ >> 4;
            boolean bl = updateSection = newChunkY != oldChunkY;
            if (newChunkX != oldChunkX || newChunkZ != oldChunkZ) {
                oldChunkX = newChunkX;
                oldChunkZ = newChunkZ;
                chunk = (class_2818)level.method_8402(oldChunkX, oldChunkZ, class_2806.field_12803, false);
                if (chunk == null) {
                    return;
                }
                updateSection = true;
            }
            if (updateSection) {
                oldChunkY = newChunkY;
                if (oldChunkY < chunk.method_32891() || oldChunkY >= chunk.method_31597()) {
                    return;
                }
                sectionIndex = chunk.method_31603(oldChunkY);
                section = chunk.method_38259(sectionIndex);
                container = section.method_12265();
            }
            if ((blockState = (class_2680)container.method_12321(mapX & 0xF, mapY & 0xF, mapZ & 0xF)).method_51366() != skipNonSolid) continue;
            consumer.accept(mapX, mapY, mapZ);
        }
    }

    public record RaycastResult(class_2338 blockPos, class_243 worldPos, class_2350 direction, boolean isSelection) {
        public RaycastResult(class_2338 blockPos, class_243 worldPos, class_2350 direction, boolean isSelection) {
            this.blockPos = blockPos = blockPos.method_10062();
            this.worldPos = worldPos;
            this.direction = direction;
            this.isSelection = isSelection;
        }

        public class_2338 getBlockPos() {
            return this.blockPos();
        }

        public class_2350 getDirection() {
            return this.direction();
        }

        public class_243 getLocation() {
            return this.worldPos();
        }
    }
}

