/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.AbstractBufferedImageOp;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public class CompositeFilter
extends AbstractBufferedImageOp {
    private Composite composite;
    private AffineTransform transform;

    public CompositeFilter() {
    }

    public CompositeFilter(Composite composite) {
        this.composite = composite;
    }

    public CompositeFilter(Composite composite, AffineTransform transform) {
        this.composite = composite;
        this.transform = transform;
    }

    public void setComposite(Composite composite) {
        this.composite = composite;
    }

    public Composite getComposite() {
        return this.composite;
    }

    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, null);
        }
        Graphics2D g2 = dst.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.setComposite(this.composite);
        g2.drawRenderedImage(src, this.transform);
        g2.dispose();
        return dst;
    }

    public String toString() {
        return "Composite";
    }
}

