/*
 * Decompiled with CFR 0.152.
 */
package com.ezylang.evalex.data;

import com.ezylang.evalex.parser.ASTNode;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public final class EvaluationValue
implements Comparable<EvaluationValue> {
    private final Object value;
    private final DataType dataType;

    public EvaluationValue(Object value) {
        BigDecimal number = this.convertToBigDecimal(value);
        if (number != null) {
            this.dataType = DataType.NUMBER;
            this.value = number;
        } else if (value instanceof CharSequence) {
            this.dataType = DataType.STRING;
            this.value = ((CharSequence)value).toString();
        } else if (value instanceof Character) {
            this.dataType = DataType.STRING;
            this.value = ((Character)value).toString();
        } else if (value instanceof Boolean) {
            this.dataType = DataType.BOOLEAN;
            this.value = value;
        } else if (value instanceof ASTNode) {
            this.dataType = DataType.EXPRESSION_NODE;
            this.value = value;
        } else if (value instanceof List) {
            this.dataType = DataType.ARRAY;
            this.value = this.convertToList((List)value);
        } else if (value instanceof Map) {
            this.dataType = DataType.STRUCTURE;
            this.value = this.convertMapStructure((Map)value);
        } else {
            throw new IllegalArgumentException("Unsupported data type '" + value.getClass().getName() + "'");
        }
    }

    public EvaluationValue(double value, MathContext mathContext) {
        this.dataType = DataType.NUMBER;
        this.value = new BigDecimal(Double.toString(value), mathContext);
    }

    private Map<String, EvaluationValue> convertMapStructure(Map<?, ?> value) {
        HashMap<String, EvaluationValue> structure = new HashMap<String, EvaluationValue>();
        for (Map.Entry<?, ?> entry : value.entrySet()) {
            String name = entry.getKey().toString();
            structure.put(name, new EvaluationValue(entry.getValue()));
        }
        return structure;
    }

    private List<EvaluationValue> convertToList(List<?> value) {
        ArrayList<EvaluationValue> array = new ArrayList<EvaluationValue>();
        value.forEach(element -> array.add(new EvaluationValue(element)));
        return array;
    }

    private BigDecimal convertToBigDecimal(Object value) {
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof Double) {
            return BigDecimal.valueOf((Double)value);
        }
        if (value instanceof Float) {
            return BigDecimal.valueOf(((Float)value).floatValue());
        }
        if (value instanceof Integer) {
            return BigDecimal.valueOf(((Integer)value).intValue());
        }
        if (value instanceof Long) {
            return BigDecimal.valueOf((Long)value);
        }
        if (value instanceof Short) {
            return BigDecimal.valueOf(((Short)value).shortValue());
        }
        if (value instanceof Byte) {
            return BigDecimal.valueOf(((Byte)value).byteValue());
        }
        return null;
    }

    public boolean isNumberValue() {
        return this.getDataType() == DataType.NUMBER;
    }

    public boolean isStringValue() {
        return this.getDataType() == DataType.STRING;
    }

    public boolean isBooleanValue() {
        return this.getDataType() == DataType.BOOLEAN;
    }

    public boolean isArrayValue() {
        return this.getDataType() == DataType.ARRAY;
    }

    public boolean isStructureValue() {
        return this.getDataType() == DataType.STRUCTURE;
    }

    public boolean isExpressionNode() {
        return this.getDataType() == DataType.EXPRESSION_NODE;
    }

    public static EvaluationValue numberOfString(String value, MathContext mathContext) {
        if (value.startsWith("0x") || value.startsWith("0X")) {
            BigInteger hexToInteger = new BigInteger(value.substring(2), 16);
            return new EvaluationValue(new BigDecimal(hexToInteger, mathContext));
        }
        return new EvaluationValue(new BigDecimal(value, mathContext));
    }

    public BigDecimal getNumberValue() {
        switch (this.getDataType()) {
            case NUMBER: {
                return (BigDecimal)this.value;
            }
            case BOOLEAN: {
                return Boolean.TRUE.equals(this.value) ? BigDecimal.ONE : BigDecimal.ZERO;
            }
            case STRING: {
                return Boolean.parseBoolean((String)this.value) ? BigDecimal.ONE : BigDecimal.ZERO;
            }
        }
        return BigDecimal.ZERO;
    }

    public String getStringValue() {
        if (this.getDataType() == DataType.NUMBER) {
            return ((BigDecimal)this.value).toPlainString();
        }
        return this.value.toString();
    }

    public Boolean getBooleanValue() {
        switch (this.getDataType()) {
            case NUMBER: {
                return !this.value.equals(BigDecimal.ZERO);
            }
            case BOOLEAN: {
                return (Boolean)this.value;
            }
            case STRING: {
                return Boolean.parseBoolean((String)this.value);
            }
        }
        return false;
    }

    public List<EvaluationValue> getArrayValue() {
        if (this.isArrayValue()) {
            return (List)this.value;
        }
        return Collections.emptyList();
    }

    public Map<String, EvaluationValue> getStructureValue() {
        if (this.isStructureValue()) {
            return (Map)this.value;
        }
        return Collections.emptyMap();
    }

    public ASTNode getExpressionNode() {
        return this.isExpressionNode() ? (ASTNode)this.getValue() : null;
    }

    @Override
    public int compareTo(EvaluationValue toCompare) {
        switch (this.getDataType()) {
            case NUMBER: {
                return this.getNumberValue().compareTo(toCompare.getNumberValue());
            }
            case BOOLEAN: {
                return this.getBooleanValue().compareTo(toCompare.getBooleanValue());
            }
        }
        return this.getStringValue().compareTo(toCompare.getStringValue());
    }

    @Generated
    public Object getValue() {
        return this.value;
    }

    @Generated
    public DataType getDataType() {
        return this.dataType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EvaluationValue)) {
            return false;
        }
        EvaluationValue other = (EvaluationValue)o;
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        DataType this$dataType = this.getDataType();
        DataType other$dataType = other.getDataType();
        return !(this$dataType == null ? other$dataType != null : !((Object)((Object)this$dataType)).equals((Object)other$dataType));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        DataType $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : ((Object)((Object)$dataType)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EvaluationValue(value=" + this.getValue() + ", dataType=" + this.getDataType() + ")";
    }

    public static enum DataType {
        STRING,
        NUMBER,
        BOOLEAN,
        ARRAY,
        STRUCTURE,
        EXPRESSION_NODE;

    }
}

